/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public abstract class TVConnector
extends TopView {
    public static final int SITE_SOURCE = 0;
    public static final int SITE_CENTER = 1;
    public static final int SITE_TARGET = 2;
    private int offset = 13;
    public static boolean updateSettings = false;
    protected List edgePoints = new ArrayList();
    protected Rectangle labelBounds;
    protected Rectangle sourceLabelBounds = new Rectangle(-1, -1, -1, -1);
    protected Rectangle targetLabelBounds;
    public boolean wait = false;
    private Label sourceLabel = null;
    private Label centerLabel = null;
    private Label targetLabel = null;
    private Label tempSourceLabel;
    private Label tempCenterLabel;
    private Label tempTargetLabel;
    public static final int PERMILLE = 1000;

    public TVConnector(DesignPartView dpv) {
        super(dpv);
        this.labelBounds = new Rectangle(-1, -1, -1, -1);
        this.targetLabelBounds = new Rectangle(-1, -1, -1, -1);
    }

    public TVConnector() {
        this.labelBounds = new Rectangle(-1, -1, -1, -1);
        this.targetLabelBounds = new Rectangle(-1, -1, -1, -1);
    }

    public List getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public Rectangle getBounds() {
        if (this.edgePoints.size() > 0) {
            boolean first = true;
            double xmin = 0.0;
            double ymin = 0.0;
            double xmax = 0.0;
            double ymax = 0.0;
            for (Point2D p : this.edgePoints) {
                if (first) {
                    first = false;
                    xmin = xmax = p.getX();
                    ymin = ymax = p.getY();
                    continue;
                }
                double x = p.getX();
                double y = p.getY();
                if (x < xmin) {
                    xmin = x;
                } else if (x > xmax) {
                    xmax = x;
                }
                if (y < ymin) {
                    ymin = y;
                    continue;
                }
                if (!(y > ymax)) continue;
                ymax = y;
            }
            return new Rectangle((int)xmin, (int)ymin, (int)(xmax - xmin), (int)(ymax - ymin));
        }
        return new Rectangle(1, 1, 1, 1);
    }

    @Override
    public void move(int dx, int dy) {
        for (Point2D p : this.edgePoints) {
            p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
        }
    }

    public List getEdgeViewPoints() {
        ArrayList list = new ArrayList();
        return list;
    }

    public boolean remove(DesignObject connection) {
        connection.remove();
        return true;
    }

    public void hide() {
        this.doPrivateActions();
        this.clearLabels();
        this.getDesignPartView().removeView(this);
        DesignObject dobj = this.getModel();
        if (dobj instanceof ConnectionInterface) {
            ((ConnectionInterface)((Object)dobj)).removeTopView(this);
        }
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    protected void doPrivateActions() {
    }

    public void removeConnection() {
    }

    public void clearLabels() {
        this.removeLabel(0);
        this.removeLabel(1);
        this.removeLabel(2);
    }

    public Rectangle getLabelBounds() {
        return this.labelBounds;
    }

    public void setLabelBounds(Rectangle labelBounds) {
        this.labelBounds = labelBounds;
    }

    public Rectangle getSourceLabelBounds() {
        return this.sourceLabelBounds;
    }

    public void setSourceLabelBounds(Rectangle sourceLabelBounds) {
        this.sourceLabelBounds = sourceLabelBounds;
    }

    public Rectangle getTargetLabelBounds() {
        return this.targetLabelBounds;
    }

    public void setTargetLabelBounds(Rectangle targetLabelBounds) {
        this.targetLabelBounds = targetLabelBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLabelPos(Point2D pos, Point2D otherPoint, Rectangle2D rect, int site) {
        TopView topView;
        Label label;
        if (!this.wait && pos != null && (label = this.getLabel(site)) != null && (topView = this.dpv.getViewFor(label)) != null) {
            this.wait = true;
            try {
                Rectangle rec = topView.getBounds();
                double dx = pos.getX();
                double dy = pos.getY();
                dx = this.getMiddle(pos.getX(), otherPoint.getX(), 2);
                dy = this.getMiddle(pos.getY(), otherPoint.getY(), 2);
                topView.setBounds(new Rectangle(new Point((int)dx, (int)dy), new Dimension((int)((RectangularShape)rec).getWidth(), (int)((RectangularShape)rec).getHeight())));
                label.setLastPos(pos);
            }
            finally {
                this.wait = false;
            }
        }
    }

    private double getMiddle(double xy, double other, int counts) {
        double res = other;
        for (int i = 0; i < counts; ++i) {
            res = (xy + res) / 2.0;
        }
        return res;
    }

    public Point2D getDefaultLabelPosition(TVConnector view, int site) {
        if (1 != site) {
            try {
                Point2D pe;
                Point2D p0;
                Rectangle tmp = null;
                tmp = view.getBounds();
                int labelWidth = 1;
                List points = view.getActualPoints();
                if (site == 0) {
                    p0 = (Point2D)points.get(0);
                    pe = (Point2D)points.get(points.size() - 1);
                } else {
                    p0 = (Point2D)points.get(points.size() - 1);
                    pe = (Point2D)points.get(0);
                }
                if (tmp != null) {
                    double x0 = ((RectangularShape)tmp).getX() + (double)labelWidth;
                    int xdir = labelWidth - 40;
                    if (p0.getX() > pe.getX()) {
                        x0 += ((RectangularShape)tmp).getWidth();
                        xdir = -labelWidth;
                    }
                    double y0 = ((RectangularShape)tmp).getY();
                    int ydir = 30;
                    if (p0.getY() > pe.getY()) {
                        y0 += ((RectangularShape)tmp).getHeight();
                        ydir = -20;
                    }
                    double x = x0 + (double)xdir;
                    double y = y0 + (double)ydir;
                    return new Point2D.Double(x, y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Point2D getCenterPoint(TVConnector view) {
        Point2D.Double p = new Point2D.Double();
        List points = view.getActualPoints();
        Point2D p0 = (Point2D)points.get(0);
        Point2D pe = (Point2D)points.get(points.size() - 1);
        double x = p0.getX() <= pe.getX() ? pe.getX() - p0.getX() : p0.getX() - pe.getX();
        double y = p0.getY() <= pe.getY() ? pe.getY() - p0.getY() : p0.getY() - pe.getY();
        ((Point2D)p).setLocation(x, y);
        return p;
    }

    public Point2D getCenterLabelPosition(TVConnector view) {
        Rectangle tmp = view.getBounds();
        int unit = 1000;
        Point2D.Double pos = new Point2D.Double(500.0, 500.0);
        List points = view.getActualPoints();
        Point2D p0 = (Point2D)points.get(0);
        Point2D pe = (Point2D)points.get(points.size() - 1);
        if (pos != null && tmp != null) {
            double x0 = ((RectangularShape)tmp).getX();
            int xdir = 1;
            if (p0.getX() > pe.getX()) {
                x0 += ((RectangularShape)tmp).getWidth();
                xdir = -1;
            }
            double y0 = ((RectangularShape)tmp).getY();
            int ydir = 1;
            if (p0.getY() > pe.getY()) {
                y0 += ((RectangularShape)tmp).getHeight();
                ydir = -1;
            }
            double x = x0 + (double)xdir * (((RectangularShape)tmp).getWidth() * ((Point2D)pos).getX() / (double)unit);
            double y = y0 + (double)ydir * (((RectangularShape)tmp).getHeight() * ((Point2D)pos).getY() / (double)unit);
            return new Point2D.Double(x, y);
        }
        return null;
    }

    public void removeLabel(int site) {
        Label label = this.getLabel(site);
        if (label != null) {
            this.getDesignPartView().removeViewFor(label);
            label.remove();
            switch (site) {
                case 0: {
                    this.sourceLabel = null;
                    break;
                }
                case 1: {
                    this.centerLabel = null;
                    break;
                }
                case 2: {
                    this.targetLabel = null;
                }
            }
        }
    }

    public Label getLabel(int site) {
        switch (site) {
            case 0: {
                return this.sourceLabel;
            }
            case 1: {
                return this.centerLabel;
            }
            case 2: {
                return this.targetLabel;
            }
        }
        return null;
    }

    public Label getCenterLabel() {
        return this.getLabel(1);
    }

    public Label getSourceLabel() {
        return this.getLabel(0);
    }

    public Label getTargetLabel() {
        return this.getLabel(2);
    }

    public void clearCenterLabel() {
        this.centerLabel = null;
    }

    public void clearSourceLabel() {
        this.sourceLabel = null;
    }

    public void clearTargetLabel() {
        this.targetLabel = null;
    }

    private Label getOrCreateLabel(int site, Rectangle bounds, String text) {
        Label label = this.getLabel(site);
        if (label == null) {
            Point2D.Double pos;
            label = this.getDesignPartView().getDesignPart().createLabel();
            label.setTVConnector(this);
            label.setSite(site);
            TopView topView = this.getDesignPartView().getFirstViewFor(label);
            if (topView == null) {
                topView = this.getDesignPartView().createTopViewFor(label);
            }
            if (((Point2D)(pos = new Point2D.Double(bounds.getX(), bounds.getY()))).getX() == -1.0 && ((Point2D)pos).getY() == -1.0) {
                Point2D defLoc = this.getDefaultLabelPosition(this, site);
                if (defLoc == null) {
                    pos.setLocation(new Point2D.Double(bounds.getX(), bounds.getY()));
                } else {
                    pos.setLocation(defLoc);
                }
            }
            int width = (int)bounds.getWidth();
            int height = (int)bounds.getHeight();
            DefaultFontAndColor dfc = label.isRelationshipAttributesLabel() ? label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                Font font = label.isRelationshipAttributesLabel() ? dfc.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont() : dfc.getFontObject(EditableFonts.FO_TEXT).getFont();
                FontMetrics m = DesignPartView.getGraphics().getFontMetrics(font);
                if (width == -1) {
                    width = m.stringWidth(text) + 10;
                }
                if (height == -1) {
                    height = font.getSize() * 2;
                }
            }
            Rectangle rec = 1 == site ? (bounds.getX() < 0.0 || bounds.getY() < 0.0 || bounds.getWidth() < 0.0 || bounds.getHeight() < 0.0 ? new Rectangle((int)((Point2D)pos).getX() - width / 2, (int)((Point2D)pos).getY() - height / 2, width, height) : new Rectangle(bounds)) : new Rectangle((int)((Point2D)pos).getX(), (int)((Point2D)pos).getY(), width, height);
            switch (site) {
                case 0: {
                    this.sourceLabel = label;
                    this.sourceLabelBounds = rec;
                    this.readProps(this.sourceLabel, this.tempSourceLabel);
                    break;
                }
                case 1: {
                    this.centerLabel = label;
                    this.labelBounds = rec;
                    this.readProps(this.centerLabel, this.tempCenterLabel);
                    break;
                }
                case 2: {
                    this.targetLabel = label;
                    this.targetLabelBounds = rec;
                    this.readProps(this.targetLabel, this.tempTargetLabel);
                }
            }
        }
        return label;
    }

    private void readProps(Label label, Label temp) {
        if (temp != null) {
            label.setUseDefaultColor(temp.useDefaultColor());
            label.setBackgroundColor(temp.getBackgroundColor());
            label.setForegroundColor(temp.getForegroundColor());
            if (label.getTopView() != null && temp.getTopView() != null) {
                label.getTopView().getEditableFonts().clear();
                Iterator it = temp.getTopView().getEditableFonts().iterator();
                while (it.hasNext()) {
                    label.getTopView().getEditableFonts().add(it.next());
                }
            }
            temp.remove();
        }
    }

    protected void displayLabel(String text, Rectangle bounds, int site) {
        Label label = this.getOrCreateLabel(site, bounds, text);
        if (label != null) {
            label.setText(text);
        }
    }

    public void displayLabels() {
    }

    public void connectLabels() {
        Label label = this.getLabel(0);
        if (label != null) {
            label.setConnectorSelected(true);
        }
        if ((label = this.getLabel(1)) != null) {
            label.setConnectorSelected(true);
        }
        if ((label = this.getLabel(2)) != null) {
            label.setConnectorSelected(true);
        }
    }

    public void disconnectLabels() {
        Label label = this.getLabel(0);
        if (label != null) {
            label.setConnectorSelected(false);
        }
        if ((label = this.getLabel(1)) != null) {
            label.setConnectorSelected(false);
        }
        if ((label = this.getLabel(2)) != null) {
            label.setConnectorSelected(false);
        }
    }

    public Label getTempCenterLabel() {
        if (this.tempCenterLabel == null) {
            this.tempCenterLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempCenterLabel.setTVConnector(this);
        }
        return this.tempCenterLabel;
    }

    public Label getTempSourceLabel() {
        if (this.tempSourceLabel == null) {
            this.tempSourceLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempSourceLabel.setTVConnector(this);
        }
        return this.tempSourceLabel;
    }

    public Label getTempTargetLabel() {
        if (this.tempTargetLabel == null) {
            this.tempTargetLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempTargetLabel.setTVConnector(this);
        }
        return this.tempTargetLabel;
    }

    public TopView getSourceTopView() {
        return ((ConnectionInterface)((Object)this.getModel())).getSourceTopView(this.getDesignPartView());
    }

    public TopView getTargetTopView() {
        return ((ConnectionInterface)((Object)this.getModel())).getTargetTopView(this.getDesignPartView());
    }

    public List getLabels() {
        ArrayList<Label> list = new ArrayList<Label>();
        if (this.sourceLabel != null) {
            list.add(this.sourceLabel);
        }
        if (this.targetLabel != null) {
            list.add(this.targetLabel);
        }
        if (this.centerLabel != null) {
            list.add(this.centerLabel);
        }
        return list;
    }

    public Rectangle getLabelBoundsFor(int site) {
        switch (site) {
            case 0: {
                return this.getSourceLabelBounds();
            }
            case 1: {
                return this.getLabelBounds();
            }
            case 2: {
                return this.getTargetLabelBounds();
            }
        }
        return new Rectangle(-1, -1, -1, -1);
    }

    public void setLabelBoundsFor(Rectangle rect, int site) {
        switch (site) {
            case 0: {
                this.setSourceLabelBounds(rect);
                break;
            }
            case 1: {
                this.setLabelBounds(rect);
                break;
            }
            case 2: {
                this.setTargetLabelBounds(rect);
            }
        }
    }

    public void setLabel(Label label, int site) {
        switch (site) {
            case 0: {
                this.sourceLabel = label;
                break;
            }
            case 1: {
                this.centerLabel = label;
                break;
            }
            case 2: {
                this.targetLabel = label;
            }
        }
    }

    public List getActualPoints() {
        ArrayList<Point2D> list = null;
        List edgePoints = this.getEdgePoints();
        for (int i = 0; i < edgePoints.size(); ++i) {
            Object obj = edgePoints.get(i);
            Point2D p = (Point2D)obj;
            if (list == null) {
                list = new ArrayList<Point2D>();
            }
            list.add(p);
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public Rectangle getLineBounds() {
        List list = this.getActualPoints();
        if (list.size() > 0) {
            Point2D p = (Point2D)list.get(0);
            Rectangle r = new Rectangle((int)p.getX(), (int)p.getY());
            for (int i = 1; i < list.size(); ++i) {
                p = (Point2D)list.get(i);
                Rectangle rt = new Rectangle((int)p.getX(), (int)p.getY());
                r.union(rt);
            }
            return r;
        }
        return null;
    }

    public void resetEdgeParams() {
    }

    public boolean isSelfReference() {
        TopView s = this.getSourceTopView();
        TopView t = this.getTargetTopView();
        return s != null && t != null && s == t;
    }

    public void straightLine(boolean checkChanges, boolean deletePoints) {
        try {
            if (this.isSelfReference()) {
                this.createDefaultSelfReferencePoints();
                return;
            }
            int n = this.getEdgePoints().size();
            if (!deletePoints && n > 2) {
                return;
            }
            if (n > 2) {
                for (int i = n - 2; i >= 1; --i) {
                    this.getEdgePoints().remove(i);
                }
            }
            Point2D ps = null;
            Point2D pt = null;
            ContainerView source = (ContainerView)this.getSourceTopView();
            ContainerView target = (ContainerView)this.getTargetTopView();
            Point2D sc = source.getCenterPoint();
            Point2D tc = target.getCenterPoint();
            if (source != null && target != null && source != target) {
                Rectangle sr = source.getBounds();
                Rectangle tr = target.getBounds();
                if (((RectangularShape)sr).getY() <= tr.getMaxY() && ((RectangularShape)sr).getY() >= ((RectangularShape)tr).getY() || ((RectangularShape)tr).getY() <= sr.getMaxY() && ((RectangularShape)tr).getY() >= ((RectangularShape)sr).getY()) {
                    double min = Math.max(((RectangularShape)sr).getY(), ((RectangularShape)tr).getY());
                    double my = Math.min(sr.getMaxY(), tr.getMaxY());
                    double y = (min + my) / 2.0;
                    ps = source.getPerimeterPoint(null, tc, false, false);
                    pt = target.getPerimeterPoint(null, sc, false, false);
                    if (!checkChanges || ps.getY() != pt.getY() || ps.getY() < min || ps.getY() > my) {
                        if (ps == null) {
                            ps = new Point2D.Double();
                        }
                        if (pt == null) {
                            pt = new Point2D.Double();
                        }
                        if (((RectangularShape)sr).getX() >= ((RectangularShape)tr).getX()) {
                            ps.setLocation(((RectangularShape)sr).getX(), y);
                        } else {
                            ps.setLocation(sr.getMaxX(), y);
                        }
                        if (((RectangularShape)tr).getX() >= ((RectangularShape)sr).getX()) {
                            pt.setLocation(((RectangularShape)tr).getX(), y);
                        } else {
                            pt.setLocation(tr.getMaxX(), y);
                        }
                        double lt = y;
                        double lb = y;
                        while (source.getOtherPointAt(ps, this) != null && lb + (double)this.offset <= my && lt - (double)this.offset >= min) {
                            ps.setLocation(ps.getX(), lb + (double)this.offset);
                            lb = ps.getY();
                            if (source.getOtherPointAt(ps, this) == null) continue;
                            ps.setLocation(ps.getX(), lt - (double)this.offset);
                            lt = ps.getY();
                        }
                        pt.setLocation(pt.getX(), ps.getY());
                        lb = lt = pt.getY();
                        while (target.getOtherPointAt(pt, this) != null && lb + (double)this.offset <= my && lt - (double)this.offset >= min) {
                            pt.setLocation(pt.getX(), lb + (double)this.offset);
                            lb = pt.getY();
                            if (target.getOtherPointAt(pt, this) == null) continue;
                            pt.setLocation(pt.getX(), lt - (double)this.offset);
                            lt = pt.getY();
                        }
                        ps.setLocation(ps.getX(), pt.getY());
                    }
                } else if (((RectangularShape)sr).getX() <= tr.getMaxX() && ((RectangularShape)sr).getX() >= ((RectangularShape)tr).getX() || ((RectangularShape)tr).getX() <= sr.getMaxX() && ((RectangularShape)tr).getX() >= ((RectangularShape)sr).getX()) {
                    double min = Math.max(((RectangularShape)sr).getX(), ((RectangularShape)tr).getX());
                    double mx = Math.min(sr.getMaxX(), tr.getMaxX());
                    double x = (min + mx) / 2.0;
                    ps = source.getPerimeterPoint(null, tc, false, false);
                    pt = target.getPerimeterPoint(null, sc, false, false);
                    if (!checkChanges || ps.getX() != pt.getX() || ps.getX() < min || ps.getX() > mx) {
                        if (ps == null) {
                            ps = new Point2D.Double();
                        }
                        if (pt == null) {
                            pt = new Point2D.Double();
                        }
                        if (((RectangularShape)sr).getY() >= ((RectangularShape)tr).getY()) {
                            ps.setLocation(x, ((RectangularShape)sr).getY());
                        } else {
                            ps.setLocation(x, sr.getMaxY());
                        }
                        if (((RectangularShape)tr).getY() >= ((RectangularShape)sr).getY()) {
                            pt.setLocation(x, ((RectangularShape)tr).getY());
                        } else {
                            pt.setLocation(x, tr.getMaxY());
                        }
                        double ll = x;
                        double lr = x;
                        while (source.getOtherPointAt(ps, this) != null && lr + (double)this.offset <= mx && ll - (double)this.offset >= min) {
                            ps.setLocation(lr + (double)this.offset, ps.getY());
                            lr = ps.getX();
                            if (source.getOtherPointAt(ps, this) == null) continue;
                            ps.setLocation(ll - (double)this.offset, ps.getY());
                            ll = ps.getX();
                        }
                        pt.setLocation(ps.getX(), pt.getY());
                        lr = ll = pt.getX();
                        while (target.getOtherPointAt(pt, this) != null && lr + (double)this.offset <= mx && ll - (double)this.offset >= min) {
                            pt.setLocation(lr + (double)this.offset, pt.getY());
                            lr = pt.getX();
                            if (target.getOtherPointAt(pt, this) == null) continue;
                            pt.setLocation(ll - (double)this.offset, pt.getY());
                            ll = pt.getX();
                        }
                        ps.setLocation(pt.getX(), ps.getY());
                    }
                } else {
                    ps = source.getPerimeterPoint(null, tc, false, true);
                    pt = target.getPerimeterPoint(null, sc, false, true);
                }
            }
            this.getEdgePoints().clear();
            this.getEdgePoints().add(ps);
            this.getEdgePoints().add(pt);
            source.addConnection(ps, this);
            target.addConnection(pt, this);
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public List createDefaultSelfReferencePoints() {
        List points = this.getEdgePoints();
        Point2D[] routed = null;
        ContainerView cv = (ContainerView)this.getSourceTopView();
        Rectangle bounds = this.getSourceTopView().getBounds();
        double index = 25.0;
        routed = new Point2D[]{new Point2D.Double(((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth() + index, ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight() / 2.0), new Point2D.Double(((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth() + index, ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight() + index), new Point2D.Double(((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth() * 0.6, ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight() + index)};
        points.clear();
        Point2D p = cv.getPerimeterPoint(null, routed[0], false, true);
        points.add(p);
        cv.addConnection(p, this);
        for (int i = 0; i < routed.length; ++i) {
            points.add(routed[i]);
        }
        p = cv.getPerimeterPoint(null, routed[routed.length - 1], false, true);
        points.add(p);
        cv.addConnection(p, this);
        return points;
    }
}

