/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSingleFile;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReports;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.ResourceProvider;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CLIReportsGenerator {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
    private final String SHOW = "show";
    private String reportsPath;
    private String reportFileName = "";
    private String xsltFile = null;
    String modelExtraFilesDirName = "";
    private String reportFilesDirName;
    private String fileFormat;
    private Design design;
    private String reportCaption = "";
    private String customReportFileName = "";
    int openedDiagramscounter = 0;
    private List currentObjectsList;
    private HashMap extraParams;
    private Settings settings;
    private String cssFiles = "";
    private StandardReportTemplate reportTemplate;
    private ResourceProvider resourceProvider;
    private MetaDataManager metaDataManager;
    private HashMap<DesignPartViewPlaceHolder, List<String>> subviewsMap;
    private Boolean replaceBooleanValues;
    private String strTrue;
    private String strFalse;
    private Boolean addTables;
    private Boolean addViews;
    private LinkedHashMap<String, List> swObjectsMap;
    private static final Logger LOGGER = new Logger(CLIReportsGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(Class clazz, ModelIDObject model, List objects, HashMap extraParams, OutputStream outStream, DesignPartView dpv, boolean createTOC) {
        block129: {
            Document doc = null;
            File outputFile = null;
            this.reportTemplate = (StandardReportTemplate)extraParams.get("report_template");
            CustomReportTemplate customReportTemplate = (CustomReportTemplate)extraParams.get("custom_report_template");
            this.metaDataManager = XMLTransformationManager.getInstance().getMetaDataManager();
            if (model != null) {
                this.modelExtraFilesDirName = model.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + model.getShortObjectID();
                this.design = model.getDesign();
            }
            this.extraParams = extraParams;
            this.settings = this.design.getSettings();
            this.reportsPath = (String)extraParams.get("reports_path");
            this.fileFormat = ((String)extraParams.get("out_format")).toLowerCase();
            this.reportCaption = (String)extraParams.get("reportCaption");
            this.customReportFileName = ((String)extraParams.get("reportCustomFilenName")).trim();
            this.subviewsMap = (HashMap)extraParams.get("subviews");
            this.addTables = (Boolean)extraParams.get("addTables");
            this.addViews = (Boolean)extraParams.get("addViews");
            this.cssFiles = (String)extraParams.get("cssFiles");
            this.currentObjectsList = new ArrayList();
            this.swObjectsMap = new LinkedHashMap();
            if (clazz == Table.class || clazz == Column.class || clazz == FKIndexAssociation.class || clazz == Index.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleTableDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleTableData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleTableDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllTablesData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllTablesDetails.xslt";
                }
            } else if (clazz == TableView.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleTableViewDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleTableViewData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleTableViewDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesViewsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllTablesViewsData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllTablesViewsDetails.xslt";
                }
            } else if (clazz == Entity.class || clazz == Attribute.class || clazz == CandidateKey.class || clazz == Relation.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleEntityDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleEntityData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleEntityDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllEntitiesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllEntitiesData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllEntitiesDetails.xslt";
                }
            } else if (clazz == EntityView.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleEntityViewDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    this.reportFilesDirName = this.reportFileName + "_files";
                    new File(this.reportsPath, this.reportFilesDirName).mkdir();
                    doc = this.gatherSingleEntityViewData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleEntityViewDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllEntitiesViewsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllEntitiesViewsData((DesignPart)model, this.reportTemplate, this.subviewsMap, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllEntitiesViewsDetails.xslt";
                }
            } else if (clazz == StructuredType.class || clazz == TypeElement.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleStructuredTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleStructuredTypeData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleStructuredTypeDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllStructuredTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllStructuredTypesData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllStructuredTypesDetails.xslt";
                }
            } else if (clazz == CollectionType.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleCollectionTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleCollectionTypeData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleCollectionTypeDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllCollectionTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllCollectionTypesData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllCollectionTypesDetails.xslt";
                }
            } else if (clazz == DistinctType.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleDistinctTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleDistinctTypeData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleDistinctTypeDetails.xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllDistinctTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllDistinctTypesData((DesignPart)model, this.reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllDistinctTypesDetails.xslt";
                }
            } else if (clazz == Domain.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllDomainsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherAllDomainsData((DesignPart)model, this.reportTemplate);
                this.xsltFile = "datamodeler/reports/xslt/10/AllDomainsDetails.xslt";
            } else if (clazz == Label.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesaAndViewsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherAllTablesAndViewsData((DesignPart)model, this.reportTemplate, objects);
                this.xsltFile = "datamodeler/reports/xslt/10/AllTablesAndViewsDetails.xslt";
            } else if (clazz == SearchResultsReports.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SearchResultsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.generateSearchResultsDomDocument(customReportTemplate, model, objects, extraParams);
                this.xsltFile = "datamodeler/reports/xslt/10/SearchResults.xslt";
            }
            outputFile = new File(this.reportsPath, this.reportFileName);
            BufferedReader xmlISR = null;
            InputStream xsltIS = null;
            OutputStreamWriter xmlOSW = null;
            OutputStreamWriter osw = null;
            PrintWriter htmlIDXPW = null;
            PrintWriter htmlTOCPW = null;
            try {
                if (doc != null) {
                    DOMSource domSource = new DOMSource(doc);
                    ByteArrayOutputStream xmlOutStream = new ByteArrayOutputStream();
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)xmlOutStream, "UTF-8");
                    StreamResult result = new StreamResult(out);
                    TransformerFactory trFact = null;
                    try {
                        trFact = TransformerFactory.newInstance();
                        trFact.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        trFact.setURIResolver(IgnoreURIResolver.INSTANCE);
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                    Transformer tr = trFact.newTransformer();
                    tr.setOutputProperty("encoding", "UTF-8");
                    tr.transform(domSource, result);
                    ByteArrayInputStream inStream = new ByteArrayInputStream(xmlOutStream.toByteArray());
                    InputStreamReader inr = new InputStreamReader((InputStream)inStream, Charset.forName("UTF-8"));
                    StreamSource xmlStreamSource = new StreamSource(inr);
                    if (this.xsltFile != null) {
                        xsltIS = this.getInputStreamFor(this.xsltFile);
                        StreamSource xsltSource = new StreamSource(xsltIS);
                        TransformerFactory transFact = TransformerFactory.newInstance();
                        transFact.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        transFact.setURIResolver(IgnoreURIResolver.INSTANCE);
                        Transformer trans = transFact.newTransformer(xsltSource);
                        trans.setOutputProperty("encoding", "UTF-8");
                        if (this.cssFiles.trim() != "") {
                            String paramName = "p";
                            int c = 0;
                            for (String s : Arrays.asList(this.cssFiles.split("\\s+"))) {
                                trans.setParameter(paramName + ++c, s);
                            }
                        }
                        trans.setOutputProperty("encoding", "UTF-8");
                        if (outStream == null) {
                            FileOutputStream fos = new FileOutputStream(outputFile);
                            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                            trans.transform(xmlStreamSource, new StreamResult(osw));
                            osw.flush();
                            fos.close();
                        } else if (this.settings.isGenerateHTMLReportTOCInSeparateFile() || !createTOC) {
                            osw = new OutputStreamWriter(outStream, "UTF-8");
                            trans.transform(xmlStreamSource, new StreamResult(osw));
                            osw.flush();
                        } else {
                            ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
                            osw = new OutputStreamWriter((OutputStream)tempStream, "UTF-8");
                            StreamResult sr = new StreamResult(osw);
                            trans.transform(xmlStreamSource, sr);
                            TreeMap<String, ModelIDObject> map = new TreeMap<String, ModelIDObject>();
                            if (createTOC) {
                                for (Object next : objects) {
                                    ModelIDObject obj = next instanceof SearchResultObject ? (ModelIDObject)((SearchResultObject)next).getObj() : (ModelIDObject)next;
                                    if (this.addTables.booleanValue() && obj instanceof Table || obj instanceof Entity) {
                                        map.put(obj.getLongName(), obj);
                                        continue;
                                    }
                                    if ((!this.addViews.booleanValue() || !(obj instanceof TableView)) && !(obj instanceof EntityView)) continue;
                                    map.put(obj.getLongName(), obj);
                                }
                            }
                            StringBuffer diagrams = new StringBuffer();
                            ArrayList<String> diagramsNameList = new ArrayList<String>();
                            if (dpv != null) {
                                diagrams.append("<br><br>");
                                diagrams.append("<h3 id=\"" + dpv.getName() + "\">").append(dpv.getName()).append("</h3>");
                                diagrams.append(DiagramToSVG.getSVGForDiagram(dpv, true, "__dg_rm", false, null));
                                diagrams.append("<br><hr>");
                                diagramsNameList.add(dpv.getName());
                            }
                            if (this.subviewsMap.size() > 0) {
                                for (Map.Entry<DesignPartViewPlaceHolder, List<String>> pair : this.subviewsMap.entrySet()) {
                                    DesignPartViewPlaceHolder sw = pair.getKey();
                                    DesignPartView svDPV = sw.getDesignPartView();
                                    diagrams.append("<br><br>");
                                    diagrams.append("<h3 id=\"" + svDPV.getName() + "\">").append(svDPV.getName()).append("</h3>");
                                    diagrams.append(DiagramToSVG.getSVGForDiagram(svDPV, true, "__dg_rm", false, null));
                                    diagrams.append("<br><hr>");
                                    diagramsNameList.add(svDPV.getName());
                                }
                            }
                            PrintStream printStream = new PrintStream(outStream, false, "UTF-8");
                            StringBuffer buf = HTMLReportSingleFile.createHTML(map, tempStream, diagrams.toString(), "", diagramsNameList);
                            printStream.print(buf);
                        }
                    } else {
                        LOGGER.error("Required XSLT file " + this.xsltFile + " for report generation not found. Process is terminated.");
                    }
                    break block129;
                }
                LOGGER.error("DomDocument missing or invalid");
            }
            catch (TransformerConfigurationException e) {
                LOGGER.error("TransformerConfigurationException during report generation " + e);
            }
            catch (TransformerException e) {
                LOGGER.error("TransformerException during report generation" + e);
            }
            catch (FileNotFoundException e) {
                if (e.getMessage().contains("Access is denied")) {
                    LOGGER.error("FileNotFoundException during report generation " + e);
                } else {
                    LOGGER.error("FileNotFoundException during report generation " + e);
                }
            }
            catch (IOException e) {
                LOGGER.error("IOException during report generation " + e);
            }
            catch (Throwable e) {
                LOGGER.error("IOException during report generation " + e);
            }
            finally {
                if (xmlOSW != null) {
                    try {
                        xmlOSW.flush();
                        xmlOSW.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + e);
                    }
                }
                if (osw != null) {
                    try {
                        if (outStream == null) {
                            osw.flush();
                            osw.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + this.reportFileName + ": " + e);
                    }
                }
                if (htmlIDXPW != null) {
                    htmlIDXPW.close();
                }
                if (htmlTOCPW != null) {
                    htmlTOCPW.close();
                }
                if (xmlISR != null) {
                    try {
                        xmlISR.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close the buffered reader : " + e);
                    }
                }
                if (xsltIS != null) {
                    try {
                        xsltIS.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT file : " + e);
                    }
                }
            }
        }
    }

    private Document gatherSingleTableData(DesignPart model, StandardReportTemplate reportTemplate, List tables) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/table", "osdmSingleTable:Table");
            document.appendChild(rootElement);
            String namespace = "osdmSingleTable:";
            this.createHeaderSection(document, namespace, rootElement, model);
            Table table = (Table)tables.get(0);
            this.currentObjectsList.add(table);
            this.createTableDetailsSection(document, namespace, rootElement, table);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single table report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private int processFKeysReferFrom(FKContainer table, Document document, Element tableDetails, String namespace) {
        int fkCount = 0;
        Element e = null;
        Element fkCollection = null;
        FKIndexAssociationSet set = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet();
        for (FKIndexAssociation fk : set.getAssociationsWith(table)) {
            if (fkCount == 0) {
                fkCollection = document.createElement(namespace + "FKRFCollection");
                tableDetails.appendChild(fkCollection);
            }
            Element fkDetails = document.createElement(namespace + "FKRFDetails");
            fkCollection.appendChild(fkDetails);
            e = document.createElement(namespace + "FKName");
            e.appendChild(document.createTextNode(fk.getName()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferredFrom");
            e.appendChild(document.createTextNode(fk.getContainerWithKeyObject().getName()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKMandatory");
            e.appendChild(document.createTextNode(fk.isMandatory() ? "Y" : ""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKTransferable");
            e.appendChild(document.createTextNode(fk.isTransferable() ? "Y" : ""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKInArc");
            e.appendChild(document.createTextNode(fk.getArc() != null ? "Y" : ""));
            fkDetails.appendChild(e);
            List<ContainedObject> rFKList = null;
            KeyObject ri = fk.getRemoteIndex();
            if (ri != null) {
                rFKList = Arrays.asList(ri.getElements());
            }
            List<ContainedObject> lFKList = Arrays.asList(fk.getLocalFKIndex().getElements());
            LinkedHashMap<FKElement, FKElement> fkColumnsMap = new LinkedHashMap<FKElement, FKElement>();
            for (int i = 0; i < lFKList.size(); ++i) {
                FKElement localColumn = (FKElement)lFKList.get(i);
                FKElement remoteColumn = null;
                if (rFKList != null) {
                    remoteColumn = (FKElement)rFKList.get(i);
                }
                fkColumnsMap.put(localColumn, remoteColumn);
            }
            String columnsNames = "";
            String refColumnsNames = "";
            for (Map.Entry pairs : fkColumnsMap.entrySet()) {
                FKElement lColumn = (FKElement)pairs.getKey();
                FKElement rColumn = (FKElement)pairs.getValue();
                if (lColumn != null) {
                    columnsNames = columnsNames + "\n" + lColumn.getName();
                }
                if (rColumn == null) continue;
                refColumnsNames = refColumnsNames + "\n" + rColumn.getName();
            }
            e = document.createElement(namespace + "FKColumnName");
            e.appendChild(document.createTextNode(refColumnsNames.trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferredColumnName");
            e.appendChild(document.createTextNode(columnsNames.trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKDeleteRule");
            e.appendChild(document.createTextNode(fk.getDeleteRule().equals("NO ACTION") ? "" : fk.getDeleteRule()));
            fkDetails.appendChild(e);
            ++fkCount;
        }
        return fkCount;
    }

    /*
     * WARNING - void declaration
     */
    private int processFKeysReferTo(FKContainer table, Document document, Element tableDetails, String namespace) {
        String columnsNames;
        Element fkDetails;
        int fkCount = 0;
        Element e = null;
        Element fkCollection = null;
        for (FKIndexAssociation fk : table.getFKAssociationsList()) {
            Object rFKList;
            KeyObject ri;
            if (fkCount == 0) {
                fkCollection = document.createElement(namespace + "FKRTCollection");
                tableDetails.appendChild(fkCollection);
            }
            if ((ri = fk.getRemoteIndex()) == null) {
                fkDetails = document.createElement(namespace + "FKRTDetails");
                fkCollection.appendChild(fkDetails);
                e = document.createElement(namespace + "FKName");
                e.appendChild(document.createTextNode(fk.getName()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferringTo");
                e.appendChild(document.createTextNode(fk.getReferredTableLongName()));
                fkDetails.appendChild(e);
                rFKList = fk.getReferredColumnNames();
                columnsNames = "";
                for (FKElement fKElement : Arrays.asList(fk.getLocalFKIndex().getElements())) {
                    if (fKElement == null) continue;
                    columnsNames = columnsNames + "\n" + fKElement.getName();
                }
                e = document.createElement(namespace + "FKColumnName");
                e.appendChild(document.createTextNode(columnsNames.trim()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferredColumnName");
                e.appendChild(document.createTextNode(((String)rFKList).replaceAll(",", "\n")));
                fkDetails.appendChild(e);
            } else {
                void var15_20;
                void var15_18;
                fkDetails = document.createElement(namespace + "FKRTDetails");
                fkCollection.appendChild(fkDetails);
                e = document.createElement(namespace + "FKName");
                e.appendChild(document.createTextNode(fk.getName()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferringTo");
                e.appendChild(document.createTextNode(fk.getRemoteTable().getName()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKMandatory");
                e.appendChild(document.createTextNode(fk.isMandatory() ? "Y" : ""));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKTransferable");
                e.appendChild(document.createTextNode(fk.isTransferable() ? "Y" : ""));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKInArc");
                e.appendChild(document.createTextNode(fk.getArc() != null ? "Y" : ""));
                fkDetails.appendChild(e);
                rFKList = Arrays.asList(ri.getElements());
                List<ContainedObject> lFKList = Arrays.asList(fk.getLocalFKIndex().getElements());
                LinkedHashMap<FKElement, FKElement> fkColumnsMap = new LinkedHashMap<FKElement, FKElement>();
                boolean bl = false;
                while (var15_18 < lFKList.size()) {
                    FKElement localColumn = (FKElement)lFKList.get((int)var15_18);
                    FKElement remoteColumn = null;
                    if (rFKList != null) {
                        remoteColumn = (FKElement)rFKList.get((int)var15_18);
                    }
                    fkColumnsMap.put(localColumn, remoteColumn);
                    ++var15_18;
                }
                String string = "";
                String refColumnsNames = "";
                for (Map.Entry pairs : fkColumnsMap.entrySet()) {
                    FKElement lColumn = (FKElement)pairs.getKey();
                    FKElement rColumn = (FKElement)pairs.getValue();
                    if (lColumn != null) {
                        String string2 = (String)var15_20 + "\n" + lColumn.getName();
                    }
                    if (rColumn == null) continue;
                    refColumnsNames = refColumnsNames + "\n" + rColumn.getName();
                }
                e = document.createElement(namespace + "FKColumnName");
                e.appendChild(document.createTextNode(var15_20.trim()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferredColumnName");
                e.appendChild(document.createTextNode(refColumnsNames.trim()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKDeleteRule");
                e.appendChild(document.createTextNode(fk.getDeleteRule().equals("NO ACTION") ? "" : fk.getDeleteRule()));
                fkDetails.appendChild(e);
            }
            ++fkCount;
        }
        for (Join join : table.getImpliedFKeys()) {
            if (fkCount == 0) {
                fkCollection = document.createElement(namespace + "FKRTCollection");
                tableDetails.appendChild(fkCollection);
            }
            fkDetails = document.createElement(namespace + "FKRTDetails");
            fkCollection.appendChild(fkDetails);
            e = document.createElement(namespace + "FKName");
            String nameText = "implied Fkey - source:\n";
            nameText = nameText + join.getFormattedDiscoverySource();
            e.appendChild(document.createTextNode(nameText));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferringTo");
            e.appendChild(document.createTextNode(join.getRefTableLongName()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKMandatory");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKTransferable");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKInArc");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
            columnsNames = join.getColumnName();
            String refColumnsNames = join.getRefColumnName();
            e = document.createElement(namespace + "FKColumnName");
            e.appendChild(document.createTextNode(columnsNames.trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferredColumnName");
            e.appendChild(document.createTextNode(refColumnsNames.trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKDeleteRule");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
        }
        return fkCount;
    }

    private Document gatherSingleEntityData(DesignPart model, StandardReportTemplate reportTemplate, List entities) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entity", "osdmSingleEntity:Entity");
            document.appendChild(rootElement);
            String namespace = "osdmSingleEntity:";
            this.createHeaderSection(document, namespace, rootElement, model);
            Entity entity = (Entity)entities.get(0);
            this.currentObjectsList.add(entity);
            this.createEntityDetailsSection(document, namespace, rootElement, entity);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single entity report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllEntitiesData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List entities) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entities", "osdmAllEntities:Entities");
            document.appendChild(rootElement);
            String namespace = "osdmAllEntities:";
            this.createHeaderSection(document, namespace, rootElement, model);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, entities);
            Element entitiesCollection = document.createElement(namespace + "EntitiesCollection");
            rootElement.appendChild(entitiesCollection);
            if (entities.size() > 0) {
                this.currentObjectsList = entities;
            } else {
                Iterator it0 = ((LogicalDesign)model).getEntitySet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (Entity entity : this.currentObjectsList) {
                Element entityDetails = document.createElement(namespace + "EntityDetails");
                entitiesCollection.appendChild(entityDetails);
                this.createEntityDetailsSection(document, namespace, entityDetails, entity);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all entities report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Element createHeaderSection(Document document, String namespace, Element rootElement, DesignPart model) {
        Element rCaption = document.createElement(namespace + "ReportCaption");
        rCaption.appendChild(document.createTextNode(this.reportCaption));
        rootElement.appendChild(rCaption);
        Element rCompanyName = document.createElement(namespace + "CompanyName");
        rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
        rootElement.appendChild(rCompanyName);
        Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
        usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
        rootElement.appendChild(usePageBreaks);
        if (model != null) {
            Element e = document.createElement(namespace + "DesignName");
            e.appendChild(document.createTextNode(this.design.getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "VersionDate");
            e.appendChild(document.createTextNode(dateFormat.format(new Date())));
            rootElement.appendChild(e);
            String designComment = this.design.getComment();
            if (designComment != "" && designComment != null) {
                Element versionCommentElement = document.createElement(namespace + "VersionComment");
                versionCommentElement.appendChild(document.createCDATASection(designComment));
                rootElement.appendChild(versionCommentElement);
            }
            e = document.createElement(namespace + "ModelName");
            e.appendChild(document.createTextNode(model.getName()));
            rootElement.appendChild(e);
        }
        return rootElement;
    }

    private Element createSubviewsSection(Document document, String namespace, Element baseElement, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, DesignPart model, List objects) {
        Element subViewsCollectionElement = document.createElement(namespace + "SubViewsCollection");
        try {
            ArrayList<DesignPartViewPlaceHolder> sortedSWList = new ArrayList<DesignPartViewPlaceHolder>();
            if (subViewsMap.size() == 0) {
                sortedSWList.addAll(model.getAllDPVPlaceHoldersForObjects(objects, this.settings.isEmbedMainDiagramInReports()));
            } else {
                for (Map.Entry<DesignPartViewPlaceHolder, List<String>> entry : subViewsMap.entrySet()) {
                    DesignPartViewPlaceHolder sw = entry.getKey();
                    sortedSWList.add(sw);
                }
            }
            Collections.sort(sortedSWList, new SubviewsComparator());
            if (this.reportTemplate.isUseDiagrams() && sortedSWList.size() > 0) {
                for (DesignPartViewPlaceHolder sw : sortedSWList) {
                    if (sw.getDesignPartView().isMainDiagram()) continue;
                    Element subViewsDetailsElement = document.createElement(namespace + "SubViewsDetails");
                    Element swNameElement = document.createElement(namespace + "SWName");
                    String swName = "";
                    swName = this.settings.isEmbedDiagramsInReports() ? sw.getName() : this.reportFilesDirName + "/" + sw.getName() + ".pdf";
                    swNameElement.appendChild(document.createTextNode(swName));
                    subViewsDetailsElement.appendChild(swNameElement);
                    Element swDiagramLinkElement = document.createElement(namespace + "SWDiagramLink");
                    if (this.settings.isEmbedDiagramsInReports()) {
                        if (((String)this.extraParams.get("out_format")).equals("HTML")) {
                            swDiagramLinkElement.appendChild(document.createTextNode(URLEncoder.encode(swName, "UTF-8").replace("+", "%20")));
                        } else {
                            swDiagramLinkElement.appendChild(document.createTextNode(swName));
                        }
                    } else {
                        swDiagramLinkElement.appendChild(document.createTextNode(swName));
                    }
                    subViewsDetailsElement.appendChild(swDiagramLinkElement);
                    String description = "";
                    description = sw.getComment() == null || sw.getComment().equals("") ? sw.getCommentInRDBMS() : sw.getComment();
                    String notes = sw.getNotes();
                    if (description != "" && description != null || notes != "" && notes != null) {
                        Element descriptionNotesElement = document.createElement(namespace + "SWDescriptionNotes");
                        if (description != "" && description != null) {
                            Element descriptionElement = document.createElement(namespace + "SWDescription");
                            descriptionElement.appendChild(document.createCDATASection(description));
                            descriptionNotesElement.appendChild(descriptionElement);
                        }
                        if (notes != "" && notes != null) {
                            Element notesElement = document.createElement(namespace + "SWNotes");
                            notesElement.appendChild(document.createCDATASection(notes));
                            descriptionNotesElement.appendChild(notesElement);
                        }
                        subViewsDetailsElement.appendChild(descriptionNotesElement);
                    }
                    Iterator it = null;
                    Object o = objects.get(0);
                    if (o instanceof Table) {
                        it = ((DPVRelational)sw.getDesignPartView()).getTables().iterator();
                    } else if (o instanceof Entity) {
                        it = ((DPVLogical)sw.getDesignPartView()).getEntities().iterator();
                    } else if (o instanceof TableView) {
                        it = ((DPVRelational)sw.getDesignPartView()).getTVViews().iterator();
                    } else if (o instanceof EntityView) {
                        it = ((DPVLogical)sw.getDesignPartView()).getTVViews().iterator();
                    }
                    List<String> swObjectsList = subViewsMap.get(sw);
                    if (swObjectsList == null) {
                        swObjectsList = new ArrayList<String>();
                        while (it.hasNext()) {
                            ContainerView tv;
                            Object dObject;
                            Object dObj = dObject = it.next();
                            if (dObject instanceof TVView) {
                                tv = (TVView)dObject;
                                dObj = tv.getModel();
                            } else if (dObject instanceof TVEntityView) {
                                tv = (TVEntityView)dObject;
                                dObj = tv.getModel();
                            }
                            if (!objects.contains(dObj)) continue;
                            swObjectsList.add((String)dObj);
                        }
                    }
                    String suffix = "";
                    Collections.sort(swObjectsList, new ObjectsComparator());
                    ArrayList<String> swObjectsListNames = new ArrayList<String>();
                    Element swObjectsElement = document.createElement(namespace + "SWObjects");
                    if (swObjectsList != null && swObjectsList.size() > 0) {
                        for (DesignObject designObject : swObjectsList) {
                            String objName = designObject.getLongName();
                            Element swObjectElement = document.createElement(namespace + "SWObject");
                            swObjectsElement.appendChild(swObjectElement);
                            Element swObjectNameElement = document.createElement(namespace + "SWObjectName");
                            swObjectNameElement.appendChild(document.createTextNode(objName));
                            swObjectElement.appendChild(swObjectNameElement);
                            Element swObjectLinkElement = document.createElement(namespace + "SWObjectLink");
                            swObjectLinkElement.appendChild(document.createTextNode(URLEncoder.encode(suffix.isEmpty() ? designObject.getShortObjectID() : designObject.getShortObjectID() + suffix, "UTF-8").replace("+", "%20")));
                            swObjectElement.appendChild(swObjectLinkElement);
                            swObjectsListNames.add(designObject.getName());
                        }
                    }
                    subViewsDetailsElement.appendChild(swObjectsElement);
                    subViewsCollectionElement.appendChild(subViewsDetailsElement);
                    this.swObjectsMap.put(swName, swObjectsListNames);
                }
                baseElement.appendChild(subViewsCollectionElement);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Subviews Section : " + e.getMessage(), e);
            return subViewsCollectionElement;
        }
        return baseElement;
    }

    private Element createEntityDetailsSection(Document document, String namespace, Element baseElement, DesignObject object) {
        try {
            Iterator<Object> atrributesIterator;
            Element attributesCollection;
            Element e;
            Entity entity = null;
            EntityView entityView = null;
            boolean isEntity = false;
            if (object instanceof Entity) {
                entity = (Entity)object;
                isEntity = true;
                e = document.createElement(namespace + "EntityName");
                e.appendChild(document.createTextNode(entity.getName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedEntityName");
                e.appendChild(document.createTextNode(entity.getShortObjectID()));
                baseElement.appendChild(e);
            } else if (object instanceof EntityView) {
                entityView = (EntityView)object;
                isEntity = false;
                e = document.createElement(namespace + "ViewName");
                e.appendChild(document.createTextNode(entityView.getLongName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedViewName");
                e.appendChild(document.createTextNode(entityView.getShortObjectID()));
                baseElement.appendChild(e);
            }
            if (isEntity) {
                e = document.createElement(namespace + "Abbreviation");
                e.appendChild(document.createTextNode(entity.getPreferredAbbreviation()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ClassificationTypeName");
                e.appendChild(document.createTextNode(""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ObjectTypeName");
                e.appendChild(document.createTextNode(entity.getBasedOnStructuredType() != null ? entity.getBasedOnStructuredType().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "SuperType");
                e.appendChild(document.createTextNode(entity.getHierarchicalParent() != null ? entity.getHierarchicalParent().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "Synonyms");
                e.appendChild(document.createTextNode(entity.getSynonym()));
                baseElement.appendChild(e);
            } else {
                if (entityView.isBST()) {
                    e = document.createElement(namespace + "StructuredTypeName");
                    e.appendChild(document.createTextNode(entityView.getBasedOnStructuredType().getName()));
                    baseElement.appendChild(e);
                }
                if (this.settings.isIncludeSelectStatementInViewReport()) {
                    e = document.createElement(namespace + "SelectStatement");
                    e.appendChild(document.createCDATASection(entityView.getUserDefinedSQL()));
                    baseElement.appendChild(e);
                }
            }
            this.createDescriptionAndNotesSection(document, namespace, baseElement, object);
            if (isEntity && this.reportTemplate.isUseQuantitativeInfo()) {
                Element quantitativeInfoElement = document.createElement(namespace + "QuantitativeInfoCollection");
                e = document.createElement(namespace + "NumberOfAttributes");
                e.appendChild(document.createTextNode(Integer.valueOf(entity.getElements().length).toString()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMin");
                e.appendChild(document.createTextNode(entity.getMinVolumes()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMax");
                e.appendChild(document.createTextNode(entity.getMaxVolumes()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedNumberOfRows");
                e.appendChild(document.createTextNode(entity.getExpectedVolumes()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedGrowth");
                e.appendChild(document.createTextNode(entity.getGrowthPercent()));
                quantitativeInfoElement.appendChild(e);
                e = document.createElement(namespace + "GrowthInterval");
                e.appendChild(document.createTextNode(entity.getGrowthType()));
                quantitativeInfoElement.appendChild(e);
                baseElement.appendChild(quantitativeInfoElement);
            }
            if (isEntity) {
                if (this.reportTemplate.isUseEntityAttributes()) {
                    int attrCount = 0;
                    attributesCollection = null;
                    atrributesIterator = entity.getAttributes().iterator();
                    entity.getElements();
                    while (atrributesIterator.hasNext()) {
                        Attribute attribute = (Attribute)atrributesIterator.next();
                        if (attrCount == 0) {
                            attributesCollection = document.createElement(namespace + "AttributesCollection");
                            baseElement.appendChild(attributesCollection);
                        }
                        Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                        attributesCollection.appendChild(attributeDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(attribute.getContainer().getIndexOf(attribute) + 1).toString()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "AttributeName");
                        e.appendChild(document.createTextNode(attribute.getName()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(attribute.isPKElement() ? "P" : ""));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        e.appendChild(document.createTextNode(attribute.isFKElement() ? "F" : ""));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(attribute.getNullsAllowed() ? "" : "Y"));
                        attributeDetails.appendChild(e);
                        String dataType = "";
                        String dataTypeKind = "";
                        String domainName = "";
                        switch (attribute.getUse()) {
                            case 0: {
                                dataTypeKind = "DOM";
                                Domain dom = attribute.getDomain();
                                domainName = dom.getName();
                                dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                                domainName = domainName.replace("Unknown", "");
                                domainName = domainName.replace("unknown", "");
                                domainName = domainName.replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                dataTypeKind = "LT";
                                dataType = this.getSizePrecisionScale(attribute, attribute.getLogicalDatatype().getName());
                                break;
                            }
                            case 2: {
                                dataTypeKind = "DT";
                                dataType = attribute.getDistinctType().getName();
                                break;
                            }
                            case 3: {
                                dataTypeKind = attribute.isReference() ? "RST" : "ST";
                                dataType = attribute.getStructuredType().getName();
                                break;
                            }
                            case 4: {
                                dataTypeKind = "CT";
                                dataType = attribute.getCollectionType().getName();
                            }
                        }
                        e = document.createElement(namespace + "DataType");
                        e.appendChild(document.createTextNode(dataType));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "DataTypeKind");
                        e.appendChild(document.createTextNode(dataTypeKind));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "DomainName");
                        e.appendChild(document.createTextNode(domainName));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "Formula");
                        e.appendChild(document.createTextNode((attribute.getFormulaDesc() + " " + attribute.getDefaultValue()).trim()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "PreferredAbbreviation");
                        e.appendChild(document.createTextNode(attribute.getPreferredAbbreviation()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "AttributeSynonyms");
                        e.appendChild(document.createTextNode(attribute.getSynonym()));
                        attributeDetails.appendChild(e);
                        ++attrCount;
                    }
                }
            } else if (this.reportTemplate.isUseEntityAttributes()) {
                int attrCount = 0;
                attributesCollection = null;
                atrributesIterator = entityView.getElementsCollection().iterator();
                int seq = 0;
                while (atrributesIterator.hasNext()) {
                    AttributeView attribute = (AttributeView)atrributesIterator.next();
                    ++seq;
                    if (attrCount == 0) {
                        attributesCollection = document.createElement(namespace + "AttributesCollection");
                        baseElement.appendChild(attributesCollection);
                    }
                    Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                    attributesCollection.appendChild(attributeDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(seq).toString()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "PK");
                    e.appendChild(document.createTextNode(attribute.isPKElement() ? "P" : ""));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "FK");
                    e.appendChild(document.createTextNode(attribute.isFKElement() ? "F" : ""));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(attribute.getNullsAllowed() ? "" : "Y"));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DataType");
                    e.appendChild(document.createTextNode(attribute.getDataTypeString()));
                    attributeDetails.appendChild(e);
                    ++attrCount;
                }
            }
            if (this.reportTemplate.isUseEntityAttributesComments()) {
                List<ContainedObject> l;
                int attributeCommentsCounter = 0;
                Element attributesCommentsCollection = null;
                if (isEntity) {
                    l = entity.getAttributes();
                    atrributesIterator = l.iterator();
                } else {
                    l = Arrays.asList(entityView.getElements());
                    atrributesIterator = l.iterator();
                }
                while (atrributesIterator.hasNext()) {
                    ContainedObjectWithDomain attr;
                    Object o = atrributesIterator.next();
                    String sequence = "";
                    String cName = "";
                    String description = "";
                    String notes = "";
                    if (o instanceof Attribute) {
                        attr = (Attribute)o;
                        sequence = Integer.valueOf(attr.getContainer().getIndexOf(attr) + 1).toString();
                        cName = attr.getName();
                        description = attr.getComment() == null || attr.getComment().equals("") ? attr.getCommentInRDBMS() : attr.getComment();
                        notes = attr.getNotes();
                    } else if (o instanceof AttributeView) {
                        attr = (AttributeView)o;
                        sequence = Integer.valueOf(Arrays.asList(entityView.getElements()).indexOf(attr) + 1).toString();
                        cName = attr.getName();
                        description = attr.getComment() == null || attr.getComment().equals("") ? attr.getCommentInRDBMS() : attr.getComment();
                        notes = attr.getNotes();
                    }
                    if ((description == null || description.equals("")) && (notes == null || notes.equals(""))) continue;
                    if (attributeCommentsCounter == 0) {
                        attributesCommentsCollection = document.createElement(namespace + "AttributesCommentsCollection");
                        baseElement.appendChild(attributesCommentsCollection);
                    }
                    Element attributeCommentsDetails = document.createElement(namespace + "AttributeCommentsDetails");
                    attributesCommentsCollection.appendChild(attributeCommentsDetails);
                    e = document.createElement(namespace + "AttributeCommentsSequence");
                    e.appendChild(document.createTextNode(sequence));
                    attributeCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeCommentsName");
                    e.appendChild(document.createTextNode(cName));
                    attributeCommentsDetails.appendChild(e);
                    if (description != "" && description != null) {
                        Element columnDescriptionElement = document.createElement(namespace + "AttributeDescription");
                        columnDescriptionElement.appendChild(document.createCDATASection(description));
                        attributeCommentsDetails.appendChild(columnDescriptionElement);
                    }
                    if (notes != "" && notes != null) {
                        Element attributeNotesElement = document.createElement(namespace + "AttributeNotes");
                        attributeNotesElement.appendChild(document.createCDATASection(notes));
                        attributeCommentsDetails.appendChild(attributeNotesElement);
                    }
                    ++attributeCommentsCounter;
                }
            }
            if (isEntity) {
                if (this.reportTemplate.isUseEntityConstraints()) {
                    Element constraintsCollection = null;
                    Iterator attributesIterator = entity.getAttributes().iterator();
                    int attrCounter = 0;
                    while (attributesIterator.hasNext()) {
                        Attribute attribute = (Attribute)attributesIterator.next();
                        if (attribute.getAVTs().size() <= 0 && attribute.getValueList() == null && attribute.getCheck() == null) continue;
                        if (attrCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            baseElement.appendChild(constraintsCollection);
                        }
                        String constraintName = "";
                        CheckConstraint ccConstraint = attribute.getCheck();
                        if (ccConstraint != null && !(constraintName = ccConstraint.getName()).equals("")) {
                            constraintName = " / " + constraintName;
                        }
                        Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                        constraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "ContstraintType");
                        e.appendChild(document.createTextNode(attrCounter == 0 ? "Attribute Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "ALCConstraintName");
                        e.appendChild(document.createTextNode(attribute.getName() + constraintName));
                        constraintDetails.appendChild(e);
                        Element rangesCollection = null;
                        Iterator itRanges = attribute.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintDetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (attribute.getValueList() != null) {
                            Iterator itVL = attribute.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)attribute.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintDetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if (ccConstraint != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintDetails.appendChild(ccCollection);
                            String generic = ccConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = ccConstraint.getTypes();
                            for (int i = 0; i < types.length; ++i) {
                                RDBMSType rdbmsType = (RDBMSType)types[i];
                                String text = ccConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                        ++attrCounter;
                    }
                }
                if (this.reportTemplate.isUseEntityIdentifiers()) {
                    Element identifiersCollection = null;
                    Iterator itKeySet = entity.getKeySet().iterator();
                    ArrayList<String> usedNames = new ArrayList<String>();
                    int idCounter = 0;
                    while (itKeySet.hasNext()) {
                        if (idCounter == 0) {
                            identifiersCollection = document.createElement(namespace + "IdentifiersCollection");
                            baseElement.appendChild(identifiersCollection);
                        }
                        CandidateKey cc = (CandidateKey)itKeySet.next();
                        ContainedObject[] elements = cc.getElements();
                        for (int i = 0; i < elements.length; ++i) {
                            ContainedObject s = elements[i];
                            Element identifierDetails = document.createElement(namespace + "IdentifierDetails");
                            identifiersCollection.appendChild(identifierDetails);
                            boolean nameUsed = false;
                            String cName = cc.getName();
                            for (String name : usedNames) {
                                if (!name.equals(cName)) continue;
                                nameUsed = true;
                                break;
                            }
                            if (!nameUsed) {
                                usedNames.add(cName);
                            }
                            e = document.createElement(namespace + "IdentifierName");
                            e.appendChild(document.createTextNode(nameUsed ? "" : cc.getName()));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "PrimaryIdentifier");
                            e.appendChild(document.createTextNode(nameUsed ? "" : (cc.getKeyState().equals("Primary Key") ? "Y" : "")));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "ElementName");
                            e.appendChild(document.createTextNode(s.getName()));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "ElementType");
                            e.appendChild(document.createTextNode("A"));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "SourceLabel");
                            e.appendChild(document.createTextNode(""));
                            identifierDetails.appendChild(e);
                            e = document.createElement(namespace + "TargetLabel");
                            e.appendChild(document.createTextNode(""));
                            identifierDetails.appendChild(e);
                        }
                        ++idCounter;
                    }
                }
                if (this.reportTemplate.isUseEntityRelationships()) {
                    Element relationshipsCollection = null;
                    Iterator relationshipsIterator = this.design.getLogicalDesign().getRelationSet().getRelationsTo(entity).iterator();
                    int relCounter = 0;
                    while (relationshipsIterator.hasNext()) {
                        if (relCounter == 0) {
                            relationshipsCollection = document.createElement(namespace + "RelationshipsCollection");
                            baseElement.appendChild(relationshipsCollection);
                        }
                        Relation relation = (Relation)relationshipsIterator.next();
                        Element relationshipDetails = document.createElement(namespace + "RelationshipDetails");
                        relationshipsCollection.appendChild(relationshipDetails);
                        if (entity == relation.getSourceEntity()) {
                            e = document.createElement(namespace + "SourceName");
                            e.appendChild(document.createTextNode(relation.getTargetEntity().getName()));
                            relationshipDetails.appendChild(e);
                        } else if (entity == relation.getTargetEntity()) {
                            e = document.createElement(namespace + "SourceName");
                            e.appendChild(document.createTextNode(relation.getSourceEntity().getName()));
                            relationshipDetails.appendChild(e);
                        }
                        e = document.createElement(namespace + "SourceRole");
                        e.appendChild(document.createTextNode(relation.getNameOnSource() != null ? relation.getNameOnSource() : ""));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "TargetRole");
                        e.appendChild(document.createTextNode(relation.getNameOnTarget() != null ? relation.getNameOnTarget() : ""));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "InArc");
                        e.appendChild(document.createTextNode(relation.inArc() ? "Y" : ""));
                        relationshipDetails.appendChild(e);
                        String cardinality = "";
                        String scard = relation.isOptionalSource() ? "0" : "1";
                        String repr = relation.getTargetCardinality().toString();
                        scard = scard + ".." + repr;
                        String tcard = relation.isOptionalTarget() ? "0" : "1";
                        repr = relation.getSourceCardinality().toString();
                        tcard = tcard + ".." + repr;
                        cardinality = scard + ":" + tcard;
                        e = document.createElement(namespace + "Cardinality");
                        e.appendChild(document.createTextNode(cardinality));
                        relationshipDetails.appendChild(e);
                        String domRoleName = "";
                        String dRoleName = relation.getDominantRole().getName();
                        if (dRoleName != null) {
                            domRoleName = dRoleName.equals("None") ? "" : dRoleName;
                        }
                        e = document.createElement(namespace + "DominantRole");
                        e.appendChild(document.createTextNode(domRoleName));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "Identifying");
                        e.appendChild(document.createTextNode(relation.isIdentifying() ? "Y" : ""));
                        relationshipDetails.appendChild(e);
                        e = document.createElement(namespace + "Transferable");
                        e.appendChild(document.createTextNode(relation.isTransferable() ? "Y" : ""));
                        relationshipDetails.appendChild(e);
                        ++relCounter;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Entity Details Section : " + e.getMessage(), e);
            return baseElement;
        }
        return baseElement;
    }

    private Document gatherAllTablesData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List tables) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tables", "osdmAllTables:Tables");
            document.appendChild(rootElement);
            String namespace = "osdmAllTables:";
            this.createHeaderSection(document, namespace, rootElement, model);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, tables);
            Element tablesCollection = document.createElement(namespace + "TablesCollection");
            rootElement.appendChild(tablesCollection);
            List currentObjectsList = new ArrayList();
            if (tables.size() != 0) {
                currentObjectsList = tables;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (Table table : currentObjectsList) {
                Element tableDetails = document.createElement(namespace + "TableDetails");
                tablesCollection.appendChild(tableDetails);
                this.createTableDetailsSection(document, namespace, tableDetails, table);
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all tables report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Element createTableDetailsSection(Document document, String namespace, Element baseElement, DesignObject object) {
        try {
            FKElement remotelColumn;
            String columnsNames;
            Element fkCollection;
            FKElement col;
            Element columnsCollection;
            Element e;
            Table table = null;
            TableView tableView = null;
            boolean isTable = false;
            if (object instanceof Table) {
                table = (Table)object;
                isTable = true;
                e = document.createElement(namespace + "TableName");
                e.appendChild(document.createTextNode(table.getLongName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedTableName");
                e.appendChild(document.createTextNode(table.getShortObjectID()));
                baseElement.appendChild(e);
            } else if (object instanceof TableView) {
                tableView = (TableView)object;
                isTable = false;
                e = document.createElement(namespace + "ViewName");
                e.appendChild(document.createTextNode(tableView.getLongName()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "EncodedViewName");
                e.appendChild(document.createTextNode(tableView.getShortObjectID()));
                baseElement.appendChild(e);
            }
            if (isTable) {
                e = document.createElement(namespace + "FunctionalName");
                e.appendChild(document.createTextNode(""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "Abbreviation");
                e.appendChild(document.createTextNode(table.getAbbreviation()));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ClassificationTypeName");
                e.appendChild(document.createTextNode(""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "ObjectTypeName");
                e.appendChild(document.createTextNode(table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : ""));
                baseElement.appendChild(e);
                e = document.createElement(namespace + "MVPrebuilt");
                e.appendChild(document.createTextNode(table.isOnPrebuiltTable() ? "Yes" : ""));
                baseElement.appendChild(e);
                if (table.getUserDefinedSQL() != null) {
                    e = document.createElement(namespace + "MVQuery");
                    e.appendChild(document.createCDATASection(table.getUserDefinedSQL()));
                    baseElement.appendChild(e);
                }
            } else {
                if (tableView.isBST()) {
                    e = document.createElement(namespace + "StructuredTypeName");
                    e.appendChild(document.createTextNode(tableView.getBasedOnStructuredType().getName()));
                    baseElement.appendChild(e);
                }
                if (this.settings.isIncludeSelectStatementInViewReport()) {
                    e = document.createElement(namespace + "SelectStatement");
                    e.appendChild(document.createCDATASection(tableView.getUserDefinedSQL()));
                    baseElement.appendChild(e);
                }
            }
            this.createDescriptionAndNotesSection(document, namespace, baseElement, object);
            if (isTable && this.reportTemplate.isUseQuantitativeInfo()) {
                Element quantitativeInfoCollectionElement = document.createElement(namespace + "QuantitativeInfoCollection");
                e = document.createElement(namespace + "NumberOfColumns");
                e.appendChild(document.createTextNode(Integer.valueOf(table.getElements().length).toString()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMin");
                e.appendChild(document.createTextNode(table.getMinVolumes()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "NumberOfRowsMax");
                e.appendChild(document.createTextNode(table.getMaxVolumes()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedNumberOfRows");
                e.appendChild(document.createTextNode(table.getExpectedVolumes()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "ExpectedGrowth");
                e.appendChild(document.createTextNode(table.getGrowthPercent()));
                quantitativeInfoCollectionElement.appendChild(e);
                e = document.createElement(namespace + "GrowthInterval");
                e.appendChild(document.createTextNode(table.getGrowthType()));
                quantitativeInfoCollectionElement.appendChild(e);
                baseElement.appendChild(quantitativeInfoCollectionElement);
            }
            if (isTable) {
                if (this.reportTemplate.isUseTableColumns()) {
                    int columnsCounter = 0;
                    columnsCollection = null;
                    for (Column column : Arrays.asList(table.getElements())) {
                        String personalInfo;
                        void var16_45;
                        if (columnsCounter == 0) {
                            columnsCollection = document.createElement(namespace + "ColumnsCollection");
                            baseElement.appendChild(columnsCollection);
                        }
                        Element columnDetails = document.createElement(namespace + "ColumnDetails");
                        columnsCollection.appendChild(columnDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        String fk = column.isFKElement() || column.isPartOfUnresolvedFK(table) ? "F" : "";
                        e.appendChild(document.createTextNode(fk));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                        columnDetails.appendChild(e);
                        String dataType = "";
                        String string = "";
                        String domainName = "";
                        switch (column.getUse()) {
                            case 0: {
                                String string2 = "DOM";
                                Domain domain = column.getDomain();
                                domainName = domain.getName();
                                dataType = this.getSizePrecisionScale(domain, domain.getLogicalDatatype().getName());
                                domainName = domainName.replace("Unknown", "");
                                domainName = domainName.replace("unknown", "");
                                domainName = domainName.replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                String string3 = "LT";
                                dataType = this.getSizePrecisionScale(column, column.getLogicalDatatype().getName());
                                break;
                            }
                            case 2: {
                                String string4 = "DT";
                                dataType = column.getDistinctType().getName();
                                break;
                            }
                            case 3: {
                                if (column.isReference()) {
                                    String string5 = "RST";
                                } else {
                                    String string6 = "ST";
                                }
                                dataType = column.getStructuredType().getName();
                                break;
                            }
                            case 4: {
                                String string7 = "CT";
                                dataType = column.getCollectionType().getName();
                            }
                        }
                        e = document.createElement(namespace + "DataType");
                        String string8 = column.isAutoIncrementColumn() ? " - AI" : "";
                        String id = column.isIdentityColumn() ? " - ID" : "";
                        e.appendChild(document.createTextNode(dataType + string8 + id));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "DataTypeKind");
                        e.appendChild(document.createTextNode((String)var16_45));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "DomainName");
                        e.appendChild(document.createTextNode(domainName));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "Formula");
                        e.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                        columnDetails.appendChild(e);
                        String security = "";
                        String string9 = column.isContainsPII() == null ? "" : (personalInfo = column.isContainsPII() != false ? "Y" : "");
                        String sensitiveInfo = column.isContainsSensitiveInformation() == null ? "" : (column.isContainsSensitiveInformation() != false ? "Y" : "");
                        String maskInfo = column.getMaskingType();
                        security = personalInfo + "/" + sensitiveInfo + "/" + maskInfo;
                        security = security.replace("//", "");
                        e = document.createElement(namespace + "Security");
                        e.appendChild(document.createTextNode(security));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PreferredAbbreviation");
                        e.appendChild(document.createTextNode(column.getAbbreviation()));
                        columnDetails.appendChild(e);
                        ++columnsCounter;
                    }
                }
            } else if (this.reportTemplate.isUseTableColumns()) {
                int columnsCounter = 0;
                columnsCollection = null;
                Iterator<Object> itColumns = tableView.getElementsCollection().iterator();
                boolean bl = false;
                while (itColumns.hasNext()) {
                    void var16_54;
                    void var12_22;
                    FKElement column = (FKElement)itColumns.next();
                    ++var12_22;
                    if (columnsCounter == 0) {
                        columnsCollection = document.createElement(namespace + "ColumnsCollection");
                        baseElement.appendChild(columnsCollection);
                    }
                    Element columnDetails = document.createElement(namespace + "ColumnDetails");
                    columnsCollection.appendChild(columnDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf((int)var12_22).toString()));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "ColumnName");
                    e.appendChild(document.createTextNode(column.getName()));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "PK");
                    e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "FK");
                    String fk = column.isFKElement() || column.isPartOfUnresolvedFK(tableView) ? "F" : "";
                    e.appendChild(document.createTextNode(fk));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "DataType");
                    String string = "";
                    if (column instanceof ColumnView) {
                        e.appendChild(document.createTextNode(((ColumnView)column).getDataTypeString()));
                    } else if (column instanceof Column) {
                        String string10;
                        col = (Column)column;
                        e.appendChild(document.createTextNode(((Column)col).getDatatypeString()));
                        String string11 = ((Column)col).isContainsPII() == null ? "" : (string10 = ((Column)col).isContainsPII() != false ? "Y" : "");
                        String sensitiveInfo = ((Column)col).isContainsSensitiveInformation() == null ? "" : (((Column)col).isContainsSensitiveInformation() != false ? "Y" : "");
                        String maskInfo = ((Column)col).getMaskingType();
                        String string13 = string10 + "/" + sensitiveInfo + "/" + maskInfo;
                        string13 = string13.replace("//", "");
                    }
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "Security");
                    e.appendChild(document.createTextNode((String)var16_54));
                    columnDetails.appendChild(e);
                    ++columnsCounter;
                }
            }
            if (this.reportTemplate.isUseTableColumnsComments()) {
                Iterator<ContainedObject> columnsIterator;
                int columnsCommentsCounter = 0;
                Element columnsCommentsCollection = null;
                if (isTable) {
                    List<ContainedObject> list = Arrays.asList(table.getElements());
                    columnsIterator = list.iterator();
                } else {
                    List<ContainedObject> list = Arrays.asList(tableView.getElements());
                    columnsIterator = list.iterator();
                }
                while (columnsIterator.hasNext()) {
                    void var16_63;
                    ContainedObject containedObject = columnsIterator.next();
                    String sequence = "";
                    String cName = "";
                    String description = "";
                    String string = "";
                    if (containedObject instanceof Column) {
                        col = (Column)containedObject;
                        sequence = Integer.valueOf(col.getContainer().getIndexOf(col) + 1).toString();
                        cName = col.getName();
                        description = col.getComment() == null || col.getComment().equals("") ? col.getCommentInRDBMS() : col.getComment();
                        String string14 = col.getNotes();
                    } else if (containedObject instanceof ColumnView) {
                        col = (ColumnView)containedObject;
                        sequence = Integer.valueOf(Arrays.asList(tableView.getElements()).indexOf(col) + 1).toString();
                        cName = col.getName();
                        description = col.getComment() == null || col.getComment().equals("") ? col.getCommentInRDBMS() : col.getComment();
                        String string15 = col.getNotes();
                    }
                    if ((description == null || description.equals("")) && (var16_63 == null || var16_63.equals(""))) continue;
                    if (columnsCommentsCounter == 0) {
                        columnsCommentsCollection = document.createElement(namespace + "ColumnsCommentsCollection");
                        baseElement.appendChild(columnsCommentsCollection);
                    }
                    Element columnCommentsDetails = document.createElement(namespace + "ColumnCommentsDetails");
                    columnsCommentsCollection.appendChild(columnCommentsDetails);
                    e = document.createElement(namespace + "ColumnCommentsSequence");
                    e.appendChild(document.createTextNode(sequence));
                    columnCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "ColumnCommentsName");
                    e.appendChild(document.createTextNode(cName));
                    columnCommentsDetails.appendChild(e);
                    if (description != "" && description != null) {
                        Element element = document.createElement(namespace + "ColumnDescription");
                        element.appendChild(document.createCDATASection(description));
                        columnCommentsDetails.appendChild(element);
                    }
                    if (var16_63 != "" && var16_63 != null) {
                        Element element = document.createElement(namespace + "ColumnNotes");
                        element.appendChild(document.createCDATASection((String)var16_63));
                        columnCommentsDetails.appendChild(element);
                    }
                    ++columnsCommentsCounter;
                }
            }
            if (isTable) {
                if (this.reportTemplate.isUseTableIndexes()) {
                    int indesexCounter = 0;
                    HashMap<String, String> usedNames = new HashMap<String, String>();
                    Element indesexCollection = null;
                    Iterator iterator = table.getKeySet().iterator();
                    while (iterator.hasNext()) {
                        Index index = (Index)iterator.next();
                        if (index.isFK()) continue;
                        if (indesexCounter == 0) {
                            indesexCollection = document.createElement(namespace + "IndexesCollection");
                            baseElement.appendChild(indesexCollection);
                        }
                        Iterator<ContainedObject> itIdxColumns = null;
                        if (index.hasIndexExpression()) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(" ");
                            itIdxColumns = list.iterator();
                        } else {
                            itIdxColumns = Arrays.asList(index.getElements()).iterator();
                        }
                        while (itIdxColumns.hasNext()) {
                            void var16_68;
                            Column col2 = null;
                            Object var16_65 = null;
                            ContainedObject obj = itIdxColumns.next();
                            if (obj instanceof Column) {
                                col2 = (Column)obj;
                                String string = col2.getName();
                            } else {
                                String string = ((Object)obj).toString();
                            }
                            Element element = document.createElement(namespace + "IndexDetails");
                            indesexCollection.appendChild(element);
                            String state = index.getIndexState();
                            boolean nameUsed = false;
                            String cName = index.getName();
                            for (Map.Entry pair : usedNames.entrySet()) {
                                String name = (String)pair.getKey();
                                String st = (String)pair.getValue();
                                if (!name.equals(cName) || !st.equals(state)) continue;
                                nameUsed = true;
                                break;
                            }
                            if (!nameUsed) {
                                usedNames.put(cName, state);
                            }
                            e = document.createElement(namespace + "IndexName");
                            e.appendChild(document.createTextNode(nameUsed ? "" : index.getName()));
                            element.appendChild(e);
                            state = state.equals("Unique Plain Index") ? "UN" : (state.equals("Unique Constraint") ? "UK" : (state.equals("Primary Constraint") ? "PK" : ""));
                            e = document.createElement(namespace + "IndexState");
                            e.appendChild(document.createTextNode(nameUsed ? "" : state));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexFunctional");
                            e.appendChild(document.createTextNode(!"".equalsIgnoreCase(index.getIndexExpression()) ? "Y" : ""));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexSpatial");
                            e.appendChild(document.createTextNode(index.isSpatialIndex() ? "Y" : ""));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexExpression");
                            e.appendChild(document.createTextNode(index.getIndexExpression()));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexColumnName");
                            e.appendChild(document.createTextNode((String)var16_68));
                            element.appendChild(e);
                            e = document.createElement(namespace + "IndexSortOrder");
                            if (col2 != null) {
                                e.appendChild(document.createTextNode(index.getColumnSortOrder(col2)));
                            } else {
                                e.appendChild(document.createTextNode(" "));
                            }
                            element.appendChild(e);
                        }
                        ++indesexCounter;
                    }
                }
                if (this.reportTemplate.isUseTableConstraints()) {
                    int constraintsCounter = 0;
                    Element constraintsCollection = null;
                    Node tableLevelConstraintsCollection = null;
                    for (TableLevelConstraint tlConstraint : table.getCheckConstraints()) {
                        if (constraintsCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            baseElement.appendChild(constraintsCollection);
                            tableLevelConstraintsCollection = document.createElement(namespace + "TableLevelConstraintsCollection");
                            constraintsCollection.appendChild(tableLevelConstraintsCollection);
                        }
                        Element constraintDetails = document.createElement(namespace + "TableLevelConstraintDetails");
                        tableLevelConstraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "TLConstraintType");
                        e.appendChild(document.createTextNode(constraintsCounter == 0 ? "Table Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "TLConstraintName");
                        e.appendChild(document.createTextNode(tlConstraint.getName()));
                        constraintDetails.appendChild(e);
                        Element tlConstraintElement = document.createElement(namespace + "TLConstraintRule");
                        tlConstraintElement.appendChild(document.createCDATASection(tlConstraint.getRule()));
                        constraintDetails.appendChild(tlConstraintElement);
                        ++constraintsCounter;
                    }
                    int columnConstraintsCounter = 0;
                    Element columnLevelConstraintsCollection = null;
                    for (Column column : Arrays.asList(table.getElements())) {
                        if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                        if (constraintsCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            baseElement.appendChild(constraintsCollection);
                        }
                        if (columnConstraintsCounter == 0) {
                            columnLevelConstraintsCollection = document.createElement(namespace + "ColumnLevelConstraintsCollection");
                            constraintsCollection.appendChild(columnLevelConstraintsCollection);
                        }
                        String constraintName = "";
                        CheckConstraint checkConstraint = column.getCheck();
                        if (checkConstraint != null && !(constraintName = checkConstraint.getName()).equals("")) {
                            constraintName = " / " + constraintName;
                        }
                        Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                        columnLevelConstraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "ContstraintType");
                        e.appendChild(document.createTextNode(columnConstraintsCounter == 0 ? "Column Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "ALCConstraintName");
                        e.appendChild(document.createTextNode(column.getName() + constraintName));
                        constraintDetails.appendChild(e);
                        Element rangesCollection = null;
                        Iterator itRanges = column.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintDetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (column.getValueList() != null) {
                            Iterator itVL = column.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)column.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintDetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if (checkConstraint != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintDetails.appendChild(ccCollection);
                            String generic = checkConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = checkConstraint.getTypes();
                            for (int i = 0; i < types.length; ++i) {
                                RDBMSType rdbmsType = (RDBMSType)types[i];
                                String text = checkConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                        ++columnConstraintsCounter;
                    }
                }
            }
            if (this.reportTemplate.isUseTableFKReferringTo()) {
                void var12_33;
                int fkCount = 0;
                fkCollection = null;
                Iterator<FKIndexAssociation> itFKFrom = isTable ? table.getFKAssociationsList().iterator() : tableView.getFKAssociationsList().iterator();
                while (itFKFrom.hasNext()) {
                    Element fkDetails;
                    KeyObject ri;
                    FKIndexAssociation fKIndexAssociation = itFKFrom.next();
                    if (fkCount == 0) {
                        fkCollection = document.createElement(namespace + "FKRTCollection");
                        baseElement.appendChild(fkCollection);
                    }
                    if ((ri = fKIndexAssociation.getRemoteIndex()) == null) {
                        void var16_73;
                        fkDetails = document.createElement(namespace + "FKRTDetails");
                        fkCollection.appendChild(fkDetails);
                        e = document.createElement(namespace + "FKName");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getName()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferringTo");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getReferredTableLongName()));
                        fkDetails.appendChild(e);
                        String rFKList = fKIndexAssociation.getReferredColumnNames();
                        String string = "";
                        for (FKElement fKElement : Arrays.asList(fKIndexAssociation.getLocalFKIndex().getElements())) {
                            if (fKElement == null) continue;
                            String string16 = (String)var16_73 + "\n" + fKElement.getName();
                        }
                        e = document.createElement(namespace + "FKReferringColumnName");
                        e.appendChild(document.createTextNode(var16_73.trim()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferredColumnName");
                        e.appendChild(document.createTextNode(rFKList.replaceAll(",", "\n")));
                        fkDetails.appendChild(e);
                    } else {
                        void var18_100;
                        void var18_98;
                        fkDetails = document.createElement(namespace + "FKRTDetails");
                        fkCollection.appendChild(fkDetails);
                        e = document.createElement(namespace + "FKName");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getName()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferringTo");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getRemoteTable().getName()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKMandatory");
                        e.appendChild(document.createTextNode(fKIndexAssociation.isMandatory() ? "Y" : ""));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKTransferable");
                        e.appendChild(document.createTextNode(fKIndexAssociation.isTransferable() ? "Y" : ""));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKInArc");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getArc() != null ? "Y" : ""));
                        fkDetails.appendChild(e);
                        List<ContainedObject> referedColumnsList = Arrays.asList(ri.getElements());
                        List<ContainedObject> list = Arrays.asList(fKIndexAssociation.getLocalFKIndex().getElements());
                        columnsNames = "";
                        boolean bl = false;
                        while (var18_98 < list.size()) {
                            FKElement localColumn = (FKElement)list.get((int)var18_98);
                            if (localColumn != null) {
                                columnsNames = columnsNames + "\n" + localColumn.getName();
                            }
                            ++var18_98;
                        }
                        String string = "";
                        for (int i = 0; i < referedColumnsList.size(); ++i) {
                            remotelColumn = (FKElement)referedColumnsList.get(i);
                            if (remotelColumn == null) continue;
                            String string17 = (String)var18_100 + "\n" + remotelColumn.getName();
                        }
                        e = document.createElement(namespace + "FKReferringColumnName");
                        e.appendChild(document.createTextNode(columnsNames.trim()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKReferredColumnName");
                        e.appendChild(document.createTextNode(var18_100.trim()));
                        fkDetails.appendChild(e);
                        e = document.createElement(namespace + "FKDeleteRule");
                        e.appendChild(document.createTextNode(fKIndexAssociation.getDeleteRule().equals("NO ACTION") ? "" : fKIndexAssociation.getDeleteRule()));
                        fkDetails.appendChild(e);
                    }
                    ++fkCount;
                }
                Object var12_30 = null;
                if (isTable) {
                    List<ImpliedForeignKey> list = table.getImpliedForeignKeyList();
                } else {
                    List<ImpliedForeignKey> list = tableView.getImpliedForeignKeyList();
                }
                for (ImpliedForeignKey join : var12_33) {
                    if (fkCount == 0) {
                        fkCollection = document.createElement(namespace + "FKRTCollection");
                        baseElement.appendChild(fkCollection);
                    }
                    Element fkDetails = document.createElement(namespace + "FKRTDetails");
                    fkCollection.appendChild(fkDetails);
                    e = document.createElement(namespace + "FKName");
                    String string18 = join.getName() + "\nimplied Fkey - source:\n";
                    string18 = string18 + join.getFormattedDiscoverySource();
                    e.appendChild(document.createTextNode(string18));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferringTo");
                    e.appendChild(document.createTextNode(join.getReferredTableLongName()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKMandatory");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKTransferable");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKInArc");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                    columnsNames = join.getLocalColumnName();
                    String string19 = join.getReferredColumnName();
                    e = document.createElement(namespace + "FKReferringColumnName");
                    e.appendChild(document.createTextNode(columnsNames.trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferredColumnName");
                    e.appendChild(document.createTextNode(string19.trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKDeleteRule");
                    e.appendChild(document.createTextNode(""));
                    fkDetails.appendChild(e);
                }
            }
            if (this.reportTemplate.isUseTableFKReferredFrom()) {
                Iterator itFKTo;
                int fkCount = 0;
                fkCollection = null;
                if (isTable) {
                    FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet();
                    itFKTo = fKIndexAssociationSet.getAssociationsWith(table).iterator();
                } else {
                    FKIndexAssociationSet fKIndexAssociationSet = ((RelationalDesign)tableView.getDesignPart()).getFKIndexAssociationSet();
                    itFKTo = fKIndexAssociationSet.getAssociationsWith(tableView).iterator();
                }
                while (itFKTo.hasNext()) {
                    void var18_108;
                    void var18_106;
                    FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)itFKTo.next();
                    if (fkCount == 0) {
                        fkCollection = document.createElement(namespace + "FKRFCollection");
                        baseElement.appendChild(fkCollection);
                    }
                    Element fkDetails = document.createElement(namespace + "FKRFDetails");
                    fkCollection.appendChild(fkDetails);
                    e = document.createElement(namespace + "FKName");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getName()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferredFrom");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getContainerWithKeyObject().getName()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKMandatory");
                    e.appendChild(document.createTextNode(fKIndexAssociation.isMandatory() ? "Y" : ""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKTransferable");
                    e.appendChild(document.createTextNode(fKIndexAssociation.isTransferable() ? "Y" : ""));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKInArc");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getArc() != null ? "Y" : ""));
                    fkDetails.appendChild(e);
                    KeyObject ri = fKIndexAssociation.getRemoteIndex();
                    List<ContainedObject> referingColumnsList = Arrays.asList(ri.getElements());
                    List<ContainedObject> list = Arrays.asList(fKIndexAssociation.getLocalFKIndex().getElements());
                    columnsNames = "";
                    boolean bl = false;
                    while (var18_106 < list.size()) {
                        FKElement localColumn = (FKElement)list.get((int)var18_106);
                        if (localColumn != null) {
                            columnsNames = columnsNames + "\n" + localColumn.getName();
                        }
                        ++var18_106;
                    }
                    String string = "";
                    for (int i = 0; i < referingColumnsList.size(); ++i) {
                        remotelColumn = (FKElement)referingColumnsList.get(i);
                        if (remotelColumn == null) continue;
                        String string20 = (String)var18_108 + "\n" + remotelColumn.getName();
                    }
                    e = document.createElement(namespace + "FKReferringColumnName");
                    e.appendChild(document.createTextNode(var18_108.trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKReferredColumnName");
                    e.appendChild(document.createTextNode(columnsNames.trim()));
                    fkDetails.appendChild(e);
                    e = document.createElement(namespace + "FKDeleteRule");
                    e.appendChild(document.createTextNode(fKIndexAssociation.getDeleteRule().equals("NO ACTION") ? "" : fKIndexAssociation.getDeleteRule()));
                    fkDetails.appendChild(e);
                    ++fkCount;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Table Details Section : " + e.getMessage(), e);
            return baseElement;
        }
        return baseElement;
    }

    private Element createDescriptionAndNotesSection(Document document, String namespace, Element baseElement, Object object) {
        Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
        try {
            if (this.reportTemplate.isUseDescriptionInfo()) {
                String description = "";
                String notes = "";
                if (object instanceof DesignObject) {
                    DesignObject desObj = (DesignObject)object;
                    description = desObj.getComment() == null || desObj.getComment().equals("") ? desObj.getCommentInRDBMS() : desObj.getComment();
                    notes = desObj.getNotes();
                } else if (object instanceof AbstractView) {
                    AbstractView view = (AbstractView)object;
                    description = view.getComment() == null || view.getComment().equals("") ? view.getCommentInRDBMS() : view.getComment();
                    notes = view.getNotes();
                }
                if (description != null && !description.equals("") || notes != null && !notes.equals("")) {
                    if (description != null && !description.equals("")) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        descriptionNotesElement.appendChild(descriptionElement);
                    }
                    if (notes != null && !notes.equals("")) {
                        Element notesElement = document.createElement(namespace + "Notes");
                        notesElement.appendChild(document.createCDATASection(notes));
                        descriptionNotesElement.appendChild(notesElement);
                    }
                    baseElement.appendChild(descriptionNotesElement);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Description And Notes Section : " + e.getMessage(), e);
            return descriptionNotesElement;
        }
        return baseElement;
    }

    private Document gatherAllDomainsData(DesignPart model, StandardReportTemplate reportTemplate) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/domains", "osdmAllDomains:Domains");
            document.appendChild(rootElement);
            String namespace = "osdmAllDomains:";
            this.createHeaderSection(document, namespace, rootElement, model);
            Iterator it0 = this.design.getDomainSet().iterator();
            while (it0.hasNext()) {
                this.currentObjectsList.add(it0.next());
            }
            int domCounter = 0;
            Element domainsCollection = null;
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (Domain currDomain : this.currentObjectsList) {
                if (domCounter == 0) {
                    domainsCollection = document.createElement(namespace + "DomainsCollection");
                    rootElement.appendChild(domainsCollection);
                }
                Element domainDetails = document.createElement(namespace + "DomainDetails");
                domainsCollection.appendChild(domainDetails);
                Element e = document.createElement(namespace + "DomainName");
                e.appendChild(document.createTextNode(currDomain.getName()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedName");
                e.appendChild(document.createTextNode(currDomain.getShortObjectID()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "Synonyms");
                e.appendChild(document.createTextNode(currDomain.getSynonym()));
                domainDetails.appendChild(e);
                String dataType = this.getSizePrecisionScale(currDomain, currDomain.getLogicalDatatype().getName());
                e = document.createElement(namespace + "DataType");
                e.appendChild(document.createTextNode(dataType));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "LogicalType");
                e.appendChild(document.createTextNode(currDomain.getLogicalDatatype().getName()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "UnitOfMeasure");
                e.appendChild(document.createTextNode(currDomain.getUnitOfMeasure()));
                domainDetails.appendChild(e);
                e = document.createElement(namespace + "DefaultValue");
                e.appendChild(document.createTextNode(currDomain.getDefaultValue()));
                domainDetails.appendChild(e);
                String description = "";
                description = currDomain.getComment() == null || currDomain.getComment().equals("") ? currDomain.getCommentInRDBMS() : currDomain.getComment();
                if (description != "" && description != null) {
                    Element domainCommentElement = document.createElement(namespace + "DomainComment");
                    domainCommentElement.appendChild(document.createCDATASection(description));
                    domainDetails.appendChild(domainCommentElement);
                }
                if (reportTemplate.isUseDomainConstraints()) {
                    Element rangesCollection = null;
                    if (currDomain.getAVTs().size() > 0 || currDomain.getValueList() != null || currDomain.getCheck() != null) {
                        CheckConstraint ccConstraint;
                        Element constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                        domainDetails.appendChild(constraintsCollection);
                        Element constraintsdetails = document.createElement(namespace + "ConstraintDetails");
                        constraintsCollection.appendChild(constraintsdetails);
                        Iterator itRanges = currDomain.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintsdetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (currDomain.getValueList() != null) {
                            Iterator itVL = currDomain.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)currDomain.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintsdetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if ((ccConstraint = currDomain.getCheck()) != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintsdetails.appendChild(ccCollection);
                            String generic = ccConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = ccConstraint.getTypes();
                            for (int s = 0; s < types.length; ++s) {
                                RDBMSType rdbmsType = (RDBMSType)types[s];
                                String text = ccConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                    }
                }
                this.createUsedInObjectsSection(document, namespace, domainDetails, currDomain);
                ++domCounter;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during domains report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleCollectionTypeData(DesignPart model, StandardReportTemplate reportTemplate, List collectionTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/collectiontype", "osdmSingleCollectionType:CollectionType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleCollectionType:";
            this.createHeaderSection(document, namespace, rootElement, model);
            CollectionType collectionType = (CollectionType)collectionTypes.get(0);
            this.currentObjectsList.add(collectionType);
            this.createDescriptionAndNotesSection(document, namespace, rootElement, collectionType);
            Element e = document.createElement(namespace + "CTName");
            e.appendChild(document.createTextNode(collectionType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "EncodedName");
            e.appendChild(document.createTextNode(collectionType.getShortObjectID()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTType");
            e.appendChild(document.createTextNode(collectionType.getType()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTMaxElements");
            e.appendChild(document.createTextNode(Integer.valueOf(collectionType.getMaxElement()).toString()));
            rootElement.appendChild(e);
            String dataType = "";
            String dataTypeKind = "";
            String domainName = "";
            DesignObject dtType = collectionType.getDataType();
            if (dtType instanceof Domain) {
                dataTypeKind = "DOM";
                Domain dom = (Domain)dtType;
                domainName = dom.getName();
                dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                domainName = domainName.replace("Unknown", "");
                domainName = domainName.replace("unknown", "");
                domainName = domainName.replace("UNKNOWN", "");
            } else if (dtType instanceof LogicalDatatype) {
                dataTypeKind = "LT";
                LogicalDatatype lt = (LogicalDatatype)dtType;
                dataType = this.getSizePrecisionScale(collectionType.getElementType(), lt.getName());
            } else if (dtType instanceof DistinctType) {
                dataTypeKind = "DT";
            } else if (dtType instanceof StructuredType) {
                dataTypeKind = "ST";
            } else if (dtType instanceof CollectionType) {
                dataTypeKind = "CT";
            }
            e = document.createElement(namespace + "CTDataType");
            e.appendChild(document.createTextNode(dataType));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTDataTypeKind");
            e.appendChild(document.createTextNode(dataTypeKind));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTDomainName");
            e.appendChild(document.createTextNode(domainName));
            rootElement.appendChild(e);
            this.createUsedInObjectsSection(document, namespace, rootElement, collectionType);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single collection type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllCollectionTypesData(DesignPart model, StandardReportTemplate reportTemplate, List collectionTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/collectiontypes", "osdmAllCollectionTypes:CollectionTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllCollectionTypes:";
            this.createHeaderSection(document, namespace, rootElement, model);
            Element ctCollection = document.createElement(namespace + "CTCollection");
            rootElement.appendChild(ctCollection);
            if (collectionTypes.size() > 0) {
                this.currentObjectsList = collectionTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getCollectionTypeSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (CollectionType collectionType : this.currentObjectsList) {
                Element ctDetails = document.createElement(namespace + "CTDetails");
                ctCollection.appendChild(ctDetails);
                this.createDescriptionAndNotesSection(document, namespace, ctDetails, collectionType);
                Element e = document.createElement(namespace + "CTName");
                e.appendChild(document.createTextNode(collectionType.getLongName()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedName");
                e.appendChild(document.createTextNode(collectionType.getShortObjectID()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTType");
                e.appendChild(document.createTextNode(collectionType.getType()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTMaxElements");
                e.appendChild(document.createTextNode(Integer.valueOf(collectionType.getMaxElement()).toString()));
                ctDetails.appendChild(e);
                String dataType = "";
                String dataTypeKind = "";
                String domainName = "";
                DesignObject dtType = collectionType.getDataType();
                if (dtType instanceof Domain) {
                    dataTypeKind = "DOM";
                    Domain dom = (Domain)dtType;
                    domainName = dom.getName();
                    dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                    domainName = domainName.replace("Unknown", "");
                    domainName = domainName.replace("unknown", "");
                    domainName = domainName.replace("UNKNOWN", "");
                } else if (dtType instanceof LogicalDatatype) {
                    dataTypeKind = "LT";
                    LogicalDatatype lt = (LogicalDatatype)dtType;
                    dataType = this.getSizePrecisionScale(collectionType.getElementType(), lt.getName());
                } else if (dtType instanceof DistinctType) {
                    dataTypeKind = "DT";
                } else if (dtType instanceof StructuredType) {
                    dataTypeKind = "ST";
                } else if (dtType instanceof CollectionType) {
                    dataTypeKind = "CT";
                }
                e = document.createElement(namespace + "CTDataType");
                e.appendChild(document.createTextNode(dataType));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTDataTypeKind");
                e.appendChild(document.createTextNode(dataTypeKind));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTDomainName");
                e.appendChild(document.createTextNode(domainName));
                ctDetails.appendChild(e);
                this.createUsedInObjectsSection(document, namespace, ctDetails, collectionType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all collection type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleStructuredTypeData(DesignPart model, StandardReportTemplate reportTemplate, List structuredTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/structuredtype", "osdmSingleStructuredType:StructuredType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleStructuredType:";
            this.createHeaderSection(document, namespace, rootElement, model);
            StructuredType structuredType = (StructuredType)structuredTypes.get(0);
            this.currentObjectsList.add(structuredType);
            this.createSTDetailsSection(document, namespace, rootElement, structuredType);
            this.createUsedInObjectsSection(document, namespace, rootElement, structuredType);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single structured type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Element createSTDetailsSection(Document document, String namespace, Element baseElement, StructuredType structuredType) {
        try {
            Element e = document.createElement(namespace + "STName");
            e.appendChild(document.createTextNode(structuredType.getLongName()));
            baseElement.appendChild(e);
            e = document.createElement(namespace + "EncodedSTName");
            e.appendChild(document.createTextNode(structuredType.getShortObjectID()));
            baseElement.appendChild(e);
            e = document.createElement(namespace + "STSuperType");
            e.appendChild(document.createTextNode(structuredType.getParentType() != null ? structuredType.getParentType().getName() : ""));
            baseElement.appendChild(e);
            this.createDescriptionAndNotesSection(document, namespace, baseElement, structuredType);
            if (this.reportTemplate.isUseSTAttributes()) {
                int attrCount = 0;
                Element attributesCollection = null;
                for (TypeElement attribute : Arrays.asList(structuredType.getElements())) {
                    if (attrCount == 0) {
                        attributesCollection = document.createElement(namespace + "AttributesCollection");
                        baseElement.appendChild(attributesCollection);
                    }
                    Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                    attributesCollection.appendChild(attributeDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(attribute.getStructuredType().getIndexOf(attribute) + 1).toString()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(attribute.isMandatory() ? "Y" : ""));
                    attributeDetails.appendChild(e);
                    String dataType = "";
                    String dataTypeKind = "";
                    String domainName = "";
                    DesignObject dtType = attribute.getType();
                    if (dtType instanceof Domain) {
                        dataTypeKind = "DOM";
                        Domain dom = attribute.getDomain();
                        domainName = attribute.getType().getName();
                        dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                        domainName = domainName.replace("Unknown", "");
                        domainName = domainName.replace("unknown", "");
                        domainName = domainName.replace("UNKNOWN", "");
                    } else if (dtType instanceof LogicalDatatype) {
                        dataTypeKind = "LT";
                        dataType = this.getSizePrecisionScale(attribute, attribute.getType().getName());
                    } else if (dtType instanceof DistinctType) {
                        dataTypeKind = "DT";
                    } else if (dtType instanceof StructuredType) {
                        dataTypeKind = "ST";
                    } else if (dtType instanceof CollectionType) {
                        dataTypeKind = "CT";
                    }
                    e = document.createElement(namespace + "DataType");
                    e.appendChild(document.createTextNode(dataType));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DataTypeKind");
                    e.appendChild(document.createTextNode(dataTypeKind));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DomainName");
                    e.appendChild(document.createTextNode(domainName));
                    attributeDetails.appendChild(e);
                    ++attrCount;
                }
            }
            if (this.reportTemplate.isUseSTAttributesComments()) {
                int attributeCommentsCounter = 0;
                Element attributesCommentsCollection = null;
                for (TypeElement attribute : structuredType.getAttributesList()) {
                    String attributeDescription = "";
                    attributeDescription = attribute.getComment() == null || attribute.getComment().equals("") ? attribute.getCommentInRDBMS() : attribute.getComment();
                    String attributeNotes = attribute.getNotes();
                    if ((attributeDescription == null || attributeDescription.equals("")) && (attributeNotes == null || attributeNotes.equals(""))) continue;
                    if (attributeCommentsCounter == 0) {
                        attributesCommentsCollection = document.createElement(namespace + "AttributesCommentsCollection");
                        baseElement.appendChild(attributesCommentsCollection);
                    }
                    Element attributeCommentsDetails = document.createElement(namespace + "AttributeCommentsDetails");
                    attributesCommentsCollection.appendChild(attributeCommentsDetails);
                    e = document.createElement(namespace + "AttributeCommentsSequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(attribute.getStructuredType().getIndexOf(attribute) + 1).toString()));
                    attributeCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeCommentsName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeCommentsDetails.appendChild(e);
                    if (attributeDescription != "" && attributeDescription != null) {
                        Element columnDescriptionElement = document.createElement(namespace + "AttributeDescription");
                        columnDescriptionElement.appendChild(document.createCDATASection(attributeDescription));
                        attributeCommentsDetails.appendChild(columnDescriptionElement);
                    }
                    if (attributeNotes != "" && attributeNotes != null) {
                        Element attributeNotesElement = document.createElement(namespace + "AttributeNotes");
                        attributeNotesElement.appendChild(document.createCDATASection(attributeNotes));
                        attributeCommentsDetails.appendChild(attributeNotesElement);
                    }
                    ++attributeCommentsCounter;
                }
            }
            if (this.reportTemplate.isUseSTMethods()) {
                int methodsCounter = 0;
                Element methodsCollection = null;
                for (Method method : structuredType.getMethodsList()) {
                    if (methodsCounter == 0) {
                        methodsCollection = document.createElement(namespace + "MethodsCollection");
                        baseElement.appendChild(methodsCollection);
                    }
                    Element methodDetails = document.createElement(namespace + "MethodDetails");
                    methodsCollection.appendChild(methodDetails);
                    e = document.createElement(namespace + "MethodSequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(methodsCounter + 1).toString()));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodName");
                    e.appendChild(document.createTextNode(method.getName()));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodConstructor");
                    e.appendChild(document.createTextNode(method.isConstructor() ? "Y" : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodOverriding");
                    e.appendChild(document.createTextNode(method.isOverriding() ? "Y" : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodOverridenMethod");
                    e.appendChild(document.createTextNode(method.getOverridedMethod() != null ? method.getOverridedMethod().getName() : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodReturnValue");
                    e.appendChild(document.createTextNode(method.getReturnValue() != null ? method.getReturnValue().getDataType() : ""));
                    methodDetails.appendChild(e);
                    int paramCounter = 0;
                    Element methodsParamsCollection = null;
                    for (MethodParam param : method.getParameters()) {
                        if (paramCounter == 0) {
                            methodsParamsCollection = document.createElement(namespace + "MethodParametersCollection");
                            methodDetails.appendChild(methodsParamsCollection);
                        }
                        Element methodParamsDetails = document.createElement(namespace + "MethodParameterDetails");
                        methodsParamsCollection.appendChild(methodParamsDetails);
                        e = document.createElement(namespace + "ParameterName");
                        e.appendChild(document.createTextNode(param.getName()));
                        methodParamsDetails.appendChild(e);
                        e = document.createElement(namespace + "ParameterType");
                        e.appendChild(document.createTextNode(param.getDataType()));
                        methodParamsDetails.appendChild(e);
                        ++paramCounter;
                    }
                    ++methodsCounter;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception in report generation -- Create Structured Type Details Section : " + e.getMessage(), e);
            return baseElement;
        }
        return baseElement;
    }

    private Element createUsedInObjectsSection(Document document, String namespace, Element baseElement, DesignObject object) {
        Element e;
        String eName;
        DesignObject desObj;
        short objectType = 0;
        DesignObject currentDesObj = null;
        String tableModelNameXMLTag = "";
        String tableNameXMLTag = "";
        String columnNameXMLTag = "";
        String entityNameXMLTag = "";
        String attributeNameXMLTag = "";
        String structuredTypeNameXMLTag = "";
        String typeElementNameXMLTag = "";
        boolean templateFlagTables = false;
        boolean templateFlagEntites = false;
        boolean templateFlagST = false;
        if (object instanceof Domain) {
            currentDesObj = (Domain)object;
            objectType = 0;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseDomainUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseDomainUsedInEntities();
            templateFlagST = this.reportTemplate.isUseDomainUsedInStructuredTypes();
        } else if (object instanceof StructuredType) {
            currentDesObj = (StructuredType)object;
            objectType = 3;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseSTUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseSTUsedInEntities();
            templateFlagST = this.reportTemplate.isUseSTUsedInStructuredTypes();
        } else if (object instanceof CollectionType) {
            currentDesObj = (CollectionType)object;
            objectType = 4;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseCTUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseCTUsedInEntities();
            templateFlagST = this.reportTemplate.isUseCTUsedInStructuredTypes();
        } else if (object instanceof DistinctType) {
            currentDesObj = (DistinctType)object;
            objectType = 2;
            tableModelNameXMLTag = "ModelName";
            tableNameXMLTag = "TableName";
            columnNameXMLTag = "ColumnName";
            entityNameXMLTag = "EntityName";
            attributeNameXMLTag = "AttributeName";
            structuredTypeNameXMLTag = "STName";
            typeElementNameXMLTag = "AttributeName";
            templateFlagTables = this.reportTemplate.isUseDTUsedInTables();
            templateFlagEntites = this.reportTemplate.isUseDTUsedInTables();
            templateFlagST = this.reportTemplate.isUseDTUsedInStructuredTypes();
        }
        boolean create_header = true;
        Element tablesCollection = null;
        ArrayList<String> modelUsedNames = new ArrayList<String>();
        ArrayList<String> tableUsedNames = new ArrayList<String>();
        Iterator relationalDesignsIterator = this.design.getRelationalDesigns().iterator();
        Iterator allEntitiesIterator = this.design.getLogicalDesign().getEntitySet().iterator();
        Iterator stIterator = this.design.getDataTypesDesign().getStructuredTypeSet().iterator();
        if (templateFlagTables) {
            while (relationalDesignsIterator.hasNext()) {
                RelationalDesign rd = (RelationalDesign)relationalDesignsIterator.next();
                Iterator itAllTables = rd.getTableSet().iterator();
                while (itAllTables.hasNext()) {
                    Table table = (Table)itAllTables.next();
                    for (Column column : Arrays.asList(table.getElements())) {
                        if (column.getUse() != objectType) continue;
                        desObj = null;
                        if (currentDesObj instanceof StructuredType) {
                            desObj = column.getStructuredType();
                        } else if (currentDesObj instanceof CollectionType) {
                            desObj = column.getCollectionType();
                        } else if (currentDesObj instanceof DistinctType) {
                            desObj = column.getDistinctType();
                        } else if (currentDesObj instanceof Domain) {
                            desObj = column.getDomain();
                        }
                        if (currentDesObj != desObj) continue;
                        if (create_header) {
                            tablesCollection = document.createElement(namespace + "TablesCollection");
                            baseElement.appendChild(tablesCollection);
                            create_header = false;
                        }
                        boolean modelNameUsed = false;
                        String cName = rd.getName();
                        for (String name : modelUsedNames) {
                            if (!name.equals(cName)) continue;
                            modelNameUsed = true;
                            break;
                        }
                        if (!modelNameUsed) {
                            modelUsedNames.add(cName);
                        }
                        boolean tableNameUsed = false;
                        String tName = table.getLongName();
                        for (String name : tableUsedNames) {
                            if (!name.equals(tName)) continue;
                            tableNameUsed = true;
                            break;
                        }
                        if (!tableNameUsed) {
                            tableUsedNames.add(tName);
                        }
                        Element tableDetails = document.createElement(namespace + "TableDetails");
                        tablesCollection.appendChild(tableDetails);
                        Element e2 = document.createElement(namespace + tableModelNameXMLTag);
                        e2.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                        tableDetails.appendChild(e2);
                        e2 = document.createElement(namespace + tableNameXMLTag);
                        e2.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                        tableDetails.appendChild(e2);
                        e2 = document.createElement(namespace + columnNameXMLTag);
                        e2.appendChild(document.createTextNode(column.getName()));
                        tableDetails.appendChild(e2);
                    }
                }
            }
        }
        if (templateFlagEntites) {
            create_header = true;
            Element entitiesCollection = null;
            ArrayList entityUsedNames = new ArrayList();
            while (allEntitiesIterator.hasNext()) {
                Entity entity = (Entity)allEntitiesIterator.next();
                for (Attribute attribute : Arrays.asList(entity.getElements())) {
                    if (attribute.getUse() != objectType) continue;
                    desObj = null;
                    if (currentDesObj instanceof StructuredType) {
                        desObj = attribute.getStructuredType();
                    } else if (currentDesObj instanceof CollectionType) {
                        desObj = attribute.getCollectionType();
                    } else if (currentDesObj instanceof DistinctType) {
                        desObj = attribute.getDistinctType();
                    } else if (currentDesObj instanceof Domain) {
                        desObj = attribute.getDomain();
                    }
                    if (currentDesObj != desObj) continue;
                    if (create_header) {
                        entitiesCollection = document.createElement(namespace + "EntitiesCollection");
                        baseElement.appendChild(entitiesCollection);
                        create_header = false;
                    }
                    boolean entityNameUsed = false;
                    eName = entity.getName();
                    for (String name : entityUsedNames) {
                        if (!name.equals(eName)) continue;
                        entityNameUsed = true;
                        break;
                    }
                    if (!entityNameUsed) {
                        tableUsedNames.add(eName);
                    }
                    Element entityDetails = document.createElement(namespace + "EntityDetails");
                    entitiesCollection.appendChild(entityDetails);
                    e = document.createElement(namespace + entityNameXMLTag);
                    e.appendChild(document.createTextNode(!entityNameUsed ? entity.getName() : ""));
                    entityDetails.appendChild(e);
                    e = document.createElement(namespace + attributeNameXMLTag);
                    e.appendChild(document.createTextNode(attribute.getName()));
                    entityDetails.appendChild(e);
                }
            }
        }
        if (templateFlagST) {
            create_header = true;
            Element stCollection = null;
            ArrayList stUsedNames = new ArrayList();
            while (stIterator.hasNext()) {
                StructuredType st = (StructuredType)stIterator.next();
                for (TypeElement typeElement : Arrays.asList(st.getElements())) {
                    desObj = typeElement.getType();
                    if (currentDesObj != desObj) continue;
                    if (create_header) {
                        stCollection = document.createElement(namespace + "STCollection");
                        baseElement.appendChild(stCollection);
                        create_header = false;
                    }
                    boolean stNameUsed = false;
                    eName = st.getName();
                    for (String name : stUsedNames) {
                        if (!name.equals(eName)) continue;
                        stNameUsed = true;
                        break;
                    }
                    if (!stNameUsed) {
                        tableUsedNames.add(eName);
                    }
                    Element stDetails = document.createElement(namespace + "STDetails");
                    stCollection.appendChild(stDetails);
                    e = document.createElement(namespace + structuredTypeNameXMLTag);
                    e.appendChild(document.createTextNode(!stNameUsed ? st.getName() : ""));
                    stDetails.appendChild(e);
                    e = document.createElement(namespace + typeElementNameXMLTag);
                    e.appendChild(document.createTextNode(typeElement.getName()));
                    stDetails.appendChild(e);
                }
            }
        }
        return baseElement;
    }

    private Document gatherAllStructuredTypesData(DesignPart model, StandardReportTemplate reportTemplate, List structuredTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/structuredtypes", "osdmAllStructuredTypes:StructuredTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllStructuredTypes:";
            this.createHeaderSection(document, namespace, rootElement, model);
            Element stCollection = document.createElement(namespace + "STCollection");
            rootElement.appendChild(stCollection);
            if (structuredTypes.size() > 0) {
                this.currentObjectsList = structuredTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getStructuredTypeSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (StructuredType structuredType : this.currentObjectsList) {
                Element stDetails = document.createElement(namespace + "STDetails");
                stCollection.appendChild(stDetails);
                this.createSTDetailsSection(document, namespace, stDetails, structuredType);
                this.createUsedInObjectsSection(document, namespace, stDetails, structuredType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all structured types report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleDistinctTypeData(DesignPart model, StandardReportTemplate reportTemplate, List distinctTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/distincttype", "osdmSingleDistinctType:DistinctType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleDistinctType:";
            this.createHeaderSection(document, namespace, rootElement, model);
            DistinctType distinctType = (DistinctType)distinctTypes.get(0);
            this.currentObjectsList.add(distinctType);
            Element e = document.createElement(namespace + "DTName");
            e.appendChild(document.createTextNode(distinctType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "EncodedName");
            e.appendChild(document.createTextNode(distinctType.getShortObjectID()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTLogicalType");
            e.appendChild(document.createTextNode(distinctType.getLogicalDataType().getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTSize");
            String sz = distinctType.getSize();
            if (sz != null) {
                e.appendChild(document.createTextNode(!sz.equals("") && !sz.equals("0") ? distinctType.getSize() : ""));
            } else {
                e.appendChild(document.createTextNode(""));
            }
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTPrecision");
            int p = distinctType.getPrecision();
            e.appendChild(document.createTextNode(p > 0 ? Integer.valueOf(distinctType.getPrecision()).toString() : ""));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTScale");
            int s = distinctType.getScale();
            e.appendChild(document.createTextNode(s > 0 ? Integer.valueOf(distinctType.getScale()).toString() : ""));
            rootElement.appendChild(e);
            this.createDescriptionAndNotesSection(document, namespace, rootElement, distinctType);
            this.createUsedInObjectsSection(document, namespace, rootElement, distinctType);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single distinct type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllDistinctTypesData(DesignPart model, StandardReportTemplate reportTemplate, List distinctTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/distincttypes", "osdmAllDistinctTypes:DistinctTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllDistinctTypes:";
            this.createHeaderSection(document, namespace, rootElement, model);
            Element dtCollection = document.createElement(namespace + "DTCollection");
            rootElement.appendChild(dtCollection);
            if (distinctTypes.size() > 0) {
                this.currentObjectsList = distinctTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getDistinctTypeSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (DistinctType distinctType : this.currentObjectsList) {
                Element dtDetails = document.createElement(namespace + "DTDetails");
                dtCollection.appendChild(dtDetails);
                Element e = document.createElement(namespace + "DTName");
                e.appendChild(document.createTextNode(distinctType.getLongName()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedName");
                e.appendChild(document.createTextNode(distinctType.getShortObjectID()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTLogicalType");
                e.appendChild(document.createTextNode(distinctType.getLogicalDataType().getName()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTSize");
                String sz = distinctType.getSize();
                if (sz != null) {
                    e.appendChild(document.createTextNode(!sz.equals("") && !sz.equals("0") ? distinctType.getSize() : ""));
                } else {
                    e.appendChild(document.createTextNode(""));
                }
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTPrecision");
                int p = distinctType.getPrecision();
                e.appendChild(document.createTextNode(p > 0 ? Integer.valueOf(distinctType.getPrecision()).toString() : ""));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTScale");
                int s = distinctType.getScale();
                e.appendChild(document.createTextNode(s > 0 ? Integer.valueOf(distinctType.getScale()).toString() : ""));
                dtDetails.appendChild(e);
                this.createDescriptionAndNotesSection(document, namespace, dtDetails, distinctType);
                this.createUsedInObjectsSection(document, namespace, dtDetails, distinctType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all distinct types report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleTableViewData(DesignPart model, StandardReportTemplate reportTemplate, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tableview", "osdmSingleTableView:TableView");
            document.appendChild(rootElement);
            String namespace = "osdmSingleTableView:";
            this.createHeaderSection(document, namespace, rootElement, model);
            TableView view = (TableView)views.get(0);
            this.currentObjectsList.add(view);
            this.createTableDetailsSection(document, namespace, rootElement, view);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single table view report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleEntityViewData(DesignPart model, StandardReportTemplate reportTemplate, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entityview", "osdmSingleEntityView:EntityView");
            document.appendChild(rootElement);
            String namespace = "osdmSingleEntityView:";
            this.createHeaderSection(document, namespace, rootElement, model);
            EntityView view = (EntityView)views.get(0);
            this.currentObjectsList.add(view);
            this.createEntityDetailsSection(document, namespace, rootElement, view);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single entity view report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    /*
     * Could not resolve type clashes
     */
    private Document gatherAllTablesAndViewsData(DesignPart model, StandardReportTemplate reportTemplate, List tablesAndViews) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tablesandviews", "osdmAllTablesAndViews:TablesAndViews");
            document.appendChild(rootElement);
            String namespace = "osdmAllTablesAndViews:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            Element e = null;
            if (model != null) {
                e = document.createElement(namespace + "DesignName");
                e.appendChild(document.createTextNode(this.design.getName()));
                rootElement.appendChild(e);
                e = document.createElement(namespace + "VersionDate");
                e.appendChild(document.createTextNode(dateFormat.format(new Date())));
                rootElement.appendChild(e);
                String designComment = this.design.getComment();
                if (designComment != "" && designComment != null) {
                    Element versionCommentElement = document.createElement(namespace + "VersionComment");
                    versionCommentElement.appendChild(document.createCDATASection(designComment));
                    rootElement.appendChild(versionCommentElement);
                }
                e = document.createElement(namespace + "ModelName");
                e.appendChild(document.createTextNode(model.getName()));
                rootElement.appendChild(e);
            }
            Element tablesCollection = document.createElement(namespace + "TablesCollection");
            rootElement.appendChild(tablesCollection);
            Element viewsCollection = document.createElement(namespace + "TablesViewsCollection");
            rootElement.appendChild(viewsCollection);
            List currentObjectsList = new ArrayList();
            if (tablesAndViews.size() != 0) {
                currentObjectsList = tablesAndViews;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
                it0 = ((RelationalDesign)model).getTableViewSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (Object dObj : currentObjectsList) {
                String fk;
                Element tableDetails;
                if (dObj instanceof Table && this.addTables.booleanValue()) {
                    Table table = (Table)dObj;
                    tableDetails = document.createElement(namespace + "TableDetails");
                    tablesCollection.appendChild(tableDetails);
                    e = document.createElement(namespace + "TableName");
                    e.appendChild(document.createTextNode(table.getLongName()));
                    tableDetails.appendChild(e);
                    e = document.createElement(namespace + "EncodedTableName");
                    e.appendChild(document.createTextNode(table.getShortObjectID()));
                    tableDetails.appendChild(e);
                    e = document.createElement(namespace + "ObjectTypeName");
                    e.appendChild(document.createTextNode(table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : ""));
                    tableDetails.appendChild(e);
                    String description = "";
                    description = table.getComment() == null || table.getComment().equals("") ? table.getCommentInRDBMS() : table.getComment();
                    if (description != "" && description != null) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        tableDetails.appendChild(descriptionElement);
                    }
                    e = document.createElement(namespace + "MVPrebuilt");
                    e.appendChild(document.createTextNode(table.isOnPrebuiltTable() ? "Yes" : ""));
                    tableDetails.appendChild(e);
                    if (table.getUserDefinedSQL() != null) {
                        e = document.createElement(namespace + "MVQuery");
                        e.appendChild(document.createCDATASection(table.getUserDefinedSQL()));
                        tableDetails.appendChild(e);
                    }
                    if (reportTemplate.isUseTableColumns()) {
                        int columnsCounter = 0;
                        Element columnsCollection = null;
                        for (FKElement column : Arrays.asList(table.getElements())) {
                            String personalInfo;
                            if (columnsCounter == 0) {
                                columnsCollection = document.createElement(namespace + "ColumnsCollection");
                                tableDetails.appendChild(columnsCollection);
                            }
                            Element columnDetails = document.createElement(namespace + "ColumnDetails");
                            columnsCollection.appendChild(columnDetails);
                            e = document.createElement(namespace + "Sequence");
                            e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "PK");
                            e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "FK");
                            fk = ((Column)column).isFKElement() || column.isPartOfUnresolvedFK(table) ? "F" : "";
                            e.appendChild(document.createTextNode(fk));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "M");
                            e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                            columnDetails.appendChild(e);
                            String dataType = "";
                            String domainName = "";
                            switch (column.getUse()) {
                                case 0: {
                                    Domain dom = column.getDomain();
                                    domainName = dom.getName();
                                    dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                                    String domainName = domainName.replace("Unknown", "");
                                    domainName = domainName.replace("unknown", "");
                                    domainName = domainName.replace("UNKNOWN", "");
                                    break;
                                }
                                case 1: {
                                    dataType = ((Column)column).getNativeDataType();
                                    break;
                                }
                                case 2: {
                                    dataType = column.getDistinctType().getName();
                                    break;
                                }
                                case 3: {
                                    dataType = column.getStructuredType().getName();
                                    break;
                                }
                                case 4: {
                                    dataType = column.getCollectionType().getName();
                                }
                            }
                            e = document.createElement(namespace + "DataType");
                            String ai = ((Column)column).isAutoIncrementColumn() ? " - AI" : "";
                            String id = ((Column)column).isIdentityColumn() ? " - ID" : "";
                            e.appendChild(document.createTextNode(dataType + ai + id));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "Formula");
                            e.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                            columnDetails.appendChild(e);
                            String security = "";
                            String string = ((Column)column).isContainsPII() == null ? "" : (personalInfo = ((Column)column).isContainsPII() != false ? "Y" : "");
                            String sensitiveInfo = ((Column)column).isContainsSensitiveInformation() == null ? "" : (((Column)column).isContainsSensitiveInformation() != false ? "Y" : "");
                            String maskInfo = ((Column)column).getMaskingType();
                            if (maskInfo == null) {
                                maskInfo = "";
                            }
                            security = personalInfo + "/" + sensitiveInfo + "/" + maskInfo;
                            security = security.replace("//", "");
                            e = document.createElement(namespace + "Security");
                            e.appendChild(document.createTextNode(security));
                            columnDetails.appendChild(e);
                            String columnDescription = "";
                            columnDescription = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                            if (columnDescription != "" && columnDescription != null) {
                                Element columnDescriptionElement = document.createElement(namespace + "ColumnDescription");
                                columnDescriptionElement.appendChild(document.createCDATASection(columnDescription));
                                columnDetails.appendChild(columnDescriptionElement);
                            }
                            ++columnsCounter;
                        }
                    }
                    if (reportTemplate.isUseTableIndexes()) {
                        int indesexCounter = 0;
                        HashMap<String, String> usedNames = new HashMap<String, String>();
                        Element indesexCollection = null;
                        Iterator itIndexes = table.getKeySet().iterator();
                        while (itIndexes.hasNext()) {
                            Index index = (Index)itIndexes.next();
                            if (index.isFK()) continue;
                            if (indesexCounter == 0) {
                                indesexCollection = document.createElement(namespace + "IndexesCollection");
                                tableDetails.appendChild(indesexCollection);
                            }
                            Iterator<ContainedObject> itIdxColumns = null;
                            if (index.hasIndexExpression()) {
                                ArrayList<String> list = new ArrayList<String>();
                                list.add(" ");
                                itIdxColumns = list.iterator();
                            } else {
                                itIdxColumns = Arrays.asList(index.getElements()).iterator();
                            }
                            while (itIdxColumns.hasNext()) {
                                Column col = null;
                                String colName = null;
                                ContainedObject obj = itIdxColumns.next();
                                if (obj instanceof Column) {
                                    col = (Column)obj;
                                    colName = col.getName();
                                } else {
                                    colName = ((Object)obj).toString();
                                }
                                Element indexdetails = document.createElement(namespace + "IndexDetails");
                                indesexCollection.appendChild(indexdetails);
                                String state = index.getIndexState();
                                boolean nameUsed = false;
                                String cName = index.getName();
                                for (Map.Entry pair : usedNames.entrySet()) {
                                    String name = (String)pair.getKey();
                                    String st = (String)pair.getValue();
                                    if (!name.equals(cName) || !st.equals(state)) continue;
                                    nameUsed = true;
                                    break;
                                }
                                if (!nameUsed) {
                                    usedNames.put(cName, state);
                                }
                                e = document.createElement(namespace + "IndexName");
                                e.appendChild(document.createTextNode(nameUsed ? "" : index.getName()));
                                indexdetails.appendChild(e);
                                state = state.equals("Unique Plain Index") ? "UN" : (state.equals("Unique Constraint") ? "UK" : (state.equals("Primary Constraint") ? "PK" : ""));
                                e = document.createElement(namespace + "IndexState");
                                e.appendChild(document.createTextNode(nameUsed ? "" : state));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexFunctional");
                                e.appendChild(document.createTextNode(!"".equalsIgnoreCase(index.getIndexExpression()) ? "Y" : ""));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexSpatial");
                                e.appendChild(document.createTextNode(index.isSpatialIndex() ? "Y" : ""));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexExpression");
                                e.appendChild(document.createTextNode(index.getIndexExpression()));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexColumnName");
                                e.appendChild(document.createTextNode(colName));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexSortOrder");
                                if (col != null) {
                                    e.appendChild(document.createTextNode(index.getColumnSortOrder(col)));
                                } else {
                                    e.appendChild(document.createTextNode(" "));
                                }
                                indexdetails.appendChild(e);
                            }
                            ++indesexCounter;
                        }
                    }
                    if (reportTemplate.isUseTableConstraints()) {
                        int constraintsCounter = 0;
                        Element constraintsCollection = null;
                        Node tableLevelConstraintsCollection = null;
                        for (TableLevelConstraint tlConstraint : table.getCheckConstraints()) {
                            if (constraintsCounter == 0) {
                                constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                                tableDetails.appendChild(constraintsCollection);
                                tableLevelConstraintsCollection = document.createElement(namespace + "TableLevelConstraintsCollection");
                                constraintsCollection.appendChild(tableLevelConstraintsCollection);
                            }
                            Element constraintDetails = document.createElement(namespace + "TableLevelConstraintDetails");
                            tableLevelConstraintsCollection.appendChild(constraintDetails);
                            e = document.createElement(namespace + "TLConstraintType");
                            e.appendChild(document.createTextNode(constraintsCounter == 0 ? "Table Level" : ""));
                            constraintDetails.appendChild(e);
                            e = document.createElement(namespace + "TLConstraintName");
                            e.appendChild(document.createTextNode(tlConstraint.getName()));
                            constraintDetails.appendChild(e);
                            Element tlConstraintElement = document.createElement(namespace + "TLConstraintRule");
                            tlConstraintElement.appendChild(document.createCDATASection(tlConstraint.getRule()));
                            constraintDetails.appendChild(tlConstraintElement);
                            ++constraintsCounter;
                        }
                        int columnConstraintsCounter = 0;
                        Element columnLevelConstraintsCollection = null;
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                            if (constraintsCounter == 0) {
                                constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                                tableDetails.appendChild(constraintsCollection);
                            }
                            if (columnConstraintsCounter == 0) {
                                columnLevelConstraintsCollection = document.createElement(namespace + "ColumnLevelConstraintsCollection");
                                constraintsCollection.appendChild(columnLevelConstraintsCollection);
                            }
                            String constraintName = "";
                            CheckConstraint ccConstraint = column.getCheck();
                            if (ccConstraint != null && !(constraintName = ccConstraint.getName()).equals("")) {
                                constraintName = " / " + constraintName;
                            }
                            Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                            columnLevelConstraintsCollection.appendChild(constraintDetails);
                            e = document.createElement(namespace + "ContstraintType");
                            e.appendChild(document.createTextNode(columnConstraintsCounter == 0 ? "Column Level" : ""));
                            constraintDetails.appendChild(e);
                            e = document.createElement(namespace + "ALCConstraintName");
                            e.appendChild(document.createTextNode(column.getName() + constraintName));
                            constraintDetails.appendChild(e);
                            Element rangesCollection = null;
                            Iterator itRanges = column.getAVTs().iterator();
                            int rgCounter = 0;
                            while (itRanges.hasNext()) {
                                AVT avt = (AVT)itRanges.next();
                                if (rgCounter == 0) {
                                    rangesCollection = document.createElement(namespace + "RangesCollection");
                                    constraintDetails.appendChild(rangesCollection);
                                }
                                Element rangeDetails = document.createElement(namespace + "RangeDetails");
                                rangesCollection.appendChild(rangeDetails);
                                e = document.createElement(namespace + "RangeBeginValue");
                                e.appendChild(document.createTextNode(avt.getBeginValue()));
                                rangeDetails.appendChild(e);
                                e = document.createElement(namespace + "RangeEndValue");
                                e.appendChild(document.createTextNode(avt.getEndValue()));
                                rangeDetails.appendChild(e);
                                e = document.createElement(namespace + "RangeShortDescription");
                                e.appendChild(document.createTextNode(avt.getDescription()));
                                rangeDetails.appendChild(e);
                                ++rgCounter;
                            }
                            Element vlCollection = null;
                            int vlCounter = 0;
                            if (column.getValueList() != null) {
                                Iterator itVL = column.getValueIterator();
                                while (itVL.hasNext()) {
                                    Object key = itVL.next();
                                    String value = (String)column.getValueList().getValuesDescriptionMap().get(key);
                                    if (vlCounter == 0) {
                                        vlCollection = document.createElement(namespace + "ValueListsCollection");
                                        constraintDetails.appendChild(vlCollection);
                                    }
                                    Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                    vlCollection.appendChild(vlDetails);
                                    e = document.createElement(namespace + "VLValue");
                                    e.appendChild(document.createTextNode(key.toString()));
                                    vlDetails.appendChild(e);
                                    e = document.createElement(namespace + "VLShortDescription");
                                    e.appendChild(document.createTextNode(value));
                                    vlDetails.appendChild(e);
                                    ++vlCounter;
                                }
                            }
                            if (ccConstraint != null) {
                                Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                                constraintDetails.appendChild(ccCollection);
                                String generic = ccConstraint.getGenericConstraint();
                                if (!generic.trim().equalsIgnoreCase("")) {
                                    Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                    ccCollection.appendChild(ccDetails);
                                    Element ccText = document.createElement(namespace + "CheckConstraintText");
                                    ccText.appendChild(document.createCDATASection(generic));
                                    ccDetails.appendChild(ccText);
                                    e = document.createElement(namespace + "DatabaseType");
                                    e.appendChild(document.createTextNode("Generic Constraint"));
                                    ccDetails.appendChild(e);
                                }
                                Object[] types = ccConstraint.getTypes();
                                for (int i = 0; i < types.length; ++i) {
                                    RDBMSType rdbmsType = (RDBMSType)types[i];
                                    String text = ccConstraint.getImplementationFor(rdbmsType);
                                    if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                    Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                    ccCollection.appendChild(ccDetails);
                                    Element ccText = document.createElement(namespace + "CheckConstraintText");
                                    ccText.appendChild(document.createCDATASection(text));
                                    ccDetails.appendChild(ccText);
                                    e = document.createElement(namespace + "DatabaseType");
                                    e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                    ccDetails.appendChild(e);
                                }
                            }
                            ++columnConstraintsCounter;
                        }
                    }
                    if (reportTemplate.isUseTableFKReferringTo()) {
                        this.processFKeysReferTo(table, document, tableDetails, namespace);
                    }
                    if (!reportTemplate.isUseTableFKReferredFrom()) continue;
                    this.processFKeysReferFrom(table, document, tableDetails, namespace);
                    continue;
                }
                if (!(dObj instanceof TableView) || !this.addViews.booleanValue()) continue;
                TableView view = (TableView)dObj;
                tableDetails = document.createElement(namespace + "TableViewDetails");
                viewsCollection.appendChild(tableDetails);
                e = document.createElement(namespace + "ViewName");
                e.appendChild(document.createTextNode(view.getLongName()));
                tableDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedViewName");
                e.appendChild(document.createTextNode(view.getShortObjectID()));
                tableDetails.appendChild(e);
                if (this.settings.isIncludeSelectStatementInViewReport()) {
                    e = document.createElement(namespace + "SelectStatement");
                    e.appendChild(document.createCDATASection(view.getUserDefinedSQL()));
                    tableDetails.appendChild(e);
                }
                if (view.isBST()) {
                    e = document.createElement(namespace + "StructuredTypeName");
                    e.appendChild(document.createTextNode(view.getBasedOnStructuredTypeName()));
                    rootElement.appendChild(e);
                }
                if (reportTemplate.isUseTableColumns()) {
                    int columnsCounter = 0;
                    Element columnsCollection = null;
                    Iterator<ContainedObject> itColumns = Arrays.asList(view.getElements()).iterator();
                    int seq = 0;
                    while (itColumns.hasNext()) {
                        FKElement column;
                        ++seq;
                        column = (ColumnView)itColumns.next();
                        if (columnsCounter == 0) {
                            columnsCollection = document.createElement(namespace + "ColumnsCollection");
                            tableDetails.appendChild(columnsCollection);
                        }
                        Element columnDetails = document.createElement(namespace + "ColumnDetails");
                        columnsCollection.appendChild(columnDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(seq).toString()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        fk = ((AbstractViewElement)column).isFKElement() || column.isPartOfUnresolvedFK(view) ? "F" : "";
                        e.appendChild(document.createTextNode(fk));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "DataType");
                        e.appendChild(document.createTextNode(((AbstractViewElement)column).getDataTypeString()));
                        columnDetails.appendChild(e);
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PreferredAbbreviation");
                        e.appendChild(document.createTextNode(((AbstractViewElement)column).getAbbreviation()));
                        columnDetails.appendChild(e);
                        ++columnsCounter;
                    }
                }
                if (reportTemplate.isUseTableColumnsComments()) {
                    int columnsCommentsCounter = 0;
                    Element columnsCommentsCollection = null;
                    for (ColumnView column : Arrays.asList(view.getElements())) {
                        String columnDescription = "";
                        columnDescription = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                        String columnNotes = column.getNotes();
                        if ((columnDescription == null || columnDescription.equals("")) && (columnNotes == null || columnNotes.equals(""))) continue;
                        if (columnsCommentsCounter == 0) {
                            columnsCommentsCollection = document.createElement(namespace + "ColumnsCommentsCollection");
                            tableDetails.appendChild(columnsCommentsCollection);
                        }
                        Element columnCommentsDetails = document.createElement(namespace + "ColumnCommentsDetails");
                        columnsCommentsCollection.appendChild(columnCommentsDetails);
                        e = document.createElement(namespace + "ColumnCommentsSequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        columnCommentsDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnCommentsName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnCommentsDetails.appendChild(e);
                        if (columnDescription != "" && columnDescription != null) {
                            Element columnDescriptionElement = document.createElement(namespace + "ColumnDescription");
                            columnDescriptionElement.appendChild(document.createCDATASection(columnDescription));
                            columnCommentsDetails.appendChild(columnDescriptionElement);
                        }
                        if (columnNotes != "" && columnNotes != null) {
                            Element columnNotesElement = document.createElement(namespace + "ColumnNotes");
                            columnNotesElement.appendChild(document.createCDATASection(columnNotes));
                            columnCommentsDetails.appendChild(columnNotesElement);
                        }
                        ++columnsCommentsCounter;
                    }
                }
                if (reportTemplate.isUseTableFKReferringTo()) {
                    this.processFKeysReferTo(view, document, tableDetails, namespace);
                }
                if (!reportTemplate.isUseTableFKReferredFrom()) continue;
                this.processFKeysReferFrom(view, document, tableDetails, namespace);
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all tables and views report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables and views report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllTablesViewsData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tablesviews", "osdmAllTablesViews:TablesViews");
            document.appendChild(rootElement);
            String namespace = "osdmAllTablesViews:";
            this.createHeaderSection(document, namespace, rootElement, model);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, views);
            Element viewsCollection = document.createElement(namespace + "TablesViewsCollection");
            rootElement.appendChild(viewsCollection);
            if (views.size() != 0) {
                this.currentObjectsList = views;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableViewSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (TableView view : this.currentObjectsList) {
                Element tableViewDetails = document.createElement(namespace + "TableViewDetails");
                viewsCollection.appendChild(tableViewDetails);
                this.createTableDetailsSection(document, namespace, tableViewDetails, view);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables views report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllEntitiesViewsData(DesignPart model, StandardReportTemplate reportTemplate, HashMap<DesignPartViewPlaceHolder, List<String>> subViewsMap, List views) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/entitiesviews", "osdmAllEntitiesViews:EntitiesViews");
            document.appendChild(rootElement);
            String namespace = "osdmAllEntitiesViews:";
            this.createHeaderSection(document, namespace, rootElement, model);
            this.createSubviewsSection(document, namespace, rootElement, subViewsMap, model, views);
            Element entitiesCollection = document.createElement(namespace + "EntitiesViewsCollection");
            rootElement.appendChild(entitiesCollection);
            if (views.size() > 0) {
                this.currentObjectsList = views;
            } else {
                Iterator it0 = ((LogicalDesign)model).getEntityViewSet().iterator();
                while (it0.hasNext()) {
                    this.currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(this.currentObjectsList, new ObjectsComparator());
            for (EntityView view : this.currentObjectsList) {
                Element entityViewDetails = document.createElement(namespace + "EntityViewDetails");
                entitiesCollection.appendChild(entityViewDetails);
                this.createEntityDetailsSection(document, namespace, entityViewDetails, view);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during all entities views report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document generateSearchResultsDomDocument(CustomReportTemplate crt, ModelIDObject model, List objects, HashMap extraParams) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/searchresults", "osdmSearchResults:SearchResults");
            document.appendChild(rootElement);
            String namespace = "osdmSearchResults:";
            Element rCaption = document.createElement(namespace + "title");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            boolean showFilter = (Boolean)extraParams.get("show");
            Element objShowFilter = document.createElement(namespace + "showFilter");
            objShowFilter.appendChild(document.createTextNode(((Boolean)extraParams.get("show")).toString()));
            rootElement.appendChild(objShowFilter);
            Element objPattern = document.createElement(namespace + "pattern");
            objPattern.appendChild(document.createTextNode((String)extraParams.get("pattern")));
            rootElement.appendChild(objPattern);
            if (showFilter) {
                Element objFilter = document.createElement(namespace + "filter");
                objFilter.appendChild(document.createTextNode(((SearchSet)extraParams.get("filterObject")).getTypeName() + " " + model.getName()));
                rootElement.appendChild(objFilter);
            }
            Element tableWidth = document.createElement(namespace + "tw");
            rootElement.appendChild(tableWidth);
            Element isML = document.createElement(namespace + "multiLevel");
            boolean ml = false;
            if (!crt.getName().trim().equals("") && crt.getReportSections().size() > 1) {
                ml = true;
            }
            isML.appendChild(document.createTextNode(Boolean.toString(ml)));
            rootElement.appendChild(isML);
            Element sections = document.createElement(namespace + "sections");
            rootElement.appendChild(sections);
            Element objectsCollection = document.createElement(namespace + "objects");
            rootElement.appendChild(objectsCollection);
            ArrayList<ReportSection> usedSections = new ArrayList<ReportSection>();
            HashMap usedPropertiesMap = new HashMap();
            ArrayList<String> propertiesList = null;
            int sCounter = 0;
            for (ReportSection rs : crt.getReportSections()) {
                if (rs.getLevel() > 0) {
                    usedSections.add(rs);
                }
                if (sCounter <= 30) {
                    Element section = document.createElement(namespace + "section" + sCounter);
                    section.setAttribute("name", rs.getCustomName());
                    section.setAttribute("tw", "100%");
                    sections.appendChild(section);
                    int columnsCount = 0;
                    int colsWithZeroLength = 0;
                    double percentageUsed = 0.0;
                    for (ReportColumn rc : rs.getReportColumns()) {
                        if (rc.getColumnSize() == 0.0) {
                            ++colsWithZeroLength;
                        } else {
                            percentageUsed += rc.getColumnSize();
                        }
                        ++columnsCount;
                    }
                    double sizeForZeroLengthColumns = 0.0;
                    if (columnsCount != colsWithZeroLength) {
                        if (colsWithZeroLength > 0) {
                            sizeForZeroLengthColumns = (100.0 - percentageUsed) / (double)colsWithZeroLength;
                        }
                        if (rs.getLevel() == 0) {
                            tableWidth.appendChild(document.createTextNode("100%"));
                        }
                    } else {
                        if (colsWithZeroLength > 0) {
                            sizeForZeroLengthColumns = (100.0 - percentageUsed) / (double)colsWithZeroLength;
                        }
                        if (rs.getLevel() == 0) {
                            tableWidth.appendChild(document.createTextNode("100%"));
                        }
                    }
                    HashMap<String, Integer> columnsOrderMap = new HashMap<String, Integer>();
                    int cCounter = 0;
                    propertiesList = new ArrayList<String>();
                    for (ReportColumn rc : rs.getReportColumns()) {
                        propertiesList.add(rc.getPropertyName());
                        if (++cCounter > 30) continue;
                        Element column = document.createElement(namespace + "c" + cCounter);
                        Element show = document.createElement(namespace + "show");
                        show.appendChild(document.createTextNode("true"));
                        Element name = document.createElement(namespace + "name");
                        name.appendChild(document.createTextNode(rc.getPropertyName()));
                        Element cn = document.createElement(namespace + "customName");
                        cn.appendChild(document.createTextNode(rc.getColumnName()));
                        Element w = document.createElement(namespace + "width");
                        double columnSize = rc.getColumnSize();
                        if (columnSize == 0.0) {
                            columnSize = sizeForZeroLengthColumns;
                        }
                        w.appendChild(document.createTextNode(Double.toString(columnSize) + "%"));
                        column.appendChild(show);
                        column.appendChild(name);
                        column.appendChild(cn);
                        column.appendChild(w);
                        section.appendChild(column);
                        if (rc.getColumnOrder().equals("")) continue;
                        columnsOrderMap.put("c" + cCounter, Integer.parseInt(rc.getColumnOrder()));
                    }
                }
                usedPropertiesMap.put(rs.getElementClass(), propertiesList);
                ++sCounter;
            }
            Collections.sort(objects, new PropertiesComparator(objects, ((ReportSection)crt.getReportSections().get(0)).getReportColumns()));
            for (SearchResultObject ro : objects) {
                ModelIDObject obj = (ModelIDObject)ro.getObj();
                String objName = obj.getLongName();
                ClassDescription cd = this.metaDataManager.getClassDescription(obj.getClass().getName());
                Element baseObject = document.createElement(namespace + "object");
                objectsCollection.appendChild(baseObject);
                Element values = document.createElement(namespace + "values");
                baseObject.appendChild(values);
                Element elValue = document.createElement(namespace + "v" + "0");
                elValue.appendChild(document.createTextNode(objName));
                values.appendChild(elValue);
                int vCounter = 0;
                for (String propertyName : (List)usedPropertiesMap.get(obj.getClass())) {
                    elValue = document.createElement(namespace + "v" + ++vCounter);
                    values.appendChild(elValue);
                    ClassDescription.PropertyDescription pd = cd.getSearchablePropertyDescriptionByName(propertyName);
                    String value = "";
                    if (pd != null) {
                        String className = pd.className;
                        java.lang.reflect.Method method = pd.getter;
                        value = this.getPropertiesValue(method, className, obj);
                    } else {
                        value = obj.getProperty(propertyName);
                    }
                    elValue.appendChild(document.createTextNode(value));
                }
                sCounter = 0;
                for (ReportSection rs : usedSections) {
                    Object cd1;
                    if (++sCounter > 30) continue;
                    Element section = document.createElement(namespace + "section" + sCounter);
                    section.setAttribute("tw", "100%");
                    baseObject.appendChild(section);
                    java.lang.reflect.Method method = null;
                    if (rs.getType().equals("collection")) {
                        cd1 = (ClassDescription.CollectionDescription)rs.getElement();
                        method = ((ClassDescription.CollectionDescription)cd1).getter;
                    } else if (rs.getType().equals("roPropertiesList")) {
                        ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)rs.getElement();
                        method = pd.getter;
                    } else {
                        cd1 = (ClassDescription)rs.getElement();
                        ClassDescription.PropertyDescription pd = ((ClassDescription)cd1).getSearchablePropertyDescriptionByName(rs.getPropertyName());
                        if (pd != null) {
                            method = pd.getter;
                        }
                    }
                    Iterator<Object> itemsListIt = null;
                    if (method != null) {
                        List<Object> l;
                        Object col = method.invoke((Object)obj, new Object[0]);
                        if (col instanceof Collection) {
                            l = new ArrayList((Collection)col);
                            Collections.sort(l, new PropertiesComparator(l, rs.getReportColumns()));
                            itemsListIt = l.iterator();
                        } else if (col instanceof ElementSet) {
                            l = Arrays.asList(((ElementSet)col).toArray());
                            Collections.sort(l, new PropertiesComparator(l, rs.getReportColumns()));
                            itemsListIt = l.iterator();
                        }
                    }
                    if (itemsListIt == null) continue;
                    while (itemsListIt.hasNext()) {
                        Object rObj = itemsListIt.next();
                        Element oObject = document.createElement(namespace + "object");
                        section.appendChild(oObject);
                        Element values1 = document.createElement(namespace + "values");
                        oObject.appendChild(values1);
                        ClassDescription cd12 = this.metaDataManager.getClassDescription(rObj.getClass().getName());
                        int pCounter = 0;
                        for (ReportColumn rc : rs.getReportColumns()) {
                            elValue = document.createElement(namespace + "v" + ++pCounter);
                            values1.appendChild(elValue);
                            String value = "";
                            ClassDescription.PropertyDescription pd = cd12.getSearchablePropertyDescriptionByName(rc.getPropertyName());
                            if (pd != null) {
                                String className = pd.className;
                                java.lang.reflect.Method method1 = pd.getter;
                                value = this.getPropertiesValue(method1, className, rObj);
                            } else {
                                DesignObject o = (DesignObject)rObj;
                                value = o.getProperty(rc.getPropertyName());
                            }
                            elValue.appendChild(document.createTextNode(value));
                        }
                    }
                }
                Element section = document.createElement(namespace + "section");
                section.setAttribute("tw", "100%");
                baseObject.appendChild(section);
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.generateSearchResultsDomDocument() Exception : " + e.getMessage(), e);
            e.printStackTrace();
        }
        return document;
    }

    private String getPropertiesValue(java.lang.reflect.Method method, String className, Object obj) {
        String value = "";
        try {
            if (method != null) {
                Object object = method.invoke(obj, new Object[0]);
                if (className.indexOf("java.lang.String") > -1) {
                    if (object != null) {
                        value = (String)object;
                    }
                } else if (className.indexOf("java.lang.Integer") > -1) {
                    if (object != null) {
                        value = ((Integer)object).toString();
                    }
                } else if (className.indexOf("java.lang.Boolean") > -1) {
                    if (object != null) {
                        value = this.replaceBooleanValues.booleanValue() ? ((Boolean)object != false ? this.strTrue : this.strFalse) : ((Boolean)object).toString();
                    }
                } else if (className.indexOf("boolean") > -1) {
                    if (object != null) {
                        value = this.replaceBooleanValues.booleanValue() ? (object.toString().equals("true") ? this.strTrue : this.strFalse) : object.toString();
                    }
                } else if (className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    if (object != null) {
                        value = object.toString();
                    }
                } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                    value = object != null && object instanceof Iterable ? ReportUtils.iteratorToString(((Iterable)object).iterator()) : (object != null && object instanceof List ? ReportUtils.listToString((List)object) : (object instanceof ModelObject ? ((ModelObject)object).getName() : object.toString()));
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        return value;
    }

    private String getSizePrecisionScale(Object obj, String dataType) {
        if (dataType.equalsIgnoreCase("unknown")) {
            return "";
        }
        String precision = "";
        String scale = "";
        String size = "";
        if (obj instanceof Column) {
            precision = ((Column)obj).getPrecision();
            scale = ((Column)obj).getScale();
            size = ((Column)obj).getSize();
        } else if (obj instanceof Attribute) {
            precision = ((Attribute)obj).getPrecision();
            scale = ((Attribute)obj).getScale();
            size = ((Attribute)obj).getSize();
        } else if (obj instanceof Domain) {
            precision = ((Domain)obj).getPrecision();
            scale = ((Domain)obj).getScale();
            size = ((Domain)obj).getSize();
        } else if (obj instanceof TypeElement) {
            precision = Integer.valueOf(((TypeElement)obj).getPrecision()).toString();
            scale = Integer.valueOf(((TypeElement)obj).getScale()).toString();
            size = ((TypeElement)obj).getSize();
        }
        if (precision != null && !precision.trim().equals("") && !precision.trim().equals("0")) {
            if ((dataType = dataType + " (" + precision).indexOf("(") > -1) {
                if (scale != null && !scale.trim().equals("") && !scale.trim().equals("0")) {
                    dataType = dataType + "," + scale;
                }
                dataType = dataType + ")";
            }
        } else if (size != null && !size.trim().equals("") && !size.trim().equals("0")) {
            dataType = dataType + " (" + size + ") ";
        }
        dataType = dataType.replace("(0,0)", "");
        dataType = dataType.replace("(0)", "");
        dataType = dataType.replace("()", "");
        dataType = dataType.replace("Unknown", "");
        dataType = dataType.replace("unknown", "");
        dataType = dataType.replace("UNKNOWN", "");
        return dataType;
    }

    public ResourceProvider getResourceProvider() {
        if (this.resourceProvider == null) {
            this.resourceProvider = new ResourceProvider("");
        }
        return this.resourceProvider;
    }

    public InputStream getInputStreamFor(String location) {
        InputStream is = null;
        if (MetaFileLoader.DMWEB) {
            is = this.getClass().getClassLoader().getResourceAsStream(location);
        } else {
            is = this.getResourceProvider().getResourceAsStriam(location);
            if (is == null) {
                LOGGER.error("Data inputstream is null (path: " + location + ")");
            }
        }
        return is;
    }

    private static final class IgnoreURIResolver
    implements URIResolver {
        static final IgnoreURIResolver INSTANCE = new IgnoreURIResolver();

        private IgnoreURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(new StringReader(""));
        }
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;

        public ValueComparator(Map<String, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            Integer y;
            Integer x = this.base.get(a);
            if (x.equals(y = this.base.get(b))) {
                return a.compareTo(b);
            }
            return x.compareTo(y);
        }
    }

    class PropertiesComparator
    implements Comparator {
        TreeMap tm = new TreeMap();
        Iterator it0 = null;

        public PropertiesComparator(List searchResultObjectslist, List searchablePropertieslist) {
            for (ReportColumn rc : searchablePropertieslist) {
                String order = rc.getColumnOrder();
                if (order == null || order.equals("")) continue;
                this.tm.put(rc.getColumnOrder(), rc.getPropertyName());
            }
            if (this.tm.size() == 0) {
                this.sortByName(searchablePropertieslist);
            }
        }

        private void sortByName(List searchablePropertieslist) {
            for (ReportColumn rc : searchablePropertieslist) {
                if (!rc.getColumnName().equalsIgnoreCase("name")) continue;
                this.tm.put(1, rc.getPropertyName());
            }
        }

        public int compare(Object o1, Object o2) {
            ClassDescription cd1 = null;
            ClassDescription cd2 = null;
            Object obj1 = null;
            Object obj2 = null;
            if (o1 instanceof SearchResultObject) {
                SearchResultObject ro1 = (SearchResultObject)o1;
                obj1 = ro1.getObj();
            } else {
                obj1 = o1;
            }
            Class<?> classObj1 = obj1.getClass();
            cd1 = XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(classObj1.getName());
            if (o2 instanceof SearchResultObject) {
                SearchResultObject ro2 = (SearchResultObject)o2;
                obj2 = ro2.getObj();
            } else {
                obj2 = o2;
            }
            Class<?> classObj2 = obj2.getClass();
            cd2 = XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(classObj2.getName());
            String className1 = "";
            for (Map.Entry pairs : this.tm.entrySet()) {
                String v1 = "";
                String v2 = "";
                try {
                    ClassDescription.PropertyDescription pd2;
                    ClassDescription.PropertyDescription pd1 = cd1.getPropertyDescriptionByNameInclRO((String)pairs.getValue());
                    if (pd1 != null) {
                        className1 = pd1.className;
                        java.lang.reflect.Method method1 = pd1.getter;
                        v1 = ReportUtils.getValue((ModelIDObject)obj1, method1, className1);
                    }
                    if ((pd2 = cd2.getPropertyDescriptionByNameInclRO((String)pairs.getValue())) != null) {
                        String className2 = pd2.className;
                        java.lang.reflect.Method method2 = pd2.getter;
                        v2 = ReportUtils.getValue((ModelIDObject)obj2, method2, className2);
                    }
                    if (v1.equals(v2)) continue;
                    if (pd1.isDateTime()) {
                        Date d1 = new SimpleDateFormat(ReportUtils.dateFormat).parse(v1);
                        Date d2 = new SimpleDateFormat(ReportUtils.dateFormat).parse(v2);
                        return d1.compareTo(d2);
                    }
                    if (className1.indexOf("java.lang.Integer") > -1) {
                        return new Integer(v1).compareTo(new Integer(v2));
                    }
                    if (className1.indexOf("java.lang.Float") > -1) {
                        return new Float(v1).compareTo(new Float(v2));
                    }
                    if (className1.indexOf("java.lang.Short") > -1) {
                        return new Short(v1).compareTo(new Short(v2));
                    }
                    if (className1.indexOf("java.lang.Long") > -1) {
                        return new Long(v1).compareTo(new Long(v2));
                    }
                    if (className1.indexOf("java.lang.Double") > -1) {
                        return new Double(v1).compareTo(new Double(v2));
                    }
                    if (className1.indexOf("int") > -1) {
                        return Integer.valueOf(v1).compareTo(Integer.valueOf(v2));
                    }
                    if (className1.indexOf("float") > -1) {
                        return Float.valueOf(v1).compareTo(Float.valueOf(v2));
                    }
                    if (className1.indexOf("short") > -1) {
                        return Short.valueOf(v1).compareTo(Short.valueOf(v2));
                    }
                    if (className1.indexOf("long") > -1) {
                        return Long.valueOf(v1).compareTo(Long.valueOf(v2));
                    }
                    if (className1.indexOf("double") > -1) {
                        return Double.valueOf(v1).compareTo(Double.valueOf(v2));
                    }
                    return v1.compareTo(v2);
                }
                catch (Exception e) {
                    LOGGER.error("Exception in search results report generation (objects sort) " + e);
                }
            }
            return 0;
        }
    }

    private class SubviewsComparator
    implements Comparator {
        private SubviewsComparator() {
        }

        public int compare(Object one, Object two) {
            DesignPartViewPlaceHolder o1 = (DesignPartViewPlaceHolder)one;
            DesignPartViewPlaceHolder o2 = (DesignPartViewPlaceHolder)two;
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class ObjectsComparator
    implements Comparator {
        private ObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            String s1 = "";
            String s2 = "";
            if (one instanceof DesignObject) {
                s1 = ((DesignObject)one).getName();
            } else if (one instanceof SearchResultObject) {
                s1 = ((ModelIDObject)((SearchResultObject)one).getObj()).getName();
            }
            if (two instanceof DesignObject) {
                s2 = ((DesignObject)two).getName();
            } else if (two instanceof SearchResultObject) {
                s2 = ((ModelIDObject)((SearchResultObject)two).getObj()).getName();
            }
            return s1.compareTo(s2);
        }
    }
}

