/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandardReportConfigurationsPersistence {
    private static final String SR_FILE_NAME = "standard_reports_configurations.xml";
    private static final Logger LOGGER = new Logger(StandardReportConfigurationsPersistence.class);

    public static List<StandardReportConfiguration> loadStandardReportConfigurations() {
        ArrayList<StandardReportConfiguration> loadedReportConfigurations = new ArrayList<StandardReportConfiguration>();
        try {
            File file;
            File dir;
            if (Design.systemTypesDir != null && (dir = new File(Design.systemTypesDir)).exists() && (file = new File(dir, SR_FILE_NAME)).exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                StandardReportConfigurationsPersistence.loadData(doc, loadedReportConfigurations);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load standard report configurations: ", e);
        }
        return loadedReportConfigurations;
    }

    private static void loadData(Document doc, List<StandardReportConfiguration> loadedReportConfigurations) {
        try {
            NodeList nodes1 = doc.getElementsByTagName("standard_report");
            int nodesLength1 = nodes1.getLength();
            for (int i = 0; i < nodesLength1; ++i) {
                Element elm = (Element)nodes1.item(i);
                Class<?> clazz = null;
                String rc = elm.getAttribute("rc");
                if (!rc.trim().equals("")) {
                    int repCode = Integer.valueOf(rc);
                    if (repCode == 1 || repCode == 2) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.relational.Table");
                    } else if (repCode == 3 || repCode == 4) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.logical.Entity");
                    } else if (repCode == 5) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.Domain");
                    } else if (repCode == 7 || repCode == 8) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.StructuredType");
                    } else if (repCode == 9 || repCode == 10) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.CollectionType");
                    } else if (repCode == 11 || repCode == 12) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.DistinctType");
                    } else if (repCode == 13) {
                        clazz = Class.forName("oracle.dbtools.crest.model.ChangeRequest");
                    } else if (repCode == 14) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.Measurement");
                    }
                } else {
                    String className = elm.getAttribute("class");
                    className = className.replaceAll("oracle.dbtools.crest.model", "oracle.dbtools.crest.jsmodel");
                    clazz = Class.forName(className);
                }
                if (clazz == null) continue;
                ArrayList<String> subviews = new ArrayList<String>();
                NodeList subviewsNode = elm.getElementsByTagName("subviews");
                int nodesLength = subviewsNode.getLength();
                for (int j = 0; j < nodesLength; ++j) {
                    Element e = (Element)subviewsNode.item(j);
                    NodeList elements = e.getElementsByTagName("subview");
                    int elementsLength = elements.getLength();
                    for (int k = 0; k < elementsLength; ++k) {
                        Element e1 = (Element)elements.item(k);
                        subviews.add(e1.getAttribute("id"));
                    }
                }
                ArrayList<String> objects = new ArrayList<String>();
                NodeList objectsNode = elm.getElementsByTagName("objects");
                int objectsLength = objectsNode.getLength();
                for (int j = 0; j < objectsLength; ++j) {
                    Element e = (Element)objectsNode.item(j);
                    NodeList elements = e.getElementsByTagName("object");
                    int elementsLength = elements.getLength();
                    for (int k = 0; k < elementsLength; ++k) {
                        Element e1 = (Element)elements.item(k);
                        objects.add(e1.getAttribute("id"));
                    }
                }
                StandardReportConfiguration src = new StandardReportConfiguration(clazz, StringUtilities.decodeAttributeValue(elm.getAttribute("name")), StringUtilities.decodeAttributeValue(elm.getAttribute("description")), elm.getAttribute("design"), elm.getAttribute("model"), Boolean.valueOf(elm.getAttribute("inc_dp")), subviews, objects, elm.getAttribute("id"));
                loadedReportConfigurations.add(src);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load standard report configurations: ", e);
        }
    }
}

