/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.dimensionList;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindEditor;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindEvent;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindEventListener;
import oracle.adfdtinternal.model.dvt.util.dimensionList.DimFindHistory;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.share.nls.StringUtils;

public class DimFindTool
extends JPanel
implements ActionListener,
HelpContext,
Serializable {
    private JLabel m_findLabelMembersThat = null;
    private JLabel m_findLabel = null;
    private JLabel m_statusText = null;
    private JComboBox m_findCombo = null;
    private JComboBox m_findCombo1 = null;
    private DimFindEditor m_findEditor = null;
    private DimFindEditor m_findEditor1 = null;
    private JCheckBox m_caseCheck = null;
    private String m_closeText = null;
    private String m_findNextText = null;
    private String m_findHelpText = null;
    private JButton m_findNextButton = null;
    private JButton m_closeButton = null;
    private JButton m_findHelpButton = null;
    private boolean m_isListDisplayed = false;
    private Vector m_listeners = null;
    private Vector m_history = new Vector();
    private int m_position = 0;
    private static String[] m_strLabelTypes;
    private static ResourceBundle m_localStrings;

    public DimFindTool() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel pnlTop = new JPanel();
        JPanel pnlCen = new JPanel();
        JPanel pnlBot = new JPanel();
        GridBagLayout gblTop = new GridBagLayout();
        GridBagLayout gblCen = new GridBagLayout();
        GridBagLayout gblBot = new GridBagLayout();
        pnlTop.setLayout(gblTop);
        pnlCen.setLayout(gblCen);
        pnlBot.setLayout(gblBot);
        GridBagConstraints gbcLeft = new GridBagConstraints();
        GridBagConstraints gbcRight = new GridBagConstraints();
        gbcLeft.insets = new Insets(3, 5, 3, 3);
        gbcLeft.gridwidth = 1;
        gbcLeft.fill = 0;
        gbcLeft.anchor = 18;
        gbcLeft.weightx = 0.0;
        gbcLeft.weighty = 1.0;
        gbcRight.insets = new Insets(1, 3, 1, 3);
        gbcRight.gridwidth = 0;
        gbcRight.fill = 2;
        gbcRight.anchor = 18;
        gbcRight.weightx = 1.0;
        gbcRight.weighty = 1.0;
        this.m_findLabelMembersThat = new JLabel();
        this.m_findCombo = new JComboBox();
        this.m_findLabelMembersThat.setLabelFor(this.m_findCombo);
        this.m_findEditor = new DimFindEditor();
        this.m_findEditor.addActionListener(this);
        pnlTop.add(this.m_findLabelMembersThat);
        pnlTop.add(this.m_findCombo);
        gblTop.setConstraints(this.m_findLabelMembersThat, gbcLeft);
        gblTop.setConstraints(this.m_findCombo, gbcRight);
        this.m_findLabel = new JLabel();
        this.m_findCombo1 = new JComboBox();
        this.m_findCombo1.setMaximumRowCount(3);
        this.m_findEditor1 = new DimFindEditor();
        this.m_findEditor1.addActionListener(this);
        this.m_findCombo1.setEditor(this.m_findEditor1);
        this.m_findCombo1.setEditable(true);
        this.m_findLabel.setLabelFor(this.m_findEditor1.getEditorComponent());
        JLabel lblFill = new JLabel();
        this.m_caseCheck = new JCheckBox();
        pnlCen.add(this.m_findLabel);
        pnlCen.add(this.m_findCombo1);
        pnlCen.add(lblFill);
        pnlCen.add(this.m_caseCheck);
        gblCen.setConstraints(this.m_findLabel, gbcLeft);
        gblCen.setConstraints(this.m_findCombo1, gbcRight);
        gblCen.setConstraints(lblFill, gbcLeft);
        gblCen.setConstraints(this.m_caseCheck, gbcRight);
        this.m_statusText = new JLabel();
        this.m_statusText.setText("  ");
        JLabel lblFill2 = new JLabel();
        pnlBot.add(this.m_statusText);
        pnlBot.add(lblFill2);
        gblBot.setConstraints(this.m_statusText, gbcLeft);
        gblBot.setConstraints(lblFill2, gbcRight);
        this.add(pnlTop);
        this.add(Box.createVerticalStrut(15));
        this.add(pnlCen);
        this.add(Box.createVerticalStrut(5));
        this.add(pnlBot);
    }

    public synchronized void setPosition(int position) {
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public synchronized void setStatusText(String text) {
        this.m_statusText.setText(text != null ? text : "");
    }

    public String getStatusText() {
        return this.m_statusText.getText();
    }

    public synchronized void setHistory(DimFindHistory fh) {
        this.m_history.removeAllElements();
        if (fh != null) {
            for (int i = 0; i < fh.size(); ++i) {
                this.m_history.addElement(fh.elementAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimFindHistory getHistory() {
        DimFindHistory fh = new DimFindHistory();
        if (fh != null) {
            Vector v;
            DimFindTool dimFindTool = this;
            synchronized (dimFindTool) {
                v = (Vector)this.m_history.clone();
            }
            int count = v.size();
            for (int i = 0; i < count; ++i) {
                fh.addElement(v.elementAt(i));
            }
        }
        return fh;
    }

    public synchronized void addDimFindEventListener(Object l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
        }
    }

    public synchronized void removeDimFindEventListener(Object l) {
        if (this.m_listeners != null && !this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    public void processFindNextButton() {
        String value = null;
        boolean bdecendChecked = false;
        JTextField editorComp = (JTextField)this.m_findEditor1.getEditorComponent();
        value = editorComp.getText();
        boolean bcaseChecked = this.m_caseCheck.isSelected();
        int iIndex = this.m_findCombo.getSelectedIndex();
        if (value.length() > 0) {
            this.updateHistory(value);
            DimFindEvent fe = new DimFindEvent(this, 2, value, this.m_position, bcaseChecked, bdecendChecked, iIndex);
            this.notifyFindListeners(fe);
        }
    }

    public void processCloseButton() {
        String value = null;
        boolean bdecendChecked = false;
        JTextField editorComp = (JTextField)this.m_findEditor1.getEditorComponent();
        value = editorComp.getText();
        boolean bcaseChecked = this.m_caseCheck.isSelected();
        int iIndex = this.m_findCombo.getSelectedIndex();
        DimFindEvent fe = new DimFindEvent(this, 1, "", this.m_position, bcaseChecked, bdecendChecked, iIndex);
        this.notifyFindListeners(fe);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String value = null;
        JTextField editorComp = (JTextField)this.m_findEditor1.getEditorComponent();
        value = editorComp.getText();
        boolean bcaseChecked = this.m_caseCheck.isSelected();
        int iIndex = this.m_findCombo.getSelectedIndex();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
    }

    @Override
    public void setLocale(Locale locale) {
        m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle", locale == null ? Locale.getDefault() : locale);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateResources();
    }

    private void updateResources() {
        if (this.m_findLabelMembersThat != null) {
            String strFindMembersThat = DimFindTool.getIntlString("lblFindMembersThat");
            this.m_findLabelMembersThat.setText(StringUtils.stripMnemonic((String)strFindMembersThat));
            this.m_findLabelMembersThat.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)strFindMembersThat));
        }
        if (this.m_findLabel != null) {
            String strFind = DimFindTool.getIntlString("lblFind");
            this.m_findLabel.setText(StringUtils.stripMnemonic((String)strFind));
            this.m_findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)strFind));
        }
        if (this.m_caseCheck != null) {
            String strMatchCase = DimFindTool.getIntlString("txtMatchCase");
            this.m_caseCheck.setText(StringUtils.stripMnemonic((String)strMatchCase));
            this.m_caseCheck.setMnemonic(StringUtils.getMnemonicKeyCode((String)strMatchCase));
        }
        if (this.m_findCombo != null) {
            String txt1 = new String(DimFindTool.getIntlString("findmemContain"));
            String txt2 = new String(DimFindTool.getIntlString("findmemExactlyMatch"));
            String txt3 = new String(DimFindTool.getIntlString("findmemStartWith"));
            String txt4 = new String(DimFindTool.getIntlString("findmemEndWith"));
            m_strLabelTypes = new String[]{txt1, txt2, txt3, txt4};
            this.m_findCombo.setModel(new DefaultComboBoxModel<String>(m_strLabelTypes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFindListeners(DimFindEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v;
            DimFindTool dimFindTool = this;
            synchronized (dimFindTool) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            for (int i = 0; i < count; ++i) {
                DimFindEventListener client = (DimFindEventListener)v.elementAt(i);
                client.processDimFindEvent(e);
            }
        }
    }

    private synchronized void updateHistory(String str) {
        if (str != null && str.length() > 0) {
            boolean inList = this.m_history.contains(str);
            if (inList) {
                this.m_findCombo1.removeItem(str);
                this.m_history.removeElement(str);
            }
            this.m_findCombo1.insertItemAt(str, 0);
            this.m_findCombo1.setSelectedIndex(0);
            this.m_history.insertElementAt(str, 0);
        }
    }

    private static String getIntlString(String key) {
        String strTemp;
        if (m_localStrings == null) {
            return key;
        }
        try {
            strTemp = m_localStrings.getString(key);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource: " + key);
            e.printStackTrace();
            return key;
        }
        return strTemp;
    }

    static {
        m_localStrings = null;
    }
}

