/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.component.list;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import oracle.adfdtinternal.model.dvt.util.gui.component.list.DefaultMutableListModel;
import oracle.adfdtinternal.model.dvt.util.gui.component.list.ListCellEditor;
import oracle.adfdtinternal.model.dvt.util.gui.component.list.MutableListModel;

public class JListMutable
extends JList
implements CellEditorListener {
    protected Component m_componentEditor = null;
    protected int m_nIndexEditing = -1;
    protected ListCellEditor m_listCellEditor = null;
    private PropertyChangeListener m_propertyChangeListenerEditorRemover = null;
    protected EventObject m_eventObjectEditCellAt = null;

    public JListMutable(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public void setListCellEditor(ListCellEditor listCellEditor) {
        this.m_listCellEditor = listCellEditor;
    }

    public ListCellEditor getListCellEditor() {
        return this.m_listCellEditor;
    }

    public boolean isEditing() {
        return this.getEditorComponent() != null;
    }

    public Component getEditorComponent() {
        return this.m_componentEditor;
    }

    public int getEditingIndex() {
        return this.m_nIndexEditing;
    }

    public EventObject getEventObjectEditCellAt() {
        return this.m_eventObjectEditCellAt;
    }

    public void setEventObjectEditCellAt(EventObject eventObjectEditCellAt) {
        this.m_eventObjectEditCellAt = eventObjectEditCellAt;
    }

    public Component prepareEditor(int nIndex) {
        JComponent jComponent;
        Object objValue = this.getModel().getElementAt(nIndex);
        boolean bIsSelected = this.isSelectedIndex(nIndex);
        Component component = this.getListCellEditor().getListCellEditorComponent(this, objValue, bIsSelected, nIndex);
        if (component instanceof JComponent && (jComponent = (JComponent)component).getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this);
        }
        return component;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.getPropertyChangeListenerEditorRemover());
        this.setPropertyChangeListenerEditorRemover(null);
        if (this.getListCellEditor() != null) {
            this.getListCellEditor().removeCellEditorListener(this);
            if (this.getEditorComponent() != null) {
                this.remove(this.getEditorComponent());
            }
            Rectangle rectangleCell = this.getCellBounds(this.getIndexEditing(), this.getIndexEditing());
            this.setIndexEditing(-1);
            this.setEditorComponent(null);
            if (rectangleCell != null) {
                this.repaint(rectangleCell);
            }
        }
    }

    public boolean editCellAt(int nIndex, EventObject eventObject) {
        this.setEventObjectEditCellAt(eventObject);
        if (this.getListCellEditor() != null && !this.getListCellEditor().stopCellEditing()) {
            return false;
        }
        if (nIndex < 0 || nIndex >= this.getModel().getSize()) {
            return false;
        }
        if (!this.isCellEditable(nIndex)) {
            return false;
        }
        if (this.getPropertyChangeListenerEditorRemover() == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.setPropertyChangeListenerEditorRemover(new CellEditorRemover(keyboardFocusManager));
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.getPropertyChangeListenerEditorRemover());
        }
        if (this.getListCellEditor() != null && this.getListCellEditor().isCellEditable(eventObject)) {
            this.setEditorComponent(this.prepareEditor(nIndex));
            if (this.getEditorComponent() == null) {
                this.removeEditor();
                return false;
            }
            Rectangle rectangle = this.getCellBounds(nIndex, nIndex);
            if (this.getEditorComponent() instanceof JTextField) {
                Dimension dimension = this.getEditorComponent().getPreferredSize();
                rectangle.height = Math.max(rectangle.height, dimension.height);
            }
            this.getEditorComponent().setBounds(rectangle);
            this.add(this.getEditorComponent());
            this.getEditorComponent().validate();
            this.setIndexEditing(nIndex);
            this.getListCellEditor().addCellEditorListener(this);
            this.getEditorComponent().requestFocus();
            return true;
        }
        return false;
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.getPropertyChangeListenerEditorRemover());
        super.removeNotify();
    }

    public boolean isCellEditable(int nIndex) {
        if (this.getModel() instanceof MutableListModel) {
            return ((MutableListModel)this.getModel()).isCellEditable(nIndex);
        }
        return false;
    }

    public void setValueAt(Object objValue, int nIndex) {
        ((MutableListModel)this.getModel()).setValueAt(objValue, nIndex);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        if (this.getListCellEditor() != null) {
            Object objValue = this.getListCellEditor().getCellEditorValue();
            this.setValueAt(objValue, this.getIndexEditing());
            if ((objValue == null || objValue.equals("")) && this.getModel() instanceof DefaultMutableListModel) {
                ((DefaultMutableListModel)this.getModel()).removeElementAt(this.getIndexEditing());
            }
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.editingStopped(changeEvent);
    }

    protected void setEditorComponent(Component componentEditor) {
        this.m_componentEditor = componentEditor;
    }

    protected void setIndexEditing(int nIndexEditing) {
        this.m_nIndexEditing = nIndexEditing;
    }

    protected int getIndexEditing() {
        return this.m_nIndexEditing;
    }

    protected void setPropertyChangeListenerEditorRemover(PropertyChangeListener propertyChangeListenerEditorRemover) {
        this.m_propertyChangeListenerEditorRemover = propertyChangeListenerEditorRemover;
    }

    protected PropertyChangeListener getPropertyChangeListenerEditorRemover() {
        return this.m_propertyChangeListenerEditorRemover;
    }

    private void init() {
        this.getActionMap().put("startEditing", new StartEditingAction());
        this.getActionMap().put("cancel", new CancelEditingAction());
        this.addMouseListener(new MouseListener());
        this.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private class MouseListener
    extends MouseAdapter {
        private Component componentDispatch;

        private MouseListener() {
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component editorComponent = JListMutable.this.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(JListMutable.this, point, editorComponent);
            this.componentDispatch = SwingUtilities.getDeepestComponentAt(editorComponent, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.componentDispatch == null || !JListMutable.this.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(JListMutable.this, mouseEvent, this.componentDispatch);
            this.componentDispatch.dispatchEvent(mouseEvent2);
            return true;
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !JListMutable.this.isEnabled();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int nIndex = JListMutable.this.locationToIndex(point);
            if (nIndex == -1) {
                return;
            }
            if (JListMutable.this.editCellAt(nIndex, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else if (JListMutable.this.isRequestFocusEnabled()) {
                JListMutable.this.requestFocus();
            }
        }
    }

    private class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JListMutable jListMutable = (JListMutable)actionEvent.getSource();
            jListMutable.editingStopped(null);
        }

        @Override
        public boolean isEnabled() {
            return JListMutable.this.isEditing();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JListMutable jListMutable = (JListMutable)actionEvent.getSource();
            if (!jListMutable.hasFocus()) {
                ListCellEditor cellEditor = jListMutable.getListCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                jListMutable.requestFocus();
                return;
            }
            ListSelectionModel listSelectionModel = jListMutable.getSelectionModel();
            int nAnchorRow = listSelectionModel.getAnchorSelectionIndex();
            jListMutable.editCellAt(nAnchorRow, null);
            Component componentEditor = jListMutable.getEditorComponent();
            if (componentEditor != null) {
                componentEditor.requestFocus();
            }
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!JListMutable.this.isEditing() || JListMutable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == JListMutable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(JListMutable.this) || JListMutable.this.getListCellEditor().stopCellEditing()) break;
                JListMutable.this.getListCellEditor().cancelCellEditing();
                break;
            }
        }
    }
}

