/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.dbcart.DBCartReorderableTableModel;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartController;
import oracle.dbtools.dbcart.DbCartDropListener;
import oracle.dbtools.dbcart.DbCartListReorderableTableWithTitleBar;
import oracle.dbtools.dbcart.DbCartTabPanel;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public class DbCartPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PRE_SCRIPT_FILE_PATH = "PRE_DBCART_FILE_PATH";
    public static final String POST_SCRIPT_FILE_PATH = "POST_DBCART_FILE_PATH";
    private static final String TAB_NAME = DbCartAddinArb.getString("CART_TAB");
    private Toolbar _toolbar;
    private boolean _init = false;
    private CustomTabbedPane _tabbedPane = new CustomTabbedPane();
    private ArrayList<DbCartListReorderableTableWithTitleBar<?>> _reorderableTables = new ArrayList();
    private ArrayList<ITabCloseListner> closeListeners = new ArrayList();
    private Integer _nameSuffix = 1;
    final ITabCloseListner closeListener = new ITabCloseListner(){

        public void tabClosed() {
            DefaultListModel defaultListModel = DbCartPanel.this._tabbedPane.getTabModel();
            ArrayList<DbCartListReorderableTableWithTitleBar> arrayList = new ArrayList<DbCartListReorderableTableWithTitleBar>();
            for (DbCartListReorderableTableWithTitleBar dbCartListReorderableTableWithTitleBar : DbCartPanel.this._reorderableTables) {
                boolean bl = false;
                for (int i = defaultListModel.size() - 1; i >= 0; --i) {
                    Object e = defaultListModel.getElementAt(i);
                    if (!(e instanceof DefaultCustomTabPage) || ((DefaultCustomTabPage)e).getUserObject() != dbCartListReorderableTableWithTitleBar.getTabPanel()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(dbCartListReorderableTableWithTitleBar);
            }
            for (DbCartListReorderableTableWithTitleBar dbCartListReorderableTableWithTitleBar : arrayList) {
                DbCartPanel.this._reorderableTables.remove((Object)dbCartListReorderableTableWithTitleBar);
            }
            if (DbCartPanel.this._reorderableTables.isEmpty()) {
                DbCartController.getInstance().toggleToolbar();
            }
        }
    };

    public DbCartPanel() {
        super(new GridBagLayout());
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            this._toolbar = new Toolbar();
            DbCartController.getInstance().installToolbar(this.getToolbar());
            this.closeListeners.add(this.closeListener);
            this.addTab();
            UIUtils.addIdeKeyBindings((JComponent)this, (int)1, (String)"oracle/dbtools/dbcart/accelerators2.xml");
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._tabbedPane, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_dbcartpanel_html");
        }
    }

    public void addTab() {
        String string = TAB_NAME;
        string = string + "_" + this._nameSuffix.toString();
        this._nameSuffix = this._nameSuffix + 1;
        DBCartReorderableTableModel dBCartReorderableTableModel = new DBCartReorderableTableModel(new ExtractListModel());
        DbCartListReorderableTableWithTitleBar<ExtractObject> dbCartListReorderableTableWithTitleBar = new DbCartListReorderableTableWithTitleBar<ExtractObject>(dBCartReorderableTableModel, string);
        this._reorderableTables.add(dbCartListReorderableTableWithTitleBar);
        new DropTarget((Component)dbCartListReorderableTableWithTitleBar.getReorderableTableWithTitleBar(), new DbCartDropListener());
        new DropTarget(dbCartListReorderableTableWithTitleBar.getTable(), new DbCartDropListener());
        this._tabbedPane.addTab(null, string, (Component)dbCartListReorderableTableWithTitleBar.getTabPanel(), this.closeListeners);
        this._tabbedPane.setSelectedIndex(this._tabbedPane.getTabModel().getSize() - 1);
        this._tabbedPane.addChangeListener((ChangeListener)new tabChangeListener());
    }

    public DBCartReorderableTableModel getSelectedModel() {
        return this.getModel(this._tabbedPane.getSelectedIndex());
    }

    public DBCartReorderableTableModel getModel(int n) {
        DefaultListModel defaultListModel = this._tabbedPane.getTabModel();
        if (n >= 0 && defaultListModel != null) {
            DbCartTabPanel dbCartTabPanel;
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)defaultListModel.get(n);
            DbCartTabPanel dbCartTabPanel2 = dbCartTabPanel = defaultCustomTabPage != null ? (DbCartTabPanel)defaultCustomTabPage.getUserObject() : null;
            if (dbCartTabPanel != null) {
                ReorderableTableWithTitleBar reorderableTableWithTitleBar = dbCartTabPanel.getReorderableTableWithTitleBar();
                DbCartListReorderableTableWithTitleBar<?> dbCartListReorderableTableWithTitleBar = this.getTabPage(reorderableTableWithTitleBar);
                return dbCartListReorderableTableWithTitleBar.getModel();
            }
        }
        return null;
    }

    public DbCartListReorderableTableWithTitleBar<?> getSelectedTabPage() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n >= 0) {
            return this.getTabPage(n);
        }
        return null;
    }

    public DbCartListReorderableTableWithTitleBar<?> getTabPage(int n) {
        DefaultCustomTabPage defaultCustomTabPage;
        DbCartTabPanel dbCartTabPanel;
        ReorderableTableWithTitleBar reorderableTableWithTitleBar;
        if (n >= 0 && (reorderableTableWithTitleBar = (dbCartTabPanel = (DbCartTabPanel)(defaultCustomTabPage = (DefaultCustomTabPage)this._tabbedPane.getTabModel().get(n)).getUserObject()).getReorderableTableWithTitleBar()) != null) {
            return this.getTabPage(reorderableTableWithTitleBar);
        }
        return null;
    }

    public String getSelectedTabPageName() {
        return this._tabbedPane.getSelectedPageLabel();
    }

    public void setSelectedTabPageName(String string) {
        String string2 = string;
        Integer n = 0;
        boolean bl = false;
        while (!bl) {
            for (int i = 0; i < this._tabbedPane.getTabModel().getSize(); ++i) {
                if (!((DefaultCustomTabPage)this._tabbedPane.getTabModel().get(i)).getLabel().equals(string2)) continue;
                n = n + 1;
                string2 = string + "_" + n.toString();
            }
            bl = true;
        }
        DbCartListReorderableTableWithTitleBar<?> dbCartListReorderableTableWithTitleBar = this.getSelectedTabPage();
        if (dbCartListReorderableTableWithTitleBar != null) {
            this._tabbedPane.renameSelectedPage(string2);
        }
    }

    public void setLeftTab() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n == 0) {
            this._tabbedPane.setSelectedIndex(0);
        } else {
            this._tabbedPane.setSelectedIndex(n - 1);
        }
    }

    public void setRightTab() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n == this._tabbedPane.getNumberOfTabs() - 1) {
            this._tabbedPane.setSelectedIndex(this._tabbedPane.getNumberOfTabs() - 1);
        } else {
            this._tabbedPane.setSelectedIndex(n + 1);
        }
    }

    public ArrayList<DbCartListReorderableTableWithTitleBar<?>> getTabPages() {
        return this._reorderableTables;
    }

    public ArrayList<String> getTabPageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DbCartListReorderableTableWithTitleBar<?> dbCartListReorderableTableWithTitleBar : this._reorderableTables) {
            arrayList.add(dbCartListReorderableTableWithTitleBar.getTabLabel());
        }
        return arrayList;
    }

    public DBCartReorderableTableModel getTableModel(String string) {
        for (DbCartListReorderableTableWithTitleBar<?> dbCartListReorderableTableWithTitleBar : this._reorderableTables) {
            if (!string.equals(dbCartListReorderableTableWithTitleBar.getTabLabel())) continue;
            return dbCartListReorderableTableWithTitleBar.getModel();
        }
        return null;
    }

    public ArrayList<DBCartReorderableTableModel> getTableModels() {
        ArrayList<DBCartReorderableTableModel> arrayList = new ArrayList<DBCartReorderableTableModel>();
        for (DbCartListReorderableTableWithTitleBar<?> dbCartListReorderableTableWithTitleBar : this._reorderableTables) {
            arrayList.add(dbCartListReorderableTableWithTitleBar.getModel());
        }
        return arrayList;
    }

    public DbCartListReorderableTableWithTitleBar<?> getTabPage(ReorderableTableWithTitleBar reorderableTableWithTitleBar) {
        for (DbCartListReorderableTableWithTitleBar<?> dbCartListReorderableTableWithTitleBar : this._reorderableTables) {
            ReorderableTableWithTitleBar reorderableTableWithTitleBar2 = dbCartListReorderableTableWithTitleBar.getReorderableTableWithTitleBar();
            if (reorderableTableWithTitleBar2 != reorderableTableWithTitleBar) continue;
            return dbCartListReorderableTableWithTitleBar;
        }
        return null;
    }

    public DBCartReorderableTableModel getTableModel() {
        return this.getSelectedModel();
    }

    public JTable getTable() {
        return this.getSelectedModel().getTable();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public int getTabCount() {
        return this._tabbedPane.getNumberOfTabs();
    }

    public int getSelectedTab() {
        return this._tabbedPane.getSelectedIndex();
    }

    public void setSelectedTab(int n) {
        this._tabbedPane.setSelectedIndex(n);
    }

    class tabChangeListener
    implements ChangeListener {
        tabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DbCartController.getInstance().toggleToolbar();
        }
    }
}

