/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.headless;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.datatools.DataToolsResources;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployCloudLauncher;
import oracle.dbtools.dbcart.DbCartDeployCloudUtil;
import oracle.dbtools.dbcart.config.DbCartUserCloudConfig;
import oracle.dbtools.dbcart.headless.DbCartCommand;
import oracle.dbtools.dbcart.headless.DbCartHeadlessResources;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.importer.readers.DataReaderUtils;
import oracle.dbtools.raptor.deployment.DbmsCloudAPI;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.sftp.SftpUtil;

public class DbCartDeployCloudCommand
extends DbCartCommand {
    private DDLFormat _ddlFormat = new DDLFormat();
    private ExtractDataFormat _dataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD);
    private TargetFormat _targetFormat = new TargetFormat(2, 1, false);
    private String _connName;
    private String _title;
    private String _cloudLocation;
    private String _credential;
    private String _schema;
    private String _cartName;
    private boolean _isPdbCloud;
    private ExportAPI _expApi;
    private static String temp = "sqldev_temp";

    public DbCartDeployCloudCommand(HeadlessCore headlessCore) {
        super(DbCartCommand.Type.CLOUD, headlessCore);
    }

    @Override
    public String getHelpKey() {
        return "HELP_STRING_CART_CLOUD";
    }

    @Override
    public boolean processToolItem(String string, List<String> list) throws InvalidCommandArgumentException {
        if ("TARGET".equalsIgnoreCase(string) || "TGT".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this.setTgtFile(list.get(0));
            return true;
        }
        return false;
    }

    @Override
    public void getConfig() throws InvalidCommandArgumentException {
        try {
            URL uRL = new File(this.getConfigXML()).toURI().toURL();
            this._config = new DbCartUserCloudConfig(DbCartUserCloudConfig.importFrom(uRL));
            this.validateConfig(uRL, "deploy_cloud_tool");
            DbCartUserCloudConfig dbCartUserCloudConfig = (DbCartUserCloudConfig)this._config;
            this._connName = dbCartUserCloudConfig.getString("CLOUD_CONN");
            String string = DbCartDeployCloudUtil.validateCloudConn(this._connName);
            if (string != null) {
                throw new InvalidCommandArgumentException(string);
            }
            this._isPdbCloud = DbCartDeployCloudUtil.isPdbCloud(this._connName);
            this._schema = this._config.getString("CLOUD_SCHEMA");
            this._title = this._config.getString("CLOUD_TITLE");
            string = DbCartDeployCloudUtil.validateTitle(this._title);
            if (string != null) {
                throw new InvalidCommandArgumentException(string);
            }
            this._ddlFormat = DbCartDeployCloudUtil.getDDLFormat();
            Boolean bl = dbCartUserCloudConfig.getBoolean("DEPLOY_EXPORT_DROP");
            if (bl != null) {
                this._ddlFormat.setDrop(bl.booleanValue());
            }
            if ((bl = dbCartUserCloudConfig.getBoolean("DEPLOY_EXPORT_CASCADE")) != null) {
                this._ddlFormat.setCascade(bl.booleanValue());
            }
            FormatRegistry.setLineTerminator((String)System.getProperty("line.separator"));
            FormatRegistry.registerFormater((IResultFormatter)new LoaderFormatter());
            this._dataFormat = DbCartDeployCloudUtil.getDataFormat();
            IFormatOptions iFormatOptions = this._dataFormat.getOptions();
            String string2 = BaseDataFormat.getDelimiterFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getDelimiterConfigKey()));
            if (string2 == null || string2.length() == 0) {
                string2 = iFormatOptions.getDefaultDelimiter();
            }
            boolean bl2 = (bl = dbCartUserCloudConfig.getBoolean(iFormatOptions.getEnclosuresConfigKey())) != null ? bl : false;
            this._dataFormat.setEnclosureLeft(BaseDataFormat.getEnclosureFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getEnclosureLeftConfigKey())));
            this._dataFormat.setEnclosureRight(BaseDataFormat.getEnclosureFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getEnclosureRightConfigKey())));
            this._dataFormat.isEnclosureRightDouble(true);
            String string3 = BaseDataFormat.getRecordTerminatorFromConfigValue((String)dbCartUserCloudConfig.getString(iFormatOptions.getLineTerminatorConfigKey()));
            if (string3 == null || string3.length() == 0) {
                string3 = DataToolsResources.getString((String)"TERM_OTHER");
            }
            this._targetFormat = DbCartDeployCloudUtil.getTargetFormat(DbCartDeployCloudUtil.isPdbCloud(this._connName));
            this._targetFormat.setSaveAs(this.getTgtFile() != null && this.getTgtFile().length() > 0 ? this.getTgtFile() : this._config.getString("CLOUD_TRANSFER_FILE"));
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            throw new InvalidCommandArgumentException(DbCartAddinArb.format("UNABLE_TO_OPEN_FILE", this.getConfigXML()));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate() throws InvalidCommandArgumentException {
        ResultsFormatter resultsFormatter;
        int n;
        this.validateCart();
        this._ddlFormat.isExtractEnabled(this.isAnyDDLRows());
        this._dataFormat.isExportEnabled(this.isAnyDataRows());
        String string = DbCartDeployCloudUtil.validateForDeploy(this._extractObjects);
        if (string != null) {
            throw new InvalidCommandArgumentException(string);
        }
        if (this._dataFormat.isExportEnabled() && (n = (resultsFormatter = (ResultsFormatter)FormatRegistry.getFormatter((String)this._dataFormat.getFormat())).validateOptions()) != 0) {
            throw new InvalidCommandArgumentException(resultsFormatter.getValidationMessage());
        }
        int n2 = this._targetFormat.validateSaveAs();
        if (n2 != 0) {
            throw new InvalidCommandArgumentException(this._targetFormat.getValidationMessage());
        }
        ExportParms exportParms = new ExportParms();
        if (this._isPdbCloud) {
            void var4_8;
            exportParms.setServiceType(ExportServiceType.DEPLOY_CLOUD_WALLET);
            this._cloudLocation = this._config.getString("CLOUD_LOCATION");
            this._credential = this._config.getString("CLOUD_CREDENTIAL");
            exportParms.setCloudStgLocation(this._cloudLocation);
            exportParms.setCredential(this._credential);
            Object var4_6 = null;
            if (this._cloudLocation != null && this._credential != null) {
                String string2 = this.checkCloudStorageLocation();
            }
            if (var4_8 != null) throw new InvalidCommandArgumentException((String)var4_8);
            exportParms.setDestConnName(this._connName);
            exportParms.setDestSchema(this._schema);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy_MM_dd-HH_mm_ss");
            StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
            this._cartName = this._title + DbCartAddinArb.getString("DEPLOY_NAME_SEPARATOR") + stringBuilder;
            this.getHeadless().printMessage(new String[]{DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOYMENT", (Object[])new Object[]{this._cartName})});
            exportParms.setName(this._cartName);
            this._targetFormat.isSftp(false);
            this._targetFormat.isGenScript(true);
        } else {
            SftpParms sftpParms = new SftpParms();
            sftpParms.setCloudConnection(this._connName);
            sftpParms.setImportName(this._title);
            sftpParms.setKeyFile(null);
            sftpParms.setLocalFile(this._targetFormat.getSaveAs());
            SessionInfo.SftpInfo sftpInfo = DbCartDeployCloudUtil.getSftpInfo(this._connName);
            if (sftpInfo != null) {
                sftpParms.setUser(sftpInfo.getSftpUser());
                sftpParms.setPass(sftpInfo.getSftpPass());
                sftpParms.setHost(sftpInfo.getSftpHost());
                String string3 = sftpInfo.getSftpHost();
                sftpParms.setPort(sftpInfo.getSftpPort());
            }
            this._targetFormat.setSftpParms((Object)sftpParms);
            SftpUtil sftpUtil = new SftpUtil();
            boolean bl = sftpUtil.SftpTestConnection(sftpParms);
            if (!bl) {
                throw new InvalidCommandArgumentException(DbCartAddinArb.format(DbCartAddinArb.getString("BAD_CONN_MESSAGE"), new Object[0]));
            }
        }
        DbCartDeployCloudLauncher dbCartDeployCloudLauncher = new DbCartDeployCloudLauncher();
        dbCartDeployCloudLauncher.run(exportParms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkCloudStorageLocation() {
        if (this._isPdbCloud) {
            String string = "";
            URL uRL = null;
            if (this._cloudLocation != null) {
                try {
                    uRL = new URL(this._cloudLocation);
                }
                catch (Exception exception) {
                    return exception.getMessage();
                }
                String string2 = string = uRL != null ? uRL.toString() : "";
                if (string.trim().isEmpty()) {
                    return DbCartAddinArb.getString("NO_CLOUD_STORAGE");
                }
            } else {
                return DbCartAddinArb.getString("NO_CLOUD_STORAGE");
            }
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            DbmsCloudAPI dbmsCloudAPI = new DbmsCloudAPI(null);
            try {
                Object object;
                String string3 = (string.endsWith("/") ? string : string + "/") + DataReaderUtils.getTempName((String)temp);
                try {
                    exitCode = dbmsCloudAPI.startService(this._connName, false);
                }
                catch (Exception exception) {
                    exitCode = ExitCode.EXIT_SEVERE;
                    exitCode.setShortMessage(exception.getMessage());
                    String string4 = DbCartAddinArb.format("BAD_CLOUD_STORAGE1", this._connName);
                    dbmsCloudAPI.finishService();
                    return string4;
                }
                if (exitCode != ExitCode.EXIT_SUCCESS) {
                    String string5 = DbCartAddinArb.format("BAD_CLOUD_STORAGE1", this._connName);
                    return string5;
                }
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(temp.getBytes());
                    object = null;
                    try {
                        dbmsCloudAPI.putObject(this._credential, string3, (InputStream)byteArrayInputStream);
                        byteArrayInputStream.close();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (byteArrayInputStream != null) {
                            if (object != null) {
                                try {
                                    byteArrayInputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                byteArrayInputStream.close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exitCode = ExitCode.EXIT_SEVERE;
                    exitCode.setShortMessage(exception.getMessage());
                    String string6 = DbCartAddinArb.format("BAD_CLOUD_STORAGE2", string, this._credential);
                    dbmsCloudAPI.finishService();
                    return string6;
                }
                try {
                    dbmsCloudAPI.deleteObject(this._credential, string3);
                }
                catch (Exception exception) {
                    exitCode = ExitCode.EXIT_SEVERE;
                    exitCode.setShortMessage(exception.getMessage());
                    object = exception.getMessage();
                    dbmsCloudAPI.finishService();
                    return object;
                }
            }
            finally {
                dbmsCloudAPI.finishService();
            }
        }
        return null;
    }

    @Override
    public Object doCommand() {
        DbCartDeployOptions dbCartDeployOptions = new DbCartDeployOptions();
        dbCartDeployOptions.setSourceExtractObjectList(this._extractObjects);
        dbCartDeployOptions.setTargetFormat(this._targetFormat);
        dbCartDeployOptions.setDDLFormat(this._ddlFormat);
        dbCartDeployOptions.setDataFormat(this._dataFormat);
        this._expApi.setDeploy(dbCartDeployOptions);
        ExitCode exitCode = this._expApi.writeExportHeadless();
        if (exitCode != null) {
            return DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + exitCode));
        }
        return null;
    }
}

