/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.headless;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.config.DbCartUserExportConfig;
import oracle.dbtools.dbcart.headless.DbCartCommand;
import oracle.dbtools.dbcart.headless.DbCartHeadlessResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.ExcelFormatter;
import oracle.dbtools.raptor.format.ExcelXFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.PDFFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.format.XLSXFormatter;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;

public class DbCartExportCommand
extends DbCartCommand {
    private DDLFormat _ddlFormat = new DDLFormat();
    private ExtractDataFormat _dataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD);
    private TargetFormat _targetFormat = new TargetFormat(2, 1, false);
    private int _formatterAction;
    private ResultsFormatter _formatter;

    public DbCartExportCommand(HeadlessCore headlessCore) {
        super(DbCartCommand.Type.EXPORT, headlessCore);
    }

    @Override
    public String getHelpKey() {
        return "HELP_STRING_CART_EXPORT";
    }

    @Override
    public boolean processToolItem(String string, List<String> list) throws InvalidCommandArgumentException {
        if ("TARGET".equalsIgnoreCase(string) || "TGT".equalsIgnoreCase(string)) {
            if (list.size() != 1) {
                throw new InvalidCommandArgumentException(DbCartHeadlessResources.format("INVALID_OPTION_VALUE", string));
            }
            this.setTgtFile(list.get(0));
            return true;
        }
        return false;
    }

    @Override
    public void getConfig() throws InvalidCommandArgumentException {
        try {
            int n;
            URL uRL = new File(this.getConfigXML()).toURI().toURL();
            this._config = new DbCartUserExportConfig(DbCartUserExportConfig.importFrom(uRL));
            this.validateConfig(uRL, "export_tool");
            DbCartUserExportConfig dbCartUserExportConfig = (DbCartUserExportConfig)this._config;
            dbCartUserExportConfig.copyToDDLFormat(this._ddlFormat);
            dbCartUserExportConfig.copyToTargetFormat(this._targetFormat);
            if (this.getTgtFile() != null && this.getTgtFile().length() > 0) {
                this._targetFormat.setSaveAs(this.getTgtFile());
            }
            if ((n = this._targetFormat.validateSaveAs()) != 0) {
                throw new InvalidCommandArgumentException(this._targetFormat.getValidationMessage());
            }
            this.initFormatRegistry();
            dbCartUserExportConfig.copyToDataFormat(this._dataFormat);
            this.validateFormatter();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            throw new InvalidCommandArgumentException(DbCartAddinArb.format("UNABLE_TO_OPEN_FILE", this.getConfigXML()));
        }
    }

    @Override
    public void validate() throws InvalidCommandArgumentException {
        int n;
        Version version;
        Version version2;
        this.validateCart();
        if (this.isAnyDataFileRows()) {
            throw new InvalidCommandArgumentException(DbCartHeadlessResources.getString("NO_DATA_FILES"));
        }
        this._ddlFormat.isExtractEnabled(this.isAnyDDLRows());
        this._dataFormat.isExportEnabled(this.isAnyDataRows());
        String string = this._ddlFormat.getVersion();
        if (!string.equals(DDLFormat.COMPATIBLE) && !string.equals(DDLFormat.LATEST) && (version2 = new Version(string)).compareTo(version = DbCartUtil.getHighestVersion(this._extractObjects)) > 0) {
            this._ddlFormat.setVersion(DDLFormat.COMPATIBLE);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, DbCartAddinArb.format("VERSION_WARNING", version2.toCanonicalString()));
        }
        this._dataFormat.setUseConfigOptions(true);
        if (this._formatterAction != 0) {
            throw new InvalidCommandArgumentException(this._formatter.getValidationMessage());
        }
        if (this.getTgtFile() != null && this.getTgtFile().length() > 0) {
            this._targetFormat.setSaveAs(this.getTgtFile());
        }
        if ((n = this._targetFormat.validateSaveAs()) != 0) {
            throw new InvalidCommandArgumentException(this._targetFormat.getValidationMessage());
        }
    }

    private void initFormatRegistry() {
        FormatRegistry.setLineTerminator((String)System.getProperty("line.separator"));
        FormatRegistry.registerBasics();
        FormatRegistry.registerFormater((IResultFormatter)new ExcelFormatter());
        FormatRegistry.registerFormater((IResultFormatter)new ExcelXFormatter());
        FormatRegistry.registerFormater((IResultFormatter)new PDFFormatter());
        FormatRegistry.registerFormater((IResultFormatter)new XLSXFormatter());
    }

    private void validateFormatter() {
        this._formatter = (ResultsFormatter)FormatRegistry.getFormatter((String)this._dataFormat.getFormat());
        if (this._formatter instanceof PDFFormatter) {
            PDFFormatOptions pDFFormatOptions = new PDFConfig().getPDFPreferences();
            ((PDFFormatter)this._formatter).setPDFFormatOptions(pDFFormatOptions);
        }
        this._formatterAction = this._formatter.validateOptions();
    }

    @Override
    public Object doCommand() {
        DbCartDeployOptions dbCartDeployOptions = new DbCartDeployOptions();
        dbCartDeployOptions.setSourceExtractObjectList(this._extractObjects);
        dbCartDeployOptions.setTargetFormat(this._targetFormat);
        dbCartDeployOptions.setDDLFormat(this._ddlFormat);
        dbCartDeployOptions.setDataFormat(this._dataFormat);
        ExportAPI exportAPI = new ExportAPI();
        exportAPI.setDeploy(dbCartDeployOptions);
        exportAPI.writeExportHeadless();
        return null;
    }
}

