/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployAuthPanel;
import oracle.dbtools.dbcart.DbCartDeployCloudDdlPanel;
import oracle.dbtools.dbcart.DbCartDeployCloudLauncher;
import oracle.dbtools.dbcart.DbCartDeployCloudUtil;
import oracle.dbtools.dbcart.DbCartDeployDataOptionPanel;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.config.DbCartUserCloudConfig;
import oracle.dbtools.dbcart.resources.DbCartResources;
import oracle.dbtools.dbcart.tools.DbCartUtilityTool;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.deployment.DbmsCloudAPI;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.transfer.location.LocationTestInfo;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorage;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingUtils;

public class DbCartDeployCloudTool
extends DbCartUtilityTool {
    public static final String TYPE = "DEPLOY_CLOUD";
    private static final String SPACE = " ";
    private static final String NL = "\n";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_deploy_cloud");
    public static final int CONTINUE = 0;
    public static final int CANCEL_WITH_MSG = 1;
    public static final int CANCEL = 2;
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTPS_PREFIX = "https://";
    private JEWTDialog _actionDialog;
    private JPanel _mainPanel = new JPanel();
    private JPanel _authPanel;
    private JPanel _ddlPanel;
    private JPanel _dataPanel;
    private JPanel _targetPanel;
    private JPanel _configPanel;
    private DbCartDeployCloudDdlPanel _deployCloudDDLPanel = new DbCartDeployCloudDdlPanel();
    private DbCartDeployAuthPanel _deployAuthPanel = new DbCartDeployAuthPanel();
    private DbCartDeployDataOptionPanel _deployDataOptionPanel = new DbCartDeployDataOptionPanel();
    private DbCartUserCloudConfig _config = new DbCartUserCloudConfig();
    private TargetFormat _targetFormat;
    private TargetOptionsPanel _targetOptions;
    private TitledPane _cloudStgPane;
    private JPanel _cloudStgPanel;
    private JPanel _cloudLocationPanel;
    private JPanel _credCloudStg;
    private JLabel _ossLabel = new JLabel(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("URL")));
    private URLFileChooser.URLFileChooserPanel _ossCmp;
    private JLabel _ossCredLabel = new JLabel(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("CREDENTIAL")));
    private JComboBox<String> _ossCredCmp;
    private JButton _okButton;
    private boolean _enableDDL;
    private boolean _enableData;
    private boolean _enableCloudStorage;
    private boolean _enableCloudStorageSave;
    private boolean _enableDataFormat;
    private String _connName;
    private Connection _conn;
    private ExportAPI _expApi;
    private boolean _isPdbCloud;
    private boolean _isOpenConfig = false;
    private LocationTestInfo _locationTestInfo;
    private static String temp = "sqldev_temp";
    private String defaultCredential = "                    ";

    public DbCartDeployCloudTool() {
        super(TYPE, 3);
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("DEPLOY_CLOUD_LABEL"), null, null, (Icon)RaptorImagesArb.getIcon((String)"CLOUD"), null, (boolean)true);
            this._action.addController((Controller)this);
        }
        return this._action;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    protected void enableIfCurrentCart(boolean bl) {
        if (!bl) {
            this.setEnabled(DbCartUtil.getTableModel() != null && !DbCartUtil.getTableModel().isEmpty());
        } else {
            this.setEnabled(DbCartUtil.getTableModel() != null && DbCartUtil.getTableModel().isAllFileRowsDeployable() && (DbCartUtil.getTableModel().isAnyDDLOrDataRows() || DbCartUtil.getTableModel().isAnyFileRows()));
        }
    }

    @Override
    public boolean validateObjects() {
        return this.validateObjects(true);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            if (this.validateObjects()) {
                this.showDialog();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void showDialog() {
        Object object;
        Object object2;
        ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getIncludedDBORows();
        List<ExtractObject> list = DbCartUtil.validateUniqueObjects(arrayList, false);
        List<ExtractObject> list2 = DbCartDeployCloudUtil.validateConns(arrayList);
        List<ExtractObject> list3 = DbCartDeployCloudUtil.validateTypes(arrayList);
        List<ExtractObject> list4 = DbCartDeployCloudUtil.validateObjects(arrayList);
        arrayList = DbCartUtil.getTableModel().getIncludedObjectRows();
        StringBuffer stringBuffer = new StringBuffer();
        for (ExtractObject object32 : arrayList) {
            object2 = DbCartDeployCloudUtil.validateFileObject(object32);
            if (object2 == null) continue;
            stringBuffer.append((String)object2);
            stringBuffer.append(NL);
        }
        if (!(list.isEmpty() && list2.isEmpty() && list3.isEmpty() && list4.isEmpty() && stringBuffer.length() <= 0)) {
            object = new StringBuilder();
            String string = "";
            if (!list.isEmpty()) {
                DbCartAddinArb.format("NOT_SUPPORTED", new Object[]{DbCartAddinArb.getString("EXPORT_LABEL")} + NL);
                ((StringBuilder)object).append(DbCartAddinArb.getString("NON_UNIQUE_CART") + "\n\n");
                for (ExtractObject extractObject : list) {
                    void var8_10;
                    ((StringBuilder)object).append((String)var8_10 + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + SPACE + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    String string2 = ", ";
                }
                ((StringBuilder)object).append(NL);
            }
            if (!(list2.isEmpty() && list3.isEmpty() && list4.isEmpty())) {
                ((StringBuilder)object).append(DbCartResources.getString("UNABLE_TO_DEPLOY_OBJECTS_TO_CLOUD") + NL);
                if (!list2.isEmpty()) {
                    ((StringBuilder)object).append(DbCartResources.getString("BAD_CONN_TEXT") + NL);
                    for (ExtractObject extractObject : list2) {
                        void var8_12;
                        ((StringBuilder)object).append((String)var8_12 + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                        String string3 = ", ";
                    }
                    ((StringBuilder)object).append(NL);
                }
                if (!list3.isEmpty()) {
                    String string4 = "";
                    ((StringBuilder)object).append(DbCartResources.getString("BAD_TYPE_TEXT") + NL);
                    for (ExtractObject extractObject : list3) {
                        void var8_15;
                        ((StringBuilder)object).append((String)var8_15 + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                        String string5 = ", ";
                    }
                    ((StringBuilder)object).append(NL);
                }
                if (!list4.isEmpty()) {
                    String string6 = "";
                    ((StringBuilder)object).append(DbCartResources.getString("BAD_COLUMN_TEXT") + NL);
                    for (ExtractObject extractObject : list4) {
                        void var8_19;
                        ((StringBuilder)object).append((String)var8_19 + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                        String string7 = ", ";
                    }
                    ((StringBuilder)object).append(NL);
                }
            }
            ((StringBuilder)object).append(stringBuffer.toString());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)((StringBuilder)object).toString(), (String)DbCartAddinArb.getString("BAD_COLUMN_TITLE"), (String)"DBCART_UNSUPPORTED_OBJECT_ERROR");
        } else {
            void var8_23;
            object = DbCartAddinArb.getString("DEPLOY_CLOUD_DIALOG_TITLE");
            this._mainPanel = new JPanel();
            this._mainPanel.setLayout(new GridBagLayout());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._mainPanel, "f1_deployobjectscloud_html");
            this._targetFormat = DbCartDeployCloudUtil.getTargetFormat(false);
            String string = this._targetFormat.getDefaultDirectory();
            if (!string.endsWith(File.separator)) {
                String string8 = string + File.separator;
            }
            this._targetFormat.setSaveAs((String)var8_23 + DbCartUtil.getTabPageName() + "." + "zip");
            this._targetOptions = new TargetOptionsPanel((Component)this._mainPanel, this._targetFormat);
            this._ossLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString((String)"SOURCE_TYPE")));
            this._ossLabel.setToolTipText(DbCartAddinArb.getString("URL_TIP"));
            this._ossLabel.setLabelFor((Component)this._ossCmp);
            this.initOssCmp(null);
            this._ossCmp.setToolTipText(DbCartAddinArb.getString("URL_TIP"));
            this._deployCloudDDLPanel.allowDisable(false);
            this._deployCloudDDLPanel.showDDLCheckBox(false);
            this._deployCloudDDLPanel.showIgnoreStorage(false);
            this._deployDataOptionPanel.showDisableConstraints(true);
            this._deployDataOptionPanel.showFormatOptions(true);
            this._configPanel = this.getConfigPanel();
            this._authPanel = this._deployAuthPanel.getPanel();
            this._deployAuthPanel.getConnJCombo().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        DbCartDeployCloudTool.this.connectionChanged(DbCartDeployCloudTool.this._deployAuthPanel.getConnName(), DbCartDeployCloudTool.this._deployAuthPanel.getConnection(), DbCartDeployCloudTool.this._deployAuthPanel.isPdbCloud());
                    }
                }
            });
            this._cloudStgPanel = new JPanel(new BorderLayout());
            this._cloudStgPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            object2 = new JLabel(DbCartAddinArb.getString("CLOUD_STORAGE"));
            this._cloudStgPane = new TitledPane((Component)object2, (Component)this._cloudStgPanel);
            this._cloudLocationPanel = new JPanel(new GridBagLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            jPanel.add((Component)this._targetOptions.getPanel(), "Center");
            JLabel jLabel = new JLabel(DbCartAddinArb.getString("WORK_FILE"));
            TitledPane titledPane = new TitledPane((Component)jLabel, (Component)jPanel);
            this._targetPanel = new JPanel(new BorderLayout(0, 8));
            this._targetPanel.add((Component)titledPane, "Center");
            this._ddlPanel = this._deployCloudDDLPanel.getPanel();
            this._dataPanel = this._deployDataOptionPanel.getPanel();
            boolean bl = false;
            for (ExtractObject extractObject : arrayList) {
                if (!extractObject.isExtractMetaData()) continue;
                bl = true;
                break;
            }
            this._enableDDL = bl;
            this._deployCloudDDLPanel.enableOptions(bl);
            this._enableData = false;
            this._enableCloudStorage = false;
            this._enableDataFormat = false;
            for (ExtractObject extractObject : arrayList) {
                if (!extractObject.isExtractData()) continue;
                this._enableData = true;
                if (extractObject.isTypeDBO()) {
                    this._enableDataFormat = true;
                }
                if (extractObject.isTypeDBO() || extractObject.isTypeDataFileLocal()) {
                    this._enableCloudStorage = true;
                }
                if (!this._enableData || !this._enableDataFormat || !this._enableCloudStorage) continue;
                break;
            }
            this._enableCloudStorageSave = this._enableCloudStorage;
            this._deployDataOptionPanel.enableOptions(this._enableData, this._enableCloudStorage, this._enableDataFormat);
            this.addPanels();
            this._mainPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._mainPanel, null, (String)object, (int)6);
            this._actionDialog.pack();
            this._okButton = new JButton("OK");
            this._okButton.setEnabled(false);
            this._actionDialog.addCustomButton((Component)this._okButton);
            this._actionDialog.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    DbCartDeployCloudTool.this._deployAuthPanel.closeConnectionClone();
                }
            });
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    ExtractObject extractObject2;
                    int n = 0;
                    if (DbCartDeployCloudTool.this._deployAuthPanel.getTitle() == null || DbCartDeployCloudTool.this._deployAuthPanel.getTitle().equals("")) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartResources.getString("NULL_TITLE_MESSAGE"), (String)DbCartAddinArb.getString("BAD_TITLE_TITLE"), (String)"DBCART_DEPLOY_BAD_TITLE");
                        return;
                    }
                    if (!DbCartDeployCloudUtil.isValidString(DbCartDeployCloudTool.this._deployAuthPanel.getTitle()).booleanValue()) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartResources.getString("BAD_TITLE_MESSAGE"), (String)DbCartAddinArb.getString("BAD_TITLE_TITLE"), (String)"DBCART_DEPLOY_BAD_TITLE");
                        return;
                    }
                    DbCartDeployCloudTool.this._targetFormat = DbCartDeployCloudTool.this._targetOptions.getFormat();
                    ExportParms exportParms = new ExportParms();
                    exportParms.setSourceExtractObjectList(DbCartDeployCloudTool.this.getClonedExtractObjects(true, true));
                    if (!DbCartDeployCloudTool.this._isPdbCloud) {
                        for (ExtractObject extractObject2 : exportParms.getSourceExtractObjectList()) {
                            if (!extractObject2.isTypeDataFile()) continue;
                            object = extractObject2.getImportProperties();
                            object.put(ImportKeys.LOAD_METHOD, (Object)4);
                        }
                    }
                    exportParms.setTargetFormat(DbCartDeployCloudTool.this._targetFormat);
                    DDLFormat dDLFormat = DbCartDeployCloudTool.this.getDDLFormat();
                    exportParms.setDDLFormat(dDLFormat);
                    extractObject2 = DbCartDeployCloudTool.this.getDataFormat();
                    exportParms.setDataFormat((ExtractDataFormat)extractObject2);
                    n = DbCartDeployCloudTool.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                    if (n == 0) {
                        if (DbCartDeployCloudTool.this._isPdbCloud) {
                            n = DbCartDeployCloudTool.this.checkCloudStorageLocation();
                            if (n == 0) {
                                exportParms.setServiceType(ExportServiceType.DEPLOY_CLOUD_WALLET);
                                DbCartDeployCloudTool.this._targetFormat.setLocationTestInfo(DbCartDeployCloudTool.this._locationTestInfo);
                                exportParms.setLoadMethod(DbCartDeployCloudTool.this._deployDataOptionPanel.getLoadMethod());
                                if (DbCartDeployCloudTool.this._enableCloudStorage) {
                                    exportParms.setCloudStgLocation(DbCartDeployCloudTool.this._ossCmp.getSelectedURL().toString());
                                    exportParms.setCredential((String)DbCartDeployCloudTool.this._ossCredCmp.getSelectedItem());
                                }
                                exportParms.setDestConnName(DbCartDeployCloudTool.this._deployAuthPanel.getConnName());
                                exportParms.setDestSchema(DbCartDeployCloudTool.this._deployAuthPanel.getSchema());
                                object = new SimpleDateFormat("yy_MM_dd-HH_mm_ss");
                                StringBuilder stringBuilder = new StringBuilder(((DateFormat)object).format(new Date()));
                                exportParms.setName(DbCartDeployCloudTool.this._deployAuthPanel.getTitle() + DbCartAddinArb.getString("DEPLOY_NAME_SEPARATOR") + stringBuilder);
                                DbCartDeployCloudTool.this._targetFormat.isSftp(false);
                            }
                        } else {
                            exportParms.setServiceType(ExportServiceType.DEPLOY_CLOUD_SCHEMA);
                            object = new SftpParms();
                            object.setCloudConnection(DbCartDeployCloudTool.this._deployAuthPanel.getConnName());
                            object.setSchema(DbCartDeployCloudTool.this._deployAuthPanel.getSchema());
                            object.setImportName(DbCartDeployCloudTool.this._deployAuthPanel.getTitle());
                            object.setUser(DbCartDeployCloudTool.this._deployAuthPanel.getUser());
                            object.setPass(DbCartDeployCloudTool.this._deployAuthPanel.getPass());
                            object.setKeyFile(null);
                            object.setLocalFile(DbCartDeployCloudTool.this._targetFormat.getSaveAs());
                            object.setHost(DbCartDeployCloudTool.this._deployAuthPanel.getServer());
                            object.setPort(DbCartDeployCloudTool.this._deployAuthPanel.getPort());
                            DbCartDeployCloudTool.this._targetFormat.setSftpParms(object);
                            SftpUtil sftpUtil = new SftpUtil();
                            boolean bl = sftpUtil.SftpTestConnection((SftpParms)object);
                            if (!bl) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("BAD_CONN_MESSAGE"), (String)DbCartAddinArb.getString("BAD_CONN_TITLE"), (String)"DBCART_DEPLOY_BAD_SFTP");
                                return;
                            }
                        }
                        if (n == 0) {
                            object = new DbCartDeployCloudLauncher();
                            object.run(exportParms);
                        }
                    }
                    if (n == 0) {
                        DbCartDeployCloudTool.this._actionDialog.setVisible(false);
                        DbCartDeployCloudTool.this._actionDialog.dispose();
                    } else if (n == 1) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartDeployCloudTool.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("DEPLOY_LABEL"), (String)"DBCART_FILE_ERROR");
                    }
                }
            };
            this._okButton.addActionListener(actionListener);
            Dimension dimension = this._mainPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 40;
            this._actionDialog.setMinimumSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
            WizardLauncher.runDialog((JDialog)this._actionDialog);
        }
    }

    private int validateUserInput() {
        return this.checkForDestConnection() ? 0 : 1;
    }

    private int checkCloudStorageLocation() {
        this._locationTestInfo = null;
        if (this._isPdbCloud && this._enableCloudStorage) {
            String string = "";
            String string2 = (String)this._ossCredCmp.getSelectedItem();
            if (string2 == null || string2.trim().isEmpty()) {
                MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbCartAddinArb.getString("NO_CREDENTIAL"), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
                return 2;
            }
            if (this._ossCmp != null) {
                URL uRL = this._ossCmp.getSelectedURL();
                String string3 = string = uRL != null ? uRL.toString() : "";
                if (string.trim().isEmpty()) {
                    MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbCartAddinArb.getString("NO_CLOUD_STORAGE"), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
                    return 2;
                }
            } else {
                MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbCartAddinArb.getString("NO_CLOUD_STORAGE"), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
                return 2;
            }
            Logger.info(this.getClass(), (String)(DbmsCloudResources.getString((String)"DBMS_CLOUD_TESTING") + SPACE + DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT")));
            this._locationTestInfo = OracleSwiftObjectStorage.testBucketUrl((String)string, (boolean)true);
            if (this._locationTestInfo.getResult() == LocationTestInfo.Result.PASS) {
                return 0;
            }
            Logger.info(this.getClass(), (String)this._locationTestInfo.getResultString());
            Logger.info(this.getClass(), (String)(DbmsCloudResources.getString((String)"DBMS_CLOUD_TESTING") + SPACE + DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_DB")));
            this._locationTestInfo = null;
            if (this.checkCloudStorageLocationDbmsCloud(string2, string, false) != 0 && this._deployAuthPanel.isCloneConn()) {
                this._conn = this._deployAuthPanel.resetClonedConnection();
                if (this._conn == null) {
                    return 2;
                }
                return this.checkCloudStorageLocationDbmsCloud(string2, string, true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkCloudStorageLocationDbmsCloud(String string, String string2, boolean bl) {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        DbmsCloudAPI dbmsCloudAPI = new DbmsCloudAPI(null);
        try {
            try {
                exitCode = dbmsCloudAPI.startService(this._connName, this._conn);
            }
            catch (Exception exception) {
                exitCode = ExitCode.EXIT_SEVERE;
                exitCode.setShortMessage(exception.getMessage());
            }
            if (exitCode != ExitCode.EXIT_SUCCESS && bl) {
                MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbmsCloudResources.format((String)"DBMS_CLOUD_START_ERR", (Object[])new Object[]{this._connName}), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
                int n = 2;
                return n;
            }
            try {
                dbmsCloudAPI.testBucketUrl(string, string2);
            }
            catch (Exception exception) {
                if (bl) {
                    MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbmsCloudResources.format((String)"DBMS_CLOUD_UPLOAD_DB_ERROR", (Object[])new Object[]{string}), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
                }
                int n = 2;
                dbmsCloudAPI.finishService();
                return n;
            }
        }
        finally {
            dbmsCloudAPI.finishService();
        }
        return 0;
    }

    private boolean checkForDestConnection() {
        String string = this._deployAuthPanel.getConnName();
        Object var2_2 = null;
        boolean bl = false;
        if (var2_2 == null || string.trim().isEmpty()) {
            MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)DbCartAddinArb.getString("NO_DEST_CONNECTION"), (String)DbCartAddinArb.getString("DBCART_COPY_ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void addPanels() {
        this._mainPanel.removeAll();
        this._mainPanel.add((Component)this._configPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._authPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._targetPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 23, 2, new Insets(8, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._ddlPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._dataPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 16, 0), 0, 0));
        this._mainPanel.validate();
        this._mainPanel.repaint();
    }

    private void removeAll() {
        this._mainPanel.removeAll();
    }

    private DDLFormat getDDLFormat() {
        DDLFormat dDLFormat = DbCartDeployCloudUtil.getDDLFormat();
        dDLFormat.setDrop(this._deployCloudDDLPanel.getDoReplaceDest());
        dDLFormat.setCascade(this._deployCloudDDLPanel.getDoReplaceDest());
        return dDLFormat;
    }

    private ExtractDataFormat getDataFormat() {
        ExtractDataFormat extractDataFormat = this._deployDataOptionPanel.getFormatProperties();
        extractDataFormat.isSeparateDataFile(true);
        extractDataFormat.isTruncate(this._deployDataOptionPanel.getChkbxTruncData());
        extractDataFormat.isDisableConstraints(this._deployDataOptionPanel.getChkbxDisableConstraints());
        return extractDataFormat;
    }

    private void connectionChanged(String string, Connection connection, boolean bl) {
        this._conn = connection;
        this._connName = string;
        if (string == null || string.isEmpty()) {
            return;
        }
        this._isPdbCloud = bl;
        this._enableCloudStorage = this._isPdbCloud ? this._enableCloudStorageSave : false;
        if (!this._isOpenConfig && this._isPdbCloud) {
            this.initCredentialComp(connection);
            this.setCloudStorageUI();
        }
        this._targetPanel.setEnabled(this._enableDDL || this._enableData);
        this._dataPanel = this._deployDataOptionPanel.getPanel(bl, null, (Component)this._cloudStgPane);
        this._mainPanel.removeAll();
        this.addPanels();
        this._deployDataOptionPanel.enableOptions(this._enableData, this._enableCloudStorage, this._enableDataFormat);
        this.enableOKButton();
        this._actionDialog.pack();
        Dimension dimension = this._mainPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 28;
        this._actionDialog.setSize(n2, n);
        this._actionDialog.setPreferredSize(n2, n);
        this._actionDialog.repaint();
    }

    private void setCloudStorageUI() {
        this.setCloudStorageUI(null);
    }

    private void setCloudStorageUI(URL uRL) {
        this._cloudStgPanel.removeAll();
        this.initOssCmp(uRL);
        this._cloudLocationPanel.removeAll();
        this._cloudLocationPanel.add((Component)this._ossLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this._cloudLocationPanel.add((Component)this._ossCmp, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._cloudStgPanel.add((Component)this._cloudLocationPanel, "Center");
        this._cloudStgPanel.add((Component)this._credCloudStg, "South");
    }

    private void initOssCmp(URL uRL) {
        this._ossCmp = URLFileChooser.createURLFileChooserPanel((int)0, null, null, (boolean)false, (boolean)false, (boolean)false);
        this._ossCmp.clearChooseableURLFilters();
        this._ossCmp.setVisible(true);
        this._ossCmp.setEnabled(true);
        this._ossCmp.setCheckIfFileExists(false);
        this._ossCmp.setURLFilter(new URLFilter(){

            public boolean accept(URL uRL) {
                if (uRL == null) {
                    return false;
                }
                String string = uRL.getProtocol();
                return string.equals(DbCartDeployCloudTool.HTTPS_PROTOCOL) && URLFileSystem.isDirectoryPath((URL)uRL);
            }
        });
        this._ossCmp.setSelectionScope(1);
        this._ossCmp.setSelectedURL(null);
        this._ossCmp.setPathContext("OSS_BUCKET_CONTEXT");
        URL uRL2 = this._ossCmp.getSelectedURL();
        String string = uRL2.getProtocol();
        if (!string.equals(HTTPS_PROTOCOL)) {
            this._ossCmp.setSelectedURL(null);
        } else if (!URLFileSystem.isDirectoryPath((URL)uRL2)) {
            uRL2 = URLFileSystem.getParent((URL)uRL2);
            this._ossCmp.setSelectedURL(uRL2);
        }
        if (uRL != null) {
            this._ossCmp.setSelectedURL(null);
            this._ossCmp.setSelectedURL(uRL);
        }
    }

    private Component initCredentialComp(Connection connection) {
        this._credCloudStg = new JPanel(new GridBagLayout());
        this._ossCredCmp = DataUIUtils.getSQLCombo((JLabel)this._ossCredLabel);
        DataUIUtils.setCredentialModel(this._ossCredCmp, (Connection)connection, (boolean)false, (String)this.defaultCredential);
        this._ossCredCmp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DbCartDeployCloudTool.this.enableOKButton();
                }
            }
        });
        this._ossCredCmp.setToolTipText(DbCartAddinArb.getString("CREDENTIAL_TIP"));
        this._credCloudStg.add((Component)this._ossCredLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._credCloudStg.add(this._ossCredCmp, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 8, 0, 0), 0, 0));
        return this._credCloudStg;
    }

    private void enableOKButton() {
        boolean bl = true;
        if (this._connName == null || this._connName.isEmpty()) {
            bl = false;
        } else if (this._isPdbCloud) {
            if (this._ossCredCmp == null) {
                bl = false;
            } else if (this._ossCredCmp.isEnabled() && this._ossCredCmp.getSelectedIndex() == -1) {
                bl = false;
            }
        }
        this._okButton.setEnabled(bl);
    }

    @Override
    public void openConfigOptions() {
        block10: {
            this._isOpenConfig = true;
            URL uRL = this._chooser.getSelectedURL();
            try {
                Object object;
                String string;
                this._config = new DbCartUserCloudConfig(DbCartUserCloudConfig.importFrom(uRL));
                String string2 = this._config.getString("DbCartConfig");
                if (string2 == null) {
                    string2 = DbCartAddinArb.getString("XML_FILE_NO_KEY");
                }
                boolean bl = false;
                if (!string2.equals("deploy_cloud_tool")) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"deploy_cloud_tool\"", string2), (String)DbCartAddinArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
                    break block10;
                }
                String string3 = this._config.getString("CLOUD_CONN");
                if (!this.setCombo(string3, this._deployAuthPanel.getConnJCombo())) {
                    string = string3 == null || string3.length() == 0 ? DbCartResources.getString("XML_CONN_ERROR_MESSAGE2") : DbCartResources.format("XML_CONN_ERROR_MESSAGE1", string3);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)DbCartAddinArb.getString("XML_CONN_ERROR_TITLE"), (String)"XML_CONN_ERROR_TITLE");
                }
                if (Connections.getInstance().isOracle(string3)) {
                    bl = true;
                    string = this._config.getString("CLOUD_SCHEMA");
                    if (!this.setCombo(string, this._deployAuthPanel.getSchemaJCombo())) {
                        String string4 = string == null || string.length() == 0 ? DbCartAddinArb.getString("XML_SCHEMA_ERROR_MESSAGE2") : DbCartAddinArb.format("XML_SCHEMA_ERROR_MESSAGE1", string);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)DbCartAddinArb.getString("XML_CART_ERROR_TITLE"), (String)"XML_CART_ERROR_TITLE");
                    }
                }
                this._deployAuthPanel.setTitle(this._config.getString("CLOUD_TITLE"));
                string = this.getDDLFormat();
                this._config.copyToDDLFormat((DDLFormat)string);
                boolean bl2 = DbCartUtil.getTableModel().isAnyDDLRows();
                string.isExtractEnabled(bl2);
                this._deployCloudDDLPanel.enableOptions(bl2);
                this._ddlPanel = this._deployCloudDDLPanel.getPanel();
                this._deployCloudDDLPanel.setDoReplaceDest(string.getDrop());
                ExtractDataFormat extractDataFormat = this.getDataFormat();
                this._config.copyToDataFormat(extractDataFormat);
                this._targetFormat = this._targetOptions.getFormat();
                this._config.copyToTargetFormat(this._targetFormat);
                this._targetFormat.setSaveAs(this._config.getString("CLOUD_TRANSFER_FILE"));
                this._targetOptions.setFormat(this._targetFormat);
                this._isPdbCloud = bl;
                if (this._isPdbCloud) {
                    object = this._config.getString("CLOUD_CREDENTIAL");
                    this._ossCredCmp.setSelectedItem(object);
                    String string5 = this._config.getString("CLOUD_LOCATION");
                    try {
                        this.setCloudStorageUI(new URL(string5));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._dataPanel = this._deployDataOptionPanel.getPanel(extractDataFormat, this._isPdbCloud, null, (Component)this._cloudStgPane);
                this._mainPanel.removeAll();
                this.addPanels();
                this._actionDialog.pack();
                object = this._mainPanel.getPreferredSize();
                int n = (int)((Dimension)object).getHeight() + 100;
                int n2 = (int)((Dimension)object).getWidth() + 28;
                this._actionDialog.setSize(n2, n);
                this._actionDialog.setPreferredSize(n2, n);
                this._actionDialog.validate();
                this._actionDialog.repaint();
                this._isOpenConfig = false;
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
        }
    }

    @Override
    public void saveConfigOptions() {
        URL uRL = this.getConfigURL();
        try {
            this._config.putString("DbCartConfig", "deploy_cloud_tool");
            this._config.putString("CLOUD_TITLE", this._deployAuthPanel.getTitle());
            this._config.putString("CLOUD_CONN", this._deployAuthPanel.getConnName());
            this._config.putString("CLOUD_SCHEMA", this._deployAuthPanel.getSchema() != null ? this._deployAuthPanel.getSchema() : "");
            if (this._enableCloudStorage) {
                URL uRL2 = this._ossCmp.getSelectedURL();
                String string = uRL2 != null ? uRL2.toString() : "";
                this._config.putString("CLOUD_LOCATION", string);
                String string2 = "";
                if (this._ossCredCmp.getSelectedIndex() != -1) {
                    string2 = (String)this._ossCredCmp.getSelectedItem();
                }
                this._config.putString("CLOUD_CREDENTIAL", string2);
            }
            this._config.copyFromDDLFormat(this.getDDLFormat());
            this._config.copyFromDataFormat(this.getDataFormat());
            this._config.copyFromTargetFormat(this._targetOptions.getFormat());
            this._config.putString("CLOUD_TRANSFER_FILE", this._targetOptions.getFormat().getSaveAs());
            this._config.exportTo(uRL);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }
}

