/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.dbcart.DBCartReorderableTableModel;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.tools.DbCartTool;
import oracle.dbtools.dbcart.tools.IDbCartTool;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public abstract class DbCartUtilityTool
extends DbCartTool
implements IDbCartTool,
Controller {
    protected static final String SAVE_CONFIG = "save_config";
    private TargetOptionsPanel _targetOptions;
    private TargetFormat _targetFormat;
    private JEWTDialog _actionDialog;
    private JEWTDialog _subActionDialog;
    private final FileNameExtensionFilter _filter = new FileNameExtensionFilter(DbCartAddinArb.getString("SAVED_ACTION"), "sdcartaction", "xml");
    protected URLFileChooser.URLFileChooserPanel _chooser;
    private File _file;

    public DbCartUtilityTool(String string, int n) {
        super(string, n);
    }

    @Override
    public void toolWillEnable() {
        this.enableIfCurrentCart(true);
    }

    protected ArrayList<ExtractObject> getClonedExtractObjects() {
        return this.getClonedExtractObjects(DbCartUtil.getTableModel(), true, false);
    }

    protected ArrayList<ExtractObject> getClonedExtractObjects(boolean bl, boolean bl2) {
        return this.getClonedExtractObjects(DbCartUtil.getTableModel(), bl, bl2);
    }

    protected ArrayList<ExtractObject> getClonedExtractObjects(String string) {
        return this.getClonedExtractObjects(string, false);
    }

    protected ArrayList<ExtractObject> getClonedExtractObjects(String string, boolean bl) {
        return this.getClonedExtractObjects(DbCartUtil.getTableModel(string), bl, false);
    }

    private ArrayList<ExtractObject> getClonedExtractObjects(DBCartReorderableTableModel dBCartReorderableTableModel, boolean bl, boolean bl2) {
        if (dBCartReorderableTableModel == null) {
            return new ArrayList<ExtractObject>();
        }
        ArrayList<ExtractObject> arrayList = dBCartReorderableTableModel.getIncludedRows();
        if (!bl2) {
            for (ExtractObject extractObject : arrayList) {
                if (!extractObject.isTypeDataFile()) continue;
                arrayList.remove(extractObject);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        for (ExtractObject extractObject : arrayList) {
            ExtractObject extractObject2 = extractObject.clone();
            if (!bl) {
                extractObject2.convertToDest();
            }
            extractObject2.setListModel(null);
            arrayList2.add(extractObject2);
        }
        return arrayList2;
    }

    protected boolean validateFile(String string, String string2) {
        Object object;
        if (string != null && string.length() > 0 && ((File)(object = new File(string))).isFile()) {
            return true;
        }
        object = DbCartAddinArb.format("DEPLOY_SCRIPT_FILE_ERROR", string2, string2);
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)DbCartAddinArb.getString("DEPLOY_LABEL"), null);
        return false;
    }

    protected JPanel getConfigPanel() {
        JButton jButton = new JButton();
        jButton.setIcon(OracleIcons.getIcon((String)"open.png"));
        jButton.setToolTipText(DbCartAddinArb.getString("OPEN_CONFIG_TIP"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbCartUtilityTool.this.openConfig();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setIcon(OracleIcons.getIcon((String)"filesave.png"));
        jButton2.setToolTipText(DbCartAddinArb.getString("SAVE_CONFIG_TIP"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbCartUtilityTool.this.saveConfig();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2, 6, 6));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void openConfig() {
        String string = DbCartAddinArb.getString("OPEN_CONFIG_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_opencartconfig_html");
        TargetFormat targetFormat = new TargetFormat(1, 3);
        targetFormat.setSaveAsType(0);
        this._chooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)DbCartAddinArb.getString("OPEN_CART_FILE"));
        this._chooser.setCurrentDirectory(new File(targetFormat.getDefaultDirectory()));
        this._chooser.setFileFilter((FileFilter)this._filter);
        jPanel.add((Component)this._chooser, LayoutControl.GBC.gbc((int)0, (int)0, (int)0, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._subActionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartUtilityTool.this._file = DbCartUtilityTool.this._chooser.getSelectedFile();
                    if (DbCartUtilityTool.this._file == null || !DbCartUtilityTool.this._file.isFile()) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("OPEN_CART_INSTRUCTIONS"), (String)DbCartAddinArb.getString("CART_OPEN_ERROR_LABEL"), (String)"DBCART_FILE_ERROR");
                        bl = true;
                    } else {
                        DbCartUtilityTool.this.openConfigOptions();
                    }
                }
                if (!bl) {
                    DbCartUtilityTool.this._subActionDialog.setVisible(false);
                    DbCartUtilityTool.this._subActionDialog.dispose();
                }
            }
        };
        this._subActionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 200;
        this._subActionDialog.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._subActionDialog);
        this._subActionDialog.setVisible(true);
    }

    protected void saveConfig() {
        String string = DbCartAddinArb.getString("SAVE_CONFIG_DIALOG_TITLE");
        JLabel jLabel = new JLabel(DbCartAddinArb.getString("SAVE_CONFIG_INSTRUCTIONS"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_savecartconfig_html");
        this._targetFormat = new TargetFormat(1, 3);
        this._targetFormat.setShowEncoding(true);
        this._targetFormat.setShowCompression(false);
        this._targetFormat.setShowSaveAsType(false);
        this._targetFormat.isCompressed(false);
        this._targetFormat.setSaveAsType(0);
        String string2 = File.separator;
        String string3 = this._targetFormat.getDefaultDirectory();
        if (!string3.endsWith(string2)) {
            string3 = string3 + string2;
        }
        string3 = string3 + this._type.toLowerCase() + DbCartAddinArb.getString("SAVE_CONFIG_NAME") + ".xml";
        this._targetFormat.setSaveAs(string3);
        this._targetOptions = new TargetOptionsPanel((Component)jPanel, this._targetFormat);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._targetOptions.getPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._subActionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartUtilityTool.this._targetFormat = DbCartUtilityTool.this._targetOptions.getFormat();
                    n = DbCartUtilityTool.this._targetFormat.validateSaveAs((Component)Ide.getMainWindow());
                    if (n == 0) {
                        DbCartUtilityTool.this.saveConfigOptions();
                    }
                }
                if (n == 0) {
                    DbCartUtilityTool.this._subActionDialog.setVisible(false);
                    DbCartUtilityTool.this._subActionDialog.dispose();
                } else if (n == 1) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartUtilityTool.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("EXPORT_LABEL"), (String)"DBCART_FILE_ERROR");
                }
            }
        };
        this._subActionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 200;
        this._subActionDialog.setSize(n2, n);
        this._subActionDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._subActionDialog);
        this._subActionDialog.setVisible(true);
    }

    protected URL getConfigURL() {
        return this._targetFormat.getSaveAsURL();
    }
}

