/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightAdapter;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightSupport;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionController;
import oracle.ide.insight.completion.CompletionMultiProvider;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.options.InsightOptions;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public abstract class CompletionSupport<T extends JTextComponent>
implements InsightSupport<T, CompletionController> {
    private boolean disposed = false;
    private InsightAdapter<T, CompletionController> adapter;
    private boolean isAutoPopup;
    private boolean showOnShortcut = true;
    protected CompletionMultiProvider multiProvider;
    private Timer popupTimer;
    private Character triggerChar;
    private final CaretL caretL = new CaretL();
    protected final CompletionController controller = new CompletionController();
    private final StructureChangeListener optionsListener = new WeakStructureChangeListener(new StructureChangeListener(){

        public void structureValuesChanged(StructureChangeEvent e) {
            InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            CompletionSupport.this.popupTimer.setDelay(options.getCompletionPopupDelay());
            CompletionSupport.this.isAutoPopup = options.isCompletePopupEnabled();
        }
    });
    private final PropertyChangeListener timerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (SwingUtilities.isEventDispatchThread());
            CompletionSupport.this.popupTimer.stop();
        }
    };

    CompletionSupport(InsightAdapter<T, CompletionController> adapter) {
        this.adapter = adapter;
    }

    protected void install() {
        this.adapter.install(this);
        InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        this.popupTimer = new Timer(options.getCompletionPopupDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CompletionSupport.this.disposed) {
                    CompletionSupport.this.triggerInsight(CompletionContext.Invoked.AUTO, CompletionSupport.this.triggerChar);
                }
                CompletionSupport.this.triggerChar = null;
            }
        });
        this.popupTimer.setRepeats(false);
        this.isAutoPopup = options.isCompletePopupEnabled();
        options.addStructureChangeListener(this.optionsListener);
        this.controller.addPropertyChangeListener(this.timerListener);
        ((JTextComponent)this.adapter.getTextComponent()).addCaretListener(this.caretL);
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.adapter.deinstall();
        this.adapter = null;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public CompletionController getInsightController() {
        return this.disposed ? null : this.controller;
    }

    public boolean isShowing() {
        return this.controller.getState() == InsightController.State.SHOWING;
    }

    public void hide() {
        this.getInsightController().hide();
    }

    public void show() {
        this.show(this.multiProvider.getAllProviders().get(0));
    }

    public void show(CompletionProvider provider) {
        CompletionContext<CompletionSupport> insightContext = new CompletionContext<CompletionSupport>(this, CompletionContext.Invoked.MANUAL, provider);
        this.getInsightController().show(insightContext);
    }

    @Override
    public InsightAdapter<T, CompletionController> getAdapter() {
        return this.adapter;
    }

    public void deinstall() {
        this.popupTimer.stop();
        this.controller.removePropertyChangeListener(this.timerListener);
        InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        options.removeStructureChangeListener(this.optionsListener);
        ((JTextComponent)this.adapter.getTextComponent()).removeCaretListener(this.caretL);
        this.adapter.deinstall();
        this.adapter = null;
    }

    protected void triggerInsight(CompletionContext.Invoked invoked) {
        this.triggerInsight(invoked, null);
    }

    protected void triggerInsight(CompletionContext.Invoked invoked, Character triggerChar) {
        this.multiProvider.setFirstProvider(triggerChar);
        this.controller.show(new CompletionContext<CompletionSupport>(this, invoked, this.multiProvider));
    }

    public void setShowOnShortcut(boolean showOnShortcut) {
        this.showOnShortcut = showOnShortcut;
    }

    public boolean isShowOnShortcut() {
        return this.showOnShortcut;
    }

    protected boolean isAutoPopup() {
        return this.isAutoPopup;
    }

    public void setAutoPopup(boolean autoPopup) {
        this.isAutoPopup = autoPopup;
    }

    protected void cancelTimer() {
        this.triggerChar = null;
        this.popupTimer.stop();
    }

    protected void timerTrigger(Character triggerChar) {
        if (this.getMultiProvider().getTriggerCharacters().contains(triggerChar)) {
            this.triggerChar = triggerChar;
            this.popupTimer.restart();
        } else {
            this.triggerChar = null;
            this.popupTimer.stop();
        }
    }

    protected final CompletionMultiProvider getMultiProvider() {
        return this.multiProvider;
    }

    private final class CaretL
    implements CaretListener {
        private CaretL() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (CompletionSupport.this.controller.getState() == InsightController.State.SHOWING) {
                CompletionSupport.this.controller.triggerUpdate();
            }
        }
    }

    private static class WeakStructureChangeListener
    extends StructureChangeListener {
        private WeakReference<StructureChangeListener> ref;

        WeakStructureChangeListener(StructureChangeListener scl) {
            this.ref = new WeakReference<StructureChangeListener>(scl);
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            StructureChangeListener scl = (StructureChangeListener)this.ref.get();
            if (scl != null) {
                scl.structureValuesChanged(e);
            } else {
                ((HashStructure)e.getSource()).removeStructureChangeListener((StructureChangeListener)this);
            }
        }
    }
}

