/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Graphics;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.share.event.ListenerManager;

public final class CompoundTool
implements LayoutTool,
JLEEventSource,
JLEEventListener {
    private LayoutTool[] _tools;
    private long _enabledEvents;
    private ListenerManager _listeners;
    private JLECanvas _canvas;
    private JLEEventSource _eventSource;
    private int _count;
    private boolean _enabled = true;
    private static int _sCount = 0;

    public CompoundTool(LayoutTool first, LayoutTool second) {
        this(new LayoutTool[]{first, second});
    }

    public CompoundTool(LayoutTool first, LayoutTool second, LayoutTool third) {
        this(new LayoutTool[]{first, second, third});
    }

    public CompoundTool(LayoutTool[] subTools) {
        if (subTools == null || subTools.length == 0) {
            throw new IllegalArgumentException("must supply at least one LayoutTool");
        }
        this._tools = new LayoutTool[subTools.length];
        System.arraycopy(subTools, 0, this._tools, 0, this._tools.length);
        this._enabledEvents = 0L;
        this._count = _sCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawHighlight(Graphics g) {
        for (int i = 0; i < this._tools.length; ++i) {
            Graphics newGraphics = g.create();
            try {
                this._tools[i].drawHighlight(newGraphics);
                continue;
            }
            finally {
                newGraphics.dispose();
            }
        }
    }

    @Override
    public void drop() {
        for (int i = this._tools.length - 1; i >= 0; --i) {
            this._tools[i].drop();
        }
        this._eventSource.removeJLEEventListener(this);
        this._enabledEvents = 0L;
        this._eventSource = null;
        this._canvas = null;
    }

    @Override
    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        this._canvas = canvas;
        this._eventSource = eventSource;
        this._eventSource.addJLEEventListener(this);
        for (int i = 0; i < this._tools.length; ++i) {
            this._tools[i].pickup(canvas, this);
        }
        this._eventSource.enableJLEEvents(this._enabledEvents);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void enableJLEEvents(long eventsToEnable) {
        this._enabledEvents |= eventsToEnable;
        if (this._eventSource != null) {
            this._eventSource.enableJLEEvents(eventsToEnable);
        }
    }

    @Override
    public void addJLEEventListener(JLEEventListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    @Override
    public void removeJLEEventListener(JLEEventListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    @Override
    public void mouseClicked(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void mousePressed(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void mouseReleased(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void mouseEntered(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void mouseExited(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void mouseDragged(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void mouseMoved(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void keyTyped(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void keyPressed(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void keyReleased(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void focusGained(JLEEvent e) {
        this._processJLEEvent(e);
    }

    @Override
    public void focusLost(JLEEvent e) {
        this._processJLEEvent(e);
    }

    public LayoutTool[] getTools() {
        LayoutTool[] tools = new LayoutTool[this._tools.length];
        System.arraycopy(this._tools, 0, tools, 0, tools.length);
        return tools;
    }

    private void _processJLEEvent(JLEEvent evt) {
        Enumeration listeners;
        if (!this.isEnabled()) {
            return;
        }
        if (!this._JLEEventEnabled(evt.getID())) {
            return;
        }
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return;
        }
        while (listeners.hasMoreElements()) {
            JLEEventListener listener = (JLEEventListener)listeners.nextElement();
            switch (evt.getID()) {
                case 500: {
                    listener.mouseClicked(evt);
                    break;
                }
                case 501: {
                    listener.mousePressed(evt);
                    break;
                }
                case 502: {
                    listener.mouseReleased(evt);
                    break;
                }
                case 504: {
                    listener.mouseEntered(evt);
                    break;
                }
                case 505: {
                    listener.mouseExited(evt);
                    break;
                }
                case 503: {
                    listener.mouseMoved(evt);
                    break;
                }
                case 506: {
                    listener.mouseDragged(evt);
                    break;
                }
                case 400: {
                    listener.keyTyped(evt);
                    break;
                }
                case 401: {
                    listener.keyPressed(evt);
                    break;
                }
                case 402: {
                    listener.keyReleased(evt);
                    break;
                }
                case 1004: {
                    listener.focusGained(evt);
                    break;
                }
                case 1005: {
                    listener.focusLost(evt);
                }
            }
        }
    }

    private boolean _JLEEventEnabled(int mask) {
        switch (mask) {
            case 503: 
            case 506: {
                if ((this._enabledEvents & 0x20L) == 0L) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this._enabledEvents & 0x10L) == 0L) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this._enabledEvents & 8L) == 0L) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this._enabledEvents & 4L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "CompoundTool" + this._count;
    }
}

