/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import oracle.mapviewer.share.OMSException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TileLayerConfig {
    public static final int COORDINATE_SYSTEM_TYPE_GEODETIC = 0;
    public static final int COORDINATE_SYSTEM_TYPE_PROJECTED = 1;
    private String tileLayerName = null;
    private String dataSource = null;
    private String imageFormat = "PNG";
    private String copyright = null;
    private int srid = -1;
    private double distConvFactor = 0.0;
    private int coordSysType = 1;
    private double[] coordSysBounds = null;
    private ZoomLevel[] zoomLevels = null;
    private boolean transparent = false;
    private boolean isOnLine = true;

    public TileLayerConfig(String configStr) throws OMSException {
        if (configStr == null || configStr.trim().length() == 0) {
            throw new OMSException("Empty config string!");
        }
        StringReader rdr = new StringReader(configStr);
        XMLDocument doc = null;
        DOMParser parser = new DOMParser();
        try {
            XMLElement node;
            parser.setErrorStream((OutputStream)System.err);
            parser.setValidationMode(0);
            parser.setPreserveWhitespace(false);
            parser.showWarnings(true);
            parser.parse((Reader)rdr);
            doc = parser.getDocument();
            NodeList nl = doc.getChildrenByTagName("map_tile_layer_config");
            if (nl != null && nl.getLength() > 0 && ((nl = (node = (XMLElement)nl.item(0)).getChildrenByTagName("map_tile_layer")) == null || nl.getLength() == 0)) {
                nl = node.getChildrenByTagName("cache_instance");
            }
            if (nl == null || nl.getLength() == 0) {
                nl = doc.getChildrenByTagName("map_tile_layer");
            } else if (nl == null || nl.getLength() == 0) {
                nl = doc.getChildrenByTagName("cache_instance");
            }
            if (nl == null || nl.getLength() == 0) {
                throw new OMSException("Invalid config string. (" + configStr + ")");
            }
            this.init(doc, (XMLElement)nl.item(0));
        }
        catch (Exception e) {
            throw new OMSException("Error in parsing configuration file. (" + configStr + ")", (Throwable)e);
        }
        finally {
            try {
                ((Reader)rdr).close();
            }
            catch (Exception ex) {}
        }
    }

    public String getTileLayerName() {
        return this.tileLayerName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<map_tile_layer name=\"" + this.tileLayerName + "\" data_source=\"" + this.dataSource + "\" format=\"" + this.imageFormat + "\" transparent=\"" + this.transparent + "\"" + ">\n");
        if (this.copyright != null) {
            sb.append("<copyright>");
            sb.append("<![CDATA[" + this.copyright + "]]>");
            sb.append("</copyright>");
        }
        sb.append("  <coordinate_system srid=\"" + this.srid + "\" ");
        sb.append("type=\"" + (this.coordSysType == 0 ? "GEODETIC" : "PROJECTED") + "\" ");
        sb.append("distConvFactor=\"" + this.distConvFactor + "\" ");
        sb.append("minX=\"" + this.coordSysBounds[0] + "\" ");
        sb.append("minY=\"" + this.coordSysBounds[1] + "\" ");
        sb.append("maxX=\"" + this.coordSysBounds[2] + "\" ");
        sb.append("maxY=\"" + this.coordSysBounds[3] + "\"/>\n");
        sb.append("  <zoom_levels>\n");
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            sb.append("    <zoom_level level=\"" + i + "\" ");
            sb.append("name=\"" + (this.zoomLevels[i].name == null ? "" : this.zoomLevels[i].name) + "\" ");
            sb.append("scale=\"" + this.zoomLevels[i].scale + "\" ");
            sb.append("tile_width=\"" + this.zoomLevels[i].tileWidth + "\" ");
            sb.append("tile_height=\"" + this.zoomLevels[i].tileHeight + "\" ");
            sb.append("tile_image_width=\"" + this.zoomLevels[i].tileImageWidth + "\" ");
            sb.append("tile_image_height=\"" + this.zoomLevels[i].tileImageHeight + "\"/>\n");
        }
        sb.append("  </zoom_levels>\n");
        sb.append("</map_tile_layer>\n");
        return sb.toString();
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isIsOnLine() {
        return this.isOnLine;
    }

    public int getSrid() {
        return this.srid;
    }

    public double[] getCoordinateSystemBound() {
        return this.coordSysBounds;
    }

    public int getCoordinateSystemType() {
        return this.coordSysType;
    }

    public double getDistanceConversionFactor() {
        return this.distConvFactor;
    }

    public int getZoomLevelCount() {
        return this.zoomLevels == null ? 0 : this.zoomLevels.length;
    }

    public double getTileWidth(int zoomLevel) {
        return this.zoomLevels[zoomLevel].tileWidth;
    }

    public double getTileHeight(int zoomLevel) {
        return this.zoomLevels[zoomLevel].tileHeight;
    }

    public int getTileImageWidth(int zoomLevel) {
        return this.zoomLevels[zoomLevel].tileImageWidth;
    }

    public int getTileImageHeight(int zoomLevel) {
        return this.zoomLevels[zoomLevel].tileImageHeight;
    }

    public double getScale(int zoomLevel) {
        return this.zoomLevels[zoomLevel].scale;
    }

    public double getPixelsPerXUnit(int zoomLevel) {
        return this.zoomLevels[zoomLevel].pixelsPerXUnit;
    }

    public double getPixelsPerYUnit(int zoomLevel) {
        return this.zoomLevels[zoomLevel].pixelsPerYUnit;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getZoomLevelName(int zoomLevel) {
        return this.zoomLevels[zoomLevel].name;
    }

    public int getClosestScaleID(Rectangle2D box, double height) {
        if (this.zoomLevels == null) {
            return -1;
        }
        double bestRatio = 10000.0;
        int bestIdx = -1;
        double ppu = height / box.getHeight();
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            double ratio = this.zoomLevels[i].pixelsPerYUnit < ppu ? ppu / this.zoomLevels[i].pixelsPerYUnit : this.zoomLevels[i].pixelsPerYUnit / ppu;
            if (!(ratio < bestRatio)) continue;
            bestRatio = ratio;
            bestIdx = i;
        }
        return bestIdx;
    }

    public Rectangle2D getAdjustedMapBoundingBox(Rectangle2D box, double width, double height, int zoomLevel) {
        ZoomLevel zoomLevelDef = null;
        if (this.zoomLevels == null) {
            return null;
        }
        if (zoomLevel < 0 || zoomLevel >= this.getZoomLevelCount()) {
            return null;
        }
        zoomLevelDef = this.zoomLevels[zoomLevel];
        if (zoomLevelDef == null) {
            return null;
        }
        double cx = box.getCenterX();
        double cy = box.getCenterY();
        double w = width / zoomLevelDef.pixelsPerXUnit;
        double h = height / zoomLevelDef.pixelsPerYUnit;
        return new Rectangle2D.Double(cx - w / 2.0, cy - h / 2.0, w, h);
    }

    private void init(XMLDocument xml, XMLElement elem) throws OMSException {
        XMLElement inelem;
        this.tileLayerName = elem.getAttribute("name");
        if ("true".equalsIgnoreCase(elem.getAttribute("offline"))) {
            this.isOnLine = false;
        }
        this.imageFormat = elem.getAttribute("format");
        NodeList nl = elem.getChildrenByTagName("copyright");
        if (nl != null && nl.getLength() > 0) {
            this.loadCopyright(nl.item(0));
        }
        this.dataSource = elem.getAttribute("data_source");
        if (this.dataSource != null) {
            this.dataSource = this.dataSource.toUpperCase();
        }
        if ((nl = elem.getChildrenByTagName("coordinate_system")) != null && nl.getLength() > 0) {
            inelem = (XMLElement)nl.item(0);
            this.loadCoordinateSystemDef(inelem);
        }
        if ((nl = elem.getChildrenByTagName("zoom_levels")) != null && nl.getLength() > 0) {
            inelem = (XMLElement)nl.item(0);
            this.loadZoomLevelsDef(xml, inelem);
        }
    }

    private void loadZoomLevelsDef(XMLDocument xml, XMLElement elem) throws OMSException {
        NodeList nl = elem.getChildrenByTagName("zoom_level");
        if (nl != null && nl.getLength() > 0) {
            this.zoomLevels = new ZoomLevel[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                this.zoomLevels[i] = new ZoomLevel((XMLElement)nl.item(i));
            }
        }
    }

    private void loadCoordinateSystemDef(XMLElement elem) throws OMSException {
        try {
            this.srid = Integer.parseInt(elem.getAttribute("srid"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.coordSysType = "GEODETIC".equalsIgnoreCase(elem.getAttribute("type")) ? 0 : 1;
        try {
            this.distConvFactor = Integer.parseInt(elem.getAttribute("distConvFactor"));
        }
        catch (Exception e) {
            // empty catch block
        }
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        String minXStr = elem.getAttribute("minX");
        try {
            minX = Double.parseDouble(minXStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        String maxXStr = elem.getAttribute("maxX");
        try {
            maxX = Double.parseDouble(maxXStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        String minYStr = elem.getAttribute("minY");
        try {
            minY = Double.parseDouble(minYStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        String maxYStr = elem.getAttribute("maxY");
        try {
            maxY = Double.parseDouble(maxYStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.coordSysBounds = new double[4];
        this.coordSysBounds[0] = Math.min(minX, maxX);
        this.coordSysBounds[1] = Math.min(minY, maxY);
        this.coordSysBounds[2] = Math.max(minX, maxX);
        this.coordSysBounds[3] = Math.max(minY, maxY);
    }

    private void loadCopyright(Node node) throws OMSException {
        this.copyright = this.getNodeValue(node);
    }

    private String getNodeValue(Node node) {
        XMLElement elem = (XMLElement)node;
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeValue() == null) continue;
            return n.getNodeValue();
        }
        return null;
    }

    class ZoomLevel {
        String name = null;
        double scale = 0.0;
        double tileWidth = 0.0;
        double tileHeight = 0.0;
        int tileImageHeight = 0;
        int tileImageWidth = 0;
        double pixelsPerXUnit = 0.0;
        double pixelsPerYUnit = 0.0;

        ZoomLevel(XMLElement elem) {
            this.name = elem.getAttribute("name");
            try {
                this.scale = Double.parseDouble(elem.getAttribute("scale"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.tileWidth = Double.parseDouble(elem.getAttribute("tile_width"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.tileHeight = Double.parseDouble(elem.getAttribute("tile_height"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.tileImageWidth = Integer.parseInt(elem.getAttribute("tile_image_width"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.tileImageHeight = Integer.parseInt(elem.getAttribute("tile_image_height"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.tileWidth > 0.0) {
                this.pixelsPerXUnit = (double)this.tileImageWidth / this.tileWidth;
            }
            if (this.tileHeight > 0.0) {
                this.pixelsPerYUnit = (double)this.tileImageHeight / this.tileHeight;
            }
        }
    }
}

