/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.GeometryElementsPanel;
import oracle.mdeditor.ui.InvalidGeometryPanel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.SimplifyPreviewPanel;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.edit.util.SimplifyGeometrySet;
import oracle.spatial.geometry.JGeometry;

public class GeometryToolsPane
extends BasicToolsPane {
    private JButton validategeom = new JButton(Icons.getIcon("invalidgeom.png"));
    private JButton viewgeomelems = new JButton(Icons.getIcon("geomelements.png"));
    private JButton simplify = new JButton(Icons.getIcon("dual_y_line_graph.png"));
    private JButton buffer = new JButton(Icons.getIcon("buffer_dwn.png"));

    public GeometryToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.validategeom, this.viewgeomelems, this.simplify, this.buffer};
        this.setName(MessagesBundle.getMessage("Geometry_tools"));
        this.validategeom.setToolTipText(MessagesBundle.getMessage("Tooltip_validate_geometries"));
        this.validategeom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> w = new SwingWorker<Void, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void doInBackground() throws Exception {
                        MapCanvas canvas = GeometryToolsPane.this.getMapCanvas();
                        if (canvas == null) {
                            return null;
                        }
                        GeometrySetLayer layer = (GeometrySetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                        if (layer == null) {
                            return null;
                        }
                        List<GeoObject> objects = layer.getSelection();
                        if (objects == null || objects.size() == 0) {
                            return null;
                        }
                        AbstractFeature[] features = new GeometryFeature[objects.size()];
                        for (int i = 0; i < objects.size(); ++i) {
                            features[i] = (GeometryFeature)objects.get(i);
                        }
                        GeometrySet dset = (GeometrySet)layer.getIndexedDataSet().getDataSet();
                        if (dset == null || features == null || features.length == 0) {
                            return null;
                        }
                        Hashtable<String, String> invFeats = new Hashtable<String, String>();
                        Hashtable<String, AbstractFeature> invalidFeatures = new Hashtable<String, AbstractFeature>();
                        AbstractFeature[] feats = features;
                        String keyColumn = dset.getKeyColumn();
                        AbstractDataAccessObject da = null;
                        Throwable exception = null;
                        try {
                            da = layer.getDataSource().getDataAccessObject();
                            da.openConnection();
                            this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)true);
                            this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_validatinggeoms"));
                            Hashtable<String, String> validation = da.validateFeatureGeometries(keyColumn, feats, 5.0E-7);
                            if (validation == null) {
                                ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_to_validate_features"), MessagesBundle.getMessage("Warning"), 2);
                                Void void_ = null;
                                return void_;
                            }
                            for (int i = 0; i < feats.length; ++i) {
                                String key = feats[i].getAttribute(keyColumn).getValue().toString();
                                String valid = validation.get(key);
                                if (valid == null || valid.length() <= 0 || valid.equalsIgnoreCase("TRUE")) continue;
                                invFeats.put(key, valid);
                                invalidFeatures.put(key, feats[i]);
                            }
                            SwingUtilities.invokeLater(new ValidateDialogRunnable(canvas, layer, invalidFeatures, invFeats));
                        }
                        catch (MDSException ex) {
                            exception = ex;
                        }
                        catch (Exception ex) {
                            exception = ex;
                        }
                        finally {
                            try {
                                da.closeConnection();
                            }
                            catch (Exception re) {
                                re.printStackTrace();
                            }
                        }
                        if (exception != null) {
                            System.out.println(exception.getMessage());
                            ErrorDialog.showErrorDialog(exception, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_to_validate_features"), MessagesBundle.getMessage("Warning"), 2);
                            return null;
                        }
                        return null;
                    }
                };
                MapCanvas canvas = GeometryToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    w.addPropertyChangeListener(canvas);
                    w.execute();
                }
            }
        });
        this.viewgeomelems.setToolTipText(MessagesBundle.getMessage("Tooltip_view_geometry_elements"));
        this.viewgeomelems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = GeometryToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                GeometrySetLayer layer = (GeometrySetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (layer == null) {
                    return;
                }
                List<GeoObject> objects = layer.getSelection();
                if (objects == null || objects.size() == 0) {
                    return;
                }
                GeometryFeature feat = (GeometryFeature)objects.get(0);
                String keyColumn = ((IndexedGeometrySet)layer.getIndexedDataSet()).getGeometrySet().getKeyColumn();
                Layer gsLayer = canvas.getLayerManager().getLayerByTag("targetLayer");
                GeometryElementsPanel ivp = new GeometryElementsPanel((IndexedGeometrySet)layer.getIndexedDataSet(), feat, canvas, (GeometrySetLayer)gsLayer);
                OlafDialog ivpDlg = new OlafDialog(canvas.getFrameForDialog(), MessagesBundle.getMessage("Geometry_elements"), ivp, 0.9f);
                ivpDlg.setAsCloseSelection(true);
                ivpDlg.setVisible(true);
                ivpDlg.dispose();
                if (gsLayer != null) {
                    ((GeometrySetLayer)gsLayer).setHighliteGeometries(null);
                }
            }
        });
        this.simplify.setToolTipText(MessagesBundle.getMessage("Tooltip_simplify_geometries"));
        this.simplify.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                MapCanvas canvas = GeometryToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                GeometrySetLayer layer = (GeometrySetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (layer == null) {
                    return;
                }
                List<GeoObject> objs = layer.getSelection();
                if (objs == null || objs.size() == 0) {
                    return;
                }
                SRS srs = canvas.getMapRegion().getSRS();
                SimplifyPreviewPanel spvp = new SimplifyPreviewPanel(srs);
                SimplifyGeometrySet geomSimplify = new SimplifyGeometrySet();
                if (geomSimplify == null || geomSimplify.getTopology() == null) {
                    ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "Unable to create simplify instance.", "Warning_message", 2);
                    return;
                }
                String keyColumn = layer.getIndexedDataSet().getDataSet().getKeyColumn();
                Vector<JGeometry> geometries = new Vector<JGeometry>();
                AbstractFeature[] features = new AbstractFeature[objs.size()];
                for (int i2 = 0; i2 < objs.size(); ++i2) {
                    features[i2] = (AbstractFeature)objs.get(i2);
                }
                AbstractFeature[] feats = GeometrySetLayer.sortGeometryFeaturesByAreaDesc(features);
                Hashtable<String, String> unableFeats = new Hashtable<String, String>();
                for (int i3 = 0; i3 < feats.length; ++i3) {
                    if (GeometryToolsPane.this.validateGeometryFeatureForOperation(feats[i3], "simplify", false)) {
                        geometries.add(((GeometryFeature)feats[i3]).getSpatialAttribute());
                        continue;
                    }
                    String key = feats[i3].getAttribute(keyColumn).getValue().toString();
                    unableFeats.put(key, key);
                }
                Vector<Object> geometriesToSimplify = new Vector<Object>();
                Vector<JGeometry> areaGeometries = new Vector<JGeometry>();
                Vector<JGeometry> lineGeometries = new Vector<JGeometry>();
                Hashtable<Integer, JGeometry> collectionGeoms = new Hashtable<Integer, JGeometry>();
                for (i = 0; i < geometries.size(); ++i) {
                    JGeometry geom = (JGeometry)geometries.get(i);
                    int gtype = geom.getType();
                    if (gtype == 2 || gtype == 6) {
                        lineGeometries.add(geom);
                        continue;
                    }
                    if (gtype == 3 || gtype == 7) {
                        areaGeometries.add(geom);
                        continue;
                    }
                    if (gtype != 4) continue;
                    JGeometry[] elems = geom.getElements();
                    JGeometry g = null;
                    for (int k = 0; k < elems.length; ++k) {
                        int type = elems[k].getType();
                        if (type != 3) continue;
                        g = g == null ? new JGeometry(elems[k].getDimensions() * 1000 + 3, elems[k].getSRID(), elems[k].getElemInfo(), elems[k].getOrdinatesArray()) : JGeometryUtil.addPolygon(g, (JGeometry)elems[k]);
                    }
                    collectionGeoms.put(new Integer(areaGeometries.size()), geom);
                    areaGeometries.add(g);
                }
                if (areaGeometries.size() > 0) {
                    GeometryToolsPane.this.getMainApp().setCursor(Cursor.getPredefinedCursor(3));
                    System.out.println("Building in-memory topology for area geometries...");
                    try {
                        geomSimplify.buildTopology(areaGeometries);
                    }
                    catch (Exception ex) {
                        System.out.println("Exception: " + ex.getMessage());
                        try {
                            geomSimplify.reset();
                        }
                        catch (Exception eg) {
                            eg.printStackTrace();
                        }
                    }
                    finally {
                        GeometryToolsPane.this.getMainApp().setCursor(Cursor.getDefaultCursor());
                    }
                    System.out.println("Done with topology.");
                    spvp.setTopologySet(geomSimplify);
                    Vector<JGeometry> edges = geomSimplify.getTopologyEdgeGeometries();
                    if (edges != null) {
                        for (int i4 = 0; i4 < edges.size(); ++i4) {
                            geometriesToSimplify.add(edges.get(i4));
                        }
                    }
                }
                if (lineGeometries.size() > 0) {
                    for (i = 0; i < lineGeometries.size(); ++i) {
                        geometriesToSimplify.add(lineGeometries.get(i));
                    }
                }
                if (geometriesToSimplify.size() == 0) {
                    ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "There are no geometries to simplify", "Warning_message", 2);
                    return;
                }
                spvp.setGeometries(layer.getDataSource().getName(), geometriesToSimplify.toArray(new JGeometry[geometriesToSimplify.size()]));
                OlafDialog smpDlg = new OlafDialog(canvas.getFrameForDialog(), "Simplify Geometry", spvp);
                smpDlg.setSize(700, 600);
                smpDlg.setVisible(true);
                if (!smpDlg.isCancelled()) {
                    JGeometry[] spgeoms = spvp.getSimplifiedGeometries();
                    if (spgeoms == null || spgeoms.length == 0) {
                        ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "There are no simplified elements to rebuild geometries.", "Warning_message", 2);
                    } else {
                        Vector<JGeometry> outGeometries = new Vector<JGeometry>();
                        Vector<JGeometry> edges = geomSimplify.getTopologyEdgeGeometries();
                        int topoedges = 0;
                        if (edges != null && edges.size() > 0) {
                            topoedges = edges.size();
                            Vector<JGeometry> simpliEdges = new Vector<JGeometry>();
                            for (int i5 = 0; i5 < edges.size(); ++i5) {
                                simpliEdges.add(spgeoms[i5]);
                            }
                            GeometryToolsPane.this.getMainApp().setCursor(Cursor.getPredefinedCursor(3));
                            Vector<JGeometry> polyGeometries = geomSimplify.rebuildSimplifiedGeometries(simpliEdges);
                            GeometryToolsPane.this.getMainApp().setCursor(Cursor.getDefaultCursor());
                            if (polyGeometries != null && polyGeometries.size() > 0) {
                                for (int i6 = 0; i6 < polyGeometries.size(); ++i6) {
                                    outGeometries.add(polyGeometries.get(i6));
                                }
                                if (collectionGeoms.size() > 0) {
                                    Enumeration enumer = collectionGeoms.keys();
                                    while (enumer.hasMoreElements()) {
                                        Integer index = (Integer)enumer.nextElement();
                                        JGeometry indexGeom = (JGeometry)collectionGeoms.get(index);
                                        JGeometry[] elems = indexGeom.getElements();
                                        JGeometry outGeom = (JGeometry)outGeometries.get(index);
                                        for (int i7 = 0; i7 < elems.length; ++i7) {
                                            if (elems[i7].getType() == 1) {
                                                outGeom = JGeometryUtil.addPoint((JGeometry)outGeom, (JGeometry)elems[i7]);
                                                continue;
                                            }
                                            if (elems[i7].getType() != 2) continue;
                                            outGeom = JGeometryUtil.addLine((JGeometry)outGeom, (JGeometry)elems[i7]);
                                        }
                                        outGeometries.set(index, outGeom);
                                    }
                                }
                            }
                        }
                        if (spgeoms.length > topoedges) {
                            for (int i8 = topoedges; i8 < spgeoms.length; ++i8) {
                                outGeometries.add(spgeoms[i8]);
                            }
                        }
                        if (outGeometries != null && outGeometries.size() > 0) {
                            System.out.println("Updating " + outGeometries.size() + " geometries...");
                            ArrayList<String> featKeys = new ArrayList<String>();
                            ArrayList featGeoms = new ArrayList();
                            int count = 0;
                            for (int i9 = 0; i9 < feats.length; ++i9) {
                                String key = feats[i9].getAttribute(keyColumn).getValue().toString();
                                if (unableFeats.get(key) != null) continue;
                                featKeys.add(key);
                                featGeoms.add(outGeometries.get(count++));
                            }
                            GeometryToolsPane.this.getMainApp().setCursor(Cursor.getPredefinedCursor(3));
                            layer.updateObjectsSpatialAttribute(featKeys.toArray(new String[featKeys.size()]), featGeoms.toArray(new JGeometry[featGeoms.size()]));
                            System.out.println("Done with updating geometries");
                            GeometryToolsPane.this.getMainApp().setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                smpDlg.dispose();
                geomSimplify = null;
            }
        });
        this.buffer.setToolTipText(MessagesBundle.getMessage("Tooltip_buffer"));
        this.buffer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point2D pt;
                MapCanvas canvas = GeometryToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                GeometrySetLayer layer = (GeometrySetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (layer == null) {
                    return;
                }
                List<GeoObject> targetObjects = layer.getSelection();
                List<GeoObject> nontargetObjects = canvas.getLayerManager().getAllSelections();
                nontargetObjects.removeAll(targetObjects);
                GeometryFeature feat = null;
                if (targetObjects != null && targetObjects.size() > 0) {
                    feat = (GeometryFeature)targetObjects.get(0);
                } else if (nontargetObjects != null && nontargetObjects.size() > 0) {
                    feat = (GeometryFeature)nontargetObjects.get(0);
                } else {
                    return;
                }
                if (!GeometryToolsPane.this.validateGeometryFeatureForOperation(feat, "buffer", true)) {
                    return;
                }
                JGeometry geom = feat.getSpatialAttribute();
                SRS srs = canvas.getMapRegion().getSRS();
                boolean isGeodetic = false;
                if (srs != null) {
                    isGeodetic = srs.isGeodetic();
                }
                String tooltip = "in data units";
                if (isGeodetic) {
                    tooltip = "in meters";
                }
                if ((pt = EditSessionPanel.getXYOperationValues("Enter buffer values", "Distance:", tooltip, 0.0, "Arc tolerance", tooltip, 0.05, canvas.getFrameForDialog())) == null) {
                    return;
                }
                double distance = pt.getX();
                double arcTol = pt.getY();
                if (distance == 0.0) {
                    return;
                }
                if (arcTol < 0.0) {
                    arcTol = 0.05;
                }
                if (Double.isNaN(distance) || Double.isNaN(arcTol)) {
                    ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "Invalid buffer values (must be numeric).", "Warning", 2);
                    return;
                }
                JGeometry bufferGeom = null;
                try {
                    if (isGeodetic) {
                        boolean distPositive = true;
                        if (distance < 0.0) {
                            distPositive = false;
                        }
                        if (!distPositive) {
                            distance *= -1.0;
                        }
                        bufferGeom = geom.buffer(distance, srs.getSpheroid().getSemiMajorAxis(), 1.0 / srs.getSpheroid().getFlattening(), arcTol);
                    } else {
                        bufferGeom = geom.buffer(distance);
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "Unable to generate buffer. " + ex.getMessage(), "Warning", 0);
                    return;
                }
                if (bufferGeom == null) {
                    ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "Unable to generate buffer.", "Warning", 2);
                    return;
                }
                IndexedGeometrySet dset = (IndexedGeometrySet)layer.getIndexedDataSet();
                String keyColumn = dset.getDataSet().getKeyColumn();
                GeometryFeature gfeat = new GeometryFeature();
                gfeat.setSpatialAttribute(bufferGeom);
                Field[] fields = layer.getFieldsForFeature(gfeat, false);
                if (fields == null || fields.length == 0) {
                    ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), "Non null attributes have not been defined. Buffer feature is discarded.", "Warning", 2);
                    return;
                }
                gfeat.setAttributes(fields);
                String fkey = gfeat.getAttribute(keyColumn).getValue().toString();
                gfeat.setKey(fkey);
                gfeat.setLayer(layer);
                try {
                    layer.insertObject(fkey, gfeat);
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), "Could not insert object", "Error", 2);
                }
                canvas.getLayerManager().clearAllSelections();
            }
        });
        ButtonGroup grp = mainApp.getButtonGroup("toolsBG");
        for (AbstractButton btn : this.buttons) {
            if (btn instanceof JToggleButton) {
                grp.add(btn);
            }
            this.add(btn);
        }
        this.updateUIStatus();
    }

    @Override
    public void updateButtonsStatus() {
        boolean editable;
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer targetLayer = lm.getLayerByTag("targetLayer");
        if (!(targetLayer instanceof GeometrySetLayer)) {
            return;
        }
        List<GeoObject> targetSelected = ((GeometrySetLayer)targetLayer).getSelection();
        boolean bl = editable = targetLayer instanceof EditableLayer && ((EditableLayer)targetLayer).isEditable();
        if (targetSelected.size() == 1) {
            this.viewgeomelems.setEnabled(true);
            if (editable) {
                this.buffer.setEnabled(true);
            }
        }
        if (targetSelected.size() >= 1 && editable) {
            this.validategeom.setEnabled(true);
            this.simplify.setEnabled(true);
        }
    }

    private boolean validateGeometryFeatureForOperation(AbstractFeature feat, String op, boolean popupError) {
        if (feat == null || op == null) {
            return false;
        }
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return false;
        }
        if (!(feat instanceof GeometryFeature)) {
            if (!popupError) {
                return false;
            }
            ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getFormattedMessage("Cannot_apply_geometry_operation", op), MessagesBundle.getMessage("Warning"), 2);
            return false;
        }
        JGeometry geom = ((GeometryFeature)feat).getSpatialAttribute();
        if (geom == null) {
            if (!popupError) {
                return false;
            }
            ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getFormattedMessage("Cannot_apply_geometry_operation_innull", op), MessagesBundle.getMessage("Warning"), 2);
            return false;
        }
        Rectangle2D gmbr = feat.getMBR();
        if (gmbr == null) {
            if (!popupError) {
                return false;
            }
            ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getFormattedMessage("Cannot_apply_geometry_operation_withnullmbr", op), MessagesBundle.getMessage("Warning"), 2);
            return false;
        }
        if (op != null && op.equalsIgnoreCase("simplify")) {
            int gtype = geom.getType();
            if (gtype != 2 && gtype != 6 && gtype != 3 && gtype != 7 && gtype != 4) {
                if (!popupError) {
                    return false;
                }
                return false;
            }
            if (gtype == 4) {
                JGeometry[] elems = geom.getElements();
                if (elems == null || elems.length == 0) {
                    return false;
                }
                boolean hasPolygon = false;
                for (int i = 0; i < elems.length; ++i) {
                    if (elems[i].getType() != 3) continue;
                    hasPolygon = true;
                    break;
                }
                if (!hasPolygon) {
                    return false;
                }
            }
        }
        return true;
    }

    private class ValidateDialogRunnable
    implements Runnable {
        private MapCanvas canvas = null;
        private GeometrySetLayer layer = null;
        private Hashtable<String, AbstractFeature> invalidFeatures = null;
        private Hashtable<String, String> invFeats = null;

        public ValidateDialogRunnable(MapCanvas canvas, GeometrySetLayer layer, Hashtable<String, AbstractFeature> invalidFeatures, Hashtable<String, String> invFeats) {
            this.canvas = canvas;
            this.layer = layer;
            this.invalidFeatures = invalidFeatures;
            this.invFeats = invFeats;
        }

        @Override
        public void run() {
            if (this.invFeats.size() == 0) {
                ErrorDialog.showErrorDialog(null, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("All_selected_features_are_valid"), MessagesBundle.getMessage("Information"), 1);
            } else {
                Layer gsLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
                InvalidGeometryPanel ivp = new InvalidGeometryPanel(this.layer.getDataSource().getDataAccessObject(), (IndexedGeometrySet)this.layer.getIndexedDataSet(), this.invalidFeatures, this.canvas, (GeometrySetLayer)gsLayer);
                ivp.updateTable(this.invFeats);
                OlafDialog ivpDlg = new OlafDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Invalid_geometries"), ivp, 0.9f);
                ivpDlg.setSize(600, 400);
                ivpDlg.setAsCloseSelection(true);
                ivpDlg.setVisible(true);
                ivpDlg.dispose();
                if (gsLayer != null) {
                    ((GeometrySetLayer)gsLayer).setHighliteGeometries(null);
                }
            }
        }
    }
}

