/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.graphics.ShadowRenderer;
import oracle.maps.util.RenderUtils;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mapviewer.share.TopologyRelation;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextLabeler;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;
import oracle.spatial.edit.index.topology.IndexedTopologyModel;
import oracle.spatial.edit.index.topology.IndexedTopologySet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.model.topology.TopologySet;
import oracle.spatial.edit.producer.TopologyPrimitivesProducer;
import oracle.spatial.edit.producer.TopologySetProducer;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Node;
import org.w3c.dom.Element;

public class TopologySetLayer
extends AbstractDataSetLayer {
    public static final String PROPERTY_TOPOLOGY = "oracle.spatial.edit.layer.TopologySetLayer.topology";
    private IndexedTopologyModel indexedModel = null;
    private String nodeRenderStyle = null;
    private String nodeLabelStyle = null;
    private String edgeRenderStyle = null;
    private String edgeLabelStyle = null;
    private String faceRenderStyle = null;
    private String faceLabelStyle = null;
    private TopologySetLayer childLayer = null;
    private TopologySetLayer parentLayer = null;
    private static int nextGeomID = -1;
    private static Hashtable<String, TopologyModel> topoModels = new Hashtable();
    private static Hashtable<String, IndexedTopologyModel> indexedTopoModels = new Hashtable();
    private static Hashtable<String, TopologyPrimitivesProducer> topoPrimProducers = new Hashtable();
    private static Vector<TopologyPrimitiveLayer> topoPrimLayers = new Vector();
    private static Vector<TopologySetLayer> topoSetLayers = new Vector();
    private static Hashtable<String, TopologySetLayer> topoModelLayerIds = new Hashtable();
    private static Hashtable<String, TopologySetLayer> missingChildLayerIdLink = new Hashtable();

    public TopologySetLayer(MapCanvas canvas, IndexedTopologySet set, IndexedTopologyModel model) {
        super(canvas);
        this.indexedSet = set;
        if (this.indexedSet != null) {
            this.indexedSet.setDataSetLayer(this);
        }
        this.indexedModel = model;
    }

    public TopologySetLayer() {
        this(null, null, null);
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("ora_topoThemeItem.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        String topology = this.getProperty("topology");
        TopologyModel topoModel = topoModels.get(topology.toUpperCase());
        boolean newTopoModel = false;
        if (topoModel == null) {
            topoModel = new TopologyModel(topology, this.canvas.getUndoManager());
            topoModels.put(topology.toUpperCase(), topoModel);
            newTopoModel = true;
        }
        int mode = AbstractDataSet.READ_ONLY_SET;
        if (this.isEditable()) {
            mode = AbstractDataSet.READ_WRITE_SET;
        }
        if (newTopoModel) {
            try {
                topoModel.load(this.dataSource.getDataAccessObject(), this.canvas.getMapRegion().getDataWindow(), this.getWorkspace().getName(), mode);
            }
            catch (MDSException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                System.out.println(MessagesBundle.getFormattedMessage("Unable_toload_topology_model", topology));
                ex.printStackTrace();
            }
        }
        TopologySet topoSet = new TopologySet(this.getName(), topoModel);
        String baseTable = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String keyColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
        String spatialColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        topoSet.setSpatialInfo(baseTable, keyColumn, spatialColumn);
        String queryCondition = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
        topoSet.setQueryCondition(queryCondition);
        String keySequence = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence");
        topoSet.setSequenceName(keySequence);
        try {
            topoSet.loadData(this.dataSource.getDataAccessObject(), this.canvas.getMapRegion().getDataWindow(), this.getWorkspace(), mode);
            topoModel.updateTopologySetChildHierarchy(topoSet);
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println(MessagesBundle.getFormattedMessage("Unable_toload_topology_set", this.getName()));
            ex.printStackTrace();
        }
        AbstractDataAccessObject da = null;
        TopologyMetadata topoMeta = null;
        try {
            topoMeta = topoSet.getMetadata();
            da = this.dataSource.getDataAccessObject();
            da.openConnection();
            if (!da.sequenceExists(topoMeta.getTopoGeometrySequence())) {
                da.createSequence(topoMeta.getTopoGeometrySequence(), 1L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception eda) {}
        }
        IndexedTopologySet indexedSet = new IndexedTopologySet(topoSet);
        indexedSet.setDataSetLayer(this);
        IndexedTopologyModel indexedModel = indexedTopoModels.get(topology.toUpperCase());
        if (indexedModel == null) {
            indexedModel = new IndexedTopologyModel(topoSet.getTopologyModel());
            indexedTopoModels.put(topology.toUpperCase(), indexedModel);
        }
        topoSetLayers.add(this);
        TopologyPrimitivesProducer primProducer = topoPrimProducers.get(topology.toUpperCase());
        if (primProducer == null) {
            primProducer = new TopologyPrimitivesProducer(this.dataSource, indexedModel);
            topoPrimProducers.put(topology.toUpperCase(), primProducer);
        }
        TopologySetProducer idxprod = new TopologySetProducer(this, primProducer);
        this.setGeoDataProducer(idxprod);
        int layerId = topoMeta.getTopoLayerId();
        int childLayerId = topoMeta.getChildLayerId();
        if (childLayerId != 0) {
            TopologySetLayer ly = topoModelLayerIds.get(topology.toUpperCase() + "_" + childLayerId);
            if (ly != null) {
                this.setChildLayer(ly);
            } else {
                missingChildLayerIdLink.put(topology.toUpperCase() + "_" + childLayerId, this);
            }
        } else {
            TopologySetLayer parently = missingChildLayerIdLink.get(topology.toUpperCase() + "_" + layerId);
            if (parently != null) {
                parently.setChildLayer(this);
            }
        }
        topoModelLayerIds.put(topology.toUpperCase() + "_" + layerId, this);
    }

    @Override
    public ThemeDescriptor getThemeDescriptor() {
        ThemeDescriptor td = new ThemeDescriptor();
        td.name = this.getName();
        td.type = 7;
        td.topologyName = this.getProperty("topology");
        td.featureTableName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        td.spatialColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        td.renderStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        td.labelColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn");
        td.labelStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle");
        td.SRID = this.getSRID();
        String query = "select " + td.spatialColumn;
        if (td.labelColumn != null && td.labelColumn.trim().length() > 0) {
            query = query + "," + td.labelColumn.trim();
        }
        query = query + " from " + td.featureTableName;
        td.WFS_queryCondition = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
        if (td.WFS_queryCondition != null && td.WFS_queryCondition.trim().length() > 0) {
            query = query + " where " + td.WFS_queryCondition.trim();
        }
        td.query = query;
        td.nodeStyle = this.getProperty("nodeRenderStyle");
        td.nodeLabelStyle = this.getProperty("nodeLabelStyle");
        td.linkStyle = this.getProperty("edgeRenderStyle");
        td.edgeLabelStyle = this.getProperty("edgeLabelStyle");
        td.faceStyle = this.getProperty("faceRenderStyle");
        td.faceLabelStyle = this.getProperty("faceLabelStyle");
        return td;
    }

    @Override
    protected String getModelString() {
        return "topology:" + this.getProperty(PROPERTY_TOPOLOGY);
    }

    public IndexedTopologyModel getIndexedTopologyModel() {
        return this.indexedModel;
    }

    public TopologySetLayer getChildLayer() {
        return this.childLayer;
    }

    public void setChildLayer(TopologySetLayer layer) {
        this.childLayer = layer;
        layer.parentLayer = this;
    }

    @Override
    public long render(Graphics2D g) {
        if (this.indexedModel == null || this.indexedModel.getTopologyModel() == null) {
            return 0L;
        }
        return super.render(g);
    }

    @Override
    public void renderFeature(Graphics2D g, AbstractFeature feat, AffineTransform at, Style style) {
    }

    @Override
    protected void doRealRendering() {
        String renderStyle = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        if (renderStyle == null) {
            return;
        }
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        BufferedImage tmpImg = new BufferedImage(w, h, 2);
        StyleModel styModel = StyleModelUtils.getStyleModel(renderStyle);
        Style style = StyleFactory.createStyleFromXML((String)styModel.toXMLString());
        long t1 = System.currentTimeMillis();
        Graphics2D g = tmpImg.createGraphics();
        AffineTransform xfm = this.canvas.getViewportTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        List<GeoObject> data = this.indexedSet.getFeatures(this.canvas.getMapRegion().getDataWindow());
        for (GeoObject o : data) {
            if (this.myDeleteObjects.size() > 0 && this.myDeleteObjects.get(o.getKey().toString()) != null || (targetLayer == null || this == targetLayer) && this.isSelected(o)) continue;
            RenderUtils.renderTopologyObject(g, xfm, (TopologyFeature)o, style);
        }
        Enumeration enumer = this.myNewObjects.elements();
        while (enumer.hasMoreElements()) {
            GeoObject o;
            o = (GeoObject)enumer.nextElement();
            if ((targetLayer == null || this == targetLayer) && this.isSelected(o)) continue;
            RenderUtils.renderTopologyObject(g, xfm, (TopologyFeature)o, style);
        }
        if (this.nodeRenderStyle != null || this.edgeRenderStyle != null || this.faceRenderStyle != null || this.nodeLabelStyle != null || this.edgeLabelStyle != null || this.faceLabelStyle != null) {
            StyledFeature sf;
            Drawable dr;
            JGeometry geom;
            int i;
            VisContext vc = null;
            if (this.nodeLabelStyle != null || this.edgeLabelStyle != null || this.faceLabelStyle != null) {
                vc = new VisContext();
                vc.setCRArray(new RectArray(10));
                vc.setMarkerCRArray(new RectArray(10));
                vc.setRenderedMarkerCRArray(new RectArray(10));
                try {
                    vc.setDeviceWindow((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Rectangle2D rect = this.canvas.getMapRegion().getDataWindow();
            ArrayList faces = null;
            ArrayList edges = null;
            ArrayList nodes = null;
            if (this.nodeRenderStyle != null || this.nodeLabelStyle != null) {
                nodes = new ArrayList();
            }
            if (this.edgeRenderStyle != null || this.edgeLabelStyle != null) {
                edges = new ArrayList();
            }
            if (this.faceRenderStyle != null || this.faceLabelStyle != null) {
                faces = new ArrayList();
            }
            this.indexedModel.getTopologyModel().getTopologyPrimitives(rect, nodes, edges, faces);
            if (this.faceRenderStyle != null || this.faceLabelStyle != null) {
                Style fcStyle = null;
                StyleText fclbstyle = null;
                if (this.faceRenderStyle != null) {
                    StyleModel fcstyModel = StyleModelUtils.getStyleModel(this.faceRenderStyle);
                    fcStyle = StyleFactory.createStyleFromXML((String)fcstyModel.toXMLString());
                }
                if (this.faceLabelStyle != null) {
                    StyleModel txtmodel = StyleModelUtils.getStyleModel(this.faceLabelStyle);
                    fclbstyle = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
                }
                for (i = 0; i < faces.size(); ++i) {
                    int fid = ((Face)faces.get(i)).getID();
                    geom = this.indexedModel.getTopologyModel().getFaceGeometry(fid);
                    if (geom == null || (dr = Drawable.createDrawable(geom, xfm)) == null || dr.getShape() == null) continue;
                    if (fcStyle != null) {
                        try {
                            fcStyle.apply(null, g, dr.getShape(), geom.getType(), null, null, null, null, null);
                        }
                        catch (StyleNotApplicableException ex) {
                            // empty catch block
                        }
                    }
                    if (fclbstyle == null) continue;
                    sf = new StyledFeature();
                    sf.setGeometry(JSDOGeometry.recast((JGeometry)geom));
                    sf.setShape(dr.getShape());
                    try {
                        TextLabeler.applyTextLabel((Graphics2D)g, (StyledFeatureI)sf, (StyleText)fclbstyle, (String)("" + fid), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                        continue;
                    }
                    catch (StyleNotApplicableException ex) {
                        // empty catch block
                    }
                }
            }
            if (this.edgeRenderStyle != null || this.edgeLabelStyle != null) {
                Style edStyle = null;
                StyleText edlbstyle = null;
                if (this.edgeRenderStyle != null) {
                    StyleModel edstyModel = StyleModelUtils.getStyleModel(this.edgeRenderStyle);
                    edStyle = StyleFactory.createStyleFromXML((String)edstyModel.toXMLString());
                }
                if (this.edgeLabelStyle != null) {
                    StyleModel txtmodel = StyleModelUtils.getStyleModel(this.edgeLabelStyle);
                    edlbstyle = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
                }
                for (i = 0; i < edges.size(); ++i) {
                    int eid = ((Edge)edges.get(i)).getId();
                    geom = this.indexedModel.getTopologyModel().getEdgeGeometry(eid);
                    if (geom == null || (dr = Drawable.createDrawable(geom, xfm)) == null || dr.getShape() == null) continue;
                    if (edStyle != null) {
                        try {
                            edStyle.apply(null, g, dr.getShape(), geom.getType(), null, null, null, null, null);
                        }
                        catch (StyleNotApplicableException ex) {
                            // empty catch block
                        }
                    }
                    if (edlbstyle == null) continue;
                    sf = new StyledFeature();
                    sf.setGeometry(JSDOGeometry.recast((JGeometry)geom));
                    sf.setShape(dr.getShape());
                    try {
                        TextLabeler.applyTextLabel((Graphics2D)g, (StyledFeatureI)sf, (StyleText)edlbstyle, (String)("" + eid), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                        continue;
                    }
                    catch (StyleNotApplicableException ex) {
                        // empty catch block
                    }
                }
            }
            if (this.nodeRenderStyle != null || this.nodeLabelStyle != null) {
                Style ndStyle = null;
                StyleText ndlbstyle = null;
                if (this.nodeRenderStyle != null) {
                    StyleModel ndstyModel = StyleModelUtils.getStyleModel(this.nodeRenderStyle);
                    ndStyle = StyleFactory.createStyleFromXML((String)ndstyModel.toXMLString());
                }
                if (this.nodeLabelStyle != null) {
                    StyleModel txtmodel = StyleModelUtils.getStyleModel(this.nodeLabelStyle);
                    ndlbstyle = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
                }
                for (int i2 = 0; i2 < nodes.size(); ++i2) {
                    int nid = ((Node)nodes.get(i2)).getId();
                    geom = this.indexedModel.getTopologyModel().getNodeGeometry(nid);
                    if (geom == null || (dr = Drawable.createDrawable(geom, xfm)) == null || dr.getPoint() == null) continue;
                    if (ndStyle != null) {
                        RenderUtils.renderStyledPoint(g, ndStyle, dr.getPoint(), 0.0);
                    }
                    if (ndlbstyle == null) continue;
                    sf = new StyledFeature();
                    sf.setGeometry(JSDOGeometry.recast((JGeometry)geom));
                    sf.setPoint(dr.getPoint());
                    try {
                        TextLabeler.applyTextLabel((Graphics2D)g, (StyledFeatureI)sf, (StyleText)ndlbstyle, (String)("" + nid), (boolean)true, (boolean)true, (boolean)false, (VisContext)vc);
                        continue;
                    }
                    catch (StyleNotApplicableException ex) {
                        // empty catch block
                    }
                }
            }
        }
        g.dispose();
        this.liveImg = tmpImg;
        long t2 = System.currentTimeMillis();
        System.out.println(this.getName() + "(" + this.getClass().getSimpleName() + "): Time spent on actual rendering: " + (t2 - t1) + "ms.");
    }

    @Override
    protected void renderHoverShape(GeoObject object, Shape shape, Graphics2D dest, AffineTransform transf) {
        Rectangle2D mbr = shape.getBounds2D();
        int x = (int)mbr.getMinX();
        int y = (int)mbr.getMinY();
        int w = (int)mbr.getWidth() + 1;
        int h = (int)mbr.getHeight() + 1;
        TopologyGeometry tpgeom = ((TopologyFeature)object).getSpatialAttribute();
        if (tpgeom == null) {
            return;
        }
        JGeometry[] geoms = tpgeom.getGeometries(((TopologyFeature)object).getTopologyModel());
        if (geoms == null || geoms.length == 0) {
            return;
        }
        int cvw_offset = 0;
        if (this.canvas.getWidth() < (int)mbr.getWidth()) {
            cvw_offset = (int)mbr.getWidth() - this.canvas.getWidth();
        }
        if (x + w > this.canvas.getWidth()) {
            cvw_offset -= x + w - this.canvas.getWidth();
        }
        int cvh_offset = 0;
        if (this.canvas.getHeight() < (int)mbr.getHeight()) {
            cvh_offset = (int)mbr.getHeight() - this.canvas.getHeight();
        }
        if (y + h > this.canvas.getHeight()) {
            cvh_offset -= y + h - this.canvas.getHeight();
        }
        int imgW = Math.min((int)mbr.getWidth(), this.canvas.getWidth());
        int imgH = Math.min((int)mbr.getHeight(), this.canvas.getHeight());
        if (imgW <= 0) {
            imgW = 1;
        }
        if (imgH <= 0) {
            imgH = 1;
        }
        BufferedImage image = new BufferedImage(imgW, imgH, 2);
        Graphics2D g = image.createGraphics();
        g.translate(-x - cvw_offset, -y - cvh_offset);
        for (int j = 0; j < geoms.length; ++j) {
            int gType = geoms[j].getType();
            if (gType == 3 || gType == 7) {
                g.setColor(this.hoverColor);
                g.fill(shape);
                g.setColor(this.hoverBorderColor);
                g.setStroke(this.hoverStroke);
                g.draw(shape);
                continue;
            }
            if (gType == 2 || gType == 6) {
                g.setColor(this.hoverBorderColor);
                g.setStroke(this.hoverStroke);
                g.draw(shape);
                continue;
            }
            if (gType == 4) {
                GeneralPath lines = new GeneralPath();
                GeneralPath rings = new GeneralPath();
                ShapeUtil.extractLinesAndRings((Shape)shape, (GeneralPath)lines, (GeneralPath)rings);
                g.setColor(this.hoverColor);
                g.fill(rings);
                g.setColor(this.hoverBorderColor);
                g.setStroke(this.hoverStroke);
                g.draw(rings);
                g.setColor(this.hoverBorderColor);
                g.setStroke(this.hoverStroke);
                g.draw(lines);
                JGeometry[] elems = geoms[j].getElements();
                if (elems == null || elems.length <= 0) continue;
                for (int i = 0; i < elems.length; ++i) {
                    if (elems[i].getType() != 1) continue;
                    Point2D p2 = elems[i].getJavaPoint();
                    Point2D p2new = (Point2D)p2.clone();
                    transf.transform(p2, p2new);
                    this.renderHoverPoint(p2new, g);
                }
                continue;
            }
            if (gType != 5) continue;
            float[] segCoords = new float[6];
            PathIterator pi = shape.getPathIterator(null);
            int index = 0;
            while (!pi.isDone()) {
                int t = pi.currentSegment(segCoords);
                if (t == 0 || t == 1) {
                    Point2D.Double pt = new Point2D.Double(segCoords[0], segCoords[1]);
                    this.renderHoverPoint(pt, g);
                }
                pi.next();
                ++index;
            }
        }
        g.dispose();
        ShadowRenderer sr = new ShadowRenderer();
        BufferedImage shadow = sr.createShadow(image);
        dest.drawImage((Image)shadow, (int)mbr.getMinX() + cvw_offset, (int)mbr.getMinY() + cvh_offset, null);
        dest.drawImage((Image)image, (int)mbr.getMinX() + cvw_offset, (int)mbr.getMinY() + cvh_offset, null);
        shadow = null;
        image = null;
    }

    @Override
    public int transformFeatures(GeoObject[] features, AffineTransform at) {
        if (features == null || features.length == 0) {
            return 0;
        }
        return 0;
    }

    public void setNodeRenderStyle(String style) {
        this.nodeRenderStyle = style;
    }

    public void setNodeLabelStyle(String style) {
        this.nodeLabelStyle = style;
    }

    public void setEdgeRenderStyle(String style) {
        this.edgeRenderStyle = style;
    }

    public void setEdgeLabelStyle(String style) {
        this.edgeLabelStyle = style;
    }

    public void setFaceRenderStyle(String style) {
        this.faceRenderStyle = style;
    }

    public void setFaceLabelStyle(String style) {
        this.faceLabelStyle = style;
    }

    public void updateTopologyPrimitiveStyles(String ndRenderStyle, String ndLabelStyle, String egRenderStyle, String egLabelStyle, String fcRenderStyle, String fcLabelStyle) {
        boolean hasChanges = false;
        if (this.nodeRenderStyle == null && ndRenderStyle != null || this.nodeRenderStyle != null && ndRenderStyle == null || this.nodeRenderStyle != null && ndRenderStyle != null && !this.nodeRenderStyle.equalsIgnoreCase(ndRenderStyle) || this.nodeLabelStyle == null && ndLabelStyle != null || this.nodeLabelStyle != null && ndLabelStyle == null || this.nodeLabelStyle != null && ndLabelStyle != null && !this.nodeLabelStyle.equalsIgnoreCase(ndLabelStyle)) {
            hasChanges = true;
        }
        if (this.edgeRenderStyle == null && egRenderStyle != null || this.edgeRenderStyle != null && egRenderStyle == null || this.edgeRenderStyle != null && egRenderStyle != null && !this.edgeRenderStyle.equalsIgnoreCase(egRenderStyle) || this.edgeLabelStyle == null && egLabelStyle != null || this.edgeLabelStyle != null && egLabelStyle == null || this.edgeLabelStyle != null && egLabelStyle != null && !this.edgeLabelStyle.equalsIgnoreCase(egLabelStyle)) {
            hasChanges = true;
        }
        if (this.faceRenderStyle == null && fcRenderStyle != null || this.faceRenderStyle != null && fcRenderStyle == null || this.faceRenderStyle != null && fcRenderStyle != null && !this.faceRenderStyle.equalsIgnoreCase(fcRenderStyle) || this.faceLabelStyle == null && fcLabelStyle != null || this.faceLabelStyle != null && fcLabelStyle == null || this.faceLabelStyle != null && fcLabelStyle != null && !this.faceLabelStyle.equalsIgnoreCase(fcLabelStyle)) {
            hasChanges = true;
        }
        this.nodeRenderStyle = ndRenderStyle;
        this.nodeLabelStyle = ndLabelStyle;
        this.edgeRenderStyle = egRenderStyle;
        this.edgeLabelStyle = egLabelStyle;
        this.faceRenderStyle = fcRenderStyle;
        this.faceLabelStyle = fcLabelStyle;
        if (hasChanges) {
            this.fireStateChanged();
        }
    }

    public boolean addPrimitiveGeometry(JGeometry primitive) throws Exception {
        if (primitive == null || primitive.getType() != 1 && primitive.getType() != 2 && primitive.getType() != 3) {
            throw new Exception("Null topology primitive or invalid primitive type.");
        }
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            throw new Exception("Topology model is null.");
        }
        double[] mbr = primitive.getMBR();
        boolean status = false;
        this.startChangeBlock("topo add", null);
        try {
            status = tpmodel.addPrimitiveGeometry(primitive);
            if (status) {
                Edge[] edges;
                if (mbr != null && (edges = tpmodel.searchEdges(new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]))) != null && edges.length > 0) {
                    for (int i = 0; i < edges.length; ++i) {
                        this.indexedModel.removeEdgeSegmentTree(edges[i].getId());
                    }
                }
                this.fireStateChanged();
                this.refreshPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock("topo add", null);
        }
        return status;
    }

    public boolean removeNode(int nodeId) throws Exception {
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            return false;
        }
        Rectangle2D mbr = tpmodel.getNodeMBR(nodeId);
        this.startChangeBlock("node remove", null);
        boolean status = false;
        try {
            status = tpmodel.removeNode(nodeId);
            if (status) {
                Edge[] edges;
                if (mbr != null && (edges = tpmodel.searchEdges(mbr)) != null && edges.length > 0) {
                    for (int i = 0; i < edges.length; ++i) {
                        this.indexedModel.removeEdgeSegmentTree(edges[i].getId());
                    }
                }
                this.fireStateChanged();
                this.refreshPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.startChangeBlock("node remove", null);
        }
        return status;
    }

    public boolean removeEdge(int edgeId) throws Exception {
        TopologyModel tpmodel = this.indexedModel.getTopologyModel();
        if (tpmodel == null) {
            return false;
        }
        this.startChangeBlock("edge remove", null);
        boolean status = false;
        try {
            status = tpmodel.removeEdge(edgeId);
            if (status) {
                this.indexedModel.removeEdgeSegmentTree(edgeId);
                this.fireStateChanged();
                this.refreshPrimitives();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock("edge remove", null);
        }
        return status;
    }

    public boolean assignPrimitiveToFeature(String key, int topoId, int topoType) throws Exception {
        if (key == null) {
            throw new Exception("Feature key is null.");
        }
        TopologyFeature feature = (TopologyFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("Unable to get feature for key [" + key + "].");
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom == null) {
            throw new Exception("Feature topology geometry is null.");
        }
        if (tpgeom.hasTopoPrimitive(topoId, topoType)) {
            throw new Exception("Topo primitive is already assigned to feature.");
        }
        TopologyGeometry tpgeomChange = (TopologyGeometry)tpgeom.clone();
        if (tpgeomChange == null) {
            throw new Exception("Unable to copy feature topology geometry.");
        }
        if (!tpgeomChange.addTopoPrimitive(topoId, topoType)) {
            throw new Exception("Unable to add topology primitive to feature.");
        }
        tpgeomChange.clearMBR();
        tpgeomChange.clearGeometries();
        this.indexedSet.updateSpatialAttribute(key, tpgeomChange);
        this.fireStateChanged();
        return true;
    }

    public boolean removePrimitiveFromFeature(String key, int topoId, int topoType) throws Exception {
        if (key == null) {
            throw new Exception("Feature key is null.");
        }
        TopologyFeature feature = (TopologyFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("Unable to get feature for key [" + key + "].");
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom == null) {
            throw new Exception("Feature topology geometry is null.");
        }
        if (!tpgeom.hasTopoPrimitive(topoId, topoType)) {
            throw new Exception("Topo primitive is not assigned to feature.");
        }
        TopologyGeometry tpgeomChange = (TopologyGeometry)tpgeom.clone();
        if (tpgeomChange == null) {
            throw new Exception("Unable to copy feature topology geometry.");
        }
        if (!tpgeomChange.removeTopoPrimitive(topoId, topoType)) {
            throw new Exception("Unable to remove topology primitive from feature.");
        }
        tpgeomChange.clearMBR();
        tpgeomChange.clearGeometries();
        this.indexedSet.updateSpatialAttribute(key, tpgeomChange);
        this.fireStateChanged();
        return true;
    }

    public boolean assignChildFeatureToFeature(String key, int layerId, int childfeatureId) throws Exception {
        if (key == null) {
            throw new Exception("Feature key is null.");
        }
        TopologyFeature feature = (TopologyFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("Unable to get feature for key [" + key + "].");
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom == null) {
            throw new Exception("Feature topology geometry is null.");
        }
        if (tpgeom.hasChildFeature(layerId, childfeatureId)) {
            throw new Exception("Topo child feature is already assigned to feature.");
        }
        TopologyGeometry tpgeomChange = (TopologyGeometry)tpgeom.clone();
        if (tpgeomChange == null) {
            throw new Exception("Unable to copy feature topology geometry.");
        }
        if (!tpgeomChange.addChildFeature(layerId, childfeatureId)) {
            throw new Exception("Unable to add topology child feature to feature.");
        }
        tpgeomChange.clearMBR();
        tpgeomChange.clearGeometries();
        this.indexedSet.updateSpatialAttribute(key, tpgeomChange);
        this.fireStateChanged();
        return true;
    }

    public boolean assignChildFeaturesToFeature(String key, TopoChildFeatureDescriptor[] childFeatures) throws Exception {
        if (key == null) {
            throw new Exception("Feature key is null.");
        }
        if (childFeatures == null || childFeatures.length == 0) {
            throw new Exception("There are no child feature to assign.");
        }
        TopologyFeature feature = (TopologyFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("Unable to get feature for key [" + key + "].");
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom == null) {
            throw new Exception("Feature topology geometry is null.");
        }
        TopologyGeometry tpgeomChange = (TopologyGeometry)tpgeom.clone();
        if (tpgeomChange == null) {
            throw new Exception("Unable to copy feature topology geometry.");
        }
        int processed = 0;
        for (int i = 0; i < childFeatures.length; ++i) {
            int childfeatureId;
            int layerId = childFeatures[i].getLayerId();
            if (tpgeom.hasChildFeature(layerId, childfeatureId = childFeatures[i].getFeatureId())) continue;
            if (!tpgeomChange.addChildFeature(layerId, childfeatureId)) {
                throw new Exception("Unable to add topology child feature [" + layerId + "," + childfeatureId + "] to feature.");
            }
            ++processed;
        }
        if (processed == 0) {
            throw new Exception("No features were added.");
        }
        tpgeomChange.clearMBR();
        tpgeomChange.clearGeometries();
        this.indexedSet.updateSpatialAttribute(key, tpgeomChange);
        this.fireStateChanged();
        return true;
    }

    public boolean removeChildFeatureFromFeature(String key, int layerId, int childfeatureId) throws Exception {
        if (key == null) {
            throw new Exception("Feature key is null.");
        }
        TopologyFeature feature = (TopologyFeature)this.indexedSet.getDataSet().getFeature(key);
        if (feature == null) {
            throw new Exception("Unable to get feature for key [" + key + "].");
        }
        TopologyGeometry tpgeom = feature.getSpatialAttribute();
        if (tpgeom == null) {
            throw new Exception("Feature topology geometry is null.");
        }
        if (!tpgeom.hasChildFeature(layerId, childfeatureId)) {
            throw new Exception("Topo child feature is not assigned to feature.");
        }
        TopologyGeometry tpgeomChange = (TopologyGeometry)tpgeom.clone();
        if (tpgeomChange == null) {
            throw new Exception("Unable to copy feature topology geometry.");
        }
        if (!tpgeomChange.removeChildFeature(layerId, childfeatureId)) {
            throw new Exception("Unable to remove topology child feature from feature.");
        }
        tpgeomChange.clearMBR();
        tpgeomChange.clearGeometries();
        this.indexedSet.updateSpatialAttribute(key, tpgeomChange);
        this.fireStateChanged();
        return true;
    }

    @Override
    public boolean isModified() {
        TopologyModel model;
        if (this.indexedModel != null && (model = this.indexedModel.getTopologyModel()) != null && model.isModified()) {
            return true;
        }
        return super.isModified();
    }

    public boolean canRemoveFeatures(String[] featKeys) throws Exception {
        if (featKeys == null || featKeys.length == 0) {
            throw new Exception("No features to be verified. Input feature array is null or empty.");
        }
        if (this.indexedModel == null) {
            throw new Exception("Indexed topology model is null.");
        }
        TopologyModel model = this.indexedModel.getTopologyModel();
        if (model == null) {
            throw new Exception("Topology model is null.");
        }
        if (this.indexedSet.getDataSet() == null) {
            throw new Exception("Data set is null for this topology layer.");
        }
        if (this.parentLayer == null) {
            TopologySet set = (TopologySet)this.indexedSet.getDataSet();
            TopologyMetadata meta = set.getMetadata();
            if (meta == null) {
                throw new Exception("Topology set metadata is null.");
            }
            AbstractDataAccessObject da = model.getDataAccess();
            if (da == null) {
                throw new Exception("Data access for topology model is null");
            }
            try {
                da.openConnection();
                for (int i = 0; i < featKeys.length; ++i) {
                    TopologyRelation[] relations;
                    TopologyGeometry tpgeom;
                    TopologyFeature lf = (TopologyFeature)this.indexedSet.getDataSet().getFeature(featKeys[i]);
                    if (lf == null || (tpgeom = lf.getSpatialAttribute()) == null || (relations = da.getRelationsForTopologyChildFeature(model.getName(), tpgeom.getLayerId(), tpgeom.getId(), this.getWorkspace())) == null || relations.length <= 0) continue;
                    throw new Exception("Feature " + featKeys[i] + " cannot be removed as it is assigned to a high level feature");
                }
            }
            catch (Exception ex) {
                throw ex;
            }
            catch (MDSException me) {
                throw new Exception(me.getMessage());
            }
            finally {
                try {
                    da.closeConnection();
                }
                catch (Exception e) {}
            }
            return true;
        }
        Rectangle2D searchMbr = null;
        for (int i = 0; i < featKeys.length; ++i) {
            Rectangle2D mbr;
            TopologyFeature feature = (TopologyFeature)this.indexedSet.getDataSet().getFeature(featKeys[i]);
            if (feature == null || (mbr = feature.getMBR()) == null) continue;
            if (searchMbr == null) {
                searchMbr = mbr;
                continue;
            }
            searchMbr.add(mbr);
        }
        if (searchMbr == null) {
            return true;
        }
        List<GeoObject> features = this.parentLayer.getIndexedDataSet().getFeatures(searchMbr);
        if (features == null || features.size() == 0) {
            return true;
        }
        for (int i = 0; i < featKeys.length; ++i) {
            TopologyGeometry tpgeom;
            TopologyFeature lf = (TopologyFeature)this.indexedSet.getDataSet().getFeature(featKeys[i]);
            if (lf == null || (tpgeom = lf.getSpatialAttribute()) == null) continue;
            int featureId = tpgeom.getId();
            int layerId = tpgeom.getLayerId();
            for (int j = 0; j < features.size(); ++j) {
                TopologyFeature hf = (TopologyFeature)features.get(j);
                TopologyGeometry tg = hf.getSpatialAttribute();
                if (tg == null || !tg.hasChildFeature(layerId, featureId)) continue;
                throw new Exception("Feature " + featKeys[i] + " cannot be removed as it is assigned to a high level feature");
            }
        }
        return true;
    }

    private void refreshPrimitives() {
        if (this.liveProducer != null && this.liveProducer instanceof TopologySetProducer) {
            TopologyPrimitivesProducer primProd = ((TopologySetProducer)this.liveProducer).getTopologyPrimitivesProducer();
            if (primProd == null) {
                return;
            }
            if (primProd.getFacesLayer() != null) {
                primProd.getFacesLayer().refreshPaint();
            }
            if (primProd.getEdgesLayer() != null) {
                primProd.getEdgesLayer().refreshPaint();
            }
            if (primProd.getNodesLayer() != null) {
                primProd.getNodesLayer().refreshPaint();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof TopologyPrimitiveLayer) {
            this.setToUpdate();
        } else {
            super.stateChanged(e);
        }
    }

    public static int getNextTemporaryTopoGeometryId() {
        return nextGeomID--;
    }

    public static Hashtable<String, TopologyModel> getTopoModels() {
        return topoModels;
    }

    public static Hashtable<String, IndexedTopologyModel> getIndexedTopoModels() {
        return indexedTopoModels;
    }

    public static Vector<TopologyPrimitiveLayer> getTopoPrimLayers() {
        return topoPrimLayers;
    }

    public static Hashtable<String, TopologyPrimitivesProducer> getTopoPrimProducers() {
        return topoPrimProducers;
    }
}

