/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLConverter;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLDbProvider;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLOfflineCapturer;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLQuoter;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import org.antlr.stringtemplate.StringTemplate;

public class PostgreSQL9Plugin
extends AbstractMigrationPlugin {
    public Logger LOGGER = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    public static final String DRIVER_CLASS = "org.postgresql.Driver";
    private static boolean s_driverLoaded = false;
    protected Converter m_converter;
    public static final String[] CAPTURE_MENU = new String[]{"TABLE", "TABLE_FOLDER", "VIEW", "VIEW_FOLDER", "FUNCTIONS", "FUNCTIONS_FOLDER", "PROCEDURES", "PROCEDURES_FOLDER", "INDEX", "INDEX_FOLDER", "USER", "USER_FOLDER"};
    private static Version m_driverVersion;
    private static final Version MIN_VER;
    private static final Version MAX_VER;
    private HashSet<String> sqlldrReservedWords = null;
    private static final String TEMPLATEPATH = "oracle/dbtools/migration/workbench/plugin/templates";
    private static final String POSTGRESQL_TEMPLATE_NAME = "PostgreSQL";
    private boolean m_HeaderFlag = false;

    public PostgreSQL9Plugin() {
        this.loadPluginTemplates(TEMPLATEPATH, ((Object)((Object)this)).getClass().getClassLoader(), POSTGRESQL_TEMPLATE_NAME);
    }

    public String getPlatformName() {
        return POSTGRESQL_TEMPLATE_NAME;
    }

    public String getPluginName() {
        return this.getPlatformName();
    }

    public String getVersionNumber() {
        return "9.x";
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            PostgreSQL9Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new PostgreSQLDbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        PostgreSQL9Plugin.loadDriver();
        try {
            PostgreSQL9Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new PostgreSQLDbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/postgresql/SupportedDataTypesMap.xml";
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            PostgreSQL9Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return new PostgreSQLDbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new PostgreSQLDbProvider(connection);
    }

    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider(){

            public Statement getStatementForDataMove(Connection connection) throws SQLException {
                Wrapper wrapper;
                if (m_driverVersion == null && connection != null) {
                    wrapper = connection.getMetaData();
                    m_driverVersion = new Version(new int[]{wrapper.getDriverMajorVersion(), wrapper.getDriverMinorVersion()});
                }
                if (VersionTracker.checkVersion((Version)m_driverVersion, (Version)MAX_VER, (Version)MIN_VER)) {
                    wrapper = connection.createStatement(1003, 1007);
                    wrapper.setFetchSize(Integer.MIN_VALUE);
                    return wrapper;
                }
                return super.getStatementForDataMove(connection);
            }
        };
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Object obj = Class.forName(DRIVER_CLASS).newInstance();
                if (obj instanceof Driver) {
                    Driver driver = (Driver)obj;
                    m_driverVersion = new Version(new int[]{driver.getMajorVersion(), driver.getMinorVersion()});
                }
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public String getPublishedVersion() {
        return this.getVersionNumber();
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new PostgreSQLConverter();
        }
        return this.m_converter;
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (!string.equals(this.getPlatformName())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (n == 9) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/postgresql/images/db.png";
    }

    public void registerMenuItems() {
    }

    public Quoter getQuoter() {
        return new PostgreSQLQuoter();
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String string3 = migrationConfig.getEndColumnDelimiter();
        String string4 = migrationConfig.getEndRowDelimiter();
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig2 = MigrationConfig.getInstance((PropertyStorage)preferences);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = string.indexOf(".");
        if (n != -1 && n > 0 && n < string.length() - 1) {
            string5 = string.substring(0, n);
            string6 = string.substring(n + 1);
            string7 = "mysqldump -h <SERVER> -u <USERNAME> -p<PASSWORD>  -T \"<DESTINATION_PATH>\" --fields-terminated-by=\"" + string3 + "\" --fields-escaped-by=\"\" --lines-terminated-by=\"" + string4 + "\" \"" + string5 + "\" \"" + string6 + "\" ";
        } else {
            string7 = "mysqldump -h <SERVER> -u <USERNAME> -p<PASSWORD>  -T \"<DESTINATION_PATH>\" --fields-terminated-by=\"" + string3 + "\" --fields-escaped-by=\"\" --lines-terminated-by=\"" + string4 + "\" \"<DBNAME>\" \"" + string + "\"";
        }
        return string7;
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        StringTemplate stringTemplate;
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        MigrationConfig migrationConfig2 = MigrationAddin.getMigrationConfig();
        String string3 = migrationConfig2.getEndColumnDelimiter();
        String string4 = migrationConfig2.getEndRowDelimiter();
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig3 = MigrationConfig.getInstance((PropertyStorage)preferences);
        String string5 = null;
        String string6 = null;
        Object var13_13 = null;
        int n = string.indexOf(".");
        try {
            if (n != -1 && n > 0 && n < string.length() - 1) {
                string5 = string.substring(0, n);
                string6 = string.substring(n + 1);
                stringTemplate = this.getPluginTemplateGroup().getInstanceOf("DataExportCommmand");
                stringTemplate.setAttribute("platformWindows", (Object)bl);
                stringTemplate.setAttribute("srcTableString", (Object)string6);
                stringTemplate.setAttribute("databaseString", (Object)string5);
                stringTemplate.setAttribute("endColumnDelimeter", (Object)migrationConfig.getEndColumnDelimiter());
                stringTemplate.setAttribute("endRowDelimeter", (Object)migrationConfig.getEndRowDelimiter());
            } else {
                stringTemplate = this.getPluginTemplateGroup().getInstanceOf("DataExportCommmandDBName");
                stringTemplate.setAttribute("platformWindows", (Object)bl);
                stringTemplate.setAttribute("srcTable", (Object)string);
                stringTemplate.setAttribute("endColumnDelimeter", (Object)migrationConfig.getEndColumnDelimiter());
                stringTemplate.setAttribute("endRowDelimeter", (Object)migrationConfig.getEndRowDelimiter());
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, "Cannot get data Export command for {0}", string);
            return "";
        }
        return stringTemplate.toString();
    }

    public String getDataHeaderCommand(boolean bl) {
        String string = "";
        StringTemplate stringTemplate = this.getPluginTemplateGroup().getInstanceOf("DataExportCommmandHeader");
        stringTemplate.setAttribute("platformWindows", (Object)bl);
        string = stringTemplate.toString();
        stringTemplate.reset();
        return string;
    }

    public String createDataFileName(String string, String string2) {
        int n;
        if (string2 != null && (n = string2.lastIndexOf(".")) < string2.length() - 1) {
            return string2.substring(n + 1) + ".txt";
        }
        return string2 + ".txt";
    }

    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn2.getColumnName().toUpperCase();
        if (this.sqlldrReservedWords == null) {
            this.sqlldrReservedWords = new HashSet();
            this.sqlldrReservedWords.add("AND");
            this.sqlldrReservedWords.add("FLOAT");
            this.sqlldrReservedWords.add("RECOVERABLE");
            this.sqlldrReservedWords.add("APPEND");
            this.sqlldrReservedWords.add("FORMAT");
            this.sqlldrReservedWords.add("REENABLE");
            this.sqlldrReservedWords.add("BADFILE");
            this.sqlldrReservedWords.add("GENERATED");
            this.sqlldrReservedWords.add("REPLACE");
            this.sqlldrReservedWords.add("BADDN");
            this.sqlldrReservedWords.add("GRAPHIC");
            this.sqlldrReservedWords.add("RESUME");
            this.sqlldrReservedWords.add("BEGINDATA");
            this.sqlldrReservedWords.add("INDDN");
            this.sqlldrReservedWords.add("SEQUENCE");
            this.sqlldrReservedWords.add("BLANKS");
            this.sqlldrReservedWords.add("INDEXES");
            this.sqlldrReservedWords.add("SINGLEROW");
            this.sqlldrReservedWords.add("BLOCKSIZE");
            this.sqlldrReservedWords.add("INFILE");
            this.sqlldrReservedWords.add("SKIP");
            this.sqlldrReservedWords.add("BY");
            this.sqlldrReservedWords.add("INSERT");
            this.sqlldrReservedWords.add("SMALLINT");
            this.sqlldrReservedWords.add("BYTEINT");
            this.sqlldrReservedWords.add("INTEGER");
            this.sqlldrReservedWords.add("SORTDEVT");
            this.sqlldrReservedWords.add("CHAR");
            this.sqlldrReservedWords.add("INTO");
            this.sqlldrReservedWords.add("SORTED");
            this.sqlldrReservedWords.add("CHARACTERSET");
            this.sqlldrReservedWords.add("LAST");
            this.sqlldrReservedWords.add("SORTNUM");
            this.sqlldrReservedWords.add("CONCATENATE");
            this.sqlldrReservedWords.add("LOAD");
            this.sqlldrReservedWords.add("SQL/DS");
            this.sqlldrReservedWords.add("CONSTANT");
            this.sqlldrReservedWords.add("LOG");
            this.sqlldrReservedWords.add("STORAGE");
            this.sqlldrReservedWords.add("CONTINUE_LOAD");
            this.sqlldrReservedWords.add("MAX");
            this.sqlldrReservedWords.add("STREAM");
            this.sqlldrReservedWords.add("CONTINUEIF");
            this.sqlldrReservedWords.add("MLSLABEL");
            this.sqlldrReservedWords.add("SYSDATE");
            this.sqlldrReservedWords.add("COUNT");
            this.sqlldrReservedWords.add("NEXT");
            this.sqlldrReservedWords.add("TABLE");
            this.sqlldrReservedWords.add("DATA");
            this.sqlldrReservedWords.add("NO");
            this.sqlldrReservedWords.add("TERMINATED");
            this.sqlldrReservedWords.add("DATE");
            this.sqlldrReservedWords.add("NULLCOLS");
            this.sqlldrReservedWords.add("THIS");
            this.sqlldrReservedWords.add("DECIMAL");
            this.sqlldrReservedWords.add("NULLIF");
            this.sqlldrReservedWords.add("TRAILING");
            this.sqlldrReservedWords.add("DEFAULTIF");
            this.sqlldrReservedWords.add("OPTIONALLY");
            this.sqlldrReservedWords.add("TRUNCATE");
            this.sqlldrReservedWords.add("DELETE");
            this.sqlldrReservedWords.add("OPTIONS");
            this.sqlldrReservedWords.add("UNLOAD");
            this.sqlldrReservedWords.add("DISABLED_CONSTRAINTS");
            this.sqlldrReservedWords.add("PARALLEL");
            this.sqlldrReservedWords.add("UNRECOVERABLE");
            this.sqlldrReservedWords.add("DISCARDDN");
            this.sqlldrReservedWords.add("PART");
            this.sqlldrReservedWords.add("USING");
            this.sqlldrReservedWords.add("DISCARDFILE");
            this.sqlldrReservedWords.add("PARTITION");
            this.sqlldrReservedWords.add("VARCHAR");
            this.sqlldrReservedWords.add("DISCARDMAX");
            this.sqlldrReservedWords.add("PIECED");
            this.sqlldrReservedWords.add("VARGRAPHIC");
            this.sqlldrReservedWords.add("DISCARDS");
            this.sqlldrReservedWords.add("POSITION");
            this.sqlldrReservedWords.add("VARIABLE");
            this.sqlldrReservedWords.add("DOUBLE");
            this.sqlldrReservedWords.add("PRESERVE");
            this.sqlldrReservedWords.add("WHEN");
            this.sqlldrReservedWords.add("ENCLOSED");
            this.sqlldrReservedWords.add("RAW");
            this.sqlldrReservedWords.add("WHITESPACE");
            this.sqlldrReservedWords.add("EXCEPTIONS");
            this.sqlldrReservedWords.add("READBUFFERS");
            this.sqlldrReservedWords.add("WORKDDN");
            this.sqlldrReservedWords.add("EXTERNAL");
            this.sqlldrReservedWords.add("RECLEN");
            this.sqlldrReservedWords.add("YES");
            this.sqlldrReservedWords.add("FIELDS");
            this.sqlldrReservedWords.add("RECNUM");
            this.sqlldrReservedWords.add("ZONED");
            this.sqlldrReservedWords.add("FIXED");
            this.sqlldrReservedWords.add("RECORD");
        }
        String string2 = "";
        string2 = this.sqlldrReservedWords.contains(string) ? "\"" + string + "\"" : mdColumn2.getColumnName();
        return string2;
    }

    public String getDatafileExtension() {
        return "txt";
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = "";
        boolean bl = true;
        String string2 = mdColumn2.getColumnName();
        String string3 = mdColumn2.getColumnType();
        Integer n = mdColumn2.getPrecision();
        int n2 = 0;
        n2 = n == null ? 0 : n;
        if (string3.equalsIgnoreCase("CHAR") || string3.equalsIgnoreCase("NCHAR") || string3.equalsIgnoreCase("VARCHAR2") || string3.equalsIgnoreCase("NVARCHAR2") || string3.equalsIgnoreCase("CLOB") || string3.equalsIgnoreCase("NCLOB")) {
            if (n2 >= 255) {
                string = "CHAR(" + n2 + ")";
            }
            if (string3.equalsIgnoreCase("VARCHAR2") || string3.equalsIgnoreCase("NVARCHAR2") || string3.equalsIgnoreCase("CHAR") || string3.equalsIgnoreCase("NCHAR")) {
                string = MigrationAddin.getMigrationConfig().getEmptyStringIsSpace() ? string + " \"DECODE(:" + string2 + ", 'NULL', NULL, NULL, ' ', :" + string2 + ")\"" : string + " \"DECODE(:" + string2 + ", 'NULL', NULL, NULL, NULL, :" + string2 + ")\"";
                bl = false;
            }
            if (string3.equalsIgnoreCase("CLOB") || string3.equalsIgnoreCase("NCLOB")) {
                string = string + "CHAR(2000000)";
            }
        } else if (string3.equalsIgnoreCase("TIMESTAMP")) {
            string = "\"TO_TIMESTAMP(DECODE(:" + string2 + ", 'NULL', NULL, DECODE(translate(:" + string2 + ",'10 -,:.','1'), null, null,:" + string2 + ")), '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
            bl = false;
        } else if (string3.equalsIgnoreCase("DATE")) {
            string = "\"TO_DATE(DECODE(:" + string2 + ", 'NULL', NULL,  DECODE(translate(:" + string2 + ",'10 -,:.','1'), null, null,:" + string2 + ")),  '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
            bl = false;
        } else if (string3.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
            string = "\"TO_DSINTERVAL(DECODE(:" + string2 + ", 'NULL', NULL, TO_CHAR(FLOOR(REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 1)/24)) || ' ' ||TO_CHAR(MOD(REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 1), 24)) || ':' ||REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 2) || ':' ||REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 3)))\"";
            bl = false;
        } else if (string3.equalsIgnoreCase("BLOB")) {
            string = " CHAR(2000000) ";
        }
        if (bl) {
            string = string + " NULLIF " + this.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2) + " = 'NULL'";
        }
        return string;
    }

    public int getPlatformMask() {
        return 524288;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new PostgreSQLOfflineCapturer();
    }

    public String getPlatformNameforNavigator() {
        return POSTGRESQL_TEMPLATE_NAME;
    }

    public MigrationPlugin.ProjectMergeLevel getMergeProjectSupportLevel() {
        return MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA;
    }

    static {
        MIN_VER = new Version("9.0");
        MAX_VER = new Version("10.0");
    }
}

