/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.FixedAttributeQualifiedName;
import oracle.bali.xml.grammar.IdentifierQualifiedName;
import oracle.bali.xml.util.XmlNameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedName
implements Comparable,
Serializable {
    private static final Set<String> _LOGGED_STRINGS = new HashSet<String>();
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, QualifiedName>> _sNamespaceMaps = new ConcurrentHashMap(17, 0.75f, 10);
    private static ConcurrentHashMap<String, QualifiedName> _sDefaultNamespaceMap = new ConcurrentHashMap(103, 0.75f, 10);
    private String _namespace;
    private final String _name;
    private final String _qualifiedName;
    private final int _hashCode;
    private static final long serialVersionUID = 1L;
    private static final Logger _LOGGER = Logger.getLogger(QualifiedName.class.getName());

    public static QualifiedName getQualifiedName(String namespace, String localName) {
        QualifiedName newName;
        ConcurrentHashMap<String, QualifiedName> namespaceMap = QualifiedName._getNamespaceMap(namespace);
        QualifiedName qName = namespaceMap.get(localName);
        if (qName == null && (qName = namespaceMap.putIfAbsent(localName, newName = new QualifiedName(namespace, localName))) == null) {
            qName = newName;
        }
        return qName;
    }

    public static QualifiedName getQualifiedName(String qName) {
        int separatorIndex = qName.indexOf(58);
        String namespaceURI = null;
        String localName = qName;
        if (separatorIndex != -1) {
            if (separatorIndex != 0) {
                separatorIndex = qName.lastIndexOf(58);
                namespaceURI = qName.substring(0, separatorIndex);
            }
            if (separatorIndex == qName.length() - 1) {
                throw new IllegalArgumentException("No local name provided");
            }
            localName = qName.substring(separatorIndex + 1);
        }
        return QualifiedName.getQualifiedName(namespaceURI, localName);
    }

    public static QualifiedName getQualifiedName(String namespace, String name, String identifier) {
        if (identifier == null) {
            return QualifiedName.getQualifiedName(namespace, name);
        }
        return IdentifierQualifiedName.getIdentifierQualifiedName(namespace, name, identifier);
    }

    public static QualifiedName getQualifiedName(String namespace, String name, String attributeNamespace, String attributeName, String attributeValue) {
        if (attributeName == null || attributeValue == null) {
            return QualifiedName.getQualifiedName(namespace, name);
        }
        return FixedAttributeQualifiedName.getFixedAttributeQualifiedName(namespace, name, attributeNamespace, attributeName, attributeValue);
    }

    QualifiedName(String namespace, String name) {
        this.validateNamespaceName(namespace, name);
        this._namespace = namespace;
        this._name = name;
        if (this._namespace != null) {
            int namespaceLength = this._namespace.length();
            if (namespaceLength > 0) {
                int nameLength = name.length();
                StringBuilder temp = new StringBuilder(namespaceLength + 1 + nameLength);
                temp.append(namespace);
                temp.append(':');
                temp.append(name);
                this._qualifiedName = temp.toString();
            } else {
                this._qualifiedName = name;
                this._namespace = null;
            }
        } else {
            this._qualifiedName = name;
        }
        this._hashCode = this._qualifiedName.hashCode();
    }

    protected final void validateNamespaceName(String namespace, String name) {
        block4: {
            if (name == null || name.equals("")) {
                throw new IllegalArgumentException("No local name provided");
            }
            try {
                XmlNameUtils.validateName(name);
                XmlNameUtils.validateNamespace(namespace);
            }
            catch (IllegalArgumentException iae) {
                String concat = name;
                if (namespace != null) {
                    concat = concat + "|" + namespace;
                }
                if (!_LOGGED_STRINGS.add(concat)) break block4;
                _LOGGER.log(Level.SEVERE, "Attempt to create illegal qualified name! File a bug against the caller of QualifiedName.getQualifiedName (or ImmutableXmlKey.create*). This exception will be thrown instead of loggered soon. namespace=" + namespace + " name=" + name, iae);
            }
        }
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getName() {
        return this._name;
    }

    public String getAttributeName() {
        return null;
    }

    public String getAttributeNamespace() {
        return null;
    }

    public String getAttributeValue() {
        return null;
    }

    public String getIdentifier() {
        return null;
    }

    public boolean isVariation() {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        QualifiedName testObj = (QualifiedName)o;
        String testString = testObj.getQualifiedName();
        return this._qualifiedName.compareTo(testString);
    }

    public String toString() {
        String attrValue;
        String attrName;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Qualified Name ");
        buffer.append(this._qualifiedName);
        String attrNs = this.getAttributeNamespace();
        if (attrNs != null) {
            buffer.append("\n attribute namespace ");
            buffer.append(attrNs);
        }
        if ((attrName = this.getAttributeName()) != null) {
            buffer.append("\n attribute name ");
            buffer.append(attrName);
        }
        if ((attrValue = this.getAttributeValue()) != null) {
            buffer.append("\n attribute value ");
            buffer.append(attrValue);
        }
        return buffer.toString();
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    private static ConcurrentHashMap<String, QualifiedName> _getNamespaceMap(String namespace) {
        ConcurrentHashMap newMap;
        if (namespace == null || namespace.equals("")) {
            return _sDefaultNamespaceMap;
        }
        ConcurrentHashMap<String, QualifiedName> namespaceMap = _sNamespaceMaps.get(namespace);
        if (namespaceMap == null && (namespaceMap = _sNamespaceMaps.putIfAbsent(namespace, newMap = new ConcurrentHashMap(47, 0.75f, 10))) == null) {
            namespaceMap = newMap;
        }
        return namespaceMap;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new QualifiedNameSerializationProxy(this);
    }

    private static class QualifiedNameSerializationProxy
    implements Serializable {
        private final String _namespace;
        private final String _localName;
        private static final long serialVersionUID = 1L;

        QualifiedNameSerializationProxy(QualifiedName qName) {
            this._namespace = qName.getNamespace();
            this._localName = qName.getName();
        }

        private Object readResolve() {
            return QualifiedName.getQualifiedName(this._namespace, this._localName);
        }
    }
}

