/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.common.ddl.DDLResources;
import oracle.dbtools.common.ddl.TargetFormatConfig;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.transfer.location.LocationTestInfo;

public class TargetFormat {
    public static final int PREFERENCES = 0;
    public static final int WIZARD = 1;
    public static final int HEADLESS = 2;
    public static final int UNDEFINED = 0;
    public static final int EXPORT = 1;
    public static final int DIFF = 2;
    public static final int CART = 3;
    public static final int CART_SCRIPT = 4;
    public static final int DEPLOY = 5;
    public static final int DEPLOY_PDB = 6;
    public static final int SINGLE_FILE = 0;
    public static final int MULTIPLE_FILES = 1;
    public static final int TYPE_FILES = 2;
    public static final int SEPARATE_DIRS = 3;
    public static final int STRING_TYPE = 4;
    public static final int WORKSHEET = 4;
    public static final int CLIPBOARD = 5;
    public static final int CSTORAGE_MULTIPLE_FILES = 6;
    public static final int ZIP = 0;
    public static final String SINGLE_FILE_STR;
    public static final String MULTIPLE_FILES_STR;
    public static final String TYPE_FILES_STR;
    public static final String SEPARATE_DIRS_STR;
    public static final String WORKSHEET_STR;
    public static final String CLIPBOARD_STR;
    public static final String CSTORAGE_MULTIPLE_FILE_STR;
    public static final String ZIP_STR = "ZIP";
    public static final int CONTINUE = 0;
    public static final int CANCEL_WITH_MSG = 1;
    public static final int CANCEL = 2;
    public static final int MAX_AUTO_OPEN_SIZE = 500000;
    private static final String SQL_EXT = ".sql";
    private static final String SQLDEV_EXT = ".sqldev";
    public static final String ZIP_EXT_STR = "zip";
    private static final String DEPLOY_STR = "deploy";
    private static String[] _saveAsTypes;
    private static String[] _compressionTypes;
    private static String[] _compressionExtensions;
    private int _usage = 1;
    private int _preference = 1;
    private String _urlFileContext;
    private int _saveAsType;
    private String _saveAs;
    private boolean _isCompressed;
    private int _compressionType = 0;
    private boolean _isExcutableControlFile = true;
    private boolean _isDeployCloud = false;
    private boolean _isSftp = false;
    private LocationTestInfo _locationTestInfo;
    private Object _sFtpParms;
    private String _controllingBaseName;
    private String _dataFormatExtension;
    private String _encoding = IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING");
    private boolean _openTarget = true;
    private boolean _genScript = true;
    private boolean _genDate = true;
    private boolean _defaultOpenTarget;
    private String _validationMessage;
    boolean _showSaveAsType = true;
    boolean _showCompression = true;
    boolean _showEncoding = true;

    public TargetFormat() {
        this(1, 0);
    }

    public TargetFormat(int usage, int preference) {
        this(usage, preference, true);
    }

    public TargetFormat(int usage, int preference, boolean init) {
        this._usage = usage;
        this._preference = preference;
        if (init) {
            this.initFormat();
        }
    }

    public boolean getShowSaveAsType() {
        return this._showSaveAsType;
    }

    public void setShowSaveAsType(boolean showSaveAsType) {
        this._showSaveAsType = showSaveAsType;
    }

    public boolean getShowCompression() {
        return this._showCompression;
    }

    public void setShowCompression(boolean showCompression) {
        this._showCompression = showCompression;
    }

    public boolean getShowEncoding() {
        return this._showEncoding;
    }

    public void setShowEncoding(boolean showEncoding) {
        this._showEncoding = showEncoding;
    }

    public int getUsage() {
        return this._usage;
    }

    public void setUsage(int usage) {
        this._usage = usage;
    }

    public int getPreference() {
        return this._preference;
    }

    public void setPreference(int preference) {
        this._preference = preference;
    }

    public boolean isOpenTarget() {
        return this._openTarget;
    }

    public void isOpenTarget(boolean value) {
        this._openTarget = value;
    }

    public boolean isGenScript() {
        return this._genScript;
    }

    public void isGenScript(boolean value) {
        this._genScript = value;
    }

    public boolean isGenDate() {
        return this._genDate;
    }

    public void isGenDate(boolean value) {
        this._genDate = value;
    }

    public boolean isDefaultOpenTarget() {
        return this._defaultOpenTarget;
    }

    public String[] getSaveAsTypes() {
        return _saveAsTypes;
    }

    public String getSaveAsTypeString() {
        switch (this._saveAsType) {
            case 0: {
                return SINGLE_FILE_STR;
            }
            case 1: {
                return MULTIPLE_FILES_STR;
            }
            case 2: {
                return TYPE_FILES_STR;
            }
            case 3: {
                return SEPARATE_DIRS_STR;
            }
            case 4: {
                return WORKSHEET_STR;
            }
            case 5: {
                return CLIPBOARD_STR;
            }
        }
        return SINGLE_FILE_STR;
    }

    public int getSaveAsType() {
        return this._saveAsType;
    }

    public void setSaveAsType(int value) {
        this._saveAsType = value;
    }

    public boolean isSingleFile() {
        return this._saveAsType == 0;
    }

    public boolean isMultipleFiles() {
        return this._saveAsType == 1;
    }

    public boolean isTypeFiles() {
        return this._saveAsType == 2;
    }

    public boolean isSeparateDirs() {
        return this._saveAsType == 3;
    }

    public boolean isClipboard() {
        return this._saveAsType == 5;
    }

    public boolean isWorkSheet() {
        return this._saveAsType == 4;
    }

    public boolean isStringType() {
        return this._saveAsType >= 4;
    }

    public String getSaveAs() {
        return this._saveAs;
    }

    public void setSaveAs(String value) {
        this._saveAs = value;
    }

    public boolean isExcutableControlFile() {
        return this._isExcutableControlFile;
    }

    public void isExcutableControlFile(boolean value) {
        this._isExcutableControlFile = value;
    }

    public boolean isDeployCloud() {
        return this._isDeployCloud;
    }

    public void isDeployCloud(boolean value) {
        this._isDeployCloud = value;
    }

    public LocationTestInfo getLocationTestInfo() {
        return this._locationTestInfo;
    }

    public void setLocationTestInfo(LocationTestInfo value) {
        this._locationTestInfo = value;
    }

    public boolean isSftp() {
        return this._isSftp;
    }

    public void isSftp(boolean value) {
        this._isSftp = value;
    }

    public Object getSftpParms() {
        return this._sFtpParms;
    }

    public void setSftpParms(Object value) {
        this._sFtpParms = value;
    }

    public boolean isCompressed() {
        return this._saveAsType < 4 ? this._isCompressed : false;
    }

    public void isCompressed(boolean isCompressed) {
        this._isCompressed = isCompressed;
    }

    public String[] getCompressionTypes() {
        return _compressionTypes;
    }

    public String getCompressionTypeString() {
        switch (this._saveAsType) {
            case 0: {
                return ZIP_STR;
            }
        }
        return ZIP_STR;
    }

    public int getCompressionType() {
        return this._compressionType;
    }

    public void setCompressionType(int value) {
        this._compressionType = value;
    }

    public String getCompressionExt() {
        return _compressionExtensions[this._compressionType];
    }

    public String getControllingBaseName() {
        if (this.getControllingFileName() == null || this.getControllingFileName().length() == 0) {
            this._controllingBaseName = "export.sql";
            if (this._isCompressed && this._saveAsType == 0 && this._dataFormatExtension != null) {
                this._controllingBaseName = "export." + this._dataFormatExtension;
            }
        }
        return this._controllingBaseName;
    }

    public void setControllingBaseName(String value) {
        this._controllingBaseName = value;
    }

    public String getControllingFile() {
        if (this._isCompressed) {
            return this.getControllingFileName();
        }
        if (this._saveAsType == 0) {
            String path = new File(this._saveAs).getParentFile().getPath();
            return path.endsWith(File.separator) ? path + this.getControllingFileName() : path + File.separatorChar + this.getControllingFileName();
        }
        return this._saveAs.endsWith(File.separator) ? this._saveAs + this.getControllingFileName() : this._saveAs + File.separatorChar + this.getControllingFileName();
    }

    public String getControllingFileName() {
        if (this._controllingBaseName == null) {
            return null;
        }
        int idx = this._controllingBaseName.lastIndexOf(".");
        if (idx != -1) {
            this._controllingBaseName = this._controllingBaseName.substring(0, idx);
        }
        return this._isExcutableControlFile ? this._controllingBaseName + SQL_EXT : "deploy.sqldev";
    }

    public String getDataFormatExtension() {
        return this._dataFormatExtension;
    }

    public void setDataFormatExtension(String value) {
        this._dataFormatExtension = value;
    }

    public URL getSaveAsURL() {
        return this.getURL(this._saveAs);
    }

    public URL getControllingURL() {
        return this.getURL(this.getControllingFile());
    }

    public URL getURL(String file) {
        try {
            return file != null ? new File(file).toURI().toURL() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getDefaultSaveAs() {
        return this.getDefaultSaveAs(ICommonConfig.Storage.getInstance());
    }

    public String getDefaultSaveAs(IStorage config) {
        String name = this.getDefaultDirectory(config);
        if (this._usage != 0 && (this._saveAsType == 0 || this.isCompressed())) {
            if (!name.endsWith(File.separator)) {
                name = name + File.separator;
            }
            name = this.isCompressed() ? name + DDLResources.getString("DEFAULT_DEPLOY_FILENAME") + "." + ZIP_EXT_STR : name + DDLResources.getString("DEFAULT_EXPORT_FILENAME") + SQL_EXT;
        }
        return name;
    }

    public int validateSaveAs() {
        return this.validateSaveAs(null, false);
    }

    public int validateSaveAs(Component parent) {
        if (this._usage == 2) {
            return this.validateSaveAs(parent, false);
        }
        return this.validateSaveAs(parent, true);
    }

    public int validateSaveAs(Component parent, boolean action) {
        this._validationMessage = null;
        if (this._usage == 1 || this._usage == 2) {
            if (this._saveAs == null || this._saveAs.trim().equals("")) {
                this._validationMessage = DDLResources.getString("NO_SAVE_AS");
                return 1;
            }
            if (this._saveAsType == 0 || this._isCompressed) {
                return this.validateSaveAsFile(parent, action);
            }
        }
        if (this._usage == 2 && (this._saveAsType == 4 || this._saveAsType == 5)) {
            this._validationMessage = DDLResources.format("SAVE_AS_TYPE_NA", this._saveAsType == 4 ? WORKSHEET_STR : CLIPBOARD_STR);
            return 1;
        }
        return this.isStringType() ? 0 : this.validateSaveAsDir(parent, action);
    }

    public int validateSaveAsFile(Component parent) {
        if (this._usage == 2) {
            return this.validateSaveAsFile(parent, false);
        }
        return this.validateSaveAsFile(parent, true);
    }

    public int validateSaveAsFile(Component parent, boolean confirmAction) {
        Object[] saveAsParm = new Object[]{this._saveAs};
        File f = new File(this._saveAs);
        if (f.isDirectory()) {
            this._validationMessage = DDLResources.format("DIR_FOUND", saveAsParm);
            return 1;
        }
        if (f.isFile()) {
            if (confirmAction) {
                boolean confirm = MessageHandler.confirm((Component)parent, (String)DDLResources.format("OVERWRITE_FILE", saveAsParm), (String)DDLResources.getString("CONFIRM_OVERWRITE"), null);
                if (!confirm) {
                    return 2;
                }
                if (!f.delete()) {
                    this._validationMessage = DDLResources.format("UNABLE_TO_DELETE_FILE", saveAsParm);
                    return 1;
                }
                return 0;
            }
            this._validationMessage = DDLResources.format("INVALID_FILE_EXISTS", saveAsParm);
            return 1;
        }
        if (f.getParent() == null) {
            String temp;
            String expPref = this.getDefaultDirectory();
            if (expPref.length() == 0) {
                this._validationMessage = DDLResources.format("NO_DEFAULT_DIR", expPref);
                return 1;
            }
            File defaultDir = new File(expPref);
            if (!defaultDir.isDirectory()) {
                this._validationMessage = DDLResources.format("NO_DEFAULT_DIR", expPref);
                return 1;
            }
            String expDir = expPref.endsWith(File.separator) ? expPref : expPref + File.separator;
            f = new File(expDir + this._saveAs);
            this._saveAs = temp = expDir + this._saveAs;
            return this.canCreateAction(f);
        }
        if (this.canCreate(f)) {
            return 0;
        }
        File parentFile = f.getParentFile();
        if (!parentFile.isDirectory()) {
            boolean confirm;
            if (confirmAction && !(confirm = MessageHandler.confirm((Component)parent, (String)DDLResources.format("CREATE_DIRS", saveAsParm), (String)DDLResources.getString("CONFIRM_CREATE_DIR"), null))) {
                return 2;
            }
            if (parentFile != null && parentFile.mkdirs()) {
                return 0;
            }
            this._validationMessage = DDLResources.format("INVALID_DIR", parentFile.getPath());
            return 1;
        }
        this._validationMessage = DDLResources.format("NOT_WRITABLE", parentFile.getPath());
        return 1;
    }

    public int validateSaveAsDir(Component parent) {
        if (this._usage == 2) {
            return this.validateSaveAsDir(parent, false);
        }
        return this.validateSaveAsDir(parent, true);
    }

    public int validateSaveAsDir(Component parent, boolean confirmAction) {
        boolean confirm;
        File f = new File(this._saveAs);
        Object[] saveAsParm = new Object[]{this._saveAs};
        if (f.isDirectory()) {
            return this.canCreateInAction(f);
        }
        if (f.isFile()) {
            this._validationMessage = DDLResources.format("DIR_REQUIRED", saveAsParm);
            return 1;
        }
        if (this._saveAs == null || this._saveAs.trim().equals("")) {
            boolean confirm2;
            if (this._usage == 0) {
                return 0;
            }
            Object expDir = null;
            String expPref = this.getDefaultDirectory();
            if (expPref == "") {
                this._validationMessage = DDLResources.getString("NO_DEFAULT_DIR");
                return 1;
            }
            File defaultDir = new File(expPref);
            if (!defaultDir.isDirectory()) {
                this._validationMessage = DDLResources.format("INVALID_DEFAULT_DIR", expPref);
                return 1;
            }
            if (!this.canCreateIn(defaultDir)) {
                this._validationMessage = DDLResources.format("DEFAULT_DIR_NOT_WRITABLE", expPref);
                return 1;
            }
            String msg = DDLResources.format("NO_DIR", saveAsParm);
            if (confirmAction && !(confirm2 = MessageHandler.confirm((Component)parent, (String)msg, (String)DDLResources.getString("CONFIRM_DEFAULT_DIR"), null))) {
                return 2;
            }
            return 0;
        }
        if (confirmAction && !(confirm = MessageHandler.confirm((Component)parent, (String)DDLResources.format("CREATE_DIRS", saveAsParm), (String)DDLResources.getString("CONFIRM_CREATE_DIR"), null))) {
            return 2;
        }
        if (f != null && f.mkdirs()) {
            return this.canCreateInAction(f);
        }
        this._validationMessage = DDLResources.format("INVALID_DIR", saveAsParm);
        return 1;
    }

    private boolean canCreate(File file) {
        try {
            file.createNewFile();
            FileOutputStream tmpStream = new FileOutputStream(file);
            tmpStream.write(1);
            tmpStream.close();
            file.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private int canCreateAction(File file) {
        if (this.canCreate(file)) {
            this._validationMessage = null;
            return 0;
        }
        this._validationMessage = DDLResources.format("NOT_WRITABLE", file.getPath());
        return 1;
    }

    private boolean canCreateIn(File dir) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("unload", ".tmp", dir);
            FileOutputStream tmpStream = new FileOutputStream(tmpFile);
            tmpStream.write(1);
            tmpStream.close();
            tmpFile.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private int canCreateInAction(File dir) {
        if (this.canCreateIn(dir)) {
            this._validationMessage = null;
            return 0;
        }
        this._validationMessage = DDLResources.format("NOT_WRITABLE", dir.getPath());
        return 1;
    }

    public String getDefaultDirectory() {
        return this.getDefaultDirectory(ICommonConfig.Storage.getInstance());
    }

    private String getSaveAsFile(IStorage config) {
        String expPref = config.getString("EXPORTDIR");
        if (this._preference == 2) {
            expPref = config.getString("DIFFDIR");
        } else if (this._preference == 5) {
            expPref = config.getString("DEPLOYDIR");
            if (expPref == null || expPref.trim().equals("")) {
                expPref = config.getString("CARTDIR");
            }
        } else if (this._preference == 6) {
            expPref = config.getString("DEPLOY_PDB_DIR");
            if (expPref == null || expPref.trim().equals("")) {
                expPref = "https:";
            }
        } else if (this._preference == 3) {
            expPref = config.getString("CARTDIR");
        } else if (this._preference == 4) {
            expPref = config.getString("CARTSCRIPTDIR");
        }
        return expPref;
    }

    public void setUrlPathContext(String urlFileContext) {
        this._urlFileContext = urlFileContext;
    }

    public String getUrlPathContext() {
        if (this._urlFileContext != null) {
            return this._urlFileContext;
        }
        String urlFileContext = "EXPORTDIR";
        if (this._preference == 2) {
            urlFileContext = "DIFFDIR";
        } else if (this._preference == 5) {
            urlFileContext = "DEPLOYDIR";
        } else if (this._preference == 6) {
            urlFileContext = "DEPLOY_PDB_DIR";
        } else if (this._preference == 3) {
            urlFileContext = "CARTDIR";
        } else if (this._preference == 4) {
            urlFileContext = "CARTSCRIPTDIR";
        }
        return urlFileContext;
    }

    public String getDefaultDirectory(IStorage config) {
        String expDir;
        String expPref = config.getString("EXPORTDIR");
        if (this._preference == 2) {
            expPref = config.getString("DIFFDIR");
        } else if (this._preference == 5) {
            expPref = config.getString("DEPLOYDIR");
            if (expPref == null || expPref.trim().equals("")) {
                expPref = config.getString("CARTDIR");
            }
        } else if (this._preference == 6) {
            expPref = config.getString("DEPLOY_PDB_DIR");
            if (expPref == null || expPref.trim().equals("")) {
                expPref = "https:";
            }
        } else if (this._preference == 3) {
            expPref = config.getString("CARTDIR");
        } else if (this._preference == 4) {
            expPref = config.getString("CARTSCRIPTDIR");
        }
        File defaultDirFile = null;
        if (expPref != null && expPref.length() > 0) {
            defaultDirFile = new File(expPref);
            if (defaultDirFile.isDirectory()) {
                return defaultDirFile.getPath();
            }
            if (defaultDirFile.isFile()) {
                return defaultDirFile.getParent();
            }
        }
        if ((defaultDirFile = new File(expDir = System.getProperty("user.home"))).isDirectory()) {
            return defaultDirFile.getPath();
        }
        if (defaultDirFile.isFile()) {
            return defaultDirFile.getParent();
        }
        return "";
    }

    public String getValidationMessage() {
        return this._validationMessage;
    }

    public String getEncoding() {
        return this._encoding == null ? IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING") : this._encoding;
    }

    public void setEncoding(String value) {
        this._encoding = value;
    }

    private void initFormat() {
        this.initFormat(ICommonConfig.Storage.getInstance());
    }

    public void initFormat(IStorage config) {
        if (this._preference == 1) {
            this._saveAsType = config.getInt("SAVE_AS_TYPE");
            Boolean x = config.getBoolean("EXPORT_OPEN_TGT");
            if (x != null) {
                this._openTarget = x;
            }
            this._defaultOpenTarget = this._openTarget;
            x = config.getBoolean("EXPORT_GEN_SCRIPT");
            if (x != null) {
                this._genScript = x;
            }
            if ((x = config.getBoolean("EXPORT_GEN_DATE")) != null) {
                this._genDate = x;
            }
            this._encoding = config.getString("EXPORT_ENCODING");
            x = config.getBoolean("EXPORT_COMPRESSED");
            if (x != null) {
                this._isCompressed = x;
            }
        } else if (this._preference == 2) {
            this._saveAsType = config.getInt("DIFF_SAVE_AS_TYPE");
            Boolean x = config.getBoolean("DIFF_OPEN_TGT");
            if (x != null) {
                this._openTarget = x;
            }
            this._defaultOpenTarget = this._openTarget;
            x = config.getBoolean("DIFF_GEN_SCRIPT");
            if (x != null) {
                this._genScript = x;
            }
            this._encoding = config.getString("DIFF_ENCODING");
        } else if (this._preference == 3) {
            this._saveAsType = 0;
            this._encoding = config.getString("CART_ENCODING");
        } else if (this._preference == 4) {
            this._saveAsType = 0;
            this._encoding = config.getString("CART__SCRIPT_ENCODING");
        } else if (this._preference == 5) {
            this._saveAsType = config.getInt("DEPLOY_SAVE_AS_TYPE");
            Boolean x = config.getBoolean("DEPLOY_OPEN_TGT");
            if (x != null) {
                this._openTarget = x;
            }
            this._defaultOpenTarget = this._openTarget;
            x = config.getBoolean("DEPLOY_GEN_SCRIPT");
            if (x != null) {
                this._genScript = x;
            }
            if ((x = config.getBoolean("DEPLOY_GEN_DATE")) != null) {
                this._genDate = x;
            }
            this._encoding = config.getString("DEPLOY_ENCODING");
        }
        this._saveAs = config instanceof TargetFormatConfig ? this.getDefaultSaveAs(config) : this.getSaveAsFile(config);
    }

    public void saveFormat(IStorage config) {
        if (this._preference == 1) {
            config.putString("EXPORTDIR", this.getSaveAs());
            config.putBoolean("EXPORT_OPEN_TGT", this.isOpenTarget());
            config.putBoolean("EXPORT_GEN_SCRIPT", this.isGenScript());
            config.putBoolean("EXPORT_GEN_DATE", this.isGenDate());
            config.putString("EXPORT_ENCODING", this.getEncoding());
            config.putBoolean("EXPORT_COMPRESSED", this.isCompressed());
            config.putInt("SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 2) {
            config.putString("DIFFDIR", this.getSaveAs());
            config.putBoolean("DIFF_OPEN_TGT", this.isOpenTarget());
            config.putBoolean("DIFF_GEN_SCRIPT", this.isGenScript());
            config.putString("DIFF_ENCODING", this.getEncoding());
            config.putInt("DIFF_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 3) {
            config.putString("CARTDIR", this.getSaveAs());
            config.putString("CART_ENCODING", this.getEncoding());
            config.putInt("CART_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 4) {
            config.putString("CARTSCRIPTDIR", this.getSaveAs());
            config.putString("CART__SCRIPT_ENCODING", this.getEncoding());
            config.putInt("CART_SCRIPT_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 5) {
            config.putString("DEPLOYDIR", this.getSaveAs());
            config.putBoolean("DEPLOY_OPEN_TGT", this.isOpenTarget());
            config.putBoolean("DEPLOY_GEN_SCRIPT", this.isGenScript());
            config.putBoolean("DEPLOY_GEN_DATE", this.isGenDate());
            config.putString("DEPLOY_ENCODING", this.getEncoding());
            config.putInt("DEPLOY_SAVE_AS_TYPE", this.getSaveAsType());
        } else if (this._preference == 6) {
            config.putString("DEPLOY_PDB_DIR", this.getSaveAs());
            config.putString("DEPLOY_PDB_ENCODING", this.getEncoding());
            config.putInt("DEPLOY_PDB_SAVE_AS_TYPE", this.getSaveAsType());
        }
    }

    static {
        TargetFormatConfig.DefaultInitializer.init();
        SINGLE_FILE_STR = DDLResources.getString("SAVE_AS_SINGLE");
        MULTIPLE_FILES_STR = DDLResources.getString("SAVE_AS_MULTIPLE_FILES");
        TYPE_FILES_STR = DDLResources.getString("SAVE_AS_BY_TYPE");
        SEPARATE_DIRS_STR = DDLResources.getString("SAVE_AS_SEP_DIRS");
        WORKSHEET_STR = DDLResources.getString("SAVE_AS_WORKSHEET");
        CLIPBOARD_STR = DDLResources.getString("SAVE_AS_CLIPBOARD");
        CSTORAGE_MULTIPLE_FILE_STR = DDLResources.getString("SAVE_AS_CSTORAGE_MULTIPLE_FILES");
        _saveAsTypes = new String[]{SINGLE_FILE_STR, MULTIPLE_FILES_STR, TYPE_FILES_STR, SEPARATE_DIRS_STR, WORKSHEET_STR, CLIPBOARD_STR};
        _compressionTypes = new String[]{ZIP_STR};
        _compressionExtensions = new String[]{ZIP_EXT_STR};
    }
}

