/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JTable;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportGenerationOutputStream;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.export.service.IExportServiceAddendum;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.extract.models.ExtractObjectSqlModel;
import oracle.dbtools.extract.models.ExtractScript;
import oracle.dbtools.extract.models.ExtractSqlHandler;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.writers.ImportGenFile;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;

public abstract class ExportService {
    private static String SPACE = " ";
    private ExportParms _eParms;
    private ExportService _eService;
    private IToolRunMode _tRunMode;
    private boolean _isCancel;
    private String _connName;
    private DDLFormat _ddlFormat;
    private DDLTypes _ddlType;
    private ExtractDataFormat _dataFormat;
    private ExportGenerationOutputStream _genOutput;
    private ExtractListModel _listModel;
    private ToolLogger _eLogger;
    private boolean _isShowELog;
    ResultsFormatter _formatter = null;
    private TargetFormat _targetFormat;

    public ExitCode start(ExportParms eParms, IToolRunMode tRunMode) {
        this._eParms = eParms;
        this._tRunMode = tRunMode;
        this._eService = this;
        if (this._eParms.getListModel() != null) {
            this.setExtractListModel(this._eParms.getListModel());
        } else {
            this._ddlFormat = this._eParms.getDDLFormat();
            this._dataFormat = this._eParms.getDataFormat();
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public ExitCode validate() {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        String validation = this.checkSetup();
        if (validation != null) {
            exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(validation);
        }
        return exitCode;
    }

    public void export() throws Exception {
        this.writeExportDBObjects();
    }

    public ExitCode finish() {
        return ExitCode.EXIT_SUCCESS;
    }

    public ResultsFormatter getFormatter() {
        return this._formatter;
    }

    public IToolRunMode getRunMode() {
        return this._tRunMode;
    }

    public void taskFinishedServiceProcess() {
    }

    public void taskCancelledServiceProcess() {
    }

    public void taskFailedServiceProcess() {
    }

    public String getConnName() {
        return this._connName;
    }

    public void setConnName(String connName) {
        this._connName = connName;
    }

    public boolean isCancel() {
        return this._isCancel;
    }

    public void isCancel(boolean value) {
        this._isCancel = value;
    }

    public ExtractDataFormat getDataFormat() {
        return this._dataFormat;
    }

    public void setDDLFormat(ExtractDataFormat dataFormat) {
        this._dataFormat = dataFormat;
    }

    public DDLFormat getDDLFormat() {
        return this._ddlFormat;
    }

    public void setDDLFormat(DDLFormat ddlFormat) {
        this._ddlFormat = ddlFormat;
    }

    public DDLTypes getDDLType() {
        return this._ddlType;
    }

    public void setDDLTypes(DDLTypes ddlType) {
        this._ddlType = ddlType;
    }

    public ExportGenerationOutputStream getGenOutput() {
        return this._genOutput;
    }

    public void setGenOutput() {
        this.setGenOutput(this._targetFormat);
    }

    public void setGenOutput(TargetFormat targetFormat) {
        this._genOutput = new ExportGenerationOutputStream(targetFormat);
    }

    public void startGenOutput() throws IOException {
        this.setGenOutput(this._targetFormat);
        SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
        this._genOutput.startPreamble(ExportResources.getString("CONTROL_PREFIX") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
        this._genOutput.endPreamble();
    }

    public void writeGenOutput(String data) throws IOException {
        this._genOutput.println(data);
    }

    public ExtractListModel getListModel() {
        return this._listModel;
    }

    public void setListModel(ExtractListModel listModel) {
        this._listModel = listModel;
    }

    public void setExtractListModel(ExtractListModel listModel) {
        this._listModel = listModel;
        this.setConnName(this._listModel.getSourceConnName());
        this._ddlFormat = this._listModel.getDDLFormat();
        this._dataFormat = this._listModel.getDataFormat();
        this._ddlType = this._listModel.getDDLTypes();
    }

    public boolean taskProgress() {
        return this.taskProgress(null);
    }

    public boolean taskProgress(String msg) {
        if (this._tRunMode.getTaskProgressUpdater() != null) {
            try {
                this._tRunMode.getTaskProgressUpdater().checkCanProceed();
            }
            catch (ExecutionException e) {
                this.isCancel(true);
                return false;
            }
        }
        if (msg != null) {
            this._tRunMode.getTaskDescriptor().setMessage(msg);
            if (!msg.isEmpty()) {
                this.eLog(msg);
            }
        }
        return true;
    }

    public void initELogger() {
        this._eLogger = this._tRunMode.getToolLogger();
        this._eLogger.logToolStart(this.getToolName());
        String unloadTo = this._targetFormat.getSaveAsType() < 4 ? this._targetFormat.getSaveAs() : this._targetFormat.getSaveAsTypeString();
        String msg = ExportResources.format("UNLOADING2", this._targetFormat.getSaveAsTypeString(), unloadTo);
        this._eLogger.log(msg);
    }

    public ToolLogger getELogger() {
        return this._eLogger;
    }

    public void eLog(String msg) {
        if (this._eLogger != null) {
            this._eLogger.log(msg);
        }
    }

    public void eLogException(Exception e) {
        if (e != null && this._eLogger != null) {
            this._eLogger.logException((Throwable)e);
        }
    }

    public void eLogHref(URL url) {
        if (url != null && this._eLogger != null) {
            this._eLogger.logHref(url);
        }
    }

    public void eLogToolEnd() {
        if (this._eLogger != null) {
            this._eLogger.logToolEnd();
        }
    }

    public TargetFormat getTargetFormat() {
        return this._targetFormat;
    }

    public void setTargetFormat(TargetFormat tFormat) {
        this._targetFormat = tFormat;
    }

    public String getTerm() {
        return this._tRunMode.getLineTerminator();
    }

    public String getToolName() {
        return ExportResources.getString("EXPORT_TOOL");
    }

    public boolean isExportDBObjects() {
        return this._listModel.isTypeDBO();
    }

    public boolean isDeployPdbCloud() {
        return this._eParms.getServiceType() == ExportServiceType.DEPLOY_CLOUD_WALLET;
    }

    private String checkSetup() {
        StringBuilder sb = new StringBuilder();
        boolean isOk = true;
        if (this._targetFormat.getSaveAs() == null) {
            sb.append(ExportResources.getString("NO_FILE") + this.getTerm());
            isOk = false;
        }
        if (this._targetFormat.getSaveAsType() == 4 || this._targetFormat.getSaveAsType() == 5) {
            this._targetFormat.isCompressed(false);
        }
        if (this.isExportDBObjects()) {
            if (this._ddlFormat == null) {
                sb.append(ExportResources.getString("NO_FORMAT") + this.getTerm());
                isOk = false;
            }
            if (this._ddlType == null) {
                sb.append(ExportResources.getString("NO_TYPE") + this.getTerm());
                isOk = false;
            }
        } else if (this._listModel == null || this._listModel.getFirstDataObject() == null || this._listModel.getFirstDataObject().getTable() == null) {
            sb.append(ExportResources.getString("NO_DATA") + this.getTerm());
            isOk = false;
        }
        return isOk ? null : sb.toString();
    }

    public static String validateOptions(DDLFormat ddlFormat, ExtractDataFormat dataFormat, TargetFormat targetFormat, Object pdfOptions, Component ui, IExportServiceAddendum addendum) {
        int formatterAction;
        String result;
        int targetAction = 0;
        String msg = "";
        if ((targetFormat.getSaveAsType() == 0 || targetFormat.getSaveAsType() >= 4) && dataFormat.isExportEnabled() && ddlFormat.isExtractEnabled() && !ImportDataFormat.isInsert(dataFormat.getFormat())) {
            Object[] format = new Object[]{targetFormat.getSaveAsTypeString(), dataFormat.getFormat()};
            return ExportResources.format("SINGLE_FILE_NOT_SUPPORTED", format);
        }
        if (targetFormat.getSaveAsType() == 0 && dataFormat.isExportEnabled() && ImportDataFormat.isLoader(dataFormat.getFormat()) && dataFormat.isSeparateDataFile()) {
            Object[] format = new Object[]{targetFormat.getSaveAsTypeString(), dataFormat.getFormat(), ExportResources.getString("SEPARATE_DATA_FILE")};
            return ExportResources.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT_WITH_OPT", format);
        }
        if (targetFormat.isCompressed() && dataFormat.isExportEnabled() && ((ResultsFormatter)dataFormat.getFormatter()).isStreamHandler()) {
            Object[] format = new Object[]{ExportResources.getString("COMPRESSED"), dataFormat.getFormat()};
            return ExportResources.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT", format);
        }
        if (targetFormat.getSaveAsType() < 4) {
            targetAction = targetFormat.validateSaveAs(ui);
            if (targetAction == 1) {
                return targetFormat.getValidationMessage();
            }
            if (targetAction == 2) {
                return "";
            }
        } else if (dataFormat.isExportEnabled() && !dataFormat.isTextEditorReadable()) {
            Object[] format = new Object[]{targetFormat.getSaveAsTypeString(), dataFormat.getFormat()};
            return ExportResources.format("SAVE_AS_NOT_SUPPORTED_FOR_FMT", format);
        }
        ResultsFormatter formatter = (ResultsFormatter)dataFormat.getFormatter();
        if (!ddlFormat.isExtractEnabled() && dataFormat.isExportEnabled()) {
            targetFormat.setDataFormatExtension(formatter.getExt());
        }
        if (addendum != null && (result = addendum.validateOptions(formatter, pdfOptions)) != null) {
            return result;
        }
        if (formatter.isQuerySupported()) {
            formatter.setQueryName(dataFormat.getQueryName());
            formatter.isQuerySaved(dataFormat.isQuerySaved());
        }
        if (formatter.isDataNameSupported()) {
            formatter.setDataName(dataFormat.getDataName());
        }
        if (formatter.isCommitSupported()) {
            formatter.isCommit(dataFormat.isCommit());
            formatter.setCommitRows(dataFormat.getCommitRows());
        }
        if ((formatterAction = formatter.validateOptions()) != 0) {
            msg = msg + (msg.length() == 0 ? formatter.getValidationMessage() : "\n\n" + formatter.getValidationMessage());
        }
        if (targetAction != 0 || formatterAction != 0) {
            if (targetAction == 1 || formatterAction == 1) {
                return msg;
            }
            return "";
        }
        return null;
    }

    public void writeExportDBObjects() throws Exception {
        DDLGenerator gen = DDLGenerator.getInstance();
        gen.setWriter(this._genOutput.getWriter());
        gen.setFormating(this._ddlFormat);
        if (this._targetFormat.isGenDate()) {
            SimpleDateFormat bartDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
            Date date = new Date();
            String hdrLines = "--------------------------------------------------------" + this.getTerm() + ExportResources.getString("FILE_CREATED") + bartDateFormat.format(date) + "   " + this.getTerm() + "--------------------------------------------------------" + this.getTerm();
            if (this._targetFormat.getSaveAsType() == 0) {
                if (this._ddlFormat.isExtractEnabled() || ImportDataFormat.isInsert(this._dataFormat.getFormat())) {
                    this.writeGenOutput(hdrLines);
                }
            } else {
                this._genOutput.setControllingFileHeader(hdrLines);
            }
        }
        this.taskProgress();
        if (!this.isCancel() && !this._listModel.getReconcileType().isNone()) {
            if (this._listModel.getReconcileType().isTypesAndObjects()) {
                this._listModel.startProcess(this.getRunMode().getTaskProgressUpdater());
            } else {
                this._listModel.startProcessReconcileObjects(this.getRunMode().getTaskProgressUpdater());
            }
        }
        this.taskProgress("");
        if (!this.isCancel()) {
            this.exportScript(9);
        }
        this.taskProgress();
        if (!this.isCancel() && this._ddlFormat.isExtractEnabled() && this._ddlFormat.getDrop()) {
            this._genOutput.startObject("DROP", "DROP");
            this.exportMetaListAppend(4);
        }
        this.taskProgress();
        if (!this.isCancel() && this._ddlFormat.getDep()) {
            this._ddlType.setTypes(this._listModel.getList(0, new int[]{100}));
        }
        this.taskProgress();
        if (!this.isCancel()) {
            this.exportMetaList(2);
        }
        this.taskProgress();
        if (!this.isCancel() && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(7);
        }
        this.taskProgress();
        if (!this.isCancel() && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isTruncate() && this._ddlFormat.isExtractEnabled() && !this._ddlFormat.getDrop()) {
            this._genOutput.startObject("TRUNCATE", "TRUNCATE");
            this.exportMetaListAppend(5);
        }
        this.taskProgress();
        if (!this.isCancel()) {
            this.exportDataList(8);
        }
        if (!this.isCancel()) {
            this.exportMetaList(3);
        }
        this.taskProgress();
        this.taskProgress();
        if (!this.isCancel() && this._dataFormat != null && this._dataFormat.isExportEnabled() && this._dataFormat.isDisableConstraints() && !this._ddlFormat.getDrop()) {
            this.exportMetaList(6);
        }
        this.taskProgress();
        if (!this.isCancel()) {
            this.exportScript(10);
        }
    }

    private void exportMetaListAppend(int type) throws Exception {
        List<ExtractObject> eolist = this._listModel.getList(type);
        for (ExtractObject eo : eolist) {
            String msg = ExportResources.getString("OPERATION_DDL") + SPACE + eo.getObjectType() + SPACE + eo.getTableName();
            this.taskProgress(msg);
            if (this.isCancel()) break;
            String ddl = this.getDDL(eo, type);
            if (ddl.length() <= 0) continue;
            this.writeGenOutput(ddl + this.getTerm());
        }
    }

    private void exportMetaList(int type) throws Exception {
        List<ExtractObject> eolist = this._listModel.getList(type);
        for (ExtractObject eo : eolist) {
            String msg = ExportResources.getString("OPERATION_DDL") + SPACE + eo.getObjectType() + SPACE + eo.getTableName();
            this.taskProgress(msg);
            if (this.isCancel()) break;
            BasicDBObject dbo = eo.getDBObject();
            String objectName = eo.getExternalTableName();
            String objectType = eo.isTypeDataFile() ? "TABLE" : dbo.getObjectType();
            ExtractScript es = null;
            if (type == 2 || type == 3) {
                es = eo.getScript(110);
            }
            if (es == null) {
                this._genOutput.startObject(objectName, objectType);
            } else {
                this._genOutput.startObject(objectName, objectType, es.getType(), es.getPath());
            }
            this.initApex(objectType);
            String ddl = this.getDDL(eo, type);
            if (ddl.length() > 0) {
                this.writeGenOutput(ddl + this.getTerm());
            }
            if (type == 2) {
                this.exportScript(eo, 111);
                continue;
            }
            if (type != 3) continue;
            this.exportScript(eo, 111);
        }
    }

    public void initApex(String objectType) throws Exception {
    }

    public void exportDataList(int type) throws Exception {
        List<ExtractObject> eolist = this._listModel.getList(type);
        for (ExtractObject eo : eolist) {
            String msg = ExportResources.getString("OPERATION_DATA") + SPACE + eo.getObjectType() + SPACE + eo.getTableName();
            this.taskProgress(msg);
            if (this.isCancel()) break;
            BasicDBObject dbo = eo.getDBObject();
            String objectName = eo.getExternalTableName();
            String objectType = eo.isTypeDataFile() ? "TABLE" : dbo.getObjectType();
            this.initDataExport(eo);
            ExtractScript es = eo.getScript(112);
            if (es == null) {
                this._genOutput.startObject(objectName, "DATA_" + objectType);
            } else {
                this._genOutput.startObject(objectName, "DATA_" + objectType, es.getType(), es.getPath());
            }
            if (!eo.isEmptySelect()) {
                this.writeDataUsingFormatter(eo);
            }
            this.exportScript(eo, 113);
        }
        if (eolist.size() > 0) {
            this._formatter.finishExport();
        }
    }

    public String getDDL(ExtractObject eo, int type) {
        return eo.getDDL(type).trim();
    }

    public void exportScript(int type) throws IOException {
        List<ExtractObject> eolist = this._listModel.getList(type);
        for (ExtractObject eo : eolist) {
            String msg = ExportResources.getString("OPERATION_BUILD") + SPACE + ExtractListModel.getListTypeName(type) + SPACE + eo.getTableName();
            this.taskProgress(msg);
            if (this.isCancel()) break;
            this.exportScript(eo, type == 9 ? 114 : 115);
        }
    }

    public void exportScript(ExtractObject eo, int opt) throws IOException {
        ExtractScript es = eo.getScript(opt);
        if (es != null) {
            BasicDBObject dbo = eo.getDBObject();
            String name = eo.getTableName();
            if (!eo.isTypeDataFile()) {
                name = eo.getType() == 0 ? eo.getDBObject().getObjectName() : (opt == 114 ? "INITIAL" : "FINAL");
            }
            this._genOutput.writeScript(name, es.getType(), es.getPath());
        }
    }

    public void initDataExport() {
        this.initDataExport(null);
    }

    public void initDataExport(ExtractObject EO) {
        this.initDataExport(EO, null);
    }

    public void initDataExport(ExtractObject EO, ResultsFormatter formatter) {
        BaseDataFormat dataFormat = null;
        if (EO != null && EO.isTypeDataFile()) {
            this._formatter = formatter != null ? formatter : EO.getGenFile();
            dataFormat = (ImportDataFormat)EO.getImportProperties().get(ImportKeys.IMPORT_DATA_FORMAT);
        } else {
            this._formatter = formatter != null ? formatter : (ResultsFormatter)this._dataFormat.getFormatter();
            dataFormat = this._dataFormat;
        }
        this._formatter.startExport();
        this._formatter.isHeader(dataFormat.isHeader());
        this._formatter.setDelimiter(dataFormat.getDelimiterValue());
        this._formatter.setEnclosures(dataFormat.getEnclosures(), this._dataFormat.getEnclosureLeftValue(), this._dataFormat.getEnclosureRightValue(), this._dataFormat.isEnclosureRightDouble());
        this._formatter.setLineTerminator(dataFormat.getRecordTerminatorValue());
        this._formatter.setLineTerminatorString(BaseDataFormat.getRecordTerminatorString(dataFormat.getRecordTerminatorValue()));
        this._formatter.isSeparateDataFile(true);
        this._formatter.setEncode(this._targetFormat.getEncoding());
        this._dataFormat.setEncoding(this._targetFormat.getEncoding());
        this._formatter.isDeployCloud(this._targetFormat.isDeployCloud());
        this._targetFormat.setDataFormatExtension(this._formatter.getExt());
        this._genOutput.setFormatter(this._formatter);
        if (this._formatter instanceof ImportGenFile) {
            this._formatter.setDataName("");
            this._formatter.isQuerySaved(false);
            this._formatter.setQueryName("");
        } else {
            this._formatter.setDataName(this._dataFormat.getDataName());
            this._formatter.isQuerySaved(this._dataFormat.isQuerySaved());
            this._formatter.setQueryName(this._dataFormat.getQueryName());
        }
        IExportServiceAddendum addendum = (IExportServiceAddendum)this._tRunMode.getAddendum();
        if (addendum != null) {
            addendum.initDataExport(EO, formatter, (ExportParms)this._tRunMode.getParms());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataUsingFormatter(ExtractObject dataObject) throws FileNotFoundException {
        IResultsFormatterWrapper provider = null;
        if (!this._targetFormat.isCompressed()) {
            this._formatter.setOutWriter(this.getGenOutput().getWriter());
            this._formatter.setOutputStream(this.getGenOutput().getOutputStream());
        } else {
            this._formatter.setZipper(this.getGenOutput().getZipper());
        }
        JTable table = (JTable)dataObject.getTable();
        ExtractObjectSqlModel sqlModel = dataObject.getSqlModel();
        try {
            if (!dataObject.isTypeDataFile()) {
                provider = this.getDataProvider(dataObject);
                this._formatter.setDataProvider(provider);
            }
            this._formatter.setDbObject((Object)dataObject.getDBObject());
            this._formatter.setTableName(dataObject.getTableName());
            this._formatter.setFileName(this.getGenOutput().getCurrentFileName());
            this._formatter.doPrint(this._tRunMode.getTaskProgressUpdater());
            if (this._formatter.getResultsFormatterWrapper() != null) {
                this.eLog(ExportResources.getString("EXPORTED_ROWS") + " " + this._formatter.getResultsFormatterWrapper().getRowNum() + "");
            }
            ArrayList addFiles = this._formatter.getAddToControllingFile();
            for (String fileName : addFiles) {
                this.getGenOutput().addToControllingFile(fileName);
            }
        }
        catch (Exception e2) {
            Logger.warn(this.getClass(), (Throwable)e2);
            this.eLogException(e2);
        }
        finally {
            try {
                if (provider != null && sqlModel.isExtractOwnedRS() && this._formatter != null) {
                    this._formatter.close();
                }
            }
            catch (Exception e2) {
                Logger.warn(this.getClass(), (Throwable)e2);
                this.eLogException(e2);
            }
        }
    }

    public IResultsFormatterWrapper getDataProvider(ExtractObject dataObject) {
        try {
            return ExtractSqlHandler.getDataProvider(dataObject);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
            this.eLogException(e);
            return null;
        }
    }
}

