/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.extract.models.ExtractObjectSqlModel;
import oracle.dbtools.extract.models.IExtractSqlHandler;
import oracle.dbtools.parser.plsql.BasicTabCol;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.format.SQLFormatterWrapper;
import oracle.dbtools.util.Logger;

public class BasicExtractSqlHandler
implements IExtractSqlHandler {
    private static IExtractSqlHandler handler;

    public static void setHandler(IExtractSqlHandler my_handler) {
        handler = my_handler;
    }

    @Override
    public String getInternalTableName(ExtractObject eo) {
        return ExtractResources.getString("EO_DEFAULT_EXPORT_NAME");
    }

    @Override
    public boolean isTableDirty(ExtractObject eo) {
        return false;
    }

    @Override
    public IResultsFormatterWrapper getDataProvider(ExtractObject dataObject) throws Exception {
        ExtractObjectSqlModel sqlModel = dataObject.getSqlModel();
        sqlModel.isExtractOwnedRS(false);
        SQLFormatterWrapper provider = null;
        if (!dataObject.isTypeDataFile() && !dataObject.isSourceConnTimesTen()) {
            sqlModel.isExtractOwnedRS(true);
            if (dataObject.getDBObject() != null) {
                provider = dataObject.isSqlExtendable() ? new SQLFormatterWrapper(dataObject.getDBObject().getConnectionName(), dataObject.getSqlForVisibleCols() + dataObject.getFinalWhere(), dataObject.getBindMap()) : new SQLFormatterWrapper(dataObject.getDBObject().getConnectionName(), dataObject.getSql() + dataObject.getFinalWhere());
            }
        }
        return provider;
    }

    @Override
    public void dataPrepare(ExtractObject eo) {
        this.initSqlForDBO(eo);
        this.scrubColList(eo);
        eo.getSqlModel().setColumns("*");
    }

    protected void initSqlForDBO(ExtractObject eo) {
        String tName;
        ExtractObjectSqlModel model = eo.getSqlModel();
        BasicDBObject dbo = eo.getDBObject();
        if (!eo.isSourceConnHive()) {
            model.setBindMap(dbo.getDictionary());
            tName = DBUtil.getInstance((String)eo.getSourceConnName()).addDbQuotes(dbo.getObjectName());
        } else {
            model.setBindMap(new HashMap());
            tName = eo.getDBObject().getObjectName();
        }
        if (eo.isSourceConnOracle() || eo.isSourceConnTimesTen()) {
            model.setSql("select * from (select * from " + this.getSchema(eo) + "." + tName + ")");
        } else if (this.getSchema(eo) != null) {
            if (eo.getDBObject().getConnectionType().equals("Sybase") || dbo.getConnectionType().equals("Microsoft SQL Server")) {
                String catalog = this.getCatalog(eo);
                if (catalog == null) {
                    model.setSql("select * from (select * from " + this.getSchema(eo) + "." + tName + ") as t");
                } else {
                    model.setSql("select * from (select * from " + catalog + "." + this.getSchema(eo) + "." + tName + ") as t");
                }
            } else {
                model.setSql("select * from (select * from " + this.getSchema(eo) + "." + tName + ") as t");
            }
        } else {
            model.setSql("select * from (select * from " + DBUtil.addDoubleQuote((String)dbo.getObjectName()) + ") as t");
        }
        model.setRawSql(model.getSql());
        if (eo.isSourceConnTimesTen()) {
            model.isSqlExtendable(false);
        }
    }

    protected String getSchema(ExtractObject eo) {
        BasicDBObject dbo = eo.getDBObject();
        return dbo.getSchemaName() == null || dbo.getSchemaName().equals("") ? null : (!eo.isSourceConnHive() ? DBUtil.getInstance((String)eo.getSourceConnName()).addDbQuotes(dbo.getSchemaName()) : dbo.getSchemaName());
    }

    protected String getCatalog(ExtractObject eo) {
        BasicDBObject dbo = eo.getDBObject();
        String catalog = dbo.getCatalog();
        return catalog == null || catalog.equals("") ? null : (!eo.isSourceConnHive() ? DBUtil.getInstance((String)eo.getSourceConnName()).addDbQuotes(catalog) : catalog);
    }

    protected void scrubColList(ExtractObject eo) {
        this.scrubColList(eo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrubColList(ExtractObject eo, BasicTabCol tabCol) {
        BasicDBObject dbo = eo.getDBObject();
        ExtractObjectSqlModel model = eo.getSqlModel();
        if (tabCol == null) {
            tabCol = new BasicTabCol(eo.getSourceConnName());
        }
        if (eo.isSourceConnOracle() && !eo.isSourceConnTimesTen()) {
            try {
                ArrayList cols = tabCol.fetchColumns(model.getSql(), false);
                tabCol.colTypesToExclude = new ArrayList();
                tabCol.colNamesToExclude = new ArrayList();
                tabCol.colNamesToExclude.add("ORA_ROWSCN");
                tabCol.colNamesToExclude.add("ROWID");
                tabCol.colTypesToExclude = new ArrayList();
                model.setSqlLobs(tabCol.disambiguate(cols));
                model.isLobsEmptySelect(tabCol.isEmptySelect());
                model.isLobsExcludedColumns(tabCol.excludedColumns());
                tabCol.colTypesToExclude.add("BLOB");
                tabCol.colTypesToExclude.add("CLOB");
                tabCol.colTypesToExclude.add("NCLOB");
                model.setSqlNoLobs(tabCol.disambiguate(cols));
                model.isNoLobsEmptySelect(tabCol.isEmptySelect());
                model.isNoLobsExcludedColumns(tabCol.excludedColumns());
                if (tabCol.isEmptySelect()) {
                    if (!tabCol.excludedColumns()) {
                        model.setSqlNoLobs(model.getRawSql());
                    } else {
                        model.setSqlNoLobs("");
                    }
                }
                model.setSql(eo.getListModel().isAllowLobs() ? model.getSqlLobs() : model.getSqlNoLobs());
            }
            catch (Exception e) {
                Logger.warn(this.getClass(), (Throwable)e);
            }
            return;
        }
        String sourceConnName = eo.getSourceConnName();
        if (eo.isSourceConnHive()) {
            return;
        }
        boolean reUsed = false;
        Statement pstmt = null;
        ResultSet rset = null;
        boolean lockAcquired = false;
        try {
            lockAcquired = LockManager.lock((Connection)eo.getSourceConn());
            DBUtil dbUtil = DBUtil.getInstance((String)sourceConnName);
            reUsed = true;
            if (model.getBindMap() != null && !model.getBindMap().isEmpty()) {
                model.setSql(dbUtil.prepareNonOracleSql(model.getSql(), model.getBindMap()).getSQL());
                pstmt = ConnectionResolver.getConnection((String)sourceConnName).prepareStatement(model.getSql());
            } else if (model.getBindList() != null && !model.getBindList().isEmpty()) {
                model.setSql(dbUtil.prepareNonOracleSql(model.getSql()));
                pstmt = ConnectionResolver.getConnection((String)sourceConnName).prepareStatement(model.getSql());
                DBUtil.bind((PreparedStatement)pstmt, model.getBindList());
            }
            rset = pstmt.executeQuery();
            model.setSqlLobs(model.getSql());
            ResultSetMetaData header = rset.getMetaData();
            if (header != null) {
                int colType = 0;
                String colName = null;
                int len = header.getColumnCount();
                StringBuffer cols = new StringBuffer();
                String comma = "";
                for (int i = 0; i < len; ++i) {
                    colType = header.getColumnType(i + 1);
                    colName = header.getColumnName(i + 1);
                    if (colType != 2004 && colType != 2005 && colType != 2011) {
                        cols.append(comma + "\"" + colName + "\"");
                        comma = ",";
                        continue;
                    }
                    model.isNoLobsExcludedColumns(true);
                }
                if (cols.length() == 0) {
                    model.isNoLobsEmptySelect(true);
                }
                if (model.isNoLobsExcludedColumns()) {
                    int idx = model.getSql().indexOf("(");
                    model.setSqlNoLobs("SELECT " + cols.toString() + " from " + model.getSql().substring(idx));
                } else {
                    model.setSqlNoLobs(model.getSql());
                }
                model.setSql(eo.getListModel().isAllowLobs() ? model.getSqlLobs() : model.getSqlNoLobs());
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        finally {
            if (lockAcquired) {
                LockManager.unlock((Connection)eo.getSourceConn());
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (reUsed && rset != null) {
                    rset.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

