/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.groups;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Identifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;

public class AddressedIdentifier
implements Identifier {
    public static final char ADDRESS_SEP = '@';
    QualifiedIdentifier address;
    QualifiedIdentifier name;

    public AddressedIdentifier(String string) {
        this.parse(string);
    }

    public AddressedIdentifier(QualifiedIdentifier qualifiedIdentifier, QualifiedIdentifier qualifiedIdentifier2) {
        this.address = qualifiedIdentifier;
        this.name = qualifiedIdentifier2;
    }

    @Override
    public String getId(Boolean bl) {
        if (this.address == null) {
            if (this.name == null) {
                return null;
            }
            return this.name.getId(bl);
        }
        return this.address.getId(bl) + '@' + this.name.getId(bl);
    }

    @Override
    public String getId() {
        if (this.address == null) {
            if (this.name == null) {
                return null;
            }
            return this.name.getId();
        }
        return this.address.getId() + '@' + this.name.getId();
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private void parse(String string) {
        if (string == null) {
            this.address = null;
            this.name = null;
        } else {
            int n = string.indexOf(64);
            if (n >= 0) {
                String string2 = string.substring(0, n);
                String string3 = "";
                if (n < string.length() - 1) {
                    string3 = string.substring(n + 1);
                }
                this.address = new QualifiedIdentifier(string2);
                this.name = new QualifiedIdentifier(string3);
            } else {
                this.address = null;
                this.name = new QualifiedIdentifier(string);
            }
        }
    }
}

