/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.util.Properties;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.ConnectionCmd;
import oracle.dbtools.migration.command_line.DelConnCmd;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRunner;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.command_line.RunSQLCmd;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.thirdparty.sqlserver.SQLServerBrowserAddin;
import oracle.dbtools.thirdparty.sqlserver.SQLServerConnectionPanel;
import oracle.dbtools.thirdparty.sybase.SybaseBrowserAddin;
import oracle.dbtools.thirdparty.sybase.SybaseConnectionPanel;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class MkConnCmd
extends ConnectionCmd {
    public static final String CMDNAME = "mkconn";
    public static final String MIGREPOSQL = "CREATE USER <USERNAME> IDENTIFIED BY <PASSWORD>;GRANT CREATE SESSION,RESOURCE,CONNECT,CREATE VIEW,CREATE MATERIALIZED VIEW TO <USERNAME>;ALTER USER <USERNAME> QUOTA UNLIMITED ON USERS;";

    public MkConnCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_isPersistenceManagerRequired = false;
    }

    public MkConnCmd(String string, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, string, cMDOut, bl);
        this.m_isPersistenceManagerRequired = false;
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        Object object;
        Object object2;
        Object object3;
        Thread.currentThread().setContextClassLoader(MkConnCmd.class.getClassLoader());
        MigrationCmdRunner.setupSQLDeveloper();
        Properties properties = null;
        String string = null;
        if (this.isNameAlreadyUsed(this.m_connectionDetails.getConnName())) {
            this.getCmdout().printMessage("Warning: Name already used: Connection " + this.m_connectionDetails.getConnName() + " recreated");
            object3 = new String[]{this.m_connectionDetails.getConnName()};
            DelConnCmd.deleteConnection(object3);
        }
        if (this.m_connectionDetails.getDbType().equalsIgnoreCase("oracle")) {
            properties = this.getOracleProperties();
        } else if (this.m_connectionDetails.getDbType().equalsIgnoreCase("sybase")) {
            properties = this.getSybaseProperties();
            object3 = (String)properties.get("customUrl");
            object3 = (String)object3 + ";maxStatements=0";
            properties.setProperty("customUrl", (String)object3);
        } else if (this.m_connectionDetails.getDbType().equalsIgnoreCase("sqlserver")) {
            properties = this.getSybaseProperties();
            object3 = ((String)properties.get("customUrl")).replace("jdbc:jtds:sybase://", "jdbc:jtds:sqlserver://");
            properties.setProperty("customUrl", (String)object3);
            properties.setProperty("subtype", SQLServerBrowserAddin.SUBTYPE_SQL_SERVER);
            object2 = properties.get(SybaseConnectionPanel.SYBASE_DEFAULT_PASSWORD);
            properties.remove(SybaseConnectionPanel.SYBASE_DEFAULT_PASSWORD);
            properties.put(SQLServerConnectionPanel.SQLSERVER_DEFAULT_PASSWORD, object2);
            properties.setProperty("RaptorConnectionType", "Microsoft SQL Server");
        } else if (this.m_connectionDetails.getDbType().equalsIgnoreCase("mkrepouser")) {
            object3 = this.m_connectionDetails.getSuperConn();
            try {
                object2 = MIGREPOSQL.replaceAll("<USERNAME>", this.m_connectionDetails.getUsername());
                object2 = ((String)object2).replaceAll("<PASSWORD>", this.m_connectionDetails.getPassword());
                object = new RunSQLCmd((String)object3, (String)object2, this.getCmdout(), this.isSilent());
                ((MigrationCmd)object).execute();
            }
            catch (Exception exception) {
                throw new CMDLineError(CMDNAME, "Problem creating the new user and its privileges", exception);
            }
        }
        try {
            if (this.m_connectionDetails.getSuperConn() != null) {
                object3 = this.m_connectionDetails.getSuperConn();
                object2 = CMDUtil.getQualifiedName((String)object3);
                object = Connections.getInstance().getConnectionInfo((String)object2);
                properties = object;
                properties.put("user", this.m_connectionDetails.getUsername());
                properties.put("password", this.m_connectionDetails.getPassword());
                properties.put("SavePassword", Boolean.TRUE.toString());
            }
            DatabaseConnections.getInstance().testConnection(properties);
            ConnectionUtils.addConnToStore((String)this.m_connectionDetails.getConnName(), (Properties)properties, string);
        }
        catch (ConnectionException connectionException) {
            throw new CMDLineError(CMDNAME, "Problem creating connection", (Exception)((Object)connectionException));
        }
    }

    private boolean isNameAlreadyUsed(String string) {
        String[] stringArray;
        string = CMDUtil.getQualifiedName(string);
        for (String string2 : stringArray = Connections.getInstance().getConnNames()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private Properties getSybaseProperties() {
        Properties properties = new Properties();
        String string = null;
        properties.setProperty("user", this.m_connectionDetails.getUsername());
        properties.setProperty("password", this.m_connectionDetails.getPassword());
        if (this.m_connectionDetails.isDefaultPasswordUsed()) {
            properties.put(SybaseConnectionPanel.SYBASE_DEFAULT_PASSWORD, Boolean.TRUE.toString());
            properties.setProperty("password", "");
            properties.setProperty("NoPasswordConnection", Boolean.FALSE.toString());
        } else {
            if (this.m_connectionDetails.getPassword() != null) {
                properties.setProperty("password", this.m_connectionDetails.getPassword());
                properties.setProperty("SavePassword", Boolean.TRUE.toString());
            } else {
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            properties.put(SybaseConnectionPanel.SYBASE_DEFAULT_PASSWORD, Boolean.FALSE.toString());
            properties.setProperty("NoPasswordConnection", Boolean.TRUE.toString());
        }
        properties.setProperty("subtype", SybaseBrowserAddin.SUBTYPE_SYBASE);
        properties.setProperty("driver", "net.sourceforge.jtds.jdbc.Driver");
        properties.setProperty("RaptorConnectionType", "Sybase");
        if (this.m_connectionDetails.getHost() != null) {
            properties.setProperty("hostname", this.m_connectionDetails.getHost());
        }
        if (this.m_connectionDetails.getPort() != null) {
            properties.setProperty("port", this.m_connectionDetails.getPort());
        }
        string = this.m_connectionDetails.getSid() == null ? "jdbc:jtds:sybase://" + this.m_connectionDetails.getHost() + ":" + this.m_connectionDetails.getPort() + "/" : "jdbc:jtds:sybase://" + this.m_connectionDetails.getHost() + ":" + this.m_connectionDetails.getPort() + "/" + this.m_connectionDetails.getSid();
        properties.setProperty("customUrl", string);
        return properties;
    }

    private Properties getOracleProperties() {
        String string = "oracle.jdbc.OracleDriver";
        Properties properties = new Properties();
        String string2 = null;
        if (this.m_connectionDetails.getUsername().equals("/")) {
            properties.setProperty("oraDriverType", "oci8");
            string2 = "jdbc:oracle:oci8:@";
        } else {
            string2 = "jdbc:oracle:thin:@";
            properties.setProperty("user", this.m_connectionDetails.getUsername());
            if (this.m_connectionDetails.getPassword() != null) {
                properties.setProperty("password", this.m_connectionDetails.getPassword());
                properties.setProperty("SavePassword", Boolean.TRUE.toString());
            } else {
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            properties.setProperty("oraDriverType", "thin");
        }
        if (this.m_connectionDetails.getHost() != null) {
            string2 = string2 + this.m_connectionDetails.getHost();
        }
        if (this.m_connectionDetails.getPort() != null) {
            string2 = string2 + ":" + this.m_connectionDetails.getPort();
        }
        if (this.m_connectionDetails.getSid() != null) {
            string2 = string2 + ":" + this.m_connectionDetails.getSid();
        } else if (this.m_connectionDetails.getService() != null) {
            string2 = string2 + "/" + this.m_connectionDetails.getService();
        }
        properties.setProperty("subtype", "oraJDBC");
        properties.setProperty("driver", string);
        properties.setProperty("oraDriverType", "oci8");
        properties.setProperty("RaptorConnectionType", "Oracle");
        if (this.m_connectionDetails.getRole() != null) {
            properties.setProperty("role", this.m_connectionDetails.getRole());
        }
        if (this.m_connectionDetails.getHost() != null) {
            properties.setProperty("hostname", this.m_connectionDetails.getHost());
        }
        if (this.m_connectionDetails.getPort() != null) {
            properties.setProperty("port", this.m_connectionDetails.getPort());
        }
        if (this.m_connectionDetails.getSid() != null) {
            properties.setProperty("sid", this.m_connectionDetails.getSid());
        } else if (this.m_connectionDetails.getService() != null) {
            properties.setProperty("serviceName", this.m_connectionDetails.getService());
        }
        properties.setProperty("customUrl", string2);
        properties.setProperty("OracleConnectionType", OracleConnectionType.BASIC.name());
        if (this.m_connectionDetails.isOSAuthentication() || this.m_connectionDetails.getUsername().equals("/")) {
            properties.setProperty("OS_AUTHENTICATION", "TRUE");
            properties.setProperty("NoPasswordConnection", "FALSE");
        } else {
            properties.setProperty("NoPasswordConnection", "TRUE");
        }
        return properties;
    }
}

