/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDataMoveStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.utils.Connections;

public class OfflineDataMoveCmd
extends MigrationCmd {
    public static final String CMDNAME = "datamove";

    public OfflineDataMoveCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        this.verifyRepository();
        ListConvertedModelsCmd listConvertedModelsCmd = null;
        Long l = null;
        MdConnection mdConnection = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        DBObjectId dBObjectId2 = null;
        String string = "";
        MigrationPlugin migrationPlugin = null;
        OfflineDataMoveWorker offlineDataMoveWorker = null;
        String string2 = null;
        String string3 = null;
        try {
            Object object;
            String string4;
            if (persistenceManager == null) {
                string4 = MigrationAddin.getDefaultMigrationRepository();
                object = Connections.getInstance().getConnection(string4);
                MigrationAddin.openRepository(string4);
                persistenceManager = MigrationAddin.getPersistenceManager();
            }
            if (this.getMigrationDetails().getCurrentConvertedModel() == null) {
                int n = -1;
                listConvertedModelsCmd = (ListConvertedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lsconverted", this.getMigrationDetails(), this.getCmdout(), true);
                listConvertedModelsCmd.execute();
                object = this.getMigrationDetails().get("model");
                if (listConvertedModelsCmd.hasSingleConvertedModel() || object != null && "latest".equalsIgnoreCase(((String)object).trim())) {
                    l = listConvertedModelsCmd.getLatestConvertedModel();
                } else if (object != null) {
                    n = Integer.parseInt((String)object);
                    l = listConvertedModelsCmd.getModelIdForIndex(n);
                } else if (!listConvertedModelsCmd.hasSingleConvertedModel() && object == null) {
                    listConvertedModelsCmd.printModelList();
                    n = this.getCmdout().promptForModelSelection();
                    l = listConvertedModelsCmd.getModelIdForIndex(n);
                } else {
                    throw new IllegalStateException("There are no valid converted models in the repository");
                }
                if (l != null) {
                    this.getMigrationDetails().setCurrentConvertedModel(Long.toString(l));
                } else {
                    throw new IllegalStateException("Unable to locate converted model corresponding to id: " + n);
                }
            }
            if ((mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId = new DBObjectId(Long.parseLong(string4 = this.getMigrationDetails().getCurrentConvertedModel())))) != null) {
                Object object2;
                string = MigrationUtils.getPluginIdForConnection(mdConnection);
                dBObjectId2 = mdConnection.getProjectId();
                migrationPlugin = MigrationAddin.findPlugin(string);
                string2 = this.getMigrationDetails().get("output");
                object = null;
                if (string2 != null && string2.trim().length() > 0) {
                    object = new File(string2);
                    string3 = ((File)object).getCanonicalPath();
                    string3 = string3 + File.separator + CMDNAME;
                    object2 = new File(string3);
                    boolean bl = true;
                    if (!((File)object2).exists()) {
                        bl = ((File)object2).mkdirs();
                    }
                    if (!bl) {
                        throw new IllegalStateException("Unable to create necessary output directory");
                    }
                } else {
                    throw new IllegalArgumentException("output directory is invalid or not found");
                }
                object2 = migrationPlugin.getPlatformName();
                if (((String)object2).equals("sql server")) {
                    object2 = "Sybase";
                }
                String string5 = OfflineDataMoveStream.getTimeStamp();
                string5 = string5.replaceFirst(":", "h");
                string5 = string5.replaceFirst(":", "m");
                string5 = string5 + "s";
                offlineDataMoveWorker = new OfflineDataMoveWorker(persistenceManager, mdConnection, string3);
                offlineDataMoveWorker.doWork();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

