/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.MigrationEvent;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.BaseGeneration;
import oracle.dbtools.migration.generate.FilesPerObjectSqlGeneration;
import oracle.dbtools.migration.generate.FilesPerObjectTypeSqlGeneration;
import oracle.dbtools.migration.generate.GenerateAudience;
import oracle.dbtools.migration.generate.GenerateEvent;
import oracle.dbtools.migration.generate.GenerateEventListener;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.GroupsFromGroupIterator;
import oracle.dbtools.migration.generate.Messages;
import oracle.dbtools.migration.generate.MigrGenerationOrderIterator;
import oracle.dbtools.migration.generate.SchemasFromGroupIterator;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.generate.SingleFileSqlGeneration;
import oracle.dbtools.migration.generate.UntranslatedTriggersIterator;
import oracle.dbtools.migration.parser.ParserFactoryProvider;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.persistence.MigrGenerationOrder;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class GenerateWorker
implements Cancelable {
    private PersistenceManager m_persistenceManager;
    private DBObjectId m_connectionId;
    private GenerationOutputStream m_mainMasterOutputStream;
    private String m_outputDir;
    private GenerationOutputStream m_masterDumpStream = null;
    private File m_masterFile = null;
    private boolean _genDropStmts;
    private StringTemplateGroup m_templateGroup;
    private PersistenceUtility m_persistenceUtility;
    private GenerateAudience m_audience;
    private boolean m_shouldCancel = false;
    private String m_templateName;
    private static final String DEFAULT_TEMPLATE_NAME = "10g";
    private MigrationObjectFilterList m_filters;
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private ArrayList<String> m_viewsListForRecompile;
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private boolean m_tablesOnly = false;
    private Hashtable<DBObjectId, MdSchema> m_schemaCache = new Hashtable();
    private int m_numSchema;
    private boolean m_attemptLeastPrivilege;
    private String m_currentSchemaDumpDir;
    private Hashtable<String, String> m_SchemaDumpHashTable = null;
    private HashMap<Long, String> m_dependencies = null;
    private int m_counterForEmulationPkg = 0;
    private BaseGeneration m_baseGeneration;
    private MdConstraint m_IOTTableConstraint = null;
    private MdConstraint m_IOTPrimaryKey = null;
    private IOTMode cacheIOTMode = null;
    private MdIndexe m_IOTIndex = null;
    private String m_projectName;
    private boolean m_isOnlineGenerationMode = false;
    private File m_onlineGenerationFile;
    private HashMap<String, ArrayList<MdColumn>> m_addPkOnFk = new HashMap();
    private HashMap<String, String> m_deleteDuplicateFk = new HashMap();

    public GenerateWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, GenerationOutputStream generationOutputStream, String string, MigrationObjectFilterList migrationObjectFilterList, boolean bl) {
        this.setPersistenceManager(persistenceManager);
        this.setPersistenceUtility(PersistenceUtility.getInstance(persistenceManager));
        this.setConnectionId(dBObjectId);
        this.setOutputMainMasterStream(generationOutputStream);
        this.loadTemplates();
        this.m_audience = new GenerateAudience();
        this.setTemplateName(string);
        this.setFilters(migrationObjectFilterList);
        this.loadDependencies(persistenceManager);
        this._genDropStmts = bl;
        this.getBaseGenerationObject();
    }

    private void loadDependencies(PersistenceManager persistenceManager) {
        String string = "select distinct  a1.objid, a1.objname,a2.schemaName grantee  from md_migr_dependency d,md_derivatives d1, md_derivatives d2,mgv_All_details a1, mgv_all_details a2  where d1.src_id = d.child_id and d2.src_id = d.parent_id and d1.derivative_reason IS NULL and d1.original_identifier IS NOT NULL and d2.derivative_reason IS NULL and d2.original_identifier IS NOT NULL and a1.objid = d1.derived_id and a2.objid = d2.derived_id and d.child_object_type IN ('MD_TABLES','MD_VIEWS','MD_STORED_PROGRAMS') and d.parent_object_type IN ('MD_VIEWS','MD_STORED_PROGRAMS') and a1.schemaid <> a2.schemaid";
        this.m_dependencies = new HashMap();
        ResultSet resultSet = null;
        Statement statement = null;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public GenerateWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, GenerationOutputStream generationOutputStream, MigrationObjectFilterList migrationObjectFilterList, boolean bl) {
        this(persistenceManager, dBObjectId, generationOutputStream, DEFAULT_TEMPLATE_NAME, migrationObjectFilterList, bl);
    }

    public GenerateWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, GenerationOutputStream generationOutputStream, MigrationObjectFilterList migrationObjectFilterList) {
        this(persistenceManager, dBObjectId, generationOutputStream, DEFAULT_TEMPLATE_NAME, migrationObjectFilterList, false);
    }

    private void loadTemplates() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/migration/generate/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runGenerate(boolean bl) throws GenerateException {
        GenerateEvent generateEvent;
        try {
            MigrationLogUtil.startMigrationLogSession(this.getConnectionId());
            generateEvent = new GenerateEvent(4, "", MigrationAddinArb.getString("BEGIN_GENERATE"));
            this.fireEventListeners(generateEvent);
            this.m_attemptLeastPrivilege = bl;
            this.m_numSchema = this.findSchemaCount();
            this.getGenerator().startWritingMainMasterFile();
            this.generateCreateUsers();
            this.getGenerator().setAllSchemaNames();
            this.getGenerator().startGeneration();
            this.generateSchema();
            if (this.shouldCancel()) {
                boolean bl2 = false;
                return bl2;
            }
            generateEvent.setEventId(5);
            this.fireEventListeners(generateEvent);
        }
        catch (PersistenceException persistenceException) {
            generateEvent = new GenerateEvent(6, "", persistenceException.getLocalizedMessage());
            s_log.log(Level.SEVERE, Messages.getString("GenerateWorker.5"), new Object[]{persistenceException.getLocalizedMessage(), generateEvent.getEventSource(), new ClickableLogInfo(generateEvent.getEventSource(), Messages.getString("GenerateWorker.6"))});
            this.fireEventListeners(generateEvent);
            boolean bl3 = false;
            return bl3;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            generateEvent = new GenerateEvent(6, "", noSuchObjectException.getLocalizedMessage());
            s_log.log(Level.SEVERE, Messages.getString("GenerateWorker.8"), new Object[]{noSuchObjectException.getLocalizedMessage(), generateEvent.getEventSource(), new ClickableLogInfo(generateEvent.getEventSource(), Messages.getString("GenerateWorker.9"))});
            this.fireEventListeners(generateEvent);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.getPersistenceManager().releaseCache();
            this.getGenerator().writeSchemaMasterFile();
            this.getGenerator().writeDropObjectsInSchemaFile();
            this.getGenerator().endWritingMainMasterFile();
            this.getGenerator().endGeneration();
        }
        return true;
    }

    public int findSchemaCount() throws PersistenceException {
        return this.getPersistenceUtility().getSchemaCountForConnectionId(this.getConnectionId(), this.m_filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCreateUsers() throws PersistenceException, NoSuchObjectException, GenerateException {
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = this.m_persistenceUtility.getCatalogsForConnectionId(this.getConnectionId(), this.m_filters);
        boolean bl = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        boolean bl2 = false;
        while (closeableIterator.hasNext()) {
            MgvAllCatalogsRec mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next();
            CloseableIterator closeableIterator2 = this.m_persistenceUtility.getSchemasforCatalogId(mgvAllCatalogsRec.getCatalogId(), this.m_filters);
            if (bl && !bl2 && TranslationContext.getGenerateEntireEmulationPkg()) {
                if (MigrationAddin.getMigrationConfig().getCreateUser()) {
                    this.getGenerator().generateUserEntryInMainMaster("Emulation");
                }
                bl2 = true;
                this.getGenerator().setRecompileViewsFlag("Emulation", false);
            }
            String string = null;
            while (closeableIterator2.hasNext()) {
                GenerateEvent generateEvent;
                if (this.shouldCancel()) {
                    closeableIterator2.close();
                    generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    return;
                }
                MdSchema mdSchema = (MdSchema)closeableIterator2.next();
                try {
                    if (!this.m_persistenceUtility.isDBObjectEnabled(mdSchema.getKey().getId())) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    throw new GenerateException(exception);
                }
                if (!this.doSchemaContainObjects(mdSchema)) continue;
                this.m_schemaCache.put(mdSchema.getKey(), mdSchema);
                generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_USER"), mdSchema.getName());
                try {
                    this.fireEventListeners(generateEvent);
                    string = "CREATE_USER_" + mdSchema.getName() + ".sql";
                    if (!bl) continue;
                    StringTemplate stringTemplate = MigrationAddin.getMigrationConfig().getTarget12c() ? this.getTemplateGroup().getInstanceOf("CreateUser12c") : this.getTemplateGroup().getInstanceOf("CreateUser");
                    stringTemplate.setAttribute("mdschema", (Object)mdSchema);
                    stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                    String string2 = stringTemplate.toString();
                    stringTemplate.reset();
                    if (MigrationAddin.getMigrationConfig().getCreateUser()) {
                        this.getGenerator().generateUserEntryInMainMaster(mdSchema.getName());
                    }
                    CloseableIterator<MdGroup> closeableIterator3 = null;
                    try {
                        closeableIterator3 = this.m_persistenceUtility.getGroupsForSchemaId(mdSchema.getKey(), this.m_filters);
                        if (!closeableIterator3.hasNext()) continue;
                        stringTemplate = this.getTemplateGroup().getInstanceOf("GrantCreateRole");
                        stringTemplate.setAttribute("mdschema", (Object)mdSchema);
                        stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                        string2 = stringTemplate.toString();
                        stringTemplate.reset();
                    }
                    finally {
                        if (closeableIterator3 == null) continue;
                        closeableIterator3.close();
                    }
                }
                finally {
                    generateEvent.setEventId(2);
                    this.fireEventListeners(generateEvent);
                }
            }
            closeableIterator2.close();
        }
        closeableIterator.close();
    }

    public File getMasterFile() {
        return this.m_masterFile;
    }

    protected void generateSchema() throws PersistenceException, NoSuchObjectException, GenerateException {
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = this.m_persistenceUtility.getCatalogsForConnectionId(this.getConnectionId(), this.m_filters);
        boolean bl = false;
        this.getGenerator().generateMasterEntryInMainMaster("Emulation");
        while (closeableIterator.hasNext()) {
            MgvAllCatalogsRec mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next();
            CloseableIterator object = this.m_persistenceUtility.getSchemasforCatalogId(mgvAllCatalogsRec.getCatalogId(), this.m_filters);
            while (object.hasNext()) {
                if (this.shouldCancel()) {
                    object.close();
                    GenerateEvent generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    return;
                }
                MdSchema mdSchema = (MdSchema)object.next();
                if (!this.m_persistenceUtility.isDBObjectEnabled(mdSchema.getKey().getId()) || !this.doSchemaContainObjects(mdSchema)) continue;
                MdPackage mdPackage = this.getPersistenceUtility().getEmulationPackageForSchema(mdSchema.getKey());
                if (TranslationContext.getGenerateEntireEmulationPkg() && !bl) {
                    this.generateEmulationSchema(mdSchema);
                    bl = true;
                }
                this.generateIndividualSchema(mdSchema);
                this.getGenerator().generateMasterEntryInMainMaster(mdSchema.getName());
            }
            object.close();
        }
        if (this.m_schemaCache.size() > 0) {
            this.generateTranslatedObjects();
        }
        for (MdSchema mdSchema : this.m_schemaCache.values()) {
            this.generateConnect(mdSchema);
            if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                this.generateRoleMembers(mdSchema);
            }
            if (MigrationAddin.getMigrationConfig().getGenObjectTypeTables()) {
                this.generateForeignKeyConstraints(mdSchema);
            }
            if (MigrationAddin.getMigrationConfig().getGenObjectTypeTriggers()) {
                this.generateTriggers(mdSchema);
            }
            if (MigrationAddin.getMigrationConfig().getGenObjectTypeViews()) {
                this.generateViews(mdSchema);
            }
            if (MigrationAddin.getMigrationConfig().getGenObjectTypeProcedures()) {
                this.generateUntranslatedStoredProcedures(mdSchema);
            } else {
                this.generateClobToBlob(mdSchema, false);
            }
            if (MigrationAddin.getMigrationConfig().getGenObjectTypeFunctions()) {
                this.generateUntranslatedStoredFunctions(mdSchema);
            }
            if (!MigrationAddin.getMigrationConfig().getGenObjectTypeViews()) continue;
            this.generateRecompileViews(mdSchema);
        }
        this.getGenerator().generatePostEntryInMainMaster();
        closeableIterator.close();
    }

    private void generateEmulationSchema(MdSchema mdSchema) throws GenerateException, PersistenceException {
        String string = mdSchema.getName();
        if (TranslationContext.getGenerateEntireEmulationPkg()) {
            string = "Emulation";
        }
        String string2 = string;
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SCHEMAS"), string2);
        this.getAudience().fireListeners(generateEvent);
        if (!this.m_attemptLeastPrivilege) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createConnectStringConnection");
            stringTemplate.setAttribute("schemaName", (Object)string2);
            String string3 = stringTemplate.toString();
            this.getGenerator().processFileWriting(string3, BaseGeneration.GenerationType.SINGLE);
        }
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        this.generateEmulationPackage(mdSchema);
    }

    private void generateUDTTable(MdSchema mdSchema) {
        String string;
        Object object;
        DBObjectId dBObjectId = this.getConnectionId();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getPersistenceManager().getConn());
        String string2 = "select src_id from  md_derivatives  where derived_id = " + dBObjectId.getId();
        String string3 = dBUtil.executeOracleReturnOneCol(string2, null);
        String string4 = "select min(schemaid) from mgv_all_schema_details where connid=" + string3;
        String string5 = dBUtil.executeOracleReturnOneCol(string4, null);
        String string6 = "select data_type_name ||' ' ||   CASE definition  WHEN 'char' THEN 'char(1)'  WHEN 'varchar' THEN 'varchar(1)'  ELSE definition END UDT  FROM md_user_defined_data_Types where schema_id_fk = " + string5;
        List list = dBUtil.executeReturnList(string6, null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE UDT (");
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : list) {
            object = object2.get("UDT");
            string = object.toString() + " ";
            if (!hashSet.add(string.substring(0, string.indexOf(" ")))) continue;
            bl = true;
            stringBuffer.append(object.toString() + ",");
        }
        if (bl) {
            Object object2;
            String string7 = "UDT";
            this.getGenerator().startFileWriting(mdSchema.getName(), "tables", string7, BaseGeneration.GenerationType.OBJECT);
            this.getGenerator().generatePromptDropObjectsInSchema(mdSchema.getName());
            this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "TABLE", string7);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(")");
            object2 = stringBuffer.toString();
            object = (ITranslationAll)ParserFactoryProvider.getInstance().getParser("oracle.dbtools.migration.parser.tsql.TSQLParserMain");
            string = null;
            this.getGenerator().processFileWriting("--UDT DEFINITION\n", BaseGeneration.GenerationType.OBJECT);
            try {
                string = object.translate((String)object2);
                string = string.replaceAll(" BLOB", " RAW(8)");
                this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECT);
            }
            catch (TranslationException translationException) {
                this.getGenerator().processFileWriting((String)object2, BaseGeneration.GenerationType.OBJECT);
            }
            this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(string7, mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
            String string8 = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "tables", string7);
            this.getGenerator().processFileWriting(string8, BaseGeneration.GenerationType.OBJECTTYPE);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
        }
    }

    protected void generateForeignKeyConstraints(MdSchema mdSchema) throws GenerateException {
        CloseableIterator closeableIterator = null;
        boolean bl = false;
        bl = this.getGenerator().startFileWriting(mdSchema.getName(), "foreignkeys", null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            if (this.getGenerator().getGenerationType() == BaseGeneration.GenerationType.OBJECTTYPE) {
                this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "foreignkeys"), BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().processFileWriting(this.getGenerator().generateConnectString(mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
            } else if (this.getGenerator().getGenerationType() == BaseGeneration.GenerationType.OBJECT) {
                this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "foreignkeys"), BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().processFileWriting(this.getGenerator().generateConnectString(mdSchema.getName()), BaseGeneration.GenerationType.OBJECTTYPE);
            }
        }
        try {
            closeableIterator = this.getPersistenceUtility().getForeignKeyConstraintsForSchemaId(mdSchema.getKey());
        }
        catch (PersistenceException persistenceException) {
            s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{persistenceException.getLocalizedMessage(), mdSchema.getName()});
            return;
        }
        while (closeableIterator.hasNext()) {
            MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
            try {
                MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
                try {
                    if (!this.m_persistenceUtility.isDBObjectEnabled(mdTable.getKey().getId()) || !this.m_persistenceUtility.isDBObjectEnabled(mdConstraint.getKey().getId())) {
                        continue;
                    }
                }
                catch (PersistenceException persistenceException) {
                    throw new GenerateException(persistenceException);
                }
                bl = this.generateIndividualForeignKeyConstraint(mdTable, mdConstraint);
                this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "foreignkeys", mdConstraint.getName());
            }
            catch (NoSuchObjectException noSuchObjectException) {
                s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{noSuchObjectException.getLocalizedMessage(), mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.23"))});
            }
            catch (PersistenceException persistenceException) {
                s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{persistenceException.getLocalizedMessage(), mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.25"))});
            }
        }
        if (this.getGenerator().getGenerationType() == BaseGeneration.GenerationType.OBJECTTYPE) {
            this.getGenerator().processFileWriting(this.getTemplateGroup().getInstanceOf("disconnect").toString(), BaseGeneration.GenerationType.OBJECT);
            this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "foreignkeys"), BaseGeneration.GenerationType.OBJECT);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT, bl);
        } else if (this.getGenerator().getGenerationType() == BaseGeneration.GenerationType.OBJECT) {
            this.getGenerator().processFileWriting(this.getTemplateGroup().getInstanceOf("disconnect").toString(), BaseGeneration.GenerationType.OBJECTTYPE);
            this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "foreignkeys"), BaseGeneration.GenerationType.OBJECTTYPE);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
        }
        if (bl) {
            this.getGenerator().generateForignKeyEntryInMainMaster(mdSchema.getName());
        }
    }

    protected void generateIndividualSchema(MdSchema mdSchema) throws PersistenceException, GenerateException {
        boolean bl = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createConnectStringConnection");
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SCHEMAS"), mdSchema.getName());
        this.getGenerator().generateConnectionInSchemaMaster(mdSchema.getName());
        this.getGenerator().generatePromptDropObjectsInSchema(mdSchema.getName());
        this.getAudience().fireListeners(generateEvent);
        if (bl) {
            stringTemplate.setAttribute("schemaName", (Object)mdSchema.getName());
            String string = stringTemplate.toString();
            mdSchema.setNativeSql(string);
            this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.SINGLE);
        }
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        if (bl) {
            mdSchema.save(this.getPersistenceManager());
        }
        if (MigrationAddin.getMigrationConfig().getGenObjectTypeSequences() && !this.m_tablesOnly) {
            this.generateSequences(mdSchema);
        }
        if (MigrationAddin.getMigrationConfig().getGenObjectTypeTables()) {
            this.generateAllTables(mdSchema);
        }
        if (MigrationAddin.getMigrationConfig().getGenObjectTypeIndexes()) {
            this.generateIndexes(mdSchema);
        }
        if (MigrationAddin.getMigrationConfig().getGenObjectTypeSynonyms()) {
            this.generateSynonyms(mdSchema);
        }
        if (!this.m_tablesOnly && bl) {
            this.generateRoles(mdSchema);
        }
    }

    private void createDirectory(String string) {
        File file = new File(this.getOutputDir(), string);
        file.mkdir();
        if (this.m_SchemaDumpHashTable == null) {
            this.m_SchemaDumpHashTable = new Hashtable();
        }
        this.m_SchemaDumpHashTable.put(string, file.toString());
        this.setCurrentSchemaDumpDirectory(string);
    }

    private void setCurrentSchemaDumpDirectory(String string) {
        this.m_currentSchemaDumpDir = string;
    }

    private String getCurrentSchemaDumpDirectory() {
        return this.m_currentSchemaDumpDir;
    }

    protected void generateSynonyms(MdSchema mdSchema) throws GenerateException {
        String string;
        Object object;
        String string2 = "select name, synonym_for_id, native_key from md_synonyms where schema_id_fk = (select src_id from md_derivatives where derived_id = ? and src_type = 'MD_SCHEMAS')";
        String string3 = "select new_identifier from md_derivatives where src_id = ?";
        Connection connection = this.getPersistenceManager().getConn();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        bl = this.getGenerator().startFileWriting(mdSchema.getName(), "synonyms", null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "synonyms"), BaseGeneration.GenerationType.OBJECTTYPE);
        }
        try {
            object = this.getPersistenceUtility().getEmulationPackageForSchema(mdSchema.getKey());
            if (object != null) {
                this.getGenerator().startFileWriting(mdSchema.getName(), "synonyms", ((MdPackage)object).getName(), BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().processFileWriting(this.getGenerator().createSynonymOnUtilsPkg(((MdPackage)object).getName(), mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().processFileWriting("\n", BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "SYNONYM", ((MdPackage)object).getName());
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
                string = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "synonyms", ((MdPackage)object).getName());
                this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECTTYPE);
                bl = true;
            }
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.162"), (Throwable)persistenceException);
            throw new GenerateException(persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.163"), (Throwable)noSuchObjectException);
            throw new GenerateException(noSuchObjectException);
        }
        try {
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, mdSchema.getKey().getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                string = null;
                String string4 = null;
                long l = resultSet.getLong(2);
                long l2 = new Long(resultSet.getString(3));
                PreparedStatement preparedStatement2 = connection.prepareStatement(string3);
                preparedStatement2.setLong(1, l);
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                if (resultSet2.next()) {
                    string = resultSet2.getString(1);
                }
                PreparedStatement preparedStatement3 = connection.prepareStatement(string3);
                preparedStatement3.setLong(1, l2);
                ResultSet resultSet3 = preparedStatement3.executeQuery();
                if (resultSet3.next()) {
                    string4 = resultSet3.getString(1);
                }
                if (string == null) continue;
                StringTemplate stringTemplate = null;
                String string5 = null;
                if (string4 != null) {
                    this.getGenerator().startFileWriting(mdSchema.getName(), "synonyms", (String)object, BaseGeneration.GenerationType.OBJECT);
                    stringTemplate = this.getTemplateGroup().getInstanceOf("createSynonym");
                    stringTemplate.setAttribute("name", object);
                    stringTemplate.setAttribute("refObj", (Object)(string4 + "." + string));
                    string5 = stringTemplate.toString();
                    this.getGenerator().processFileWriting(string5, BaseGeneration.GenerationType.OBJECT);
                    this.getGenerator().processFileWriting("\n", BaseGeneration.GenerationType.OBJECT);
                } else {
                    this.getGenerator().startFileWriting(mdSchema.getName(), "synonyms", (String)object, BaseGeneration.GenerationType.OBJECT);
                    stringTemplate = this.getTemplateGroup().getInstanceOf("createSynonym");
                    stringTemplate.setAttribute("name", object);
                    stringTemplate.setAttribute("refObj", (Object)string);
                    string5 = stringTemplate.toString();
                    this.getGenerator().processFileWriting(string5, BaseGeneration.GenerationType.OBJECT);
                    this.getGenerator().processFileWriting("\n", BaseGeneration.GenerationType.OBJECT);
                }
                bl = true;
                this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "SYNONYM", (String)object);
                this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects((String)object, mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
                String string6 = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "synonyms", (String)object);
                this.getGenerator().processFileWriting(string6, BaseGeneration.GenerationType.OBJECTTYPE);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (bl) {
            this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "synonyms");
            this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "synonyms"), BaseGeneration.GenerationType.OBJECTTYPE);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTranslatedObjects() throws PersistenceException {
        PersistableObject persistableObject = null;
        try (CloseableIterator closeableIterator = null;){
            closeableIterator = new MigrGenerationOrderIterator(this.getPersistenceManager(), this.m_connectionId);
            while (closeableIterator.hasNext()) {
                MigrGenerationOrder migrGenerationOrder = (MigrGenerationOrder)closeableIterator.next();
                try {
                    boolean bl;
                    MdSchema mdSchema;
                    PersistableObject persistableObject2 = this.getPersistenceUtility().loadPersistableObject(migrGenerationOrder.getObjectId(), migrGenerationOrder.getObjectType());
                    if (persistableObject2.getObjectType().equals("MD_CONSTRAINTS") || (mdSchema = this.findParentSchema(persistableObject2)) == null) continue;
                    boolean bl2 = bl = persistableObject == null || !mdSchema.getKey().equals(persistableObject.getKey());
                    if (bl) {
                        this.generateConnect(mdSchema);
                        persistableObject = mdSchema;
                    }
                    try {
                        this.generateIndividualPersistableObject(persistableObject2, (MdSchema)persistableObject);
                    }
                    catch (IOException iOException) {
                        s_log.log(Level.FINE, "Generate.EXCEPTION", new Object[]{iOException.getLocalizedMessage(), persistableObject2.getObjectName(), new ClickableLogInfo(persistableObject2, Messages.getString("GenerateWorker.29"))});
                    }
                    catch (GenerateException generateException) {
                        s_log.log(Level.FINE, "Generation.EXCEPTION", new Object[]{generateException.getLocalizedMessage(), persistableObject2.getObjectName(), new ClickableLogInfo(persistableObject2, Messages.getString("GenerateWorker.31"))});
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    s_log.log(Level.FINE, "Generate.FAILEDTORETRIEVEOBJECT", new Object[]{noSuchObjectException.getLocalizedMessage(), migrGenerationOrder.getObjectName(), new ClickableLogInfo(migrGenerationOrder, Messages.getString("GenerateWorker.33"))});
                }
            }
        }
    }

    private void generateConnect(MdSchema mdSchema) {
        boolean bl;
        boolean bl2 = bl = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        if (bl) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createConnectStringConnection");
            stringTemplate.setAttribute("schemaName", (Object)mdSchema.getName());
            String string = stringTemplate.toString();
            this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.SINGLE);
        }
    }

    protected void generateIndividualPersistableObject(PersistableObject persistableObject, MdSchema mdSchema) throws IOException, PersistenceException, NoSuchObjectException, GenerateException {
        String string = persistableObject.getObjectType();
        String string2 = null;
        boolean bl = false;
        String string3 = mdSchema.getName();
        if (MigrationAddin.getMigrationConfig().getGenObjectTypeProcedures() && string.equals("MD_STORED_PROGRAMS") && ((MdStoredProgram)persistableObject).getProgramtype().equals("PROCEDURE")) {
            string2 = "procedures";
            this.startFileWriting(mdSchema.getName(), "procedures");
            bl = this.generateIndividualStoredProcedure((MdStoredProgram)persistableObject);
        }
        if (MigrationAddin.getMigrationConfig().getGenObjectTypeFunctions() && string.equals("MD_STORED_PROGRAMS")) {
            if (((MdStoredProgram)persistableObject).getProgramtype().equals("FUNCTION")) {
                string2 = "functions";
                this.startFileWriting(mdSchema.getName(), "functions");
                bl = this.generateIndividualStoredFunction((MdStoredProgram)persistableObject);
            }
        } else if (MigrationAddin.getMigrationConfig().getGenObjectTypeTriggers() && string.equals("MD_TRIGGERS")) {
            string2 = "triggers";
            this.startFileWriting(mdSchema.getName(), "triggers");
            bl = this.generateIndividualTrigger((MdTrigger)persistableObject, mdSchema);
        } else if (MigrationAddin.getMigrationConfig().getGenObjectTypeTables() && string.equals("MD_CONSTRAINTS")) {
            this.startFileWriting(mdSchema.getName(), this.findConstraintType((MdConstraint)persistableObject));
            bl = this.generateIndividualConstraint((MdConstraint)persistableObject);
        } else if (MigrationAddin.getMigrationConfig().getGenObjectTypeViews() && string.equals("MD_VIEWS")) {
            string2 = "views";
            this.startFileWriting(mdSchema.getName(), "views");
            bl = this.generateIndividualView((MdView)persistableObject, mdSchema);
        } else if (string.equals("MD_PACKAGES")) {
            // empty if block
        }
        if (this.m_dependencies.containsKey(persistableObject.getKey().getId())) {
            this.generateObjectGrants(persistableObject);
        }
        this.endFileWriting(mdSchema.getName(), string2, bl);
    }

    private void startFileWriting(String string, String string2) {
        boolean bl = false;
        bl = this.getGenerator().startFileWriting(string, string2, null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(string, string2), BaseGeneration.GenerationType.OBJECTTYPE);
        }
    }

    private void endFileWriting(String string, String string2, boolean bl) {
        if (string2 != null) {
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
        }
    }

    private String findConstraintType(MdConstraint mdConstraint) {
        if (mdConstraint.getConstraintType().equals("FOREIGN KEY")) {
            return "foreignkeys";
        }
        if (mdConstraint.getConstraintType().equals("CHECK")) {
            return "checkconstraints";
        }
        if (mdConstraint.getConstraintType().equals("UNIQUE")) {
            return "uniqueconstraints";
        }
        return null;
    }

    private MdSchema findParentSchema(PersistableObject persistableObject) {
        PersistableObject persistableObject2;
        DBObjectId dBObjectId = null;
        MdSchema mdSchema = null;
        String string = persistableObject.getObjectType();
        if (string.equals("MD_STORED_PROGRAMS")) {
            persistableObject2 = (MdStoredProgram)persistableObject;
            dBObjectId = ((MdStoredProgram)persistableObject2).getSchemaId();
        } else if (string.equals("MD_TRIGGERS")) {
            persistableObject2 = (MdTrigger)persistableObject;
            dBObjectId = this.findParentSchemaId((MdTrigger)persistableObject2);
        } else if (string.equals("MD_CONSTRAINTS")) {
            persistableObject2 = (MdConstraint)persistableObject;
            dBObjectId = this.findParentSchemaId((MdConstraint)persistableObject2);
        } else if (string.equals("MD_VIEWS")) {
            persistableObject2 = (MdView)persistableObject;
            dBObjectId = ((MdView)persistableObject2).getSchemaId();
        } else if (string.equals("MD_PACKAGES")) {
            persistableObject2 = (MdPackage)persistableObject;
            dBObjectId = ((MdPackage)persistableObject2).getSchemaId();
        } else if (string.equals("MD_TABLES")) {
            persistableObject2 = (MdTable)persistableObject;
            dBObjectId = ((MdTable)persistableObject2).getSchemaId();
        }
        if (dBObjectId != null && (mdSchema = this.m_schemaCache.get(dBObjectId)) == null) {
            try {
                mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.38"), (Throwable)noSuchObjectException);
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.39"), (Throwable)persistenceException);
            }
        }
        return mdSchema;
    }

    private DBObjectId findParentSchemaId(MdTrigger mdTrigger) {
        try {
            if (mdTrigger.getTriggerOnFlag().equals("T")) {
                MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdTrigger.getTableOrViewId());
                return mdTable.getSchemaId();
            }
            MdView mdView = MdView.retrieveExistingInstance(this.getPersistenceManager(), mdTrigger.getTableOrViewId());
            return mdView.getSchemaId();
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.40"), (Throwable)persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.41"), (Throwable)noSuchObjectException);
        }
        return null;
    }

    private DBObjectId findParentSchemaId(MdConstraint mdConstraint) {
        try {
            MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
            return mdTable.getSchemaId();
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.42"), (Throwable)persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.43"), (Throwable)noSuchObjectException);
        }
        return null;
    }

    protected void generateRecompileViews(MdSchema mdSchema) {
        List<String> list = this.getListForRecompile();
        boolean bl = false;
        for (String string : list) {
            if (!string.startsWith(mdSchema.getName() + ".")) continue;
            string = string.substring(string.indexOf(46) + 1);
            String string2 = "ALTER VIEW " + string + " COMPILE;\n";
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.reset();
            stringTemplate.setAttribute("text", (Object)string2);
            this.getGenerator().storeRecompileViews(mdSchema.getName(), string);
            this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.SINGLE);
            bl = true;
        }
        this.getGenerator().setRecompileViewsFlag(mdSchema.getName(), bl);
    }

    protected boolean generateClobToBlob(MdSchema mdSchema, Boolean bl) throws PersistenceException, GenerateException {
        boolean bl2 = false;
        String string = "";
        String string2 = "CLOBTOBLOB_SQLDEVELOPER".toLowerCase();
        MigrationPlugin migrationPlugin = null;
        try {
            migrationPlugin = MigrationUtils.getPluginForConnection(MdConnection.retrieveExistingInstance(this.getPersistenceManager(), this.m_connectionId));
        }
        catch (MigrationPluginException migrationPluginException) {
            migrationPlugin = null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            migrationPlugin = null;
        }
        if (migrationPlugin != null && migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && this.m_persistenceUtility.getHaveIaBlob(mdSchema)) {
            int n = 500;
            if (MigrationAddin.getConfigurationData().get32kChars()) {
                n = 4000;
            }
            String string3 = "CREATE OR REPLACE PROCEDURE CLOBTOBLOB_sqldeveloper \n  ( \n    tableNameL      VARCHAR2 , \n    clobColumnNameL VARCHAR2, \n    blobColumnNameL VARCHAR2 ) \nAS \n  tableName      VARCHAR2 ( 500 ) := '';--to_UPPER(tableNameL); \n  clobColumnName VARCHAR2 ( 500 ) := '';--to_UPPER(clobColumNameL); \n  blobColumnName VARCHAR2 ( 500 ) := '';--to_UPPER(blobColumNameL); \n  tmpString      VARCHAR2 ( 500 ) := ''; \n  errorOut       BOOLEAN          := false; \n  inputLength    NUMBER; -- size of input CLOB \n  offSet         NUMBER := 1; \n  pieceMaxSize   NUMBER := " + n + ";          -- the max size of each peice large for 12c\n  piece          VARCHAR2 ( " + n + " CHAR ) ; -- these pieces will make up the entire CLOB \n  currentPlace   NUMBER := 1;            -- this is where were up to in the CLOB \n  blobLoc BLOB;                          -- blob locator in the table \n  clobLoc CLOB;                          -- clob locator pointsthis is the value from the dat file \n  myquery VARCHAR2 ( 2000 ) ; \n  -- THIS HAS TO BE CHANGED FOR SPECIFIC CUSTOMER TABLE \n  -- AND COLUMN NAMES \n  --CURSOR cur; \nTYPE cur_typ \nIS \n  REF \n  CURSOR; \n    cur cur_typ; \n    --cur_rec cur%ROWTYPE; \n  BEGIN \n    tableName      := UPPER ( tableNameL ) ; \n    clobColumnName := UPPER ( clobColumnNameL ) ; \n    blobColumnName := UPPER ( blobColumnNameL ) ; \n    BEGIN \n      EXECUTE immediate 'select table_name from user_tables where table_name = :1 ' INTO tmpString USING tableName; \n      IF ( tmpString != tableName ) THEN \n        errorOut     := true; \n      ELSE \n        BEGIN \n          EXECUTE immediate 'select COLUMN_NAME from user_tab_columns where table_name = :1 and COLUMN_NAME = :2 ' INTO tmpString USING tableName, clobColumnName; \n          IF ( tmpString != clobColumnName ) THEN \n            errorOut     := true; \n          ELSE \n            EXECUTE immediate 'select COLUMN_NAME from user_tab_columns where table_name = :1 and COLUMN_NAME = :2 ' INTO tmpString USING tableName, blobColumnName; \n            IF ( tmpString != blobColumnName ) THEN \n              errorOut     := true; \n            END IF; \n          END IF; \n        END; \n      END IF; \n    EXCEPTION \n    WHEN OTHERS THEN \n      errorOut := true; \n    END; \n    IF ( errorOut = true ) THEN \n      raise_application_error ( -20001, 'Invalid parameters' ) ; \n    END IF; \n    EXECUTE immediate 'update ' || tableName || ' set ' || blobColumnName || '= empty_blob() ' ; \n    myquery := 'SELECT '||clobColumnName||' clob_column , '||blobColumnName||' blob_column FROM ' || tableName || ' FOR UPDATE'; \n    OPEN cur FOR myquery;-- using clobColumName, blobColumnName ; \n    FETCH cur \n       INTO clobLoc, \n      blobLoc ; \n   \n  WHILE cur%FOUND \n  LOOP \n    --RETRIVE THE clobLoc and blobLoc \n    --clobLoc := cur_rec.clob_column; \n    --blobLoc := cur_rec.blob_column; \n    currentPlace := 1; -- reset evertime \n    -- find the lenght of the clob \n    inputLength := DBMS_LOB.getLength ( clobLoc ) ; \n    -- loop through each peice \n    LOOP \n      IF (inputLength > 1) /* if originally zero length, could have a chr(0) character */ \n      THEN \n        -- get the next piece and add it to the clob \n        piece := DBMS_LOB.subStr ( clobLoc,pieceMaxSize,currentPlace ) ; \n        -- append this piece to the BLOB \n        DBMS_LOB.WRITEAPPEND ( blobLoc, LENGTH ( piece ) /2, HEXTORAW ( piece ) ) ; \n      END IF; \n      currentPlace := currentPlace                     + pieceMaxSize ; \n      EXIT \n    WHEN inputLength < currentplace; \n    END LOOP; \n    FETCH cur \n       INTO clobLoc, \n      blobLoc ; \n  END LOOP; \n  EXECUTE immediate 'alter table ' || tableName || ' drop column ' || clobColumnName; \n  --unnecessary after ddl \n  COMMIT; \nEND CLOBtoBLOB_sqldeveloper;";
            boolean bl3 = false;
            if (!bl.booleanValue() && !(bl3 = this.getGenerator().startFileWriting(mdSchema.getName(), "procedures", null, BaseGeneration.GenerationType.OBJECTTYPE))) {
                this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "procedures"), BaseGeneration.GenerationType.OBJECTTYPE);
            }
            GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_STORED_PROGRAMS"), "");
            this.getGenerator().startFileWriting(mdSchema.getName(), "procedures", string2, BaseGeneration.GenerationType.OBJECT);
            this.getAudience().fireListeners(generateEvent);
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.setAttribute("text", (Object)string3);
            string = stringTemplate.toString();
            this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECT);
            stringTemplate.reset();
            stringTemplate.setAttribute("text", (Object)"/\n");
            string = stringTemplate.toString();
            this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECT);
            stringTemplate.reset();
            stringTemplate.reset();
            this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(string2, mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
            String string4 = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "procedures", string2);
            this.getGenerator().processFileWriting(string4, BaseGeneration.GenerationType.OBJECTTYPE);
            if (!bl.booleanValue()) {
                this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "procedures");
                this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "procedures"), BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl3);
            }
            bl2 = true;
        }
        return bl2;
    }

    protected void generateEmulationPackage(MdSchema mdSchema) throws PersistenceException, GenerateException {
        Boolean bl = false;
        try {
            this.getGenerator().generateConnectionInSchemaMaster("Emulation");
            MdPackage mdPackage = this.getPersistenceUtility().getEmulationPackageForSchema(mdSchema.getKey());
            if (!(mdPackage == null || this.m_counterForEmulationPkg != 0 && TranslationContext.getGenerateEntireEmulationPkg())) {
                Object object;
                this.getGenerator().startFileWriting("Emulation", "packages", null, BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes("Emulation", "packages"), BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().startFileWriting("Emulation", "packages", mdPackage.getName(), BaseGeneration.GenerationType.OBJECT);
                ++this.m_counterForEmulationPkg;
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_PACKAGE"), "");
                this.getAudience().fireListeners(generateEvent);
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
                stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdPackage.getPackageHeader()));
                this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
                stringTemplate.reset();
                stringTemplate.setAttribute("text", (Object)"/\n");
                this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
                stringTemplate.reset();
                stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdPackage.getNativeSql()));
                this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
                stringTemplate.reset();
                stringTemplate.setAttribute("text", (Object)"/\n");
                this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
                generateEvent.setEventId(2);
                this.getAudience().fireListeners(generateEvent);
                bl = true;
                if (TranslationContext.getGenerateEntireEmulationPkg()) {
                    object = this.getTemplateGroup().getInstanceOf("blindDump");
                    object.setAttribute("text", (Object)("create or replace synonym " + mdPackage.getComments() + " for  Emulation." + mdPackage.getComments().trim() + ";\n/"));
                    object.reset();
                    String string = "grant execute on " + mdPackage.getComments() + " to public;\n/ \n";
                }
                this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(mdPackage.getName(), mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().processFileWriting(this.getGenerator().generateGrantExecuteOnUtilsPkgToAllSchemas(mdPackage.getName()), BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
                object = this.getGenerator().generateObjectsInObjectTypes("Emulation", "packages", mdPackage.getName());
                this.getGenerator().processFileWriting((String)object, BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes("Emulation", "packages"), BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
                if (bl.booleanValue()) {
                    this.getGenerator().generateObjectTypesInSchemaMaster("Emulation", "packages");
                }
            } else {
                MdSynonym mdSynonym = this.getPersistenceUtility().getEmulationSynonymForSchema(mdSchema.getKey());
                if (mdSynonym != null) {
                    this.getGenerator().startFileWriting("Emulation", "synonyms", null, BaseGeneration.GenerationType.OBJECTTYPE);
                    this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes("Emulation", "synonyms"), BaseGeneration.GenerationType.OBJECTTYPE);
                    this.getGenerator().startFileWriting("Emulation", "synonyms", mdSynonym.getName(), BaseGeneration.GenerationType.OBJECT);
                    GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SYNONYM"), mdSynonym.getName());
                    StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
                    stringTemplate.setAttribute("text", (Object)mdSynonym.getProperty("MIGRATIONEMULATION"));
                    this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
                    stringTemplate.reset();
                    bl = true;
                    this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(mdSynonym.getName(), mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
                    this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
                    String string = this.getGenerator().generateObjectsInObjectTypes("Emulation", "synonyms", mdSynonym.getName());
                    this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECTTYPE);
                    this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes("Emulation", "synonyms"), BaseGeneration.GenerationType.OBJECTTYPE);
                    this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
                }
                if (bl.booleanValue()) {
                    this.getGenerator().generateObjectTypesInSchemaMaster("Emulation", "synonyms");
                }
            }
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.162"), (Throwable)persistenceException);
            throw new GenerateException(persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.163"), (Throwable)noSuchObjectException);
            throw new GenerateException(noSuchObjectException);
        }
        catch (IOException iOException) {
            MigrationLogUtil.logThrowable(iOException.getLocalizedMessage(), Messages.getString("GenerateWorker.164"), (Throwable)iOException);
            throw new GenerateException(iOException);
        }
    }

    protected void generateSequences(MdSchema mdSchema) throws GenerateException {
        CloseableIterator<MdSequence> closeableIterator = null;
        boolean bl = false;
        bl = this.getGenerator().startFileWriting(mdSchema.getName(), "sequences", null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "sequences"), BaseGeneration.GenerationType.OBJECTTYPE);
        }
        try {
            closeableIterator = this.m_persistenceUtility.getSequencesForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdSequence mdSequence = (MdSequence)closeableIterator.next();
                this.getGenerator().startFileWriting(mdSchema.getName(), "sequences", mdSequence.getName(), BaseGeneration.GenerationType.OBJECT);
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SEQUENCE"), mdSequence.getName());
                this.getAudience().fireListeners(generateEvent);
                StringTemplate stringTemplate = null;
                String string = null;
                stringTemplate = this.getTemplateGroup().getInstanceOf("DropSequence");
                stringTemplate.setAttribute("mdsequence", (Object)mdSequence);
                string = stringTemplate.toString();
                if (this._genDropStmts) {
                    string = string.replaceFirst("-- ", "");
                }
                this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().processFileWriting("\n", BaseGeneration.GenerationType.OBJECT);
                stringTemplate = this.getTemplateGroup().getInstanceOf("CreateSequence");
                stringTemplate.setAttribute("mdsequence", (Object)mdSequence);
                stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
                generateEvent.setEventId(2);
                this.getAudience().fireListeners(generateEvent);
                stringTemplate.reset();
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
                bl = true;
                String string2 = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "sequences", mdSequence.getName());
                this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECTTYPE);
                this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "sequence", mdSequence.getName());
            }
            this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "sequences"), BaseGeneration.GenerationType.OBJECTTYPE);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
            if (bl) {
                this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "sequences");
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    protected void generateRoles(MdSchema mdSchema) throws GenerateException {
        try (CloseableIterator<MdGroup> closeableIterator = null;){
            closeableIterator = this.m_persistenceUtility.getGroupsForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdGroup mdGroup = (MdGroup)closeableIterator.next();
                if (mdGroup.getGroupFlag() == null || !mdGroup.getGroupFlag().equals("R")) continue;
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_GROUP"), mdGroup.getGroupName());
                this.getAudience().fireListeners(generateEvent);
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("CreateGroup");
                stringTemplate.setAttribute("mdgroup", (Object)mdGroup);
                stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                generateEvent.setEventId(2);
                this.getAudience().fireListeners(generateEvent);
                stringTemplate.reset();
            }
        }
    }

    protected void generateRoleMembers(MdSchema mdSchema) throws GenerateException {
        CloseableIterator<MdGroup> closeableIterator = null;
        CloseableIterator closeableIterator2 = null;
        CloseableIterator closeableIterator3 = null;
        boolean bl = false;
        try {
            closeableIterator = this.m_persistenceUtility.getGroupsForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                StringTemplate stringTemplate;
                GenerateEvent generateEvent;
                PersistableObject persistableObject;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdGroup mdGroup = (MdGroup)closeableIterator.next();
                if (mdGroup.getGroupFlag() == null || !mdGroup.getGroupFlag().equals("R")) continue;
                closeableIterator3 = new SchemasFromGroupIterator(this.getPersistenceManager(), mdGroup.getKey(), this.m_filters);
                while (closeableIterator3.hasNext()) {
                    persistableObject = (MdSchema)closeableIterator3.next();
                    generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_GROUP_MEMBERS"), ((MdSchema)persistableObject).getName());
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate = this.getTemplateGroup().getInstanceOf("GrantRole");
                    stringTemplate.setAttribute("mdgroup", (Object)mdGroup);
                    stringTemplate.setAttribute("mdschema", (Object)persistableObject);
                    generateEvent.setEventId(2);
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate.reset();
                }
                if (closeableIterator3 != null) {
                    closeableIterator3.close();
                }
                closeableIterator2 = new GroupsFromGroupIterator(this.getPersistenceManager(), mdGroup.getKey(), this.m_filters);
                while (closeableIterator2.hasNext()) {
                    persistableObject = (MdGroup)closeableIterator2.next();
                    generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_GROUP_MEMBERS"), ((MdGroup)persistableObject).getGroupName());
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate = this.getTemplateGroup().getInstanceOf("GrantRoleToRole");
                    stringTemplate.setAttribute("mdgroup", (Object)mdGroup);
                    stringTemplate.setAttribute("mdgroupto", (Object)persistableObject);
                    generateEvent.setEventId(2);
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate.reset();
                    bl = true;
                }
                if (closeableIterator2 == null) continue;
                closeableIterator2.close();
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
            if (closeableIterator3 != null) {
                closeableIterator3.close();
            }
            if (closeableIterator2 != null) {
                closeableIterator2.close();
            }
        }
        if (bl) {
            this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "roles");
        }
    }

    protected void generateTriggers(MdSchema mdSchema) throws GenerateException {
        CloseableIterator closeableIterator = null;
        boolean bl = false;
        bl = this.getGenerator().startFileWriting(mdSchema.getName(), "triggers", null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "triggers"), BaseGeneration.GenerationType.OBJECTTYPE);
        }
        try {
            closeableIterator = new UntranslatedTriggersIterator(this.getPersistenceManager(), mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdTrigger mdTrigger = (MdTrigger)closeableIterator.next();
                bl = this.generateIndividualTrigger(mdTrigger, mdSchema);
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        catch (IOException iOException) {
            throw new GenerateException(iOException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "triggers"), BaseGeneration.GenerationType.OBJECTTYPE);
        this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
        if (bl) {
            this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "triggers");
        }
    }

    protected boolean generateIndividualTrigger(MdTrigger mdTrigger, MdSchema mdSchema) throws IOException, GenerateException {
        try {
            if (!this.m_persistenceUtility.isDBObjectEnabled(mdTrigger.getKey().getId()) || !this.m_persistenceUtility.isDBObjectEnabled(mdTrigger.getTableOrViewId().getId())) {
                return false;
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
        this.getGenerator().startFileWriting(mdSchema.getName(), "triggers", mdTrigger.getTriggerName(), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "TRIGGER", mdTrigger.getTriggerName());
        if (!mdTrigger.getLanguage().equals("OracleSQL")) {
            if (!MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
                s_log.log(Level.WARNING, "Generate.TRIGGERNOTCONVERTED", new Object[]{mdTrigger.getTriggerName(), mdTrigger.getLanguage(), new ClickableLogInfo(mdTrigger, "Generate")});
                return false;
            }
        } else {
            GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_TRIGGERS"), mdTrigger.getTriggerName());
            this.getAudience().fireListeners(generateEvent);
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdTrigger.getNativeSql()));
            this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
            stringTemplate.reset();
            stringTemplate.setAttribute("text", (Object)"/\n");
            this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
            stringTemplate.reset();
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
            String string = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "triggers", mdTrigger.getTriggerName());
            this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECTTYPE);
            return true;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    protected void generateViews(MdSchema var1_1) throws PersistenceException, GenerateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean generateIndividualView(MdView mdView, MdSchema mdSchema) throws IOException, PersistenceException, NoSuchObjectException {
        Object object;
        if (!mdView.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.VIEWNOTCONVERTED", new Object[]{mdView.getViewName(), mdView.getLanguage(), new ClickableLogInfo(mdView, Messages.getString("GenerateWorker.184"))});
            return false;
        }
        if (!this.m_persistenceUtility.isDBObjectEnabled(mdView.getKey().getId())) {
            return false;
        }
        this.getGenerator().startFileWriting(mdSchema.getName(), "views", mdView.getViewName(), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "VIEW", mdView.getViewName());
        int n = MigrationAddin.getMigrationConfig().getFileOutputOption();
        String string = this.getOutputDir();
        String string2 = ConvertUtils.getClobAsString(mdView.getNativeSql());
        if (string2 != null && string2.indexOf("MATERIALIZED VIEW") == -1) {
            object = this.getListForRecompile();
            object.add((String)(mdSchema.getName() + "." + mdView.getViewName()));
        }
        object = new GenerateEvent(1, MigrationAddinArb.getString("MD_VIEWS"), mdView.getViewName());
        this.getAudience().fireListeners((GenerateEvent)object);
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
        stringTemplate.setAttribute("text", (Object)string2);
        String string3 = stringTemplate.toString();
        if (string3 != null && !(string3 = string3.trim()).endsWith(";")) {
            string3 = string3 + ";";
        }
        this.getGenerator().processFileWriting(string3, BaseGeneration.GenerationType.OBJECT);
        stringTemplate.reset();
        stringTemplate.setAttribute("text", (Object)"\n");
        this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
        ((MigrationEvent)object).setEventId(2);
        this.getAudience().fireListeners((GenerateEvent)object);
        this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(mdView.getViewName(), mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
        String string4 = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "views", mdView.getViewName());
        this.getGenerator().processFileWriting(string4, BaseGeneration.GenerationType.OBJECTTYPE);
        return true;
    }

    private List<String> getListForRecompile() {
        if (this.m_viewsListForRecompile == null) {
            this.m_viewsListForRecompile = new ArrayList();
        }
        return this.m_viewsListForRecompile;
    }

    /*
     * Exception decompiling
     */
    protected void generateUntranslatedStoredProcedures(MdSchema var1_1) throws PersistenceException, GenerateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void generateUntranslatedStoredFunctions(MdSchema var1_1) throws PersistenceException, GenerateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean generateIndividualStoredProcedure(MdStoredProgram mdStoredProgram) throws IOException {
        if (!mdStoredProgram.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Generate.PROCNOTCONVERTED", new Object[]{mdStoredProgram.getName(), mdStoredProgram.getLanguage(), new ClickableLogInfo(mdStoredProgram, Messages.getString("GenerateWorker.190"))});
            return false;
        }
        try {
            if (!this.m_persistenceUtility.isDBObjectEnabled(mdStoredProgram.getKey().getId())) {
                return false;
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        String string = this.getSchemaNameFromDBObjectId(mdStoredProgram.getSchemaId());
        this.getGenerator().startFileWriting(string, "procedures", mdStoredProgram.getName(), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().generateDropObjectsInSchema(string, "PROCEDURE", mdStoredProgram.getName());
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_STORED_PROGRAMS"), mdStoredProgram.getName());
        this.getAudience().fireListeners(generateEvent);
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
        stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdStoredProgram.getNativeSql()));
        this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
        stringTemplate.reset();
        stringTemplate.setAttribute("text", (Object)"/");
        this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(mdStoredProgram.getName(), string), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
        String string2 = this.getGenerator().generateObjectsInObjectTypes(string, "procedures", mdStoredProgram.getName());
        this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECTTYPE);
        return true;
    }

    protected boolean generateIndividualStoredFunction(MdStoredProgram mdStoredProgram) throws IOException {
        if (!mdStoredProgram.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Generate.PROCNOTCONVERTED", new Object[]{mdStoredProgram.getName(), mdStoredProgram.getLanguage(), new ClickableLogInfo(mdStoredProgram, Messages.getString("GenerateWorker.190"))});
            return false;
        }
        try {
            if (!this.m_persistenceUtility.isDBObjectEnabled(mdStoredProgram.getKey().getId())) {
                return false;
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        String string = this.getSchemaNameFromDBObjectId(mdStoredProgram.getSchemaId());
        this.getGenerator().startFileWriting(string, "functions", mdStoredProgram.getName(), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().generateDropObjectsInSchema(string, "FUNCTION", mdStoredProgram.getName());
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_STORED_PROGRAMS"), mdStoredProgram.getName());
        this.getAudience().fireListeners(generateEvent);
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
        stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdStoredProgram.getNativeSql()));
        this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
        stringTemplate.reset();
        stringTemplate.setAttribute("text", (Object)"/");
        this.getGenerator().processFileWriting(stringTemplate.toString(), BaseGeneration.GenerationType.OBJECT);
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(mdStoredProgram.getName(), string), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
        String string2 = this.getGenerator().generateObjectsInObjectTypes(string, "functions", mdStoredProgram.getName());
        this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECTTYPE);
        return true;
    }

    protected void generateAllTables(MdSchema mdSchema) throws PersistenceException, GenerateException {
        CloseableIterator closeableIterator = this.m_persistenceUtility.getTablesForSchemaId(mdSchema.getKey(), this.m_filters);
        boolean bl = false;
        bl = this.getGenerator().startFileWriting(mdSchema.getName(), "tables", null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "tables"), BaseGeneration.GenerationType.OBJECTTYPE);
        }
        try {
            this.generateUDTTable(mdSchema);
        }
        catch (Exception exception) {
            s_log.log(Level.WARNING, "UDT Not generated Correctly");
        }
        try {
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdTable mdTable = (MdTable)closeableIterator.next();
                if (!this.m_persistenceUtility.isDBObjectEnabled(mdTable.getKey().getId())) continue;
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_TABLES"), mdTable.getTableName());
                this.fireEventListeners(generateEvent);
                this.generateIndividualTable(mdSchema, mdTable);
                generateEvent.setEventId(2);
                bl = true;
                this.fireEventListeners(generateEvent);
                String string = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "tables", mdTable.getTableName());
                this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECTTYPE);
            }
            this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "tables"), BaseGeneration.GenerationType.OBJECTTYPE);
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GenerateException(unsupportedEncodingException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        if (bl) {
            this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "tables");
        }
    }

    private void getBaseGenerationObject() {
        switch (MigrationAddin.getMigrationConfig().getFileOutputOption()) {
            case 0: {
                this.setGenerator(new SingleFileSqlGeneration(this));
                this.getGenerator().setGenerationType(BaseGeneration.GenerationType.SINGLE);
                break;
            }
            case 1: {
                this.setGenerator(new FilesPerObjectTypeSqlGeneration(this));
                this.getGenerator().setGenerationType(BaseGeneration.GenerationType.OBJECTTYPE);
                break;
            }
            case 2: {
                this.setGenerator(new FilesPerObjectSqlGeneration(this));
                this.getGenerator().setGenerationType(BaseGeneration.GenerationType.OBJECT);
            }
        }
    }

    private void setIOTTableConstraint(MdConstraint mdConstraint) {
        this.m_IOTTableConstraint = mdConstraint;
        if (mdConstraint != null) {
            this.setIOTIndex(null);
            this.setIOTPrimaryKey(null);
        }
    }

    private synchronized IOTMode getIOTMode() {
        if (this.cacheIOTMode == null) {
            int n = MigrationConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getIOTOption();
            if (n == 0) {
                this.cacheIOTMode = IOTMode.NONE;
            } else if (n == 1) {
                this.cacheIOTMode = IOTMode.CLUSTERED_NO_PRIMARY;
            } else if (n == 2) {
                this.cacheIOTMode = IOTMode.PRIMARY;
            }
            MigrationPlugin migrationPlugin = null;
            try {
                migrationPlugin = MigrationUtils.getPluginForConnection(MdConnection.retrieveExistingInstance(this.getPersistenceManager(), this.m_connectionId));
            }
            catch (MigrationPluginException migrationPluginException) {
                migrationPlugin = null;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                migrationPlugin = null;
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.39"), (Throwable)persistenceException);
                migrationPlugin = null;
            }
            if (migrationPlugin == null || !migrationPlugin.usesClobToBlob()) {
                this.cacheIOTMode = IOTMode.NONE;
            }
        }
        return this.cacheIOTMode;
    }

    private MdConstraint getIOTTableConstraint() {
        return this.m_IOTTableConstraint;
    }

    private MdConstraint getIOTPrimaryKey() {
        return this.m_IOTPrimaryKey;
    }

    private void setIOTPrimaryKey(MdConstraint mdConstraint) {
        this.m_IOTPrimaryKey = mdConstraint;
        if (mdConstraint != null) {
            this.setIOTTableConstraint(null);
            this.setIOTIndex(null);
        }
    }

    private void setIOTIndex(MdIndexe mdIndexe) {
        this.m_IOTIndex = mdIndexe;
        if (mdIndexe != null) {
            this.setIOTTableConstraint(null);
            this.setIOTPrimaryKey(null);
        }
    }

    private MdIndexe getIOTIndex() {
        return this.m_IOTIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean primaryKeyExists(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);){
            while (closeableIterator.hasNext()) {
                MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
                if (mdConstraint.getConstraintType() == null || !mdConstraint.getConstraintType().equals("PK")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean indexOrganizedTableColumnCheck(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = MigrationAddin.getConfigurationData().get32kChars();
        this.setIOTTableConstraint(null);
        this.setIOTIndex(null);
        String string = mdTable.getProperty("IS_INDEX_ORGANIZED_TABLE");
        if (string != null && string.equals("Y")) {
            bl = true;
        } else {
            bl2 = true;
        }
        if (bl) {
            int n = 0;
            for (MdColumn mdColumn : arrayList) {
                if (mdColumn.getColumnType().toLowerCase().startsWith("varchar2") || mdColumn.getColumnType().toLowerCase().startsWith("char") || mdColumn.getColumnType().toLowerCase().startsWith("nvarchar") || mdColumn.getColumnType().toLowerCase().startsWith("nchar")) {
                    if (mdColumn.getPrecision() != null) {
                        n += mdColumn.getPrecision() / 100;
                    }
                    if (bl3 && (mdColumn.getPrecision() > 4000 || mdColumn.getColumnType().toLowerCase().startsWith("nchar") && mdColumn.getPrecision() > 1000 || mdColumn.getColumnType().toLowerCase().startsWith("nvarchar") && mdColumn.getPrecision() > 2000 || mdColumn.getColumnType().toLowerCase().startsWith("char") && mdColumn.getPrecision() > 2000)) {
                        bl2 = true;
                        break;
                    }
                }
                if (mdColumn.getColumnType().toLowerCase().equals("blob") || mdColumn.getColumnType().toLowerCase().equals("clob")) {
                    n += 40;
                }
                n += 10;
                if (bl3 && mdColumn.getColumnType().toLowerCase().startsWith("raw") && mdColumn.getPrecision() > 2000) {
                    bl2 = true;
                    break;
                }
                if (!mdColumn.getColumnType().toLowerCase().startsWith("long")) continue;
                bl2 = true;
                break;
            }
            if (n > 400) {
                bl2 = true;
            }
        }
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> indexOrganizedTableGetUniqueConstraintClustered(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MdColumn> arrayList3 = new ArrayList<MdColumn>();
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);){
            while (closeableIterator.hasNext()) {
                MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
                if (mdConstraint.getConstraintType() == null || !mdConstraint.getConstraintType().equals("UNIQUE")) continue;
                MdConstraint mdConstraint2 = mdConstraint;
                boolean bl = false;
                String string = mdConstraint.getProperty("IS_CLUSTERED_INDEX");
                if (string != null && string.equals("Y")) {
                    bl = true;
                }
                if (!bl) continue;
                try (CloseableIterator closeableIterator2 = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());){
                    while (closeableIterator2.hasNext()) {
                        if (this.shouldCancel()) {
                            closeableIterator2.close();
                            break;
                        }
                        MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)closeableIterator2.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdConstraintDetail.getColumnId())) continue;
                            arrayList3.add(mdColumn);
                            arrayList2.add(mdColumn.getColumnName());
                            break;
                        }
                        if (!this.validateColumnsForIOT(arrayList3, false)) {
                            arrayList3 = new ArrayList();
                            arrayList2 = new ArrayList();
                        }
                        if (arrayList3.size() == 0) continue;
                        this.setIOTTableConstraint(mdConstraint2);
                    }
                }
                if (arrayList3.size() == 0) continue;
                break;
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> indexOrganizedTableGetPrimaryKeyClustered(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MdColumn> arrayList3 = new ArrayList<MdColumn>();
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);){
            boolean bl = false;
            while (closeableIterator.hasNext()) {
                Object object;
                Object object2;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    object2 = arrayList2;
                    return object2;
                }
                object2 = (MdConstraint)closeableIterator.next();
                boolean bl2 = false;
                if (((MdConstraint)object2).getConstraintType().equals("PK")) {
                    object = ((PersistableObject)object2).getProperty("IS_CLUSTERED_INDEX");
                    if (object == null || !((String)object).equals("Y")) break;
                    bl2 = true;
                }
                if (bl) {
                    break;
                }
                if (!((MdConstraint)object2).getConstraintType().equals("PK")) continue;
                object = this.m_persistenceUtility.getConstraintDetails(((PersistableObject)object2).getKey());
                try {
                    boolean bl3 = false;
                    block8: while (object.hasNext()) {
                        if (this.shouldCancel()) {
                            object.close();
                            break;
                        }
                        MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)object.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdConstraintDetail.getColumnId())) continue;
                            arrayList2.add(mdColumn.getColumnName());
                            arrayList3.add(mdColumn);
                            continue block8;
                        }
                    }
                    if (!bl3) {
                        boolean bl4 = bl3 = !this.validateColumnsForIOT(arrayList3, true);
                    }
                    if (bl3) {
                        arrayList3 = new ArrayList();
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    this.setIOTPrimaryKey((MdConstraint)object2);
                    bl = true;
                }
                finally {
                    object.close();
                }
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> indexOrganizedTableGetUniqeIndexClustered(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MdColumn> arrayList3 = new ArrayList<MdColumn>();
        boolean bl = false;
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getIndexesForTableId(mdTable.getKey(), this.m_filters);){
            boolean bl2 = false;
            while (closeableIterator.hasNext()) {
                Object object;
                Object object2;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    object2 = arrayList2;
                    return object2;
                }
                object2 = (MdIndexe)closeableIterator.next();
                boolean bl3 = false;
                if (((MdIndexe)object2).getIndexType().equals("UNIQUE")) {
                    object = ((PersistableObject)object2).getProperty("IS_CLUSTERED_INDEX");
                    if (object == null || !((String)object).equals("Y")) continue;
                    bl3 = true;
                }
                if (bl2) {
                    break;
                }
                if (!((MdIndexe)object2).getIndexType().equals("UNIQUE")) continue;
                object = this.m_persistenceUtility.getIndexDetails(((PersistableObject)object2).getKey());
                try {
                    boolean bl4 = false;
                    block8: while (object.hasNext()) {
                        if (this.shouldCancel()) {
                            object.close();
                            break;
                        }
                        MdIndexDetail mdIndexDetail = (MdIndexDetail)object.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdIndexDetail.getColumnId())) continue;
                            arrayList2.add(mdColumn.getColumnName());
                            arrayList3.add(mdColumn);
                            continue block8;
                        }
                    }
                    if (!bl4) {
                        boolean bl5 = bl4 = !this.validateColumnsForIOT(arrayList3, false);
                    }
                    if (bl4) {
                        arrayList3 = new ArrayList();
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    this.setIOTIndex((MdIndexe)object2);
                    bl2 = true;
                }
                finally {
                    object.close();
                }
            }
        }
        return arrayList2;
    }

    boolean validateColumnsForIOT(ArrayList<MdColumn> arrayList, boolean bl) {
        boolean bl2 = true;
        for (MdColumn mdColumn : arrayList) {
            String string = mdColumn.getColumnType().toLowerCase();
            if ((bl || mdColumn.getNullable() == null || bl || !mdColumn.getNullable().equals("Y")) && !string.equals("clob") && !string.equals("blob") && !string.equals("nclob")) continue;
            bl2 = false;
        }
        if (arrayList.size() > 10) {
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualTable(MdSchema mdSchema, MdTable mdTable) throws PersistenceException, FileNotFoundException, UnsupportedEncodingException {
        MdColumn mdColumn;
        boolean bl = true;
        String string = null;
        CloseableIterator closeableIterator = this.m_persistenceUtility.getColumnsForTableId(mdTable.getKey());
        ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
        this.getGenerator().startFileWriting(mdSchema.getName(), "tables", mdTable.getTableName(), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "TABLE", mdTable.getTableName());
        try {
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                mdColumn = (MdColumn)closeableIterator.next();
                arrayList.add(mdColumn);
            }
        }
        finally {
            closeableIterator.close();
        }
        mdColumn = null;
        mdColumn = this.getTemplateGroup().getInstanceOf("DropTable");
        String string2 = null;
        mdColumn = this.getTemplateGroup().getInstanceOf("DropTable");
        mdColumn.setAttribute("mdtable", mdTable);
        string2 = mdColumn.toString();
        if (this._genDropStmts) {
            string2 = string2.replaceFirst("-- ", "");
        }
        this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().processFileWriting("\n", BaseGeneration.GenerationType.OBJECT);
        this.setIOTTableConstraint(null);
        this.setIOTIndex(null);
        this.setIOTPrimaryKey(null);
        bl = this.getIOTMode() != IOTMode.NONE ? this.indexOrganizedTableColumnCheck(mdTable, arrayList) : false;
        ArrayList<Object> arrayList2 = new ArrayList();
        if (bl && this.getIOTMode() != IOTMode.NONE) {
            if (this.getIOTMode() == IOTMode.PRIMARY) {
                arrayList2 = this.indexOrganizedTableGetPrimaryKeyClustered(mdTable, arrayList);
            }
            if (this.getIOTMode() != IOTMode.PRIMARY && arrayList2.size() == 0 && !this.primaryKeyExists(mdTable, arrayList)) {
                if (arrayList2.size() == 0) {
                    arrayList2 = this.indexOrganizedTableGetUniqueConstraintClustered(mdTable, arrayList);
                }
                if (arrayList2.size() == 0) {
                    arrayList2 = this.indexOrganizedTableGetUniqeIndexClustered(mdTable, arrayList);
                }
            }
        }
        if (arrayList2.size() == 0) {
            mdColumn = this.getTemplateGroup().getInstanceOf("CreateTable");
            mdColumn.setAttribute("mdtable", mdTable);
            mdColumn.setAttribute("colList", arrayList);
            mdColumn.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
            this.setIOTTableConstraint(null);
            this.setIOTIndex(null);
            this.setIOTPrimaryKey(null);
        } else {
            string = this.getIOTPrimaryKey() != null ? this.getIOTPrimaryKey().getName() : (this.getIOTTableConstraint() != null ? this.getIOTTableConstraint().getName() : this.getIOTIndex().getIndexName());
            mdColumn = this.getTemplateGroup().getInstanceOf("CreateTableIndexOrganizedTable");
            mdColumn.setAttribute("mdtable", mdTable);
            mdColumn.setAttribute("colList", arrayList);
            mdColumn.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
            mdColumn.setAttribute("constraint_name", string);
            mdColumn.setAttribute("collist_pk", arrayList2);
        }
        string2 = mdColumn.toString();
        this.wasClustered(string, null, true);
        this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().processFileWriting("", BaseGeneration.GenerationType.OBJECT);
        if (mdTable.getComments() != null && mdTable.getComments().length() > 0) {
            mdColumn = this.getTemplateGroup().getInstanceOf("TableComment");
            mdColumn.setAttribute("tableName", mdTable.getTableName());
            mdColumn.setAttribute("comment", this.removeSingleQuotes(mdTable.getComments()));
            string2 = mdColumn.toString();
            this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECT);
            this.getGenerator().processFileWriting("", BaseGeneration.GenerationType.OBJECT);
        }
        mdTable.setNativeSql(string2);
        mdTable.save(this.getPersistenceManager());
        this.generateTableDefaultValues(mdTable, arrayList);
        if (!this.m_tablesOnly) {
            this.generateColumnComments(mdTable, arrayList);
            this.generateTableConstraints(mdTable, arrayList);
            mdColumn.reset();
            if (this.m_dependencies.containsKey(mdTable.getKey().getId())) {
                this.generateObjectGrants(mdTable);
            }
            this.getGenerator().processFileWriting("", BaseGeneration.GenerationType.OBJECT);
        }
        this.getGenerator().processFileWriting(this.getGenerator().generateGrantAllRoleToObjects(mdTable.getTableName(), mdSchema.getName()), BaseGeneration.GenerationType.OBJECT);
        this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndexes(MdSchema mdSchema) throws GenerateException {
        Object var2_2 = null;
        boolean bl = false;
        CloseableIterator closeableIterator = null;
        bl = this.getGenerator().startFileWriting(mdSchema.getName(), "indexes", null, BaseGeneration.GenerationType.OBJECTTYPE);
        if (!bl) {
            this.getGenerator().processFileWriting(this.getGenerator().generateStartPromptInObjectTypes(mdSchema.getName(), "indexes"), BaseGeneration.GenerationType.OBJECTTYPE);
        }
        try {
            closeableIterator = this.m_persistenceUtility.getTablesForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdTable mdTable = (MdTable)closeableIterator.next();
                try {
                    if (!this.m_persistenceUtility.isDBObjectEnabled(mdTable.getKey().getId())) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    throw new GenerateException(exception);
                }
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_TABLES"), mdTable.getTableName());
                this.fireEventListeners(generateEvent);
                ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
                try (CloseableIterator closeableIterator2 = this.m_persistenceUtility.getColumnsForTableId(mdTable.getKey());){
                    while (true) {
                        if (closeableIterator2.hasNext()) {
                            if (this.shouldCancel()) {
                                closeableIterator2.close();
                                return;
                            }
                            MdColumn mdColumn = (MdColumn)closeableIterator2.next();
                            arrayList.add(mdColumn);
                            continue;
                        }
                        break;
                    }
                }
                if (this.generateIndividualTableIndexes(mdSchema, mdTable, arrayList)) {
                    bl = true;
                }
                this.fireEventListeners(generateEvent);
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        this.getGenerator().processFileWriting(this.getGenerator().generateEndPromptInObjectTypes(mdSchema.getName(), "indexes"), BaseGeneration.GenerationType.OBJECTTYPE);
        this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECTTYPE, bl);
        if (bl) {
            this.getGenerator().generateObjectTypesInSchemaMaster(mdSchema.getName(), "indexes");
        }
    }

    private void generateObjectGrants(PersistableObject persistableObject) {
        DBObjectId dBObjectId = persistableObject.getKey();
        String string = this.m_dependencies.get(dBObjectId.getId());
        this.getGenerator().processFileWriting(string + "\n", BaseGeneration.GenerationType.OBJECT);
    }

    private void generateColumnComments(MdTable mdTable, ArrayList<MdColumn> arrayList) {
        for (MdColumn mdColumn : arrayList) {
            String string = mdColumn.getComments();
            if (string == null || string.length() <= 0) continue;
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("ColumnComment");
            stringTemplate.setAttribute("tableName", (Object)mdTable.getTableName());
            stringTemplate.setAttribute("columnName", (Object)mdColumn.getObjectName());
            stringTemplate.setAttribute("comment", (Object)this.removeSingleQuotes(string));
            String string2 = stringTemplate.toString();
            this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECT);
            this.getGenerator().processFileWriting("", BaseGeneration.GenerationType.OBJECT);
        }
    }

    private void generateTableDefaultValues(MdTable mdTable, ArrayList<MdColumn> arrayList) {
        for (MdColumn mdColumn : arrayList) {
            StringTemplate stringTemplate;
            String string = mdColumn.getDefaultValue();
            if (string == null || string.length() <= 0) continue;
            if (!(!mdColumn.getColumnType().equals("DATE") && !mdColumn.getColumnType().equals("TIMESTAMP") || string.startsWith("SYSDATE") || string.startsWith("SYSTIMESTAMP") || string.startsWith("SYS_EXTRACT_UTC") || string.startsWith("CURRENT_DATE") || string.startsWith("CURRENT_TIMESTAMP") || string.startsWith("LOCALTIMESTAMP"))) {
                stringTemplate = this.getTemplateGroup().getInstanceOf("alterTableForDefaultDateTimeValue");
                stringTemplate.setAttribute("columnType", (Object)mdColumn.getColumnType());
            } else {
                stringTemplate = this.getTemplateGroup().getInstanceOf("alterTableForDefaultValue");
            }
            stringTemplate.setAttribute("tableName", (Object)mdTable.getTableName());
            stringTemplate.setAttribute("columnName", (Object)mdColumn.getObjectName());
            stringTemplate.setAttribute("defaultValue", (Object)string);
            String string2 = stringTemplate.toString();
            this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECT);
        }
    }

    private String removeSingleQuotes(String string) {
        if (string.indexOf("'") == -1) {
            return string;
        }
        return string.replace("'", "''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTableConstraints(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);){
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
                if (!this.m_persistenceUtility.isDBObjectEnabled(mdConstraint.getKey().getId())) continue;
                if (mdConstraint.getConstraintType() != null) {
                    if (mdConstraint.getConstraintType().equals("PK")) {
                        this.generateIndividualPrimaryKeyConstraint(mdTable, mdConstraint, arrayList);
                        continue;
                    }
                    if (!mdConstraint.getConstraintType().equals("CHECK") && !mdConstraint.getConstraintType().equals("UNIQUE")) continue;
                    this.generateIndividualConstraint(mdConstraint, mdTable, false);
                    continue;
                }
                s_log.log(Level.WARNING, "Generate.NOCONSTRAINTTYPE", new Object[]{Messages.getString("GenerateWorker.221"), mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.222"))});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualPrimaryKeyConstraint(MdTable mdTable, MdConstraint mdConstraint, ArrayList<MdColumn> arrayList) throws PersistenceException {
        StringTemplate stringTemplate;
        if (this.getIOTPrimaryKey() != null && this.getIOTPrimaryKey().getKey().equals(mdConstraint.getKey())) {
            String string = mdConstraint.getProperty("DO_NOT_ENABLE_DISABLE");
            if (string == null) {
                mdConstraint.addProperty("DO_NOT_ENABLE_DISABLE", "Y", this.getConnectionId());
                mdConstraint.save(this.getPersistenceManager());
            }
            return;
        }
        ArrayList<MdColumn> arrayList2 = new ArrayList<MdColumn>();
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());){
            stringTemplate = this.getTemplateGroup().getInstanceOf("CreatePrimaryKey");
            stringTemplate.setAttribute("mdtable", (Object)mdTable);
            stringTemplate.setAttribute("mdconstraint", (Object)mdConstraint);
            block3: while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    break;
                }
                MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)closeableIterator.next();
                for (MdColumn mdColumn : arrayList) {
                    if (!mdColumn.getKey().equals(mdConstraintDetail.getColumnId())) continue;
                    arrayList2.add(mdColumn);
                    continue block3;
                }
            }
        }
        stringTemplate.setAttribute("collist", arrayList2);
        String string = stringTemplate.toString();
        this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECT);
        this.wasClustered(mdConstraint.getName(), mdConstraint.getProperty("IS_CLUSTERED_INDEX"), false);
        mdConstraint.setConstraintText(string);
        mdConstraint.save(this.getPersistenceManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateIndividualTableIndexes(MdSchema mdSchema, MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        boolean bl = false;
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getIndexesForTableId(mdTable.getKey(), this.m_filters);){
            while (closeableIterator.hasNext()) {
                Object object;
                StringTemplate stringTemplate;
                Object object2;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    boolean bl2 = false;
                    return bl2;
                }
                MdIndexe mdIndexe = (MdIndexe)closeableIterator.next();
                if (!this.m_persistenceUtility.isDBObjectEnabled(mdIndexe.getKey().getId())) continue;
                if (this.getIOTIndex() != null && this.getIOTIndex().getKey().equals(mdIndexe.getKey())) {
                    object2 = mdIndexe.getProperty("DO_NOT_ENABLE_DISABLE");
                    if (object2 != null) continue;
                    mdIndexe.addProperty("DO_NOT_ENABLE_DISABLE", "Y", this.getConnectionId());
                    mdIndexe.save(this.getPersistenceManager());
                    continue;
                }
                this.getGenerator().startFileWriting(mdSchema.getName(), "indexes", mdIndexe.getIndexName(), BaseGeneration.GenerationType.OBJECT);
                object2 = this.m_persistenceUtility.getIndexDetails(mdIndexe.getKey());
                ArrayList<String> arrayList2 = new ArrayList<String>();
                try {
                    stringTemplate = mdIndexe.getIndexType().equals("UNIQUE") ? this.getTemplateGroup().getInstanceOf("CreateUniqueIndex") : this.getTemplateGroup().getInstanceOf("CreateIndex");
                    stringTemplate.setAttribute("mdtable", (Object)mdTable);
                    stringTemplate.setAttribute("mdindex", (Object)mdIndexe);
                    stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                    stringTemplate.setAttribute("extindextype", (Object)mdIndexe.getProperty("EXTENDEDINDEXTYPE"));
                    block8: while (object2.hasNext()) {
                        if (this.shouldCancel()) {
                            object2.close();
                            break;
                        }
                        object = (MdIndexDetail)object2.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(((MdIndexDetail)object).getColumnId())) continue;
                            String string = ((PersistableObject)object).getProperty("IS_INDEXDETAIL_DESCENDING");
                            if (string != null && string.equals("Y")) {
                                arrayList2.add(mdColumn.getColumnName() + " DESC");
                                continue block8;
                            }
                            arrayList2.add(mdColumn.getColumnName());
                            continue block8;
                        }
                    }
                }
                finally {
                    object2.close();
                }
                stringTemplate.setAttribute("collist", arrayList2);
                String string = stringTemplate.toString();
                this.getGenerator().processFileWriting(string, BaseGeneration.GenerationType.OBJECT);
                this.wasClustered(mdIndexe.getIndexName(), mdIndexe.getProperty("IS_CLUSTERED_INDEX"), false);
                mdIndexe.setNativeSql(string);
                mdIndexe.save(this.getPersistenceManager());
                this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
                this.getGenerator().generateDropObjectsInSchema(mdSchema.getName(), "index", mdIndexe.getIndexName());
                bl = true;
                object = this.getGenerator().generateObjectsInObjectTypes(mdSchema.getName(), "indexes", mdIndexe.getIndexName());
                this.getGenerator().processFileWriting((String)object, BaseGeneration.GenerationType.OBJECTTYPE);
            }
        }
        return bl;
    }

    protected boolean generateIndividualConstraint(MdConstraint mdConstraint, MdTable mdTable, boolean bl) {
        String string = null;
        boolean bl2 = false;
        try {
            if (mdConstraint.getConstraintType().equals("FOREIGN KEY")) {
                bl2 = this.generateIndividualForeignKeyConstraint(mdTable, mdConstraint);
            } else if (mdConstraint.getConstraintType().equals("CHECK")) {
                bl2 = this.generateCheckConstraint(mdTable, mdConstraint, bl);
            } else if (mdConstraint.getConstraintType().equals("UNIQUE")) {
                bl2 = this.generateUniqueConstraint(mdTable, mdConstraint);
            }
            return bl2;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            string = noSuchObjectException.getLocalizedMessage();
        }
        catch (PersistenceException persistenceException) {
            string = persistenceException.getLocalizedMessage();
        }
        if (string != null) {
            s_log.log(Level.SEVERE, "Generate.GENERATECONSTRAINTFAILED", new Object[]{string, mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.235"))});
        }
        return bl2;
    }

    protected boolean generateIndividualConstraint(MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException, GenerateException {
        MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
        return this.generateIndividualConstraint(mdConstraint, mdTable, false);
    }

    protected boolean generateCheckConstraint(MdTable mdTable, MdConstraint mdConstraint, boolean bl) throws PersistenceException {
        if (!mdConstraint.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.CONSTRAINTNOTCONVERTED", new Object[]{mdConstraint.getName(), mdConstraint.getLanguage(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.237"))});
            return false;
        }
        String string = MigrationUtils.findCheckConstraintCondition(mdConstraint, this.getPersistenceManager());
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("CreateCheckConstraint");
        stringTemplate.setAttribute("mdconstraint", (Object)mdConstraint);
        stringTemplate.setAttribute("mdtable", (Object)mdTable);
        stringTemplate.setAttribute("condition", (Object)string);
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_CONSTRAINTS"), mdConstraint.getName());
        this.getAudience().fireListeners(generateEvent);
        String string2 = stringTemplate.toString();
        string2 = string2.replaceAll("\n", "\r\n");
        this.getGenerator().processFileWriting(string2, BaseGeneration.GenerationType.OBJECT);
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateIndividualForeignKeyConstraint(MdTable mdTable, MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException {
        Object object;
        ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
        ArrayList<MdColumn> arrayList2 = new ArrayList<MdColumn>();
        MdTable mdTable2 = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getReftableId());
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());
        String string = this.getSchemaNameFromDBObjectId(mdTable.getSchemaId());
        this.getGenerator().startFileWriting(string, "foreignkeys", mdConstraint.getName(), BaseGeneration.GenerationType.OBJECT);
        boolean bl = false;
        try {
            Object object2;
            GenerateEvent generateEvent;
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    break;
                }
                object = (MdConstraintDetail)closeableIterator.next();
                object2 = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), ((MdConstraintDetail)object).getColumnId());
                if (((MdConstraintDetail)object).getRefFlag().equals("N")) {
                    arrayList.add((MdColumn)object2);
                    continue;
                }
                arrayList2.add((MdColumn)object2);
            }
            object = null;
            if (mdConstraint.getDeleteClause() != null) {
                object = this.getTemplateGroup().getInstanceOf("CreateForeignKeyWithDeleteClause");
                object.setAttribute("delClause", (Object)mdConstraint.getDeleteClause());
            } else {
                object = this.getTemplateGroup().getInstanceOf("CreateForeignKey");
            }
            object.setAttribute("mdconstraint", (Object)mdConstraint);
            object.setAttribute("mdtable", (Object)mdTable);
            if (mdTable.getSchemaId().equals(mdTable2.getSchemaId())) {
                object.setAttribute("reftablename", (Object)mdTable2.getTableName());
            } else {
                object2 = this.findParentSchema(mdTable2);
                if (object2 != null) {
                    String string2 = ((MdSchema)object2).getName() + "." + mdTable2.getTableName();
                    object.setAttribute("reftablename", (Object)string2);
                } else {
                    s_log.log(Level.FINE, "Generate.CANTLOCATEREFSCHEMA", new Object[]{"CAN NOT FIND SCHEMA", mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.252"))});
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            object.setAttribute("collist", arrayList);
            object.setAttribute("refcols", arrayList2);
            generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_CONSTRAINTS"), mdConstraint.getName());
            this.getAudience().fireListeners(generateEvent);
            object2 = object.toString();
            this.getGenerator().processFileWriting((String)object2, BaseGeneration.GenerationType.OBJECT);
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
            mdConstraint.setConstraintText((String)object2);
            mdConstraint.save(this.getPersistenceManager());
            this.getGenerator().endFileWriting(BaseGeneration.GenerationType.OBJECT);
            bl = true;
        }
        finally {
            closeableIterator.close();
        }
        object = this.getGenerator().generateObjectsInObjectTypes(string, "foreignkeys", mdConstraint.getName());
        this.getGenerator().processFileWriting((String)object, BaseGeneration.GenerationType.OBJECTTYPE);
        return bl;
    }

    private boolean isDuplicateForeignKeysExists(MdTable mdTable, MdTable mdTable2, ArrayList<MdColumn> arrayList, ArrayList<MdColumn> arrayList2) {
        String string = mdTable.getObjectName() + "." + arrayList.get(0).getColumnName();
        String string2 = mdTable2.getObjectName() + "." + arrayList2.get(0).getColumnName();
        if (this.m_deleteDuplicateFk.get(string) == null) {
            this.m_deleteDuplicateFk.put(string, string2);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateUniqueConstraint(MdTable mdTable, MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException {
        ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
        if (this.getIOTTableConstraint() != null && this.getIOTTableConstraint().getKey().equals(mdConstraint.getKey())) {
            String string = mdConstraint.getProperty("DO_NOT_ENABLE_DISABLE");
            if (string == null) {
                mdConstraint.addProperty("DO_NOT_ENABLE_DISABLE", "Y", this.getConnectionId());
                mdConstraint.save(this.getPersistenceManager());
            }
            return false;
        }
        try (CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());){
            Object object;
            Object object2;
            GenerateEvent generateEvent;
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    break;
                }
                object2 = (MdConstraintDetail)closeableIterator.next();
                object = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), ((MdConstraintDetail)object2).getColumnId());
                arrayList.add((MdColumn)object);
            }
            object2 = this.getTemplateGroup().getInstanceOf("CreateUniqueConstraint");
            object2.setAttribute("mdconstraint", (Object)mdConstraint);
            object2.setAttribute("mdtable", (Object)mdTable);
            object2.setAttribute("collist", arrayList);
            generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_CONSTRAINTS"), mdConstraint.getName());
            this.getAudience().fireListeners(generateEvent);
            object = object2.toString();
            this.getGenerator().processFileWriting((String)object, BaseGeneration.GenerationType.OBJECT);
            this.wasClustered(mdConstraint.getName(), mdConstraint.getProperty("IS_CLUSTERED_INDEX"), false);
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
            mdConstraint.setConstraintText((String)object);
            mdConstraint.save(this.getPersistenceManager());
            boolean bl = true;
            return bl;
        }
    }

    private String wasClustered(String string, String string2, boolean bl) {
        if (string == null || string.equals("")) {
            return "";
        }
        String string3 = "";
        if (bl || string2 != null) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("Comment");
            stringTemplate.setAttribute("txt", (Object)(string + " was clustered"));
            stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
            string3 = stringTemplate.toString();
            this.getGenerator().processFileWriting(string3, BaseGeneration.GenerationType.OBJECT);
            stringTemplate.reset();
        }
        return string3;
    }

    private boolean doSchemaContainObjects(MdSchema mdSchema) {
        String string = "select count(*) from mgv_all_details where schemaid =" + mdSchema.getKey();
        String string2 = DBUtil.getInstance((Connection)this.getPersistenceManager().getConn()).executeOracleReturnOneCol(string, null);
        int n = Integer.valueOf(string2);
        return n > 1;
    }

    protected DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        this.m_connectionId = dBObjectId;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected GenerationOutputStream createOldGenOutputStream() {
        try {
            File file = new File(this.getOutputDir());
            if (!file.exists()) {
                file.mkdirs();
            }
            String string = this.getOutputDir() + File.separator + "master";
            File file2 = new File(string + ".sql");
            SimpleGenerationOutputStream simpleGenerationOutputStream = null;
            String string2 = Ide.getEnvironOptions().getEncoding();
            simpleGenerationOutputStream = string2 == null ? new SimpleGenerationOutputStream(new PrintStream(file2)) : new SimpleGenerationOutputStream(new PrintStream(file2, string2));
            return simpleGenerationOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    protected void setOutputMainMasterStream(GenerationOutputStream generationOutputStream) {
        this.m_mainMasterOutputStream = generationOutputStream;
    }

    protected GenerationOutputStream getOutputMainMasterStream() {
        return this.m_mainMasterOutputStream;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        this.m_templateGroup = stringTemplateGroup;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    protected GenerateAudience getAudience() {
        return this.m_audience;
    }

    protected void setAudience(GenerateAudience generateAudience) {
        this.m_audience = generateAudience;
    }

    public void addEventListener(GenerateEventListener generateEventListener) {
        this.getAudience().addListener(generateEventListener);
    }

    @Override
    public void signalCancel() {
        this.m_shouldCancel = true;
    }

    protected boolean shouldCancel() {
        return this.m_shouldCancel;
    }

    private void fireEventListeners(GenerateEvent generateEvent) {
        this.getAudience().fireListeners(generateEvent);
    }

    public String getTemplateName() {
        return this.m_templateName;
    }

    public void setTemplateName(String string) {
        this.m_templateName = string;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setFilters(MigrationObjectFilterList migrationObjectFilterList) {
        this.m_filters = migrationObjectFilterList;
    }

    public void setOutputDir(String string) {
        this.m_baseGeneration.setBaseDirectory(string);
    }

    public void setProjectName(String string) {
        String[] stringArray = new String[]{".", "@", "`", "!", "\"", "%", "&", "-", "+", "=", "{", "}", "[", "]", ";", ":", "<", ">", "?", "~", "/", "*", "^", "(", ")", "#", "$", "|", "'", ",", "\\"};
        if (string != null && string.trim().length() > 0) {
            if (string.trim().length() > 30) {
                string = string.trim();
                string = string.substring(0, 29);
            }
            string = string.trim();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.contains(stringArray[i])) continue;
                string = string.replace(stringArray[i], "");
            }
        }
        this.m_projectName = string;
        this.m_baseGeneration.setProjectName(string);
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public String getOutputDir() {
        return this.m_outputDir;
    }

    public BaseGeneration getGenerator() {
        return this.m_baseGeneration;
    }

    public void setGenerator(BaseGeneration baseGeneration) {
        this.m_baseGeneration = baseGeneration;
    }

    public ArrayList<String> getAllSchemaNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MdSchema mdSchema : this.m_schemaCache.values()) {
            arrayList.add(mdSchema.getName());
        }
        return arrayList;
    }

    private String getSchemaNameFromDBObjectId(DBObjectId dBObjectId) {
        try {
            MdSchema mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
            return mdSchema.getName();
        }
        catch (PersistenceException persistenceException) {
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        return null;
    }

    public void isOnlineGenerationMode(boolean bl) {
        this.m_isOnlineGenerationMode = bl;
    }

    public boolean getOnlineGenerationMode() {
        return this.m_isOnlineGenerationMode;
    }

    public void setOnlineGenerationFile(File file) {
        this.m_onlineGenerationFile = file;
    }

    public File getOnlineGenerationFile() {
        return this.m_onlineGenerationFile;
    }

    public void editMainMasterFile() throws Exception {
        this.m_baseGeneration.editMainMasterFile();
    }

    private static enum IOTMode {
        NONE,
        CLUSTERED_NO_PRIMARY,
        PRIMARY;

    }
}

