/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.generate.GenerateEvent;
import oracle.dbtools.migration.generate.GenerateEventListener;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;

public class GenerateRunner
extends AbstractCommonMigrationProgressRunnable
implements GenerateEventListener {
    private GenerateWorker m_worker;
    private URL m_url;

    public GenerateRunner(GenerateWorker generateWorker, URL uRL) {
        this.m_worker = generateWorker;
        this.m_url = uRL;
        this.setTitle(MigrationAddinArb.getString("GENERATERUNNER_TITLE"));
        this.setMessage(MigrationAddinArb.getString("GENERATERUNNER_INITIAL_MESSAGE"));
    }

    public GenerateRunner(GenerateWorker generateWorker) {
        this(generateWorker, null);
    }

    @Override
    protected Object doWork() throws Exception {
        this.m_worker.addEventListener(this);
        if (this.m_worker.runGenerate(MigrationAddin.getMigrationConfig().getSingleSchemaLeastPrivilege())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected void doCancel() {
        super.doCancel();
        this.m_worker.signalCancel();
    }

    @Override
    public void raiseEvent(GenerateEvent generateEvent) {
        String string = "";
        switch (generateEvent.getEventId()) {
            case 1: {
                string = MigrationAddinArb.getString("GENERATING") + " " + generateEvent.getEventSource();
                this.updateProgress(1, generateEvent, string);
                break;
            }
            case 2: {
                string = generateEvent.getEventSource() + " " + MigrationAddinArb.getString("GENERATED");
                this.updateProgress(2, generateEvent, string);
                break;
            }
            case 4: {
                string = MigrationAddinArb.getString("BEGIN_GENERATE");
                this.updateProgress(4, generateEvent, string);
                break;
            }
            case 5: {
                string = MigrationAddinArb.getString("END_GENERATE");
                this.updateProgress(5, generateEvent, string);
                break;
            }
            case 6: {
                string = MigrationAddinArb.getString("GENERATE_FAILED");
                this.updateProgress(6, generateEvent, string);
            }
        }
    }

    @Override
    protected void finish(Object object) {
        Boolean bl;
        super.finish(object);
        if (object != null && (bl = (Boolean)object).booleanValue() && this.m_url != null) {
            SqlNode sqlNode = null;
            try {
                final SqlNode sqlNode2 = sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)this.m_url);
                if (sqlNode2 != null) {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                        }
                    });
                }
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
        }
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{MigrationAddinArb.getString("OBJECT_TYPE"), MigrationAddinArb.getString("OBJECTS_GENERATED")};
    }

    @Override
    public String getEventString(Object object) {
        if (object != null && object instanceof GenerateEvent) {
            GenerateEvent generateEvent = (GenerateEvent)object;
            String string = null;
            if (generateEvent.getEventId() == 1) {
                for (int i = 0; i < GenerateEvent.GENERATE_OBJECTS.length; ++i) {
                    if (!generateEvent.getEventSourceType().equalsIgnoreCase(GenerateEvent.GENERATE_OBJECTS[i])) continue;
                    string = GenerateEvent.GENERATE_OBJECTS[i];
                }
            }
            return string;
        }
        return null;
    }

    @Override
    public void setTableCellRenderer() {
    }

    @Override
    public void setToolTip() {
    }
}

