/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.TreePicker;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.migration.workbench.core.util.MigrationResourceManager;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.ide.model.Element;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class TranslatePageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider {
    private final MultiLineLabel m_lblOverview = new MultiLineLabel(QMWizardArb.getString(""));
    private final JLabel m_lblLeftDBO = new JLabel(QMWizardArb.getString("AvailableDBO"));
    private final JLabel m_lblRightDBO = new JLabel(QMWizardArb.getString("SelectedDBO"));
    private JList m_availableList = new JList();
    private DefaultListModel m_availListModel = new DefaultListModel();
    private JList m_selectedList = new JList();
    private DefaultListModel m_selListModel = new DefaultListModel();
    private final ListPicker m_availableListPicker = new ListPicker(this.m_availableList);
    private final ListPicker m_selectedListPicker = new ListPicker(this.m_selectedList);
    private final MultiLineLabel m_lblPageOverview = new MultiLineLabel(QMWizardArb.getString("TranslatePageOverview"));
    private JPanel m_mainPanel = null;
    private final JCheckBox _chkGoSummary = new JCheckBox();
    private boolean _skip = false;
    private boolean _pageLocked = false;
    private JTree m_availableTree = null;
    private JTree m_selectedTree = null;
    private final Shuttle m_dboChooserShuttle = new Shuttle();
    private TranslateTreePicker m_availableDBOPicker = null;
    private TranslateTreePicker m_selectedDBOPicker = null;
    private static Icon m_schemaFldrIcon = OracleNavigatorResource.getIcon((String)"SCHEMAS_FOLDER_ICON");
    private static Icon m_viewFldrIcon = OracleNavigatorResource.getIcon((String)"VIEW_FOLDER_ICON");
    private static Icon m_viewIcon = OracleIcons.getIcon((String)"view.png");
    private static String m_viewFldrLbl = OracleNavigatorResource.getString((String)"VIEW_LABEL");
    private static Icon m_procFldrIcon = OracleNavigatorResource.getIcon((String)"PROCEDURE_FOLDER_ICON");
    private static Icon m_procIcon = OracleNavigatorResource.getIcon((String)"PROCEDURE_ICON");
    private static String m_procFldrLbl = OracleNavigatorResource.getString((String)"PROCEDURE_LABEL");
    private static Icon m_funcFldrIcon = OracleNavigatorResource.getIcon((String)"FUNCTION_FOLDER_ICON");
    private static Icon m_funcIcon = OracleNavigatorResource.getIcon((String)"FUNCTION_ICON");
    private static String m_funcFldrLbl = OracleNavigatorResource.getString((String)"FUNCTION_LABEL");
    private static Icon m_triggFldrIcon = OracleNavigatorResource.getIcon((String)"TRIGGER_FOLDER_ICON");
    private static Icon m_triggIcon = OracleIcons.getIcon((String)"trigger.png");
    private static String m_triggFldrLbl = OracleNavigatorResource.getString((String)"TRIGGER_LABEL");
    private static Icon m_constraintFldrIcon = MigrationResourceManager.getIcon(TranslatePageMigration.class, "/oracle/dbtools/migration/workbench/core/images/constraint_fld_eng.png");
    private static Icon m_constraintIcon = OracleIcons.getIcon((String)"constraint.png");
    private static String m_constraintFldrLbl = QMWizardArb.getString("ConstraintLabel");
    private static final String QUERY = "WITH MDDER AS (SELECT * FROM MD_DERIVATIVES WHERE MD_DERIVATIVES.DERIVED_CONNECTION_ID_FK = ? AND UPPER(MD_DERIVATIVES.ENABLED) = 'Y' AND MD_DERIVATIVES.DERIVATIVE_REASON IS NULL AND (MD_DERIVATIVES.SRC_TYPE = 'MD_STORED_PROGRAMS' OR MD_DERIVATIVES.SRC_TYPE = 'MD_VIEWS' OR MD_DERIVATIVES.SRC_TYPE = 'MD_TRIGGERS' OR MD_DERIVATIVES.SRC_TYPE = 'MD_SCHEMAS' OR MD_DERIVATIVES.SRC_TYPE = 'MD_CONSTRAINTS')) SELECT MD_SCHEMAS.NAME SCHEMANAME, MD_SCHEMAS.ID SCHEMAID, MD_STORED_PROGRAMS.NAME OBJNAME, MD_STORED_PROGRAMS.ID OBJID, 'MD_STORED_PROGRAMS' OBJTYPE, 'PROCEDURE' TYPE FROM MD_SCHEMAS INNER JOIN MDDER ON MD_SCHEMAS.ID = MDDER.DERIVED_ID INNER JOIN MD_STORED_PROGRAMS ON MD_STORED_PROGRAMS.SCHEMA_ID_FK = MD_SCHEMAS.ID AND MD_STORED_PROGRAMS.PROGRAMTYPE = 'PROCEDURE' INNER JOIN MDDER MDDER2 ON MD_STORED_PROGRAMS.ID = MDDER2.DERIVED_ID AND UPPER(MDDER2.ENABLED) = 'Y' UNION SELECT  MD_SCHEMAS.NAME SCHEMANAME,MD_SCHEMAS.ID SCHEMAID,MD_STORED_PROGRAMS.NAME OBJNAME, MD_STORED_PROGRAMS.ID OBJID, 'MD_STORED_PROGRAMS' OBJTYPE, 'FUNCTION' TYPE FROM MD_SCHEMAS INNER JOIN MDDER ON MD_SCHEMAS.ID = MDDER.DERIVED_ID INNER JOIN MD_STORED_PROGRAMS ON MD_STORED_PROGRAMS.SCHEMA_ID_FK = MD_SCHEMAS.ID AND MD_STORED_PROGRAMS.PROGRAMTYPE = 'FUNCTION' INNER JOIN MDDER MDDER2 ON MD_STORED_PROGRAMS.ID = MDDER2.DERIVED_ID AND UPPER(MDDER2.ENABLED) = 'Y' UNION SELECT MD_SCHEMAS.NAME SCHEMANAME, MD_SCHEMAS.ID SCHEMAID, MD_VIEWS.VIEW_NAME OBJNAME, MD_VIEWS.ID OBJID, 'MD_VIEWS' OBJTYPE, 'NONE' TYPE FROM MD_SCHEMAS INNER JOIN MDDER ON MD_SCHEMAS.ID = MDDER.DERIVED_ID INNER JOIN MD_VIEWS ON MD_VIEWS.SCHEMA_ID_FK = MD_SCHEMAS.ID INNER JOIN MDDER MDDER2 ON MD_VIEWS.ID = MDDER2.DERIVED_ID AND UPPER(MDDER2.ENABLED) = 'Y' UNION SELECT MD_SCHEMAS.NAME SCHEMANAME,MD_SCHEMAS.ID SCHEMAID,MD_TRIGGERS.TRIGGER_NAME OBJNAME, MD_TRIGGERS.ID OBJID, 'MD_TRIGGERS' OBJTYPE, 'NONE' TYPE FROM MD_SCHEMAS INNER JOIN MDDER ON MD_SCHEMAS.ID = MDDER.DERIVED_ID INNER JOIN MD_TABLES ON MD_TABLES.SCHEMA_ID_FK = MD_SCHEMAS.ID INNER JOIN MD_TRIGGERS ON MD_TABLES.ID = MD_TRIGGERS.TABLE_OR_VIEW_ID_FK INNER JOIN MDDER MDDER2 ON MD_TRIGGERS.ID = MDDER2.DERIVED_ID AND MDDER2.SRC_TYPE = MDDER2.DERIVED_TYPE AND UPPER(MDDER2.ENABLED) = 'Y'UNION SELECT  MD_SCHEMAS.NAME SCHEMANAME,MD_SCHEMAS.ID SCHEMAID,MD_TRIGGERS.TRIGGER_NAME OBJNAME, MD_TRIGGERS.ID OBJID, 'MD_TRIGGERS' OBJTYPE, 'NONE' TYPE FROM MD_SCHEMAS INNER JOIN MDDER ON MD_SCHEMAS.ID = MDDER.DERIVED_ID INNER JOIN MD_VIEWS ON MD_VIEWS.SCHEMA_ID_FK = MD_SCHEMAS.ID INNER JOIN MD_TRIGGERS ON MD_VIEWS.ID = MD_TRIGGERS.TABLE_OR_VIEW_ID_FK INNER JOIN MDDER MDDER2 ON MD_TRIGGERS.ID = MDDER2.DERIVED_ID AND MDDER2.SRC_TYPE = MDDER2.DERIVED_TYPE AND UPPER(MDDER2.ENABLED) = 'Y'UNION SELECT MD_SCHEMAS.NAME SCHEMANAME, MD_SCHEMAS.ID SCHEMAID, MD_CONSTRAINTS.NAME OBJNAME, MD_CONSTRAINTS.ID OBJID, 'MD_CONSTRAINTS' OBJTYPE, 'CHECK' TYPE FROM MD_SCHEMAS INNER JOIN MDDER ON MD_SCHEMAS.ID = MDDER.DERIVED_ID INNER JOIN MD_TABLES ON MD_TABLES.SCHEMA_ID_FK = MD_SCHEMAS.ID INNER JOIN MD_CONSTRAINTS ON MD_CONSTRAINTS.TABLE_ID_FK = MD_TABLES.ID AND MD_CONSTRAINTS.CONSTRAINT_TYPE = 'CHECK' INNER JOIN MDDER MDDER2 ON MD_CONSTRAINTS.ID = MDDER2.DERIVED_ID AND UPPER(MDDER2.ENABLED) = 'Y'ORDER BY SCHEMANAME";
    private int m_numObjects = 0;

    TranslatePageMigration() {
        ResourceUtils.resButton((AbstractButton)this._chkGoSummary, (String)QMWizardArb.getString("GoToSummary"));
        this.putClientProperty("pagetitle", QMWizard.TRSLTE_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.TRSLTE_PAGE_ID, this);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.skipIfNeeded(traversableContext);
        this.initGUI();
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateAndAbsorbPage(traversableContext);
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP6"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP6"));
            }
        }
    }

    public Object getExitTransition() {
        if (this._chkGoSummary.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        if (summaryCategory != null) {
            summaryCategory2 = summaryCategory;
            summaryItem = this.getSelectedObjects().size() > 0 || !this.getDefaultSelection().equals("") ? new SummaryItem(QMWizardArb.getString("ObjectsSelected"), QMWizardArb.getString("Yes")) : new SummaryItem(QMWizardArb.getString("ObjectsSelected"), QMWizardArb.getString("No"));
            summaryCategory2.addChild(summaryItem);
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Element element;
            MdConnection mdConnection;
            MdConnection mdConnection2;
            Properties properties = new Properties();
            MigrationWizardFinisher migrationWizardFinisher = null;
            MdProject mdProject = QMWizard.ContextHelper.getProject();
            if (mdProject != null) {
                properties.put("PARAM_PROJ", mdProject);
            }
            if ((mdConnection2 = QMWizard.ContextHelper.getCapturedConnectionObject()) != null) {
                properties.put("CONV_CATPCONN", mdConnection2);
            }
            if ((mdConnection = QMWizard.ContextHelper.getConvertedConnectionObject()) != null) {
                properties.put("CONV_CONVCONN", mdConnection);
            }
            if ((element = QMWizard.ContextHelper.getContextElement()) != null) {
                properties.put("CTX_ELEMENT", element);
            }
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            if (mdConnection != null) {
                if (traversableContext.get("SELECTED_TO_TRNSL_LIST") != null) {
                    properties.put("PARAM_TRNSL_SELOBJECTS", traversableContext.get("SELECTED_TO_TRNSL_LIST"));
                }
            } else if (traversableContext.get("SELECTED_TO_TRNSL_GROUPS") != null) {
                properties.put("PARAM_TRNSL_SELOBJGROUPS", traversableContext.get("SELECTED_TO_TRNSL_GROUPS"));
            }
            migrationWizardFinisher.setParamAndFinish(properties, 32);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private void initGUI() {
        if (!this._skip && this.m_mainPanel == null) {
            this.m_mainPanel = new JPanel();
            this.m_mainPanel.setLayout(new BorderLayout());
            this.m_dboChooserShuttle.add((Component)this.m_lblLeftDBO, (Object)"FromHeader");
            this.m_dboChooserShuttle.add((Component)this.m_lblRightDBO, (Object)"ToHeader");
            SortableNode sortableNode = null;
            SortableNode sortableNode2 = null;
            if (QMWizard.ContextHelper.getConvertedConnectionObject() != null) {
                Element element = QMWizard.ContextHelper.getContextElement();
                ConvertedModelsFolderNode convertedModelsFolderNode = (ConvertedModelsFolderNode)element;
                MdConnection mdConnection = convertedModelsFolderNode.getConvertedConnection();
                SchemaNode[] schemaNodeArray = null;
                long l = System.currentTimeMillis();
                if (mdConnection != null) {
                    schemaNodeArray = this.getSchemaNodes(mdConnection);
                }
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                sortableNode = new SortableNode();
                sortableNode.setUserObject("convobj_root");
                if (schemaNodeArray != null) {
                    for (SchemaNode schemaNode : schemaNodeArray) {
                        if (schemaNode.getChildCount() <= 0) continue;
                        sortableNode.add(schemaNode);
                    }
                }
                this.m_availableTree = new JTree(sortableNode);
                this.m_availableTree.setRootVisible(false);
                this.m_availableTree.setCellRenderer(new TranslateTreeCellRenderer());
                for (int i = 0; i < this.m_availableTree.getRowCount(); ++i) {
                    this.m_availableTree.expandRow(i);
                }
                this.m_availableDBOPicker = new TranslateTreePicker(this.m_availableTree);
                this.m_dboChooserShuttle.setFromPicker((ItemPicker)this.m_availableDBOPicker);
                sortableNode2 = new SortableNode();
                sortableNode2.setUserObject("convobj_root");
                this.m_selectedTree = new JTree(sortableNode2);
                this.m_selectedTree.setRootVisible(false);
                this.m_selectedTree.setCellRenderer(new TranslateTreeCellRenderer());
                this.m_selectedDBOPicker = new TranslateTreePicker(this.m_selectedTree);
                this.m_dboChooserShuttle.setToPicker((ItemPicker)this.m_selectedDBOPicker);
            } else {
                this.m_availableList.setModel(this.m_availListModel);
                this.m_selectedList.setModel(this.m_selListModel);
                this.m_selListModel.addElement(QMWizardArb.getString("AllConstraints"));
                this.m_selListModel.addElement(QMWizardArb.getString("AllFunctions"));
                this.m_selListModel.addElement(QMWizardArb.getString("AllProcedures"));
                this.m_selListModel.addElement(QMWizardArb.getString("AllTriggers"));
                this.m_selListModel.addElement(QMWizardArb.getString("AllViews"));
                this.m_dboChooserShuttle.setFromPicker((ItemPicker)this.m_availableListPicker);
                this.m_dboChooserShuttle.setToPicker((ItemPicker)this.m_selectedListPicker);
            }
            this.setLayout(new BorderLayout());
            this.m_mainPanel.add((Component)this.m_lblPageOverview, "North");
            this.m_mainPanel.add((Component)this.m_dboChooserShuttle, "Center");
            this.m_mainPanel.add((Component)this._chkGoSummary, "South");
            this.add(this.m_mainPanel, "Center");
        }
    }

    private HashMap<Long, String> getSelectedObjects() {
        DefaultTreeModel defaultTreeModel;
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        if (this.m_selectedTree != null && (defaultTreeModel = (DefaultTreeModel)this.m_selectedTree.getModel()).getRoot() != null) {
            for (int i = 0; i < defaultTreeModel.getChildCount(defaultTreeModel.getRoot()); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultTreeModel.getRoot(), i);
                if (!(defaultMutableTreeNode instanceof SchemaNode)) continue;
                hashMap.putAll(this.getChildren(defaultTreeModel, defaultMutableTreeNode));
            }
        }
        return hashMap;
    }

    private String getDefaultSelection() {
        String string = "";
        if (this.m_selListModel.contains(QMWizardArb.getString("AllConstraints")) || this.m_selListModel.contains(QMWizardArb.getString("AllFunctions")) || this.m_selListModel.contains(QMWizardArb.getString("AllProcedures")) || this.m_selListModel.contains(QMWizardArb.getString("AllTriggers")) || this.m_selListModel.contains(QMWizardArb.getString("AllViews"))) {
            string = QMWizardArb.getString("AllObjects");
        }
        return string;
    }

    private ArrayList<String> getSelectedObjectGroups() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_selListModel.size(); ++i) {
            arrayList.add((String)this.m_selListModel.getElementAt(i));
        }
        return arrayList;
    }

    private HashMap<Long, String> getChildren(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        int n = defaultTreeModel.getChildCount(defaultMutableTreeNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getChild(defaultMutableTreeNode, i);
            if (defaultMutableTreeNode2 instanceof FolderNode) {
                hashMap.putAll(this.getChildren(defaultTreeModel, defaultMutableTreeNode2));
            }
            if (defaultMutableTreeNode2 instanceof ViewNode) {
                hashMap.put(((ViewNode)defaultMutableTreeNode2).getId(), "View");
                continue;
            }
            if (defaultMutableTreeNode2 instanceof ProcNode) {
                hashMap.put(((ProcNode)defaultMutableTreeNode2).getId(), "Stored Program");
                continue;
            }
            if (defaultMutableTreeNode2 instanceof FuncNode) {
                hashMap.put(((FuncNode)defaultMutableTreeNode2).getId(), "Stored Program");
                continue;
            }
            if (defaultMutableTreeNode2 instanceof TriggNode) {
                hashMap.put(((TriggNode)defaultMutableTreeNode2).getId(), "Trigger");
                continue;
            }
            if (!(defaultMutableTreeNode2 instanceof ConstraintNode)) continue;
            hashMap.put(((ConstraintNode)defaultMutableTreeNode2).getId(), "Constraint");
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaNode[] getSchemaNodes(MdConnection mdConnection) {
        int n;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<SchemaNode> arrayList = new ArrayList<SchemaNode>();
        SchemaNode[] schemaNodeArray = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        long l = 0L;
        long l2 = 0L;
        SchemaNode schemaNode = null;
        FolderNode folderNode = null;
        FolderNode folderNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        Connection connection = MigrationAddin.getPersistenceManager().getConn();
        try {
            preparedStatement = connection.prepareStatement(QUERY);
            preparedStatement.setLong(1, mdConnection.getKey().getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet != null && resultSet.next()) {
                DefaultMutableTreeNode defaultMutableTreeNode4;
                if (l != resultSet.getLong(2)) {
                    string = resultSet.getString(1);
                    l = resultSet.getLong(2);
                    schemaNode = new SchemaNode(l, string);
                    arrayList.add(schemaNode);
                    folderNode = new FolderNode(m_procFldrLbl);
                    folderNode2 = new FolderNode(m_funcFldrLbl);
                    defaultMutableTreeNode = new FolderNode(m_viewFldrLbl);
                    defaultMutableTreeNode2 = new FolderNode(m_triggFldrLbl);
                    defaultMutableTreeNode3 = new FolderNode(m_constraintFldrLbl);
                }
                string2 = resultSet.getString(3);
                l2 = resultSet.getLong(4);
                string3 = resultSet.getString(5);
                string4 = resultSet.getString(6);
                if (string3.equals("MD_VIEWS")) {
                    defaultMutableTreeNode4 = new ViewNode(l2, string2);
                    defaultMutableTreeNode.add(defaultMutableTreeNode4);
                } else if (string3.equals("MD_STORED_PROGRAMS")) {
                    if (string4.equals("PROCEDURE")) {
                        defaultMutableTreeNode4 = new ProcNode(l2, string2);
                        folderNode.add(defaultMutableTreeNode4);
                    } else if (string4.equals("FUNCTION")) {
                        defaultMutableTreeNode4 = new FuncNode(l2, string2);
                        folderNode2.add(defaultMutableTreeNode4);
                    }
                } else if (string3.equals("MD_TRIGGERS")) {
                    defaultMutableTreeNode4 = new TriggNode(l2, string2);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                } else if (string3.equals("MD_CONSTRAINTS")) {
                    defaultMutableTreeNode4 = new ConstraintNode(l2, string2);
                    defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                }
                if (schemaNode == null) continue;
                if (defaultMutableTreeNode.getChildCount() > 0 && !schemaNode.isNodeChild(defaultMutableTreeNode)) {
                    schemaNode.add(defaultMutableTreeNode);
                }
                if (folderNode.getChildCount() > 0 && !schemaNode.isNodeChild(folderNode)) {
                    schemaNode.add(folderNode);
                }
                if (folderNode2.getChildCount() > 0 && !schemaNode.isNodeChild(folderNode2)) {
                    schemaNode.add(folderNode2);
                }
                if (defaultMutableTreeNode2.getChildCount() > 0 && !schemaNode.isNodeChild(defaultMutableTreeNode2)) {
                    schemaNode.add(defaultMutableTreeNode2);
                }
                if (defaultMutableTreeNode3.getChildCount() <= 0 || schemaNode.isNodeChild(defaultMutableTreeNode3)) continue;
                schemaNode.add(defaultMutableTreeNode3);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                preparedStatement.close();
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        if ((n = arrayList.size()) > 0) {
            schemaNodeArray = new SchemaNode[n];
            arrayList.toArray(schemaNodeArray);
        }
        return schemaNodeArray;
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private void disablePageWidgets() {
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (QMWizard.ContextHelper.isMigrationAction() && QMWizard.ContextHelper.getActionName() != null && (QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("GENERATE_PAGE").trim()) || QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("DATAMOVE_PAGE").trim()))) {
            this._skip = true;
            this.lockPage(false);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
        if (QMWizard.ContextHelper.getConvertedConnectionObject() != null) {
            HashMap<Long, String> hashMap = this.getSelectedObjects();
            traversableContext.put("SELECTED_TO_TRNSL_LIST", Collections.unmodifiableMap(hashMap));
        } else {
            ArrayList<String> arrayList = null;
            if (this.m_availListModel.size() <= 0) {
                arrayList = new ArrayList();
                arrayList.add(QMWizardArb.getString("AllObjects"));
            } else {
                arrayList = this.getSelectedObjectGroups();
            }
            traversableContext.put("SELECTED_TO_TRNSL_GROUPS", Collections.unmodifiableCollection(arrayList));
        }
    }

    class SortableNode
    extends DefaultMutableTreeNode {
        private Comparator m_comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        };

        SortableNode() {
        }

        @Override
        public void insert(MutableTreeNode mutableTreeNode, int n) {
            super.insert(mutableTreeNode, n);
            Collections.sort(this.children, this.m_comparator);
        }
    }

    class ConstraintNode
    extends DefaultMutableTreeNode {
        private MdConstraint m_constraint = null;
        private long m_id = -1L;

        public ConstraintNode(MdConstraint mdConstraint) {
            this.setUserObject(mdConstraint);
            this.m_constraint = mdConstraint;
        }

        public ConstraintNode(Long l, String string) {
            this.setUserObject(string);
            this.m_id = l;
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }

        public long getId() {
            return this.m_id;
        }
    }

    class TriggNode
    extends DefaultMutableTreeNode {
        private MdTrigger m_trigg = null;
        private long m_id = -1L;

        public TriggNode(MdTrigger mdTrigger) {
            this.setUserObject(mdTrigger);
            this.m_trigg = mdTrigger;
        }

        public TriggNode(Long l, String string) {
            this.setUserObject(string);
            this.m_id = l;
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }

        public long getId() {
            return this.m_id;
        }
    }

    class FuncNode
    extends DefaultMutableTreeNode {
        private MdStoredProgram m_proc = null;
        private long m_id = -1L;

        public FuncNode(MdStoredProgram mdStoredProgram) {
            this.setUserObject(mdStoredProgram);
            this.m_proc = mdStoredProgram;
        }

        public FuncNode(Long l, String string) {
            this.setUserObject(string);
            this.m_id = l;
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }

        public long getId() {
            return this.m_id;
        }
    }

    class ProcNode
    extends DefaultMutableTreeNode {
        private MdStoredProgram m_proc = null;
        private long m_id = -1L;

        public ProcNode(MdStoredProgram mdStoredProgram) {
            this.setUserObject(mdStoredProgram);
            this.m_proc = mdStoredProgram;
        }

        public ProcNode(Long l, String string) {
            this.setUserObject(string);
            this.m_id = l;
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }

        public long getId() {
            return this.m_id;
        }
    }

    class ViewNode
    extends DefaultMutableTreeNode {
        private MdView m_view = null;
        private long m_id = -1L;

        public ViewNode(MdView mdView) {
            this.setUserObject(mdView);
            this.m_view = mdView;
        }

        public ViewNode(Long l, String string) {
            this.setUserObject(string);
            this.m_id = l;
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }

        public long getId() {
            return this.m_id;
        }
    }

    class SchemaNode
    extends SortableNode {
        private static final long serialVersionUID = 1L;
        private MdSchema m_schema = null;
        private long m_id = -1L;

        public SchemaNode(MdSchema mdSchema) {
            this.m_schema = mdSchema;
            this.setUserObject(mdSchema);
        }

        public SchemaNode(Long l, String string) {
            this.setUserObject(string);
            this.m_id = l;
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }

        public long getId() {
            return this.m_id;
        }
    }

    class FolderNode
    extends SortableNode {
        public FolderNode(String string) {
            this.setUserObject(string);
        }
    }

    class TranslateTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        TranslateTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            SchemaNode schemaNode = null;
            if (defaultMutableTreeNode instanceof SchemaNode) {
                schemaNode = (SchemaNode)defaultMutableTreeNode;
                String string = schemaNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(m_schemaFldrIcon);
            } else if (defaultMutableTreeNode instanceof ViewNode) {
                ViewNode viewNode = (ViewNode)defaultMutableTreeNode;
                String string = viewNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(m_viewIcon);
            } else if (defaultMutableTreeNode instanceof ProcNode) {
                ProcNode procNode = (ProcNode)defaultMutableTreeNode;
                String string = procNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(m_procIcon);
            } else if (defaultMutableTreeNode instanceof FuncNode) {
                FuncNode funcNode = (FuncNode)defaultMutableTreeNode;
                String string = funcNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(m_funcIcon);
            } else if (defaultMutableTreeNode instanceof TriggNode) {
                TriggNode triggNode = (TriggNode)defaultMutableTreeNode;
                String string = triggNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(m_triggIcon);
            } else if (defaultMutableTreeNode instanceof ConstraintNode) {
                ConstraintNode constraintNode = (ConstraintNode)defaultMutableTreeNode;
                String string = constraintNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(m_constraintIcon);
            } else if (defaultMutableTreeNode instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)defaultMutableTreeNode;
                String string = folderNode.toString();
                component = super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
                String string2 = (String)folderNode.getUserObject();
                if (string2.equals(m_viewFldrLbl)) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(m_viewFldrIcon);
                } else if (string2.equals(m_procFldrLbl)) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(m_procFldrIcon);
                } else if (string2.equals(m_funcFldrLbl)) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(m_funcFldrIcon);
                } else if (string2.equals(m_triggFldrLbl)) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(m_triggFldrIcon);
                } else if (string2.equals(m_constraintFldrLbl)) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(m_constraintFldrIcon);
                }
            } else {
                component = super.getTreeCellRendererComponent(jTree, null, bl, bl2, bl3, n, bl4);
                JLabel jLabel = (JLabel)component;
                jLabel.setIcon(null);
            }
            return component;
        }
    }

    class TranslateTreePicker
    extends TreePicker {
        public TranslateTreePicker(JTree jTree) {
            super(jTree);
        }

        public boolean addSelectedItems(Transferable[] transferableArray) {
            if (transferableArray != null) {
                block2: for (Transferable transferable : transferableArray) {
                    DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                    if (dataFlavorArray == null) continue;
                    for (DataFlavor dataFlavor : dataFlavorArray) {
                        try {
                            DefaultMutableTreeNode[] defaultMutableTreeNodeArray;
                            int n;
                            int n2;
                            int n3;
                            Object object = transferable.getTransferData(dataFlavor);
                            TreePath treePath = (TreePath)object;
                            Object[] objectArray = treePath.getPath();
                            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
                            Object object2 = null;
                            int n4 = -1;
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            for (n3 = 0; n3 < objectArray.length; ++n3) {
                                if (n3 == 0) {
                                    if (!((DefaultMutableTreeNode)objectArray[n3]).getUserObject().equals(((DefaultMutableTreeNode)defaultTreeModel.getRoot()).getUserObject())) break;
                                    object2 = defaultTreeModel.getRoot();
                                    arrayList.add(object2);
                                    n4 = n3;
                                    continue;
                                }
                                if (object2 == null) continue;
                                int n5 = defaultTreeModel.getChildCount(object2);
                                n2 = 0;
                                for (n = 0; n < n5; ++n) {
                                    defaultMutableTreeNodeArray = (DefaultMutableTreeNode[])defaultTreeModel.getChild(object2, n);
                                    if (!defaultMutableTreeNodeArray.getUserObject().equals(((DefaultMutableTreeNode)objectArray[n3]).getUserObject())) continue;
                                    object2 = defaultMutableTreeNodeArray;
                                    n4 = n3;
                                    n2 = 1;
                                    break;
                                }
                                if (n2 == 0) break;
                                arrayList.add(object2);
                            }
                            if (n4 != -1 && n4 == objectArray.length - 1) {
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[n4];
                                this._recursivelyAddChildren(defaultMutableTreeNode, object2, defaultTreeModel, arrayList);
                            } else {
                                for (n3 = n4 + 1; n3 < objectArray.length; ++n3) {
                                    DefaultMutableTreeNode defaultMutableTreeNode;
                                    if (n3 == 0) {
                                        object2 = defaultTreeModel.getRoot();
                                        arrayList.add(object2);
                                        continue;
                                    }
                                    if (n3 == objectArray.length - 1) {
                                        int n6;
                                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)objectArray[n3];
                                        DefaultMutableTreeNode defaultMutableTreeNode3 = this.createToNode(defaultMutableTreeNode2);
                                        n = defaultMutableTreeNode2.getChildCount();
                                        defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n];
                                        for (n6 = 0; n6 < n; ++n6) {
                                            defaultMutableTreeNodeArray[n6] = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n6);
                                        }
                                        for (n6 = 0; n6 < n; ++n6) {
                                            defaultMutableTreeNode3.add(defaultMutableTreeNodeArray[n6]);
                                        }
                                        this.insert(defaultTreeModel, defaultMutableTreeNode3, (DefaultMutableTreeNode)object2);
                                        arrayList.add(defaultMutableTreeNode3);
                                        object2 = objectArray[n3];
                                        continue;
                                    }
                                    DefaultMutableTreeNode defaultMutableTreeNode4 = null;
                                    defaultMutableTreeNode4 = defaultMutableTreeNode = this.createToNode((DefaultMutableTreeNode)objectArray[n3]);
                                    this.insert(defaultTreeModel, defaultMutableTreeNode4, (DefaultMutableTreeNode)object2);
                                    arrayList.add(defaultMutableTreeNode4);
                                    object2 = defaultMutableTreeNode4;
                                }
                            }
                            Object[] objectArray2 = arrayList.toArray();
                            TreePath treePath2 = new TreePath(objectArray2);
                            this.getTree().makeVisible(treePath2);
                            this.getTree().revalidate();
                            for (n2 = 0; n2 < this.getTree().getRowCount(); ++n2) {
                                this.getTree().expandRow(n2);
                            }
                            continue block2;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            return true;
        }

        public void removeSelectedItems() {
            TreePath[] treePathArray = this.getTree().getSelectionPaths();
            if (treePathArray != null) {
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
                for (int i = 0; i < treePathArray.length; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    if (defaultMutableTreeNode2 == null) continue;
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                    if (defaultMutableTreeNode2.getChildCount() != 0 || defaultMutableTreeNode2.getParent() == null) continue;
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
                }
            }
        }

        private void _recursivelyAddChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object, DefaultTreeModel defaultTreeModel, ArrayList arrayList) {
            int n;
            int n2 = defaultMutableTreeNode.getChildCount();
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
            for (int i = 0; i < n2; ++i) {
                defaultMutableTreeNodeArray[i] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object;
            int n3 = defaultMutableTreeNode2.getChildCount();
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray2 = new DefaultMutableTreeNode[n3];
            for (n = 0; n < n3; ++n) {
                defaultMutableTreeNodeArray2[n] = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            }
            for (n = 0; n < n2; ++n) {
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    if (!defaultMutableTreeNodeArray[n].getUserObject().equals(defaultMutableTreeNodeArray2[i].getUserObject())) continue;
                    bl = true;
                    object = defaultMutableTreeNodeArray2[i];
                    break;
                }
                if (!bl) {
                    this.insert(defaultTreeModel, defaultMutableTreeNodeArray[n], defaultMutableTreeNode2);
                    arrayList.add(defaultMutableTreeNodeArray[n]);
                    continue;
                }
                this._recursivelyAddChildren(defaultMutableTreeNodeArray[n], object, defaultTreeModel, arrayList);
            }
        }

        private DefaultMutableTreeNode createToNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            if (defaultMutableTreeNode instanceof SchemaNode) {
                defaultMutableTreeNode2 = new SchemaNode(((SchemaNode)defaultMutableTreeNode).getId(), ((SchemaNode)defaultMutableTreeNode).toString());
            } else if (defaultMutableTreeNode instanceof ViewNode) {
                defaultMutableTreeNode2 = new ViewNode(((ViewNode)defaultMutableTreeNode).getId(), ((ViewNode)defaultMutableTreeNode).toString());
            } else if (defaultMutableTreeNode instanceof ProcNode) {
                defaultMutableTreeNode2 = new ProcNode(((ProcNode)defaultMutableTreeNode).getId(), ((ProcNode)defaultMutableTreeNode).toString());
            } else if (defaultMutableTreeNode instanceof FuncNode) {
                defaultMutableTreeNode2 = new FuncNode(((FuncNode)defaultMutableTreeNode).getId(), ((FuncNode)defaultMutableTreeNode).toString());
            } else if (defaultMutableTreeNode instanceof TriggNode) {
                defaultMutableTreeNode2 = new TriggNode(((TriggNode)defaultMutableTreeNode).getId(), ((TriggNode)defaultMutableTreeNode).toString());
            } else if (defaultMutableTreeNode instanceof ConstraintNode) {
                defaultMutableTreeNode2 = new ConstraintNode(((ConstraintNode)defaultMutableTreeNode).getId(), ((ConstraintNode)defaultMutableTreeNode).toString());
            } else if (defaultMutableTreeNode instanceof FolderNode) {
                defaultMutableTreeNode2 = new FolderNode((String)((FolderNode)defaultMutableTreeNode).getUserObject());
            }
            return defaultMutableTreeNode2;
        }

        private void orderedInsert(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            if (defaultTreeModel != null && defaultMutableTreeNode != null && defaultMutableTreeNode2 != null) {
                if (defaultMutableTreeNode instanceof FolderNode) {
                    int n = defaultTreeModel.getChildCount(defaultMutableTreeNode2);
                    if (n == 1) {
                        if (((String)defaultMutableTreeNode.getUserObject()).equals(m_viewFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
                        } else {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
                        }
                    } else if (n == 2) {
                        if (((String)defaultMutableTreeNode.getUserObject()).equals(m_viewFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
                        } else if (((String)defaultMutableTreeNode.getUserObject()).equals(m_procFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 1);
                        } else {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
                        }
                    } else if (n == 3) {
                        if (((String)defaultMutableTreeNode.getUserObject()).equals(m_viewFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
                        } else if (((String)defaultMutableTreeNode.getUserObject()).equals(m_procFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 1);
                        } else if (((String)defaultMutableTreeNode.getUserObject()).equals(m_funcFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 2);
                        } else {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
                        }
                    } else if (n == 4) {
                        if (((String)defaultMutableTreeNode.getUserObject()).equals(m_viewFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
                        } else if (((String)defaultMutableTreeNode.getUserObject()).equals(m_procFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 1);
                        } else if (((String)defaultMutableTreeNode.getUserObject()).equals(m_funcFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 2);
                        } else if (((String)defaultMutableTreeNode.getUserObject()).equals(m_triggFldrLbl)) {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, 3);
                        } else {
                            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
                        }
                    } else {
                        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
                    }
                } else {
                    this.insert(defaultTreeModel, defaultMutableTreeNode, defaultMutableTreeNode2);
                }
            }
        }

        private void insert(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            if (defaultMutableTreeNode2 instanceof SortableNode) {
                ((SortableNode)defaultMutableTreeNode2).insert(defaultMutableTreeNode, ((SortableNode)defaultMutableTreeNode2).getChildCount());
                int[] nArray = new int[((SortableNode)defaultMutableTreeNode2).getChildCount()];
                for (int i = 0; i < ((SortableNode)defaultMutableTreeNode2).getChildCount(); ++i) {
                    nArray[i] = i;
                }
                defaultTreeModel.nodeStructureChanged((SortableNode)defaultMutableTreeNode2);
            } else {
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultTreeModel.getChildCount(defaultMutableTreeNode2));
            }
        }
    }
}

