/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.dataload;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.dbtools.migration.cloud.core.utils.RunSQLcl;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;

public final class DwcsSQLQueryExecution {
    private static final boolean DEBUG = false;
    private static Logger dwcsSQLQueryExecutionLogger = Logger.getLogger(DwcsSQLQueryExecution.class.getName());

    private DwcsSQLQueryExecution() {
        throw new UnsupportedOperationException("Error");
    }

    public static void dropOCACredential(RunSQLcl runSQLcl, String string) throws SQLException, SQLCLException {
        String string2 = "execute DBMS_CLOUD.drop_credential(credential_name => '<DWCS_CRED>')".replace("<DWCS_CRED>", string);
        runSQLcl.runSQLScript(string2);
    }

    public static void createOCACredential(RunSQLcl runSQLcl, String string, String string2, String string3) throws SQLException, SQLCLException {
        String string4 = "execute DBMS_CLOUD.create_credential(credential_name => '<DWCS_CRED>', username => '<aws_access_key>', password => '<aws_secret_key>')".replace("<DWCS_CRED>", string).replaceAll("<aws_access_key>", string2).replaceAll("<aws_secret_key>", string3);
        runSQLcl.runSQLScript(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet executeSQLQuery(String string, Connection connection) throws SQLException {
        DwcsSQLQueryExecution.traceFlow("Start executeSQLQuery ... query=" + string);
        ResultSet resultSet = null;
        try (Statement statement = null;){
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
        }
        DwcsSQLQueryExecution.traceFlow("end executeSQLQuery ...");
        return resultSet;
    }

    public static void executeSQL(String string, Connection connection) throws SQLException {
        DwcsSQLQueryExecution.traceFlow("Start executeSQL ... query=" + string);
        try (Statement statement = null;){
            statement = connection.createStatement();
            statement.execute(string);
        }
        DwcsSQLQueryExecution.traceFlow("end executeSQLQuery ...");
    }

    public static void executeUpdateSQL(String string, Connection connection) throws SQLException {
        DwcsSQLQueryExecution.traceFlow("Start executeSQL ... query=" + string);
        try (Statement statement = null;){
            statement = connection.createStatement();
            statement.executeUpdate(string);
        }
        DwcsSQLQueryExecution.traceFlow("end executeSQLQuery ...");
    }

    private static void traceFlow(String string) {
    }
}

