/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.report.redshift;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftMigrationUIDataInput;
import oracle.dbtools.migration.cloud.core.utils.MigrationConstants;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdeveloper.db.ConnectionException;

public class RedshiftDataMigrationReport {
    private static final boolean DEBUG = false;
    private Logger migrationGenerateLogger = Logger.getLogger(RedshiftDataMigrationReport.class.getName());
    String[] m_newDeployableSchemas = null;
    private LinkedHashMap<String, Integer> m_operationID = new LinkedHashMap();
    private RedshiftMigrationUIDataInput m_redshiftUIData = null;
    private List<String> m_keysTableNames = new ArrayList<String>();
    private HashMap<String, String> m_statusDataLoadTables = new HashMap();
    private HashMap<String, String> m_statusFailedCancelledDataload = new HashMap();
    private HashMap<String, String> m_statusSuccessDataload = new HashMap();

    public RedshiftDataMigrationReport(RedshiftMigrationUIDataInput redshiftMigrationUIDataInput, List<String> list, HashMap<String, String> hashMap) {
        this.m_redshiftUIData = redshiftMigrationUIDataInput;
        this.m_keysTableNames = list;
        this.m_newDeployableSchemas = this.m_redshiftUIData.getSourceUpdatedDeployableSchemas();
        this.m_statusDataLoadTables = hashMap;
    }

    public void generateMigrationDataReport() throws SQLException, IOException {
        this.collectSuccessAndFailureTableNames();
        this.executeDataReport();
    }

    public void executeDataReport() throws SQLException, IOException {
        ResultSet resultSet = null;
        Connection connection = null;
        PrintWriter printWriter = null;
        try {
            Instant instant = Instant.now();
            printWriter = new PrintWriter(new FileWriter(this.getFileDirectory() + File.separator + "redshift_migration_report" + instant.toString().replace(":", "-") + ".txt"));
            printWriter.write(Utilities.nls("MIGRATION_REPORT_HEADER"));
            printWriter.write(MigrationUtilities.getLineSeparator());
            printWriter.write("______________________________________________________________");
            printWriter.write(MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
            if (this.m_redshiftUIData.isUseDBMSSchedulerChecked().booleanValue()) {
                if (this.m_statusSuccessDataload.size() == 0) {
                    printWriter.write(Utilities.nls("MIGRATION_REPORT_NO_JOBS") + MigrationUtilities.getLineSeparator());
                } else {
                    printWriter.write(Utilities.nls("MIGRATION_REPORT_JOB_SCHEDULER_DESC") + MigrationUtilities.getLineSeparator());
                    String[] stringArray = new String[]{"", ""};
                    for (Map.Entry<String, String> entry : this.m_statusSuccessDataload.entrySet()) {
                        String string = entry.getKey();
                        String string2 = "";
                        printWriter.write("SCHEMA_NAME.TABLE_NAME : " + string + MigrationUtilities.getLineSeparator());
                        stringArray = this.getSchemaAndTableName(string);
                        string2 = stringArray[0].substring(0, Math.min(stringArray[0].length(), 49)) + "_" + stringArray[1].substring(0, Math.min(stringArray[1].length(), 49));
                        printWriter.write("SCHEDULED JOB NAME : " + string2 + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
                    }
                }
                printWriter.write("______________________________________________________________");
                return;
            }
            if (this.m_statusFailedCancelledDataload.size() > 0) {
                printWriter.write(Utilities.nls("MIGRATION_REPORT_FAILED_OR_CANCELLED") + MigrationUtilities.getLineSeparator());
            }
            for (Map.Entry<String, String> entry : this.m_statusFailedCancelledDataload.entrySet()) {
                String string = entry.getKey();
                String string3 = entry.getValue();
                printWriter.write("SCHEMA_NAME.TABLE_NAME : " + string + MigrationUtilities.getLineSeparator());
                printWriter.write("STATUS : " + string3 + MigrationUtilities.getLineSeparator());
            }
            printWriter.write("______________________________________________________________" + MigrationUtilities.getLineSeparator());
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            if (Connections.getInstance().lock(connection)) {
                resultSet = DBUtil.getInstance((Connection)connection).executeOracleQuery(MigrationConstants.generateReportFromMD_REPORT, null);
                if (resultSet == null || !resultSet.isBeforeFirst()) {
                    printWriter.write(Utilities.nls("MIGRATION_REPORT_NO_ROWS"));
                    return;
                }
                while (resultSet.next()) {
                    printWriter.write("OPERATION ID      : " + resultSet.getInt(1) + MigrationUtilities.getLineSeparator() + "LOGFILE TABLE     : " + resultSet.getString(2) + MigrationUtilities.getLineSeparator() + "BADFILE TABLE     : " + resultSet.getString(3) + MigrationUtilities.getLineSeparator() + "SOURCE SCHEMA     : " + resultSet.getString(4) + MigrationUtilities.getLineSeparator() + "TARGET SCHEMA     : " + resultSet.getString(7) + MigrationUtilities.getLineSeparator() + "SOURCE TABLE      : " + resultSet.getString(5) + MigrationUtilities.getLineSeparator() + "TARGET TABLE      : " + resultSet.getString(8) + MigrationUtilities.getLineSeparator() + "SOURCE TABLE ROWS : " + Math.round(resultSet.getDouble(6)) + MigrationUtilities.getLineSeparator() + "TABLE ROWS LOADED : " + Math.round(resultSet.getDouble(9)) + MigrationUtilities.getLineSeparator() + "ERROR MESSAGE     : " + resultSet.getString(10) + MigrationUtilities.getLineSeparator() + "STATUS            : " + resultSet.getString(11) + MigrationUtilities.getLineSeparator() + "START TIME        : " + resultSet.getTimestamp(12) + MigrationUtilities.getLineSeparator() + "END TIME          : " + resultSet.getTimestamp(13) + MigrationUtilities.getLineSeparator());
                    printWriter.write("______________________________________________________________");
                    printWriter.write(MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
                }
            }
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                resultSet.close();
            }
            throw sQLException;
        }
        catch (ConnectionException connectionException) {
            if (resultSet != null) {
                resultSet.close();
            }
            throw new SQLException(connectionException.getLocalizedMessage());
        }
        finally {
            printWriter.close();
            DBUtil.closeResultSet((ResultSet)resultSet);
            if (connection != null && !connection.isClosed()) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDataReportForAllOperationIDs() throws SQLException, IOException {
        String[] stringArray = new String[]{"", ""};
        try (PrintWriter printWriter = null;){
            Instant instant = Instant.now();
            printWriter = new PrintWriter(new FileWriter(this.getFileDirectory() + File.separator + "redshift_migration_report" + instant.toString().replace(":", "-") + ".txt"));
            String string = "-- This is a generated Redshift Migration Report file 'redshift_migration_report' " + System.getProperty("line.separator");
            printWriter.write(string);
            printWriter.write(MigrationUtilities.getLineSeparator());
            printWriter.write("______________________________________________________________");
            printWriter.write(MigrationUtilities.getLineSeparator());
            for (int i = 0; i < this.m_keysTableNames.size(); ++i) {
                stringArray = this.getSchemaAndTableName(this.m_keysTableNames.get(i));
                this.executeDataReportForOperationID(stringArray[0], stringArray[1], printWriter);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeDataReportForOperationID(String string, String string2, PrintWriter printWriter) throws SQLException, IOException {
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            if (Connections.getInstance().lock(connection)) {
                resultSet = DBUtil.getInstance((Connection)connection).executeOracleQuery("SELECT id, sid, owner_name, table_name, rows_loaded, logfile_table, badfile_table, status FROM DBA_LOAD_OPERATIONS WHERE id = ( select operation_id from sqldev_migrepos.MD_REPORT where TARGET_SCHEMA_NAME= '<schemaname>' and TARGET_TABLE_NAME = '<tablename>') ".replace("<schemaname>", string).replace("<tablename>", string2), null);
                while (resultSet.next()) {
                    printWriter.write("ID\t      : " + resultSet.getInt(1) + MigrationUtilities.getLineSeparator() + "SID           : " + resultSet.getInt(2) + MigrationUtilities.getLineSeparator() + "OWNER_NAME    : " + resultSet.getString(3) + MigrationUtilities.getLineSeparator() + "TABLE_NAME    : " + resultSet.getString(4) + MigrationUtilities.getLineSeparator() + "ROWS_LOADED   : " + resultSet.getString(5) + MigrationUtilities.getLineSeparator() + "LOGFILE_TABLE : " + resultSet.getString(6) + MigrationUtilities.getLineSeparator() + "BADFILE_TABLE : " + resultSet.getString(7) + MigrationUtilities.getLineSeparator() + "STATUS        : " + resultSet.getString(8) + MigrationUtilities.getLineSeparator());
                    printWriter.write("______________________________________________________________");
                    printWriter.write(MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                if (resultSet == null) throw sQLException;
                resultSet.close();
                throw sQLException;
                catch (ConnectionException connectionException) {
                    if (resultSet == null) throw new SQLException(connectionException.getLocalizedMessage());
                    resultSet.close();
                    throw new SQLException(connectionException.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                if (connection == null) throw throwable;
                if (connection.isClosed()) throw throwable;
                Connections.getInstance().unlock(connection);
                connection.close();
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        if (connection == null) return;
        if (connection.isClosed()) return;
        Connections.getInstance().unlock(connection);
        connection.close();
    }

    private void traceFlow(String string) {
    }

    private String getFileDirectory() {
        if (this.m_redshiftUIData.getSqlScriptDirectory() == null || "".equals(this.m_redshiftUIData.getSqlScriptDirectory())) {
            if (MigrationUtilities.isPlatormMacOS()) {
                return "/tmp";
            }
            return System.getProperty("java.io.tmpdir");
        }
        return this.m_redshiftUIData.getSqlScriptDirectory();
    }

    public String[] getSchemaAndTableName(String string) {
        String[] stringArray = new String[]{"", ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\.");
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "\\ ");
        stringArray[0] = stringTokenizer2.nextToken().toUpperCase();
        stringArray[1] = stringTokenizer.nextToken().toUpperCase();
        return stringArray;
    }

    private String getSchemasSelectedScripts(String[] stringArray) {
        String string = Utilities.convertToQuotedCommaSeparatedString(stringArray);
        String string2 = "SELECT schema_name FROM sqldev_migrepos.MD_GENERATE WHERE OBJECT_TYPE= 'SCHEMA' and schema_name in (<deployable_schemas>)".replace("<deployable_schemas>", string);
        return string2;
    }

    private void collectSuccessAndFailureTableNames() {
        for (Map.Entry<String, String> entry : this.m_statusDataLoadTables.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2.equals(Utilities.nls("DATALOAD_SUCCESSS"))) {
                this.m_statusSuccessDataload.put(string, string2);
                continue;
            }
            this.m_statusFailedCancelledDataload.put(string, string2);
        }
    }
}

