/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.backendDelegation;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftDDLAndDataMigration;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftDDLMigration;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftDataMigration;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftMigrationUIDataInput;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;
import oracle.dbtools.migration.cloud.core.utils.log.CoreLogger;
import oracle.dbtools.migration.cloud.ui.log.LogManager;
import oracle.dbtools.migration.cloud.ui.preferences.CloudMigrationOptions;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.javatools.db.DBException;

public class BackendDelegatorRaptorTask
extends RaptorTask<Boolean> {
    private static final boolean DEBUG = false;
    private String redShiftDatabase = null;
    private String redShiftDatabaseDisplayName = null;
    private String targetDatabase = null;
    private String targetDatabaseDisplayName = null;
    private String s3Bucket = null;
    private String awsAccessKey = null;
    private String awsSecureAccessPassword = null;
    private String[] selectedSchemas = null;
    private String[] availableSchemas = null;
    private String[] previouslyDeployedSchemas = null;
    private String[] newDeployableSchemas = null;
    private String migrationType = null;
    private int stepsCompleted = -1;
    private Boolean migrationNow = false;
    private String scriptsInDirectory = null;
    private static LogManager logManager;
    private static CoreLogger coreLogger;
    HashMap<String, Object> prefHashmap = null;
    private String migrationRepositoryPassword = null;
    private Boolean isDropMigrationRepository = false;
    private Boolean cancelInvoked = false;
    private Boolean completed = false;
    private Logger backendDelegatorRaptorTaskLogger = Logger.getLogger(BackendDelegatorRaptorTask.class.getName());
    private long migrationStartTime;
    private long migrationEndTime;

    public BackendDelegatorRaptorTask(String string) {
        super(string);
        coreLogger = CoreLogger.getInstance();
        coreLogger.setSqlScriptDirectory(CloudMigrationOptions.getPrefenceOutputDirectory());
        logManager = LogManager.getInstance();
        logManager.setDirectory(coreLogger.getSqlScriptDirectory());
        LogManager.resetLineNumber();
        this.setCancellable(true);
    }

    public BackendDelegatorRaptorTask(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String[] stringArray2, String string7, Boolean bl, String string8, HashMap<String, Object> hashMap, String string9, String string10, Boolean bl2, String string11, String[] stringArray3, String[] stringArray4) {
        super(string, true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this.setRedshiftDatabase(string2);
        this.setRedshiftDatabaseDisplayName(string9);
        this.setTargetDatabase(string3);
        this.setTargetDatabaseDisplayName(string10);
        this.setS3Bucket(string6);
        this.setAWSSecureAccess(string5);
        this.setAWSAccessKey(string4);
        this.setSelectedSchemas(stringArray);
        this.setPreviouslyDeployedSchemas(stringArray3);
        this.setNewDeployableSchemas(stringArray4);
        this.setAvailableSchemas(stringArray2);
        this.setMigrationType(string7);
        this.setMigrationNow(bl);
        this.setScriptsInDirectory(string8);
        this.setStepsCompleted(0);
        if (hashMap == null) {
            this.backendDelegatorRaptorTaskLogger.info("preferenceHashmap == null");
        }
        this.prefHashmap = hashMap;
        this.setMigrationRepositoryPassword(string11);
        this.setIsDropMigrationRepository(bl2);
        coreLogger = CoreLogger.getInstance();
        coreLogger.setSqlScriptDirectory(this.getScriptsInDirectory());
        logManager = LogManager.getInstance();
        logManager.setDirectory(coreLogger.getSqlScriptDirectory());
        LogManager.resetLineNumber();
        this.setCancellable(true);
    }

    protected Boolean doWork() throws TaskException {
        this.backendDelegatorRaptorTaskLogger.info("BackendDelegatorRaptorTask.doWork....start.");
        Boolean bl = false;
        if (this.getMigrationNow().booleanValue() && this.getScriptsInDirectory() == null) {
            try {
                bl = this.migrateNow();
            }
            catch (IOException iOException) {
                logManager.logStringWithComments("IO Exception happened.", iOException);
                throw new TaskException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (!this.getMigrationNow().booleanValue() && this.getScriptsInDirectory() != null) {
            try {
                bl = this.migrateScripts(this.getScriptsInDirectory());
            }
            catch (IOException iOException) {
                logManager.logStringWithComments("IO Exception happened.", iOException);
                throw new TaskException(iOException.getMessage(), iOException.getCause());
            }
        }
        if (this.getMigrationNow().booleanValue() && this.getScriptsInDirectory() != null) {
            try {
                bl = this.migrateNowAndDumpScripts(this.getScriptsInDirectory());
            }
            catch (IOException iOException) {
                logManager.logStringWithComments("IO Exception happened.", iOException);
            }
        }
        this.backendDelegatorRaptorTaskLogger.info("BackendDelegatorRaptorTask.doWork....end.");
        return bl;
    }

    public boolean cancel() {
        this.setCancelInvoked(true);
        this.getDescriptor().setCancelled(true);
        return true;
    }

    private void setRedshiftDatabaseDisplayName(String string) {
        this.redShiftDatabaseDisplayName = string;
    }

    public String getRedShiftDatabaseDisplayName() {
        return this.redShiftDatabaseDisplayName;
    }

    public void setRedshiftDatabase(String string) {
        this.redShiftDatabase = string;
    }

    public String getRedShiftDatabase() {
        return this.redShiftDatabase;
    }

    private void setTargetDatabaseDisplayName(String string) {
        this.targetDatabaseDisplayName = string;
    }

    public String getTargetDatabaseDisplayName() {
        return this.targetDatabaseDisplayName;
    }

    public void setTargetDatabase(String string) {
        this.targetDatabase = string;
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setS3Bucket(String string) {
        this.s3Bucket = string;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public void setAWSSecureAccess(String string) {
        this.awsSecureAccessPassword = string;
    }

    public String getAWSSecureAccess() {
        return this.awsSecureAccessPassword;
    }

    public void setAWSAccessKey(String string) {
        this.awsAccessKey = string;
    }

    public String getAWSAccessKey() {
        return this.awsAccessKey;
    }

    public void setSelectedSchemas(String[] stringArray) {
        this.selectedSchemas = stringArray;
    }

    public String[] getSelectedSchemas() {
        return this.selectedSchemas;
    }

    public void setAvailableSchemas(String[] stringArray) {
        this.availableSchemas = stringArray;
    }

    public String[] getAvailableSchemas() {
        return this.availableSchemas;
    }

    public void setPreviouslyDeployedSchemas(String[] stringArray) {
        this.previouslyDeployedSchemas = stringArray;
    }

    public String[] getPreviouslyDeployedSchemas() {
        return this.previouslyDeployedSchemas;
    }

    public void setNewDeployableSchemas(String[] stringArray) {
        this.newDeployableSchemas = stringArray;
    }

    public String[] getNewDeployableSchemas() {
        return this.newDeployableSchemas;
    }

    public void setMigrationType(String string) {
        this.migrationType = string;
    }

    public String getMigrationType() {
        return this.migrationType;
    }

    public int getStepsCompleted() {
        return this.stepsCompleted;
    }

    public void setStepsCompleted(int n) {
        this.stepsCompleted = n;
    }

    private Boolean getMigrationNow() {
        return this.migrationNow;
    }

    private void setMigrationNow(Boolean bl) {
        this.migrationNow = bl;
    }

    private String getScriptsInDirectory() {
        return this.scriptsInDirectory;
    }

    private void setScriptsInDirectory(String string) {
        this.scriptsInDirectory = string;
    }

    private void consoleOutputRedshiftData() {
        System.out.println(this.getSetupParametersAsString());
    }

    private void loggerOutputRedshiftData() {
        this.backendDelegatorRaptorTaskLogger.info(this.getSetupParametersAsString());
    }

    private String getSetupParametersAsString() {
        String string = "";
        string = string + this.stringln("========================================================");
        string = string + this.stringln("BackendDelegatorWorker.doMigrationWork.....Test Redshift input data ...");
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getRedShiftDatabase() = " + this.getRedShiftDatabase());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getTargetDatabase() = " + this.getTargetDatabase());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getMigrationType() = " + this.getMigrationType());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getAWSAccessKey() = " + this.getAWSAccessKey());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getAWSSecureAccess() = " + this.getAWSSecureAccess());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getS3Bucket() = " + this.getS3Bucket());
        if (this.getAvailableSchemas() != null && this.getAvailableSchemas().length > 0) {
            for (String string2 : this.getAvailableSchemas()) {
                string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.available_schema = " + string2);
            }
        } else {
            string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.available_schemas = NO AVAILABLE DATABASES.");
        }
        if (this.getSelectedSchemas() != null && this.getSelectedSchemas().length > 0) {
            for (String string2 : this.getSelectedSchemas()) {
                string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.selected_schema = " + string2);
            }
        } else {
            string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.selected_schemas = NO SELECTED DATABASES.");
        }
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getMigrationNow() = " + this.getMigrationNow());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getScriptsInDirectory() = " + this.getScriptsInDirectory());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getMigrationRepositoryPassword() = " + this.getMigrationRepositoryPassword());
        string = string + this.stringln("BackendDelegatorWorker.consoleOutputRedshiftData.getIsDropMigrationRepository() = " + this.getIsDropMigrationRepository());
        string = string + this.stringln("========================================================");
        return string;
    }

    private String stringln(String string) {
        return string + "\n";
    }

    public void updateProgressMonitor(int n, int n2, String string, String string2, long l) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = 0;
        int n4 = 100;
        double d = (double)n / (double)n2 * (double)(n4 - n3);
        this.setStepsCompleted((int)d);
        this.getDescriptor().setProgress(this.getStepsCompleted());
        this.setMessage(Utilities.nls("TASK_OF_TASKS_COMPLETED") + "[" + n + "/" + n2 + "]: " + string);
        logManager.logStringWithComments(Utilities.nls("TASK") + "[" + n + "/" + n2 + "]: " + string2, " [" + this.convertMilliToSecs(l) + " ]");
    }

    private Boolean migrateNow() throws TaskException, IOException {
        String string = "BackendDelegatorRaptorTask.migrateNow.RUN ..." + Thread.currentThread().getId();
        String string2 = "BackendDelegatorRaptorTask.migrateNow.RUN ...Over.";
        this.traceFlow(string);
        this.backendDelegatorRaptorTaskLogger.info(string);
        Boolean bl = this.startMigration();
        this.backendDelegatorRaptorTaskLogger.info(string2);
        this.traceFlow(string2);
        return bl;
    }

    public void traceFlow(String string) {
    }

    private Boolean migrateNowAndDumpScripts(String string) throws TaskException, IOException {
        return this.startMigration();
    }

    private Boolean migrateScripts(String string) throws TaskException, IOException {
        return this.startMigration();
    }

    private Boolean startMigration() throws TaskException, IOException {
        this.logPreMigrationData();
        RedshiftMigrationUIDataInput redshiftMigrationUIDataInput = new RedshiftMigrationUIDataInput();
        redshiftMigrationUIDataInput.setUserPreferences(this.prefHashmap);
        try {
            redshiftMigrationUIDataInput.setSourceConnectionString(this.getRedShiftDatabase());
            redshiftMigrationUIDataInput.setSourceSelectedSchemas(this.getSelectedSchemas());
            redshiftMigrationUIDataInput.setSourcePreviousSchemas(this.getPreviouslyDeployedSchemas());
            redshiftMigrationUIDataInput.setSourceUpdatedDeployableSchemas(this.getNewDeployableSchemas());
            redshiftMigrationUIDataInput.setMigrationType(this.getMigrationType());
            redshiftMigrationUIDataInput.setAwsAccessKey(this.getAWSAccessKey());
            redshiftMigrationUIDataInput.setAwsSecretAccess(this.getAWSSecureAccess());
            redshiftMigrationUIDataInput.setAwsS3BucketHTTPSLocation(this.getS3Bucket());
            redshiftMigrationUIDataInput.setSqlScriptDirectory(coreLogger.getSqlScriptDirectory());
            redshiftMigrationUIDataInput.setStartDeployment(this.getMigrationNow());
            redshiftMigrationUIDataInput.setMigrationRepositoryPassword(this.getMigrationRepositoryPassword());
            redshiftMigrationUIDataInput.setDropMigrationRepository(this.getIsDropMigrationRepository());
            redshiftMigrationUIDataInput.setTargetConnectionString(this.getTargetDatabase());
            if (this.getMigrationType().equals(Utilities.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_DDL_DATA"))) {
                this.traceFlow("Starting DDL_AND_DATA");
                RedshiftDDLAndDataMigration redshiftDDLAndDataMigration = new RedshiftDDLAndDataMigration(redshiftMigrationUIDataInput);
                this.completed = redshiftDDLAndDataMigration.startRedshiftMigration(this);
                this.traceFlow("Ending DDL_AND_DATA");
            } else if (this.getMigrationType().equals(Utilities.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_ONLY_DDL"))) {
                RedshiftDDLMigration redshiftDDLMigration = new RedshiftDDLMigration(redshiftMigrationUIDataInput);
                this.completed = redshiftDDLMigration.startRedshiftMigration(this);
            } else if (this.getMigrationType().equals(Utilities.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_ONLY_DATA"))) {
                RedshiftDataMigration redshiftDataMigration = new RedshiftDataMigration(redshiftMigrationUIDataInput);
                this.completed = redshiftDataMigration.startRedshiftMigration(this);
            }
        }
        catch (DBException dBException) {
            this.backendDelegatorRaptorTaskLogger.severe("[startMigration]d be.exception=" + dBException.getMessage());
            this.completed = false;
            logManager.logStringWithComments("DB Exception happened.", (Exception)((Object)dBException));
            throw new TaskException(dBException.getMessage(), dBException.getCause());
        }
        catch (SQLException sQLException) {
            this.backendDelegatorRaptorTaskLogger.severe("[startMigration] sql exception=" + sQLException.getMessage());
            this.completed = false;
            logManager.logStringWithComments("SQL Exception happened.", sQLException);
            throw new TaskException(sQLException.getMessage(), sQLException.getCause());
        }
        catch (SQLCLException sQLCLException) {
            this.backendDelegatorRaptorTaskLogger.severe("[startMigration] sqlcl exception=" + sQLCLException.getMessage());
            this.completed = false;
            logManager.logStringWithComments("SQLCL Exception happened.", sQLCLException);
            throw new TaskException(sQLCLException.getMessage(), sQLCLException.getCause());
        }
        catch (IOException iOException) {
            this.backendDelegatorRaptorTaskLogger.severe("[startMigration] io.exception=" + iOException.getMessage());
            this.completed = false;
            logManager.logStringWithComments("IO Exception happened.", iOException);
            throw new TaskException(iOException.getMessage(), iOException.getCause());
        }
        catch (Exception exception) {
            this.backendDelegatorRaptorTaskLogger.severe("[startMigration] e.exception=" + exception.getMessage());
            this.completed = false;
            logManager.logStringWithComments("Exception happened.", exception);
            throw new TaskException(exception.getMessage(), exception.getCause());
        }
        finally {
            this.logPostMigrationData();
            logManager.close();
        }
        return this.completed;
    }

    private void logPreMigrationData() throws IOException {
        this.setMigrationTimeTicker(true);
        logManager.createNewLogFile();
        logManager.logHeader(this.nls("UILOGGER_REDSHIFT_ADWC_MIGRATION"));
        logManager.logNowTime(this.nls("UILOGGER_STARTED_AT"));
        logManager.logDoubleDashLine(80);
        logManager.logStringWithComments(this.nls("UILOGGER_PRE_AWS_MIGRATION"));
        logManager.logSingleDashLine(80);
        logManager.logStringWithComments(this.nls("UILOGGER_AWS_REDSHIFT"), this.getRedShiftDatabaseDisplayName());
        logManager.logStringWithComments(this.nls("UILOGGER_TARGET"), this.getTargetDatabaseDisplayName());
        logManager.logStringsWithCommentsWrapped(this.nls("UILOGGER_AVALIABLE_SCHEMAS"), this.getAvailableSchemas());
        logManager.logStringsWithCommentsWrapped(this.nls("UILOGGER_PREVIOUSLY_DEPLOYED_SCHEMAS"), this.getPreviouslyDeployedSchemas());
        logManager.logStringsWithCommentsWrapped(this.nls("UILOGGER_NEW_DEPLOYABLE_SCHEMAS"), this.getNewDeployableSchemas());
        logManager.logStringsWithCommentsWrapped(this.nls("UILOGGER_SELECTED_SCHEMAS"), this.getSelectedSchemas());
        logManager.logStringWithComments(this.nls("UILOGGER_MIGRATION_TYPE"), this.getMigrationType());
        logManager.logStringWithComments(this.nls("UILOGGER_MIGRATION_NOW"), this.getMigrationNow().toString());
        if (this.getScriptsInDirectory() == null || this.getScriptsInDirectory().length() == 0) {
            logManager.logStringWithComments(this.nls("UILOGGER_UNLOAD_SCRIPTS_DIR"), this.nls("UILOGGER_UNLOAD_DIR_NOT_SELECTED"));
        } else {
            logManager.logStringWithComments(this.nls("UILOGGER_UNLOAD_SCRIPTS_DIR"), this.getScriptsInDirectory());
        }
        logManager.logStringWithComments(this.nls("UILOGGER_MIGRATION_DIR_IN_PREFERENCE"), this.getPreferencesMigrationDirectory());
        logManager.logStringWithComments(this.nls("UILOGGER_DROP_MIGRATION_REPOSITORY"), this.getIsDropMigrationRepository().toString());
        logManager.logStringWithComments(this.nls("UILOGGER_MIGRATION_REPOSITORY_PASSWORD"), "****************");
        logManager.logStringWithComments(this.nls("UILOGGER_USE_MAX_THREAD_NUMBER"), this.getPreferencesUseMaxThreads().toString());
        logManager.logStringWithComments(this.nls("UILOGGER_USE_DBMS_SCHEDULER"), this.getPreferencesUseDBMSScheduler().toString());
        if (this.getPreferencesUseDBMSScheduler().booleanValue()) {
            logManager.logStringWithComments(this.nls("UILOGGER_DATE_TO_DEPLOY_TYPE"), this.getPreferencesDateToDeployType());
            String string = this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_ONCE");
            if (this.getPreferencesDateToDeployType().equals(string)) {
                logManager.logStringWithComments(this.nls("UILOGGER_FORMATTED_DATE_TO_DEPLOY"), this.getPreferencesFormattedDateToDeployType());
            }
        }
        logManager.logEmptyLine();
        this.logARSPreferences();
        this.logCPDPreferences();
        logManager.logSingleDashLine(80);
        logManager.logEmptyLine();
    }

    private void logPostMigrationData() {
        this.traceFlow("logPostMigrationData .....");
        if (this.completed.booleanValue()) {
            this.setMigrationTimeTicker(false);
            logManager.logDoubleDashLine(80);
            logManager.logStringWithComments(this.nls("UILOGGER_TOTAL_TIME_TO_MIGRATE"), this.getTotalMigrationTimeInSecs());
            logManager.logDoubleDashLine(80);
        } else {
            this.setMigrationTimeTicker(false);
            logManager.logDoubleDashLine(80);
            logManager.logStringWithComments(this.nls("UILOGGER_MIGRATE_FAILURE"));
            logManager.logDoubleDashLine(80);
        }
    }

    private void logMigrationProcessHeader() {
        logManager.logDoubleDashLine(80);
        logManager.logNowTime(this.nls("UILOGGER_MIGRATION_TASK_REPORT"));
        logManager.logDoubleDashLine(80);
    }

    public String convertMilliToSecs(long l) {
        return l / 1000L + " secs";
    }

    public String convertMilliToHoursMinSecs(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 3600L;
        long l4 = l2 - l3 * 3600L;
        long l5 = l4 / 60L;
        long l6 = l4 - l5 * 60L;
        return l3 + ":" + l5 + ":" + l6;
    }

    private void setMigrationTimeTicker(boolean bl) {
        if (bl) {
            this.migrationStartTime = System.currentTimeMillis();
        } else {
            this.migrationEndTime = System.currentTimeMillis();
        }
    }

    private String getTotalMigrationTimeInSecs() {
        return this.convertMilliToHoursMinSecs(this.migrationEndTime - this.migrationStartTime);
    }

    private void logARSPreferences() {
        logManager.logSingleDashLine(80);
        logManager.logStringWithComments(this.nls("UILOGGER_REDSHIFT_SETTINGS"));
        logManager.logSingleDashLine(80);
        logManager.logStringWithComments(this.decorateRedshitPrefix(this.nls("UILOGGER_REDSHIFT_ALLOWOVERWRITE")), String.valueOf(this.getPreferencesARSOverWrite()));
        logManager.logSingleDashLine(80);
        logManager.logEmptyLine();
    }

    public String decorateRedshitPrefix(String string) {
        return "Redshift [" + string + "]";
    }

    private Boolean getPreferencesARSOverWrite() {
        return (Boolean)this.prefHashmap.get("ARS.OVERWRITE");
    }

    private void logCPDPreferences() {
        logManager.logSingleDashLine(80);
        logManager.logStringWithComments(this.nls("UILOGGER_ADWC_COPYDATA_PREFERENCE"));
        logManager.logSingleDashLine(80);
        logManager.logStringWithComments(this.decorateADWCopyDataPrefix(this.nls("UILOGGER_ADWC_PREFERENCE_REJECT_LIMIT")), this.getPreferencesCPDRejlim().toString());
        logManager.logSingleDashLine(80);
        logManager.logEmptyLine();
    }

    public String decorateADWCopyDataPrefix(String string) {
        return "ADWC CopyData [" + string + "]";
    }

    private Integer getPreferencesCPDRejlim() {
        return (Integer)this.prefHashmap.get("CPD.REJLIM");
    }

    private String getPreferencesMigrationDirectory() {
        return (String)this.prefHashmap.get("REDSHIFT_MIGRATION_DIR");
    }

    private Integer getPreferencesUseMaxThreads() {
        return (Integer)this.prefHashmap.get("MAX_NUMBER_THREADS");
    }

    private Boolean getPreferencesUseDBMSScheduler() {
        return (Boolean)this.prefHashmap.get("USE_DBMS_SCHEDULER");
    }

    private String getPreferencesDateToDeployType() {
        return (String)this.prefHashmap.get("DATE_TO_DEPLOY_TYPE");
    }

    private long getPreferencesDateToDeploy() {
        return (Long)this.prefHashmap.get("DATE_TO_DEPLOY");
    }

    private String getPreferencesDateToDeployTimeZone() {
        return (String)this.prefHashmap.get("DATE_TO_DEPLOY_TIME_ZONE");
    }

    private String getPreferencesFormattedDateToDeployType() {
        return (String)this.prefHashmap.get("FORMATTED_DATE_TO_DEPLOY");
    }

    public String getMigrationRepositoryPassword() {
        return this.migrationRepositoryPassword;
    }

    public void setMigrationRepositoryPassword(String string) {
        this.migrationRepositoryPassword = string;
    }

    public Boolean getIsDropMigrationRepository() {
        return this.isDropMigrationRepository;
    }

    public void setIsDropMigrationRepository(Boolean bl) {
        this.isDropMigrationRepository = bl;
    }

    public Boolean getCancelInvoked() {
        return this.cancelInvoked;
    }

    public void setCancelInvoked(Boolean bl) {
        this.cancelInvoked = bl;
    }

    protected void tearDown() {
        this.traceFlow("[BackendDelegatorRaptorTask] teardown ... goes here.");
    }

    public void checkCanProceed() throws ExecutionException {
        super.checkCanProceed();
        this.traceFlow("checkCanProceed called... , time=" + System.currentTimeMillis() + ", isAlive=" + this.getDescriptor().getStatus().isAlive() + ", status=" + this.getDescriptor().getStatus());
    }

    public static LogManager getLogManager() {
        return logManager;
    }

    public static void setLogManager(LogManager logManager) {
        BackendDelegatorRaptorTask.logManager = logManager;
    }

    protected String nls(String string) {
        return CloudMigrationsResources.get(string);
    }
}

