/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.log;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class LogManager {
    public static String LOG_DIRECTORY_PATH = null;
    public static final String MIGRATION_REPOSITORY_LOGFILE_NAME = "MigrationResults.log";
    private static final boolean DEBUG = false;
    private static int lineNumber = 0;
    private Logger logger = Logger.getLogger(LogManager.class.getName());
    FileWriter writer = null;
    PrintWriter printWriter = null;
    long startTimeInMillis = 0L;
    long endTimeInMillis = 0L;
    private static int WRAP_LENGTH;
    private static int MAX_TOTAL_LINE_WIDTH;
    private static String COMMA_SEPARATOR;
    private static LogManager logManager;
    Path newFile = null;

    public static LogManager getInstance() {
        if (logManager == null) {
            logManager = new LogManager();
        }
        return logManager;
    }

    public void setDirectory(String string) {
        Path path = Paths.get(string, new String[0]);
        this.newFile = path.resolve(MIGRATION_REPOSITORY_LOGFILE_NAME);
    }

    public void createNewLogFile() throws IOException {
        Files.deleteIfExists(this.newFile);
        Files.createFile(this.newFile, new FileAttribute[0]);
        this.writer = new FileWriter(this.newFile.toFile());
        this.printWriter = new PrintWriter(this.writer);
    }

    public Path getLogFilePath() {
        return this.newFile;
    }

    private void logString(String string) {
        if (string != null && string.trim().length() > 0) {
            this.printWriter.print(string);
            this.printWriter.println();
        }
    }

    private void logStrings(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                this.printWriter.print(string + COMMA_SEPARATOR);
            }
            this.printWriter.println();
        }
    }

    public void logStringsWithComments(String string, String[] stringArray) {
        LogManager.nextLineNumber();
        if (string != null && string.trim().length() > 0) {
            string = this.formatComment(string);
            this.printWriter.print(string + " : ");
        }
        if (stringArray != null && stringArray.length == 0) {
            this.printWriter.println();
        } else {
            this.logStrings(stringArray);
        }
    }

    public void logStringsWithCommentsWrapped(String string, String[] stringArray) {
        int n;
        String string2 = "";
        if (string != null && string.trim().length() > 0) {
            string = this.formatComment(string);
            this.printWriter.print(string + " : ");
            for (n = 0; n < string.length(); ++n) {
                string2 = string2 + " ";
            }
        }
        if (stringArray.length == 0) {
            this.printWriter.println();
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (n != 0 && n % 5 == 0) {
                this.printWriter.print(string2 + " : ");
                this.printWriter.print(stringArray[n] + ", ");
                continue;
            }
            if (n % 5 == 4 || n == stringArray.length - 1) {
                this.printWriter.print(stringArray[n]);
                this.printWriter.println();
                continue;
            }
            this.printWriter.print(stringArray[n] + ", ");
        }
    }

    public void logStringWithComments(String string) {
        this.logStringWithComments(string, "");
    }

    public void logStringWithComments(String string, long l) {
        this.logStringWithComments(string, "" + l);
    }

    public void logStringWithComments(String string, String string2) {
        LogManager.nextLineNumber();
        if (string != null && string.trim().length() > 0) {
            string = this.formatComment(string);
            if (string2 == null || string2.trim().length() == 0) {
                this.printWriter.print(string);
            } else {
                this.printWriter.print(string + " : ");
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            this.printWriter.println();
        } else {
            this.logString(string2);
        }
    }

    public String getCurrentTimeString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        return string;
    }

    public void logHeader(String string) {
        this.logDoubleDashLine(MAX_TOTAL_LINE_WIDTH);
        this.logStringWithComments(string);
        this.logDoubleDashLine(MAX_TOTAL_LINE_WIDTH);
    }

    public void logNowTime(String string) {
        this.startTimeInMillis = System.currentTimeMillis();
        Date date = new Date();
        this.logDoubleDashLine(MAX_TOTAL_LINE_WIDTH);
        this.logStringWithComments(string, DateFormat.getInstance().format(date));
        this.logDoubleDashLine(MAX_TOTAL_LINE_WIDTH);
    }

    public void logFooter(String string) {
        this.endTimeInMillis = System.currentTimeMillis();
        this.logDoubleDashLine(MAX_TOTAL_LINE_WIDTH);
        this.logStringWithComments(string, this.getCurrentTimeString());
        long l = this.endTimeInMillis - this.startTimeInMillis;
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        String string2 = simpleDateFormat.format(date);
        this.logStringWithComments(string, string2);
        this.logDoubleDashLine(MAX_TOTAL_LINE_WIDTH);
    }

    public void logEmptyLine() {
        LogManager.nextLineNumber();
        this.printWriter.println();
    }

    public void logDoubleDashLine(int n) {
        LogManager.nextLineNumber();
        for (int i = 0; i < n; ++i) {
            this.printWriter.print("=");
        }
        this.printWriter.println();
    }

    public void logSingleDashLine(int n) {
        LogManager.nextLineNumber();
        for (int i = 0; i < n; ++i) {
            this.printWriter.print("-");
        }
        this.printWriter.println();
    }

    private String formatComment(String string) {
        int n = string.length();
        if (n > 80) {
            string = string.substring(0, 77) + "...";
        } else {
            int n2 = 80 - n;
            String string2 = "";
            for (int i = 0; i < n2; ++i) {
                string2 = string2 + " ";
            }
            string = string + string2;
        }
        return string;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public static void resetLineNumber() {
        lineNumber = 0;
    }

    public static int getLineNumber() {
        return lineNumber;
    }

    public static void nextLineNumber() {
        ++lineNumber;
    }

    public void printLineNumber() {
        String string = new Integer(LogManager.getLineNumber()).toString();
        if (string.length() < 4) {
            int n = 4 - string.length();
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "0";
            }
            string2 = string2 + string;
            this.printWriter.print("[" + string2 + "] ");
        } else {
            this.printWriter.print("[" + string + "] ");
        }
    }

    public void logStringWithComments(String string, Exception exception) {
        LogManager.nextLineNumber();
        this.logStringWithComments(string, exception.getMessage());
    }

    static {
        COMMA_SEPARATOR = ", ";
        logManager = null;
    }
}

