/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.format;

import javax.swing.undo.UndoableEdit;
import oracle.dbtools.format.CodeFragment;
import oracle.dbtools.format.SqlFromJava;
import oracle.dbtools.java.JavaEarley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class ExposeCommand
extends Command {
    private UndoableEdit _undoableEdit;
    private boolean toClipboard;

    public static void main(String[] stringArray) throws Exception {
        String string = "String sql = \"select DEPTNO, DNAME, LOC from DEPT\";";
        System.out.println(new ExposeCommand(null, false).extractSql(string));
    }

    public ExposeCommand(Context context, boolean bl) {
        super(-1, 0, "Expose SQL Command");
        this.toClipboard = bl;
        this.context = context;
    }

    public int doit() {
        if (this._undoableEdit == null) {
            View view = this.context.getView();
            if (view instanceof BasicEditorPaneContainer) {
                TextNode textNode = (TextNode)this.context.getNode();
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                textBuffer.beginEdit();
                CodeFragment codeFragment = new CodeFragment(this.context);
                String string = this.extractSql(codeFragment.source);
                if (!this.toClipboard) {
                    if (0 != codeFragment.selectionEnd) {
                        textBuffer.remove(codeFragment.selectionStart, codeFragment.selectionEnd - codeFragment.selectionStart);
                    } else {
                        textBuffer.removeToEnd(0);
                    }
                    textBuffer.insert(codeFragment.selectionStart, string.toCharArray());
                } else {
                    UIUtils.setClipboard((String)string);
                }
                this._undoableEdit = textBuffer.endEdit();
                textNode.releaseTextBuffer();
            }
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    private String concatStringLiterals(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (LexerToken lexerToken : LexerToken.parse((String)string)) {
            String string2;
            if (lexerToken.type != Token.DQUOTED_STRING && lexerToken.type != Token.QUOTED_STRING) continue;
            if (0 < stringBuilder.length()) {
                if (SyntaxError.checkSyntax((String)stringBuilder.toString(), (String[])new String[]{"select", "insert", "update", "delete", "merge"}) == null) {
                    stringBuilder.append(";");
                }
                stringBuilder.append("\n");
            }
            if ((string2 = lexerToken.content.substring(1, lexerToken.content.length() - 1)).endsWith("\\n")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String extractSql(String string) {
        if (!JavaEarley.recognizedJava((String)string)) {
            return this.concatStringLiterals(string);
        }
        try {
            string = new SqlFromJava().extractQuery(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.concatStringLiterals(string);
    }

    public int undo() throws Exception {
        this._undoableEdit.undo();
        return 0;
    }
}

