/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Color;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.util.Service;
import oracle.ide.ceditor.options.S2Highlight;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;

public class SuggestedItemHelper {
    public static final String prefix = "[";
    public static final String suffix = "]";
    private static String placeholderPrefix = null;
    public static String placeholderSuffix = "</FONT>";

    public Icon getIcon(String string) {
        if ("FUNCTION".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("FUNCTION");
        }
        if ("PROCEDURE".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("PROCEDURE");
        }
        if ("COLUMN".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("COLUMN");
        }
        if ("TABLE".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"table.png");
        }
        if ("VIEW".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"view.png");
        }
        if (string != null && string.indexOf("CHAR") >= 0 || "STRING".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("STRING");
        }
        if ("INTEGER".equalsIgnoreCase(string) || "NUMBER".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"field.png");
        }
        if ("DATE".equalsIgnoreCase(string) || "TIMESTAMP".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("DATE");
        }
        if ("BOOLEAN".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("BOOLEAN");
        }
        if ("USER DEFINED".equals(string) || "TYPE".equals(string) || "SUBTYPE".equals(string)) {
            return OracleIcons.getIcon((String)"domain.png");
        }
        if ("SCHEMA".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"user.png");
        }
        if ("PACKAGE".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"package.png");
        }
        if ("SNIPPET".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"library.png");
        }
        if ("SEQUENCE".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"sequence.png");
        }
        if ("HISTORY".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"history.png");
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon("SIGMA");
        }
        return null;
    }

    public String getDisplayText(SuggestedItem suggestedItem) {
        if (!SuggestedItem.isHTML) {
            return this.toString();
        }
        int n = suggestedItem.getPrefixLength();
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (!(suggestedItem.getOwner() == null || 0 >= suggestedItem.getOwner().length() || suggestedItem.getPrefixLength() != 0 && suggestedItem.getName().indexOf(46) >= 0 && suggestedItem.getName().substring(0, suggestedItem.getPrefixLength()).equalsIgnoreCase(suggestedItem.getOwner() + '.') || "COLUMN".equals(suggestedItem.getType()))) {
            stringBuilder.append("<font color=gray>" + suggestedItem.getOwner() + ".</font>");
            n -= suggestedItem.getOwner().length() + 1;
        }
        if (n > 0 && n < suggestedItem.getName().length()) {
            stringBuilder.append("<b>" + suggestedItem.getName().substring(0, n) + "</b>" + suggestedItem.getName().substring(n));
        } else {
            String string;
            block6: {
                string = suggestedItem.getName();
                try {
                    string = string.replace(prefix, SuggestedItemHelper.getPlaceholderPrefix());
                    string = string.replace(suffix, placeholderSuffix);
                }
                catch (Exception exception) {
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    if (!stackTraceElementArray[stackTraceElementArray.length - 1].toString().startsWith("java.awt.EventDispatchThread.run")) break block6;
                    System.err.println("Unexpected: " + exception.toString());
                }
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String getPlaceholderPrefix() {
        block4: {
            if (placeholderPrefix != null) {
                return placeholderPrefix;
            }
            try {
                Color color = Color.gray;
                Preferences preferences = Preferences.getPreferences();
                SyntaxColorsOptions syntaxColorsOptions = SyntaxColorsOptions.getInstance((PropertyStorage)preferences);
                for (Object e : syntaxColorsOptions.getStyleList()) {
                    S2Highlight s2Highlight;
                    if (!(e instanceof S2Highlight) || !"tab-field".equals((s2Highlight = (S2Highlight)e).getStyleName())) continue;
                    color = new Color(s2Highlight.getBackgroundRGB());
                }
                placeholderPrefix = "<FONT style=\"BACKGROUND-COLOR: #" + Integer.toHexString(color.getRGB()).substring(2) + "\">";
            }
            catch (Exception exception) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                if (!stackTraceElementArray[stackTraceElementArray.length - 1].toString().startsWith("java.awt.EventDispatchThread.run")) break block4;
                System.err.println("Unexpected: " + exception.toString());
            }
        }
        return placeholderPrefix;
    }

    public String format(String string) {
        String string2 = this.toString();
        if (!"ARGUMENT".equals(string)) {
            return string2;
        }
        CustomFormat.getInstance();
        Map map = CustomFormat.getInstance().options;
        CustomFormat.getInstance();
        ((Object)((Object)CustomFormat.getInstance())).getClass();
        if (!((Boolean)map.get("breaksProcArgs")).booleanValue()) {
            return string2;
        }
        CustomFormat.getInstance();
        Map map2 = CustomFormat.getInstance().options;
        CustomFormat.getInstance();
        ((Object)((Object)CustomFormat.getInstance())).getClass();
        String string3 = Service.padln((String)"", (int)((Integer)map2.get("identSpaces")));
        return "\n" + string3 + string2.replace(",", ",\n" + string3);
    }
}

