/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.util.Service;

public class TabColTest {
    private static int testNo = 0;
    private static boolean unitTestIsOK = true;
    static Set<RuleTuple> rules = TabColTest.tabColRules();
    static Earley earley = new Earley(rules){

        protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
            LexerToken lexerToken = list.get(n);
            return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
        }
    };
    private static int output = (Integer)TabColTest.earley.symbolIndexes.get("output");
    private static int assertion = (Integer)TabColTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)TabColTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)TabColTest.earley.symbolIndexes.get("comment");
    private static int prompt = (Integer)TabColTest.earley.symbolIndexes.get("prompt");
    private static int excludeTypes = (Integer)TabColTest.earley.symbolIndexes.get("excludeTypes");
    private static int excludeNames = (Integer)TabColTest.earley.symbolIndexes.get("excludeNames");
    private static boolean excludeVirtualColumns = false;
    private static List<String> colNamesToExclude = null;
    private static List<String> colTypesToExclude = null;

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(TabColTest.class, (String)"TabCol.test");
        List list = LexerToken.parse((String)string, (String)"#");
        Matrix matrix = new Matrix((Parser)earley);
        Visual visual = null;
        if (list.size() < 100) {
            visual = new Visual(list, (Parser)earley);
        }
        earley.parse(list, (Matriceable)matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw((Matriceable)matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        TabColTest.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        if (unitTestIsOK) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> ");
        }
    }

    private static Set<RuleTuple> tabColRules() {
        try {
            String string = Service.readFile(TabColTest.class, (String)"TabColTest.grammar");
            List list = LexerToken.parse((String)string, (boolean)false, (int)1);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for TabCol test");
        }
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            System.out.print("TEST#" + testNo++ + " -> ");
            if (TabColTest.assertion(parseNode, list, string)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (parseNode.contains(output)) {
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                System.out.println("TEST#" + testNo++ + " ->\n" + TabColTest.query(parseNode2, list, string));
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            TabColTest.comment(parseNode, list, string);
            return;
        }
        if (parseNode.contains(excludeTypes)) {
            TabColTest.exclude(parseNode, list, string, excludeTypes);
            return;
        }
        if (parseNode.contains(excludeNames)) {
            TabColTest.exclude(parseNode, list, string, excludeNames);
            return;
        }
        if (parseNode.contains(((Integer)TabColTest.earley.symbolIndexes.get("excludeVirtualColumns")).intValue())) {
            excludeVirtualColumns = true;
            return;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            TabColTest.atest(parseNode3, list, string);
        }
    }

    private static boolean assertion(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = null;
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(query)) {
                string2 = TabColTest.output(parseNode2, list, string);
                continue;
            }
            if (!parseNode2.contains(prompt)) continue;
            string3 = TabColTest.prompt(parseNode2, list, string);
        }
        if (!string2.startsWith(string3)) {
            for (int i = 0; i < string2.length() && i < string3.length(); ++i) {
                if (string2.charAt(i) == string3.charAt(i)) continue;
                int n = i + 30;
                String string4 = "...";
                if (string2.length() < n) {
                    n = string2.length();
                    string4 = "";
                }
                System.out.println(string2.substring(0, i) + " >>> " + string2.substring(i, n) + string4 + " <<<");
                break;
            }
            unitTestIsOK = false;
            return false;
        }
        return true;
    }

    private static String prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        return string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
    }

    private static String query(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = TabColTest.output(parseNode, list, string);
        return string2;
    }

    private static String output(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        String string2 = string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
        return TabCol.test(string2, colTypesToExclude, colNamesToExclude, excludeVirtualColumns);
    }

    private static String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.from + 1 == parseNode.to) {
            String string2 = list.get((int)parseNode.from).content;
            if (string2.charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        String string3 = "";
        for (ParseNode parseNode2 : parseNode.children()) {
            string3 = string3 + " " + TabColTest.sql_fragment(parseNode2, list, string);
        }
        return string3;
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end));
        return null;
    }

    private static ParseNode exclude(ParseNode parseNode, List<LexerToken> list, String string, int n) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = -1;
        for (LexerToken lexerToken : list) {
            if (parseNode.from + 2 >= ++n2 || n2 >= parseNode.to || lexerToken.type != Token.IDENTIFIER) continue;
            linkedList.add(lexerToken.content);
        }
        if (excludeNames == n) {
            colNamesToExclude = linkedList;
        } else {
            colTypesToExclude = linkedList;
        }
        return null;
    }
}

