/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.util.URIUtils;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class PrivateHostPanel
implements Traversable {
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final char HTTP_PROTOCOL_MNEMONIC = 'P';
    private static final char HTTPS_PROTOCOL_MNEMONIC = 'S';
    private JRadioButton m_btnHttp = new JRadioButton();
    private JRadioButton m_btnHttps = new JRadioButton();
    private ButtonGroup m_grp = new ButtonGroup();
    private JTextField m_fldHost = new JTextField();
    private WholeNumberField m_port = new WholeNumberField(5);
    private JTextField m_fldServerPath = new JTextField();
    private JLabel m_lblServicePath = new JLabel();
    private JTextField m_fldServicePath = new JTextField();

    private static String getDisplayPath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            if (!string.startsWith("/")) {
                stringBuilder.append('/');
            }
            if (string.endsWith("/")) {
                stringBuilder.append(string.substring(0, string.length() - 1));
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public PrivateHostPanel() {
        this.m_grp.add(this.m_btnHttp);
        this.m_grp.add(this.m_btnHttps);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_grp.clearSelection();
        URI uRI = (URI)traversableContext.get("Cloud.Root");
        if (uRI != null) {
            String string = uRI.getScheme();
            if (HTTPS_PROTOCOL.equals(string)) {
                this.m_btnHttps.setSelected(true);
            } else {
                this.m_btnHttp.setSelected(true);
            }
            this.m_fldHost.setText(uRI.getHost());
            int n = uRI.getPort();
            if (n == -1) {
                this.m_port.setText("");
            } else {
                this.m_port.setNumber((Number)n);
            }
            String string2 = PrivateHostPanel.getDisplayPath(uRI.getPath());
            this.m_fldServerPath.setText(string2);
            URI uRI2 = (URI)traversableContext.get("Cloud.ServiceURI");
            if (uRI2 != null) {
                URI uRI3 = uRI.relativize(uRI2);
                String string3 = PrivateHostPanel.getDisplayPath(uRI3.getPath());
                this.m_fldServicePath.setText(string3);
            }
        } else {
            this.m_btnHttp.setSelected(true);
            String string = (String)traversableContext.get("Cloud.DefaultHostname");
            if (string != null) {
                this.m_fldHost.setText(string);
            }
            this.m_port.setNumber((Number)80);
            this.m_fldServerPath.setText("/ords");
        }
        this.enableServiceName(!Boolean.TRUE.equals(traversableContext.get("Cloud.HideServiceName")));
    }

    private void enableServiceName(boolean bl) {
        this.m_fldServicePath.setVisible(bl);
        this.m_lblServicePath.setVisible(bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_btnHttps.isSelected() ? HTTPS_PROTOCOL : HTTP_PROTOCOL;
        String string2 = this.m_fldHost.getText().trim();
        if (!ModelUtil.hasLength((String)string2)) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_HOST"));
        }
        Number number = this.m_port.getNumber();
        int n = number != null ? number.intValue() : -1;
        String string3 = this.m_fldServerPath.getText();
        if (ModelUtil.hasLength((String)string3) && !string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        URI uRI = URIUtils.newURI((String)string, (String)string2, (int)n, (String)string3, (boolean)true);
        traversableContext.put("Cloud.Root", (Object)uRI);
        URI uRI2 = uRI;
        if (this.m_fldServicePath.isVisible()) {
            String string4 = this.m_fldServicePath.getText();
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            if (ModelUtil.hasLength((String)string4)) {
                uRI2 = URIUtils.newURI((URI)uRI, (String)string4, (boolean)true);
            }
        }
        traversableContext.put("Cloud.ServiceURI", (Object)uRI2);
    }

    public void createComponent(JPanel jPanel, int n) {
        int n2 = n;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        ResourceUtils.resButton((AbstractButton)this.m_btnHttp, (String)HTTP_PROTOCOL);
        this.m_btnHttp.setMnemonic('P');
        ResourceUtils.resButton((AbstractButton)this.m_btnHttps, (String)HTTPS_PROTOCOL);
        this.m_btnHttps.setMnemonic('S');
        jPanel2.add((Component)this.m_btnHttp, LayoutControl.GBC.gbc(0, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_btnHttps, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring(jPanel2, 2);
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc(0, n2, 4, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldHost, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_HOSTNAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_fldHost, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_port, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_PORT"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_port, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldServerPath, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_PATH"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.m_fldServerPath, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resLabel((JLabel)this.m_lblServicePath, (Component)this.m_fldServicePath, (String)this.getServiceNameLabel());
        jPanel.add((Component)this.m_lblServicePath, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y));
        jPanel.add((Component)this.m_fldServicePath, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.XY));
        LayoutControl.GBC.addVSpring(jPanel, 3);
    }

    public Component getComponent() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        this.createComponent(jPanel, 0);
        return jPanel;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return "f1_advcloudconnection_html";
    }

    public Component getInitialFocusComponent() {
        return this.m_fldHost;
    }

    protected String getServiceNameLabel() {
        return CloudBrowserResources.getString("NEW_PRIVATE_CONN_SERVICE_NAME");
    }
}

