/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.http.JsonObjectHandler;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.cloud.navigator.CloudFolder;
import oracle.dbtools.raptor.cloud.navigator.CloudObjectType;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.URIUtils;
import oracle.ide.model.Element;
import org.apache.http.client.ResponseHandler;

public class ConnectionTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((CloudConnection)this.getElement());
    }

    private CloudFolder createFolder(URL uRL, CloudObjectType cloudObjectType) {
        CloudFolder cloudFolder = new CloudFolder(uRL);
        cloudFolder.setObjectType(cloudObjectType);
        return cloudFolder;
    }

    private class LoadTask
    extends CloudTask<Collection<Element>> {
        private CloudConnection m_owner;
        private String m_cName;

        LoadTask(CloudConnection cloudConnection) {
            super(CloudBrowserResources.getString("TASK_CLOUD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            ConnectionTreeNode.this.setComparator(null);
            this.m_owner = cloudConnection;
            this.m_cName = this.m_owner.getConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            List<Element> list = null;
            try {
                Session session = (Session)this.m_owner.getConnection();
                final URI uRI = session.getDefaultServiceURI();
                list = (List<Element>)session.executeQuery(uRI, (ResponseHandler)new JsonObjectHandler<List<Element>>(){

                    protected List<Element> build(TreeNode treeNode2) throws IOException {
                        ArrayList<Element> arrayList = new ArrayList<Element>();
                        TreeNode treeNode3 = treeNode2.path("items");
                        this.checkJsonNode(treeNode3, "items", treeNode -> treeNode.isArray());
                        Iterator iterator = ((JrsArray)treeNode3).elements();
                        while (iterator.hasNext()) {
                            TreeNode treeNode4 = (TreeNode)iterator.next();
                            String string = this.getAsString(treeNode4, "type");
                            TreeNode treeNode5 = treeNode4.path("uri");
                            this.checkJsonNode(treeNode5, "uri", IS_OBJECT);
                            String string2 = this.getAsString(treeNode5, "$ref");
                            if (Debug.isDebugBuild() && uRI.getScheme().equals("http")) {
                                string2 = string2.replace("https:", "http:");
                            }
                            try {
                                CloudObjectType cloudObjectType = new CloudObjectType(string);
                                URL uRL = DBURLFormatHelper.getURL("sqldev.cloud", LoadTask.this.m_cName, null, null, string);
                                CloudFolder cloudFolder = ConnectionTreeNode.this.createFolder(uRL, cloudObjectType);
                                cloudFolder.setRemoteURI(URIUtils.newURI((String)string2));
                                cloudFolder.setConnectionName(LoadTask.this.m_owner.getConnectionName());
                                arrayList.add((Element)cloudFolder);
                            }
                            catch (Exception exception) {}
                        }
                        return arrayList;
                    }
                });
            }
            catch (SessionException sessionException) {
                Logger.warn(CloudController.class, (Throwable)sessionException);
                throw new TaskException((Throwable)sessionException);
            }
            catch (IOException iOException) {
                Logger.warn(CloudController.class, (Throwable)iOException);
                throw new TaskException((Throwable)iOException);
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }
    }
}

