/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.dbtools.http.JsonObjectHandler;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.cloud.CloudAddin;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CloudTask;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.cloud.navigator.CloudFolder;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudObjectType;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.cloud.navigator.ViewerStyle;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.URIUtils;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import org.apache.http.client.ResponseHandler;

public class FolderTreeNode
extends AsynchronousNavigatorTreeNode {
    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        return new LoadTask((CloudFolder)this.getElement());
    }

    private class LoadTask
    extends CloudTask<Collection<Element>> {
        private CloudFolder m_owner;
        private String m_cName;

        LoadTask(CloudFolder cloudFolder) {
            super(CloudBrowserResources.getString("TASK_CLOUD_CONNECT"), true, IRaptorTaskRunMode.TASKVIEWER);
            this.m_owner = cloudFolder;
            this.m_cName = cloudFolder.getConnectionName();
        }

        @Override
        protected String getConnectionName() {
            return this.m_cName;
        }

        protected Collection<Element> doWork() throws TaskException {
            List list = null;
            if (this.m_cName != null) {
                final CloudObjectType cloudObjectType = this.m_owner.getObjectType();
                try {
                    Session session = CConnections.getInstance().getConnection(this.m_cName, false);
                    final URL uRL = this.m_owner.getURL();
                    if (session != null) {
                        Logger.fine(CloudAddin.class, (String)("CloudFolderFilter.getChildren() for " + uRL.toString()));
                        list = (List)session.executeQuery(this.m_owner.getRemoteURI(), (ResponseHandler)new JsonObjectHandler<List<Element>>(){

                            protected List<Element> build(TreeNode treeNode2) throws IOException {
                                ArrayList<Element> arrayList = new ArrayList<Element>();
                                TreeNode treeNode3 = treeNode2.path("items");
                                this.checkJsonNode(treeNode3, "items", treeNode -> treeNode.isArray());
                                Iterator iterator = ((JrsArray)treeNode3).elements();
                                while (iterator.hasNext()) {
                                    TreeNode treeNode4 = (TreeNode)iterator.next();
                                    Logger.fine(CloudAddin.class, (String)("childValue: " + treeNode4.toString()));
                                    String string = this.getAsString(treeNode4, "object_name");
                                    TreeNode treeNode5 = treeNode4.path("uri");
                                    this.checkJsonNode(treeNode5, "uri", IS_OBJECT);
                                    String string2 = this.getAsString(treeNode5, "$ref");
                                    if (Debug.isDebugBuild() && LoadTask.this.m_owner.getRemoteURI().getScheme().equals("http")) {
                                        string2 = string2.replace("https:", "http:");
                                    }
                                    try {
                                        URL uRL2 = DBURLFormatHelper.getURL(uRL, string);
                                        CloudObject cloudObject = (CloudObject)NodeFactory.findOrCreate(CloudObject.class, (URL)uRL2);
                                        cloudObject.setCloudObjectType(cloudObjectType);
                                        cloudObject.setRemoteURI(URIUtils.newURI((String)string2));
                                        arrayList.add(cloudObject);
                                    }
                                    catch (Exception exception) {}
                                }
                                return arrayList;
                            }
                        });
                        if (list != null && list.size() > 0) {
                            CloudObject cloudObject = (CloudObject)list.get(0);
                            URI uRI = cloudObject.getRemoteURI();
                            LinkedHashMap linkedHashMap = new LinkedHashMap();
                            linkedHashMap = (LinkedHashMap)session.executeQuery(uRI, (ResponseHandler)new JsonObjectHandler<LinkedHashMap<String, CloudViewerDetail>>(){

                                protected LinkedHashMap<String, CloudViewerDetail> build(TreeNode treeNode2) throws IOException {
                                    LinkedHashMap<String, CloudViewerDetail> linkedHashMap = new LinkedHashMap<String, CloudViewerDetail>();
                                    TreeNode treeNode3 = treeNode2.path("items");
                                    this.checkJsonNode(treeNode3, "items", treeNode -> treeNode.isArray());
                                    Iterator iterator = ((JrsArray)treeNode3).elements();
                                    while (iterator.hasNext()) {
                                        TreeNode treeNode4 = (TreeNode)iterator.next();
                                        String string = this.getAsString(treeNode4, "viewer");
                                        String string2 = this.getAsString(treeNode4, "style");
                                        TreeNode treeNode5 = treeNode4.path("uri");
                                        this.checkJsonNode(treeNode5, "uri", IS_OBJECT);
                                        String string3 = this.getAsString(treeNode5, "$ref");
                                        linkedHashMap.put(string, new CloudViewerDetail(ViewerStyle.getStyle(string2), string3));
                                    }
                                    return linkedHashMap;
                                }
                            });
                            for (Element element : list) {
                                LinkedHashMap<String, CloudViewerDetail> linkedHashMap2 = new LinkedHashMap<String, CloudViewerDetail>();
                                for (String string : linkedHashMap.keySet()) {
                                    CloudViewerDetail cloudViewerDetail = (CloudViewerDetail)linkedHashMap.get(string);
                                    String string2 = cloudViewerDetail.getUriString().replace(cloudObject.getName().replace(" ", "%20"), ((CloudObject)element).getName());
                                    CloudViewerDetail cloudViewerDetail2 = new CloudViewerDetail(cloudViewerDetail.getStyle(), string2);
                                    linkedHashMap2.put(string, cloudViewerDetail2);
                                }
                                ((CloudObject)element).setViewers(linkedHashMap2);
                            }
                        }
                    }
                }
                catch (SessionException sessionException) {
                    Logger.warn(CloudController.class, (Throwable)sessionException);
                    throw new TaskException((Throwable)sessionException);
                }
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }
    }
}

