/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.common.ddl.DDLFormatConfig;
import oracle.dbtools.common.ddl.TargetFormatConfig;
import oracle.dbtools.export.ExportDataFormatConfig;
import oracle.dbtools.importer.core.ImportDataFormatConfig;
import oracle.dbtools.insight.CompletionConfig;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.URLFileChooserPaths;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Copyable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBConfig
extends HashStructureAdapter
implements Copyable,
IStorage,
ICommonConfig,
DDLFormatConfig,
TargetFormatConfig,
CompletionConfig,
ExportDataFormatConfig,
ImportDataFormatConfig {
    private static final Logger LOGGER = Logger.getLogger(DBConfig.class.getName());
    public static final String KEY = "DBConfig";
    public static final String NLS_SKIP = "NLS_SKIP";
    public static final String WORKSHEETOPEN = "WORKSHEETOPEN";
    public static final String UNSHAREDWORKSHEETOPEN = "UNSHAREDWORKSHEETOPEN";
    public static final String WORKSHEETCLOSE = "WORKSHEETCLOSE";
    public static final String REPORTCLOSE = "REPORTCLOSE";
    public static final String REPORTMAXCHARTROWS = "REPORTMAXCHARTROWS";
    public static final String MAXSCRIPTROWS = "MAXSCRIPTROWS";
    public static final String MAXSCRIPTLINES = "MAXSCRIPTLINES";
    public static final String MAXHISTORYROWS = "MAXHISTORYROWS";
    public static final String AUTOCOMMIT = "AUTOCOMMIT";
    public static final String DEFAULTPATH = "DEFAULTPATH";
    public static final String SAVEBINDS = "SAVEBINDS";
    public static final String PROMPT_WHEN_CLOSE = "PROMPTWHENCLOSE";
    public static final String ZEBRA_ROWS = "ZEBRA_ROWS";
    public static final String CODEADVISOR_ENABLE = "CODEADVISOR_ENABLE";
    public static final String CODEADVISOR_BASIC = "CODEADVISOR_BASIC";
    public static final String CODEADVISOR_DETAILED = "CODEADVISOR_DETAILED";
    public static final String CODEADVISOR_ENVIRONMENT = "CODEADVISOR_ENVIRONMENT";
    public static final String CODEADVISOR_REFRESHDELAY = "CODEADVISOR_REFRESHDELAY";
    public static final String CODEADVISOR_INACTIVITYDELAY = "CODEADVISOR_INACTIVITYDELAY";
    public static final String REINIT_ON_EXIT = "REINIT_ON_EXIT";
    public static final String SKIP_METADATA_DETAIL = "SKIP_METADATA_DETAIL";
    public static final String COMMIT_PRIOR_TRANSACTION = "COMMIT_PRIOR_TRANSACTION";
    public static final String AUTOPIN = "AUTOPIN";
    public static final String NLS_LANG = "NLS_LANG";
    public static final String NLS_TERR = "NLS_TERR";
    public static final String NLS_SORT = "NLS_SORT";
    public static final String NLS_COMP = "NLS_COMP";
    public static final String NLS_DATE_LANG = "NLS_DATE_LANG";
    public static final String NLS_DATE_FORM = "NLS_DATE_FORM";
    public static final String NLS_TS_FORM = "NLS_TS_FORM";
    public static final String NLS_TS_TZ_FORM = "NLS_TS_TZ_FORM";
    public static final String NLS_DEC_SEP = "NLS_DEC_SEP";
    public static final String NLS_GRP_SEP = "NLS_GRP_SEP";
    public static final String NLS_CURR = "NLS_CURR";
    public static final String NLS_ISO_CURR = "NLS_ISO_CURR";
    public static final String NLS_LENGTH = "NLS_LENGTH";
    public static final String ARRAYFETCHSIZE = "ARRAYFETCHSIZE";
    public static final String NULLDISPLAY = "NULLDISPLAY";
    public static final String NULLCOLOR = "NULLCOLOR";
    public static final String DISPLAY_STRUCT_VALUE_IN_GRID = "DISPLAY_STRUCT_VALUE_IN_GRID";
    public static final String DISPLAY_XMLTYPE_VALUE_IN_GRID = "DISPLAY_XMLTYPE_VALUE_IN_GRID";
    private static final String EXTENSION = "EXTENSION";
    private static final String TPDRIVER = "TPDRIVER";
    public static final String TEMPLATES = "TEMPLATES";
    public static final String TEMPLATES_AUTOREPLACE = "TEMPLATES_AUTOREPLACE";
    public static final String PLSQLPROFILERDIR = "PLSQLPROFILERDIR";
    public static final String PLSQLOPTIMLEVEL = "PLSQLOPTIMLEVEL";
    public static final String PLSQLSCOPE = "PLSQLSCOPE";
    public static final String DROPTYPEFORCE = "DROPTYPEFORCE";
    public static final String AUTOPINPLSQLEDITORS = "AUTOPINPLSQLEDITORS";
    public static final String MAXOPENPLSQLEDITORS = "MAXOPENPLSQLEDITORS";
    public static final String READONLYPLSQLEDITORS = "READONLYSQLEDITORS";
    public static final String LINKDBWITHFILESOURCES = "LINKDBWITHFILESOURCES";
    public static final String SUPPORTEDBREADCRUMBS = "SUPPORTEDBREADCRUMBS";
    public static final String SUPPORTEDGUTTERNAVIGATION = "SUPPORTEDGUTTERNAVIGATION";
    public static final String SUPPORTEDQUICKDOCUMENTATION = "SUPPORTEDQUICKDOCUMENTATION";
    public static final String SUPPORTEDSYNKSPECANDBODY = "SUPPORTEDSYNKSPECANDBODY";
    public static final String SUPPORTEDTESTQUERY = "SUPPORTEDTESTQUERY";
    public static final String CASECONVERTER_STATE = "CASECONVERTER_STATE";
    public static final String CUSTOM_SYNTAX_COLOR_URL = "CUSTOM_SYNTAX_COLOR_URL";
    public static final String SEMANTICANALYSIS_TABLEADVICE = "SEMANTICANALYSIS_TABLEADVICE";
    public static final String SEMANTICANALYSIS_EXPANDADVICE = "SEMANTICANALYSIS_EXPANDADVICE";
    public static final String AUTOFORMAT = "AUTOFORMAT";
    public static final String FORMAT_PROFILE_URL = "FORMAT_PROFILE_URL";
    public static final String CUSTOM_FORMAT_URL = "FORMAT_PROFILE_URL";
    public static final String LEGACY_OUTLINE = "LEGACY_OUTLINE";
    public static final String ARBORI_EDITOR = "ARBORI_EDITOR";
    public static final String SINGLE_CLICK_TREE = "OPEN_ON_SINGLE_CLICK";
    public static final String SEARCH_AUTO_WILDCARD = "SEARCH_AUTO_WILDCARD";
    public static final String CSV_DATE_FORMAT = "CSV_DATE_FORMAT";
    public static final String INSTANCE_VIEWER_GRAPH_DURATION = "INSTANCE_VIEWER_GRAPH_DURATION";
    public static final String DRAG_N_DROP_CHOICES = "DRAG_N_DROP_CHOICES";
    public static final String DRAG_N_DROP_PROMPT = "DRAG_N_DROP_PROMPT";
    public static final int DRAG_N_DROP_SELECT = 1;
    public static final int DRAG_N_DROP_JOIN = 2;
    public static final int DRAG_N_DROP_INSERT = 3;
    public static final int DRAG_N_DROP_UPDATE = 4;
    public static final int DRAG_N_DROP_DELETE = 5;
    public static final int DRAG_N_DROP_OBJNAME = 6;
    public static final String AUTO_READONLY_FORMAT = "AUTO_READONLY_FORMAT";
    public static final String GLOGIN = "GLOGIN";
    public static final String GLOGIN_FILE = "";
    public static final String USE_THICK_DRIVER = "USE_THICK_DRIVER";
    public static final String DATAEDITOR_AUTOCOMMIT = "DATAEDITOR_AUTOCOMMIT";
    public static final String DATAEDITOR_POSTONROWCHANGE = "DATAEDITOR_POSTONROWCHANGE";
    public static final String AUTOPIN_RESULTS_TABS = "AUTOPIN_RESULTS_TABS";
    public static final String KERBEROS_CONFIG = "KERBEROS_CONFIG";
    public static final String KERBEROS_CACHE = "KERBEROS_CACHE";
    public static final String EDITOR_TAB = "KERBEROS_CACHE";
    public static final String TNS_NAMES_DIR = "TNS_NAMES_DIR";
    public static final String SQL_PATH_OVERRIDE = "SQL_PATH_OVERRIDE";
    public static final String DATAEDITOR_USE_SCN = "DATAEDITOR_USE_SCN";
    public static final String SKIP_WELCOME = "SKIP_WELCOME";
    public static final String APPSCAN_HIDE_WELCOME = "APPSCAN_HIDE_WELCOME";
    public static final String COPYHADOOP_SKIP_WELCOME = "COPYHADOOP_SKIP_WELCOME";
    public static final String OSCHI_SKIP_WELCOME = "OSCHI_SKIP_WELCOME";
    public static final String OLHI_SKIP_WELCOME = "OLHI_SKIP_WELCOME";
    public static final String PDF_AUTHOR = "PDF_AUTHOR";
    public static final String PDF_KEYWORDS = "PDF_KEYWORDS";
    public static final String PDF_SUBJECT = "PDF_SUBJECT";
    public static final String PDF_TITLE = "PDF_TITLE";
    public static final String PDF_HEADER = "PDF_HEADER";
    public static final String PDF_FOOTER = "PDF_FOOTER";
    public static final String PDF_INSERT_HEADER = "PDF_INSERT_HEADER";
    public static final String PDF_INSERT_FOOTER = "PDF_INSERT_FOOTER";
    public static final String PDF_HEADER_PATTERN = "PDF_HEADER_PATTERN";
    public static final String PDF_FOOTER_PATTERN = "PDF_FOOTER_PATTERN";
    public static final String PDF_AUTO_UPDATE_DATE = "PDF_AUTO_UPDATE_DATE";
    public static final String PDF_VERSION_SUPPORT = "PDF_VERSION_SUPPORT";
    public static final String PDF_COMPRESSION_LEVEL = "PDF_COMPRESSION_LEVEL";
    public static final String PDF_FONT_LOCATION = "PDF_FONT_LOCATION";
    public static final String PDF_EXTERNAL_LIBRARY = "PDF_EXTERNAL_LIBRARY";
    public static final String PDF_EMBED_FONTS = "PDF_EMBED_FONTS";
    public static final String PDF_FONT = "PDF_FONT";
    public static final String PDF_FONT_NAME = "PDF_FONT_NAME";
    public static final String PDF_FONT_STYLE = "PDF_FONT_STYLE";
    public static final String PDF_FONT_SIZE = "PDF_FONT_SIZE";
    public static final String PDF_FONT_COLOR = "PDF_FONT_COLOR";
    public static final String PDF_HEADER_FONT = "PDF_HEADER_FONT";
    public static final String PDF_HEADER_FONT_NAME = "PDF_HEADER_FONT_NAME";
    public static final String PDF_HEADER_FONT_STYLE = "PDF_HEADER_FONT_STYLE";
    public static final String PDF_HEADER_FONT_SIZE = "PDF_HEADER_FONT_SIZE";
    public static final String PDF_HEADER_FONT_COLOR = "PDF_HEADER_FONT_COLOR";
    public static final String PDF_HEADER_ROW_SHADING = "PDF_HEADER_ROW_SHADING";
    public static final String PDF_HEADER_LABELING = "PDF_HEADER_LABELING";
    public static final String PDF_FOOTER_FONT = "PDF_FOOTER_FONT";
    public static final String PDF_FOOTER_FONT_NAME = "PDF_FOOTER_FONT_NAME";
    public static final String PDF_FOOTER_FONT_STYLE = "PDF_FOOTER_FONT_STYLE";
    public static final String PDF_FOOTER_FONT_SIZE = "PDF_FOOTER_FONT_SIZE";
    public static final String PDF_FOOTER_FONT_COLOR = "PDF_FOOTER_FONT_COLOR";
    public static final String PDF_FOOTER_ROW_SHADING = "PDF_FOOTER_ROW_SHADING";
    public static final String PDF_FOOTER_LABELING = "PDF_FOOTER_LABELING";
    public static final String PDF_USE_ROW_SHADING = "PDF_USE_ROW_SHADING";
    public static final String PDF_ODD_ROW_SHADING = "PDF_ODD_ROW_SHADING";
    public static final String PDF_EVEN_ROW_SHADING = "PDF_EVEN_ROW_SHADING";
    public static final String PDF_SHOW_ALL_BORDERS = "PDF_SHOW_ALL_BORDERS";
    public static final String PDF_BORDER_COLOR = "PDF_BORDER_COLOR";
    public static final String PDF_SPACING_BEFORE_TABLE = "PDF_SPACING_BEFORE_TABLE";
    public static final String PDF_SPACING_AFTER_TABLE = "PDF_SPACING_AFTER_TABLE";
    public static final String PDF_TABLE_HORIZONTAL_ALIGNMENT = "PDF_TABLE_HORIZONTAL_ALIGNMENT";
    public static final String PDF_COLUMN_WIDTH = "PDF_COLUMN_WIDTH";
    public static final String PDF_BLOB_ACTION = "PDF_BLOB_ACTION";
    public static final String PDF_CREATE_ZIP_FILE = "PDF_CREATE_ZIP_FILE";
    public static final String PDF_CELL_PADTOP = "PDF_CELL_PADTOP";
    public static final String PDF_CELL_PADBOTTOM = "PDF_CELL_PADBOTTOM";
    public static final String PDF_CELL_PADLEFT = "PDF_CELL_PADLEFT";
    public static final String PDF_CELL_PADRIGHT = "PDF_CELL_PADRIGHT";
    public static final String PDF_CELL_HORIZONTALALIGN = "PDF_CELL_HORIZONTALALIGN";
    public static final String PDF_CELL_VERTICALALIGN = "PDF_CELL_VERTICALALIGN";
    public static final String PDF_CELL_WRAPTEXT = "PDF_CELL_WRAPTEXT";
    public static final String X_PDF_OPEN_PASSWORD = "PDF_OPEN_PASSWORD";
    public static final String X_PDF_PERMISSION_PASSWORD = "PDF_PERMISSION_PASSWORD";
    public static final String X_PDF_SECURITY_ALLOWED = "PDF_SECURITY_ALLOWED";
    public static final String X_PDF_OPEN_PWD_REQUIRED = "PDF_OPEN_PWD_REQUIRED";
    public static final String X_PDF_PERMISSIONS_ALLOWED = "PDF_PERMISSIONS_ALLOWED";
    public static final String X_PDF_PRINTING_ALLOWED = "PDF_PRINTING_ALLOWED";
    public static final String X_PDF_COPYING_ALLOWED = "PDF_COPYING_ALLOWED";
    public static final String X_PDF_UPDATING_ALLOWED = "PDF_UPDATING_ALLOWED";
    public static final String X_PDF_ACCESSIBLE_DEVICES_ALLOWED = "PDF_ACCESSIBLE_DEVICES_ALLOWED";
    public static final String X_PDF_ENCRYPTION_LEVEL = "PDF_ENCRYPTION_LEVEL";
    public static final String CONFIRM_TO_LOG = "CONFIRM_TO_LOG";
    public static final String INDENT_CACHE = "INDENT_CACHE_NUMBER";
    public static final String INDENT_CACHE_USE_TAB = "INDENT_CACHE_USE_TAB";
    public static final String URLFILECHOOSER_SHORTCUTS = "URLFILECHOOSER_SHORTCUTS";
    public static final String TERADATAUSEFEXP = "TERADATAUSEFEXP";
    public static final String TERADATAMAXFEXPSESSIONS = "TERADATAFEXPMAXSESSIONS";
    public static final String TERADATAMINFEXPSESSIONS = "TERADATAFEXPMINSESSIONS";
    public static final String OSS_BUCKET_CONTEXT_KEY = "OSS_BUCKET_CONTEXT";
    private static Map<String, Object> s_defaults = new HashMap<String, Object>();

    private static Integer getIntegerDefault(String string) {
        Object object = DBConfig.getObjectDefault(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(Integer.parseInt(object.toString())) : null);
    }

    private static String getStringDefault(String string) {
        Object object = DBConfig.getObjectDefault(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : null);
    }

    private static boolean getBooleanDefault(String string) {
        Object object = DBConfig.getObjectDefault(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.parseBoolean(object.toString()) : false);
    }

    private static Object getObjectDefault(String string) {
        Object object = s_defaults.get(string);
        if (null == object) {
            object = ICommonConfig.Defaults.get((String)string);
        }
        return object;
    }

    private static Locale getSafeLocale() {
        Locale locale = Locale.getDefault();
        String string = LocaleMapper.getOraLocale((Locale)locale);
        if (string == null) {
            LOGGER.warning("Unsupported Locale " + locale.getDisplayName() + "; trying language only");
            locale = new Locale(locale.getLanguage());
            string = LocaleMapper.getOraLocale((Locale)locale);
            if (string == null) {
                LOGGER.warning("Unable to use default country for language " + locale.getLanguage() + "; falling back to en_US");
                locale = Locale.US;
            }
        }
        return locale;
    }

    private DBConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DBConfig getInstance(PropertyStorage propertyStorage) {
        return new DBConfig(DBConfig.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public static DBConfig getInstance(TraversableContext traversableContext) {
        return DBConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static DBConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return DBConfig.getInstance((PropertyStorage)preferences);
    }

    public Map<String, String> getNLSMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : s_defaults.keySet()) {
            if (string.indexOf("NLS_") != 0) continue;
            hashMap.put(string, this._hash.getString(string) == null ? s_defaults.get(string).toString() : this._hash.getString(string));
        }
        return hashMap;
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.addStructureChangeListener(structureChangeListener);
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.removeStructureChangeListener(structureChangeListener);
    }

    public String getString(String string) {
        return this._hash.getString(string, DBConfig.getStringDefault(string));
    }

    public void putString(String string, String string2) {
        this._hash.putString(string, string2);
    }

    public int getInt(String string) {
        return this._hash.getInt(string, DBConfig.getIntegerDefault(string).intValue());
    }

    public void putInt(String string, int n) {
        this._hash.putInt(string, n);
    }

    public Boolean getBoolean(String string) {
        return this._hash.getBoolean(string, DBConfig.getBooleanDefault(string));
    }

    public void putBoolean(String string, boolean bl) {
        this._hash.putBoolean(string, bl);
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(s_defaults.keySet());
        hashSet.addAll(this._hash.keySet());
        return hashSet;
    }

    public List<String> getExtensions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, List<String>> map = this.getExtensions();
        List<String> list = map.get(string);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void putExtensions(Map<String, List<String>> map) {
        HashStructure hashStructure = HashStructure.newInstance();
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            ListStructure listStructure = ListStructure.newInstance();
            for (String string2 : list) {
                listStructure.add((Object)string2);
            }
            hashStructure.putListStructure(string, listStructure);
        }
        this._hash.putHashStructure(EXTENSION, hashStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getExtensions() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Object object = this._hash.getObject(EXTENSION);
        if (object instanceof HashStructure) {
            HashStructure hashStructure = (HashStructure)object;
            for (String string : hashStructure.keySet()) {
                ListStructure listStructure = hashStructure.getOrCreateListStructure(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object2 = listStructure.iteratorLock();
                synchronized (object2) {
                    for (Object e : listStructure) {
                        arrayList.add((String)e);
                    }
                }
                hashMap.put(string, arrayList);
            }
        } else {
            String string;
            if (object instanceof String && (string = (String)object).length() > 5) {
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    DOMParser dOMParser = new DOMParser();
                    dOMParser.setPreserveWhitespace(false);
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    dOMParser.parse((InputStream)byteArrayInputStream);
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    NodeList nodeList = xMLDocument.getChildNodes();
                    NodeList nodeList2 = nodeList.item(0).getChildNodes();
                    for (int i = 0; i < nodeList2.getLength(); ++i) {
                        NodeList nodeList3 = nodeList2.item(i).getChildNodes();
                        String string2 = nodeList3.item(0).getTextContent();
                        String string3 = nodeList3.item(1).getTextContent();
                        ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string2);
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                            hashMap.put(string2, arrayList);
                        }
                        arrayList.add(string3);
                    }
                }
                catch (SAXException sAXException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                finally {
                    if (byteArrayInputStream != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.putExtensions(hashMap);
        }
        return hashMap;
    }

    public URLFileChooserPaths getURLFileChooserPaths() {
        return URLFileChooserPaths.findOrCreate(this._hash);
    }

    public URLPath getURLFileChooserShortcuts() {
        return this.getURLPath(URLFILECHOOSER_SHORTCUTS);
    }

    public URLPath getThirdPartyPath() {
        return this.getURLPath(TPDRIVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLPath getURLPath(String string) {
        URLPath uRLPath = new URLPath();
        Object object = this._hash.getObject(string);
        if (object instanceof ListStructure) {
            ListStructure listStructure = this._hash.getOrCreateListStructure(string);
            Object object2 = listStructure.iteratorLock();
            synchronized (object2) {
                for (Object e : listStructure) {
                    URL uRL = (URL)e;
                    uRLPath.add(uRL);
                }
            }
        } else if (object instanceof String) {
            uRLPath.add(this.parsePathFromXML((String)object));
            this.setThirdPartyPath(uRLPath);
        }
        return uRLPath;
    }

    public void setURLFileChooserShortcuts(URLPath uRLPath) {
        this.setURLPath(uRLPath, URLFILECHOOSER_SHORTCUTS);
    }

    public void setThirdPartyPath(URLPath uRLPath) {
        this.setURLPath(uRLPath, TPDRIVER);
    }

    private void setURLPath(URLPath uRLPath, String string) {
        ListStructure listStructure = ListStructure.newInstance();
        for (URL uRL : uRLPath.asList()) {
            listStructure.add((Object)uRL);
        }
        this._hash.putListStructure(string, listStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLPath parsePathFromXML(String string) {
        URLPath uRLPath = new URLPath();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (string != null && string.length() > 5) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                dOMParser.parse((InputStream)byteArrayInputStream);
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2 = nodeList.item(i).getTextContent();
                    URL uRL = new URL(string2);
                    uRLPath.add(uRL);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return uRLPath;
    }

    public DBConfig() {
        super(HashStructure.newInstance());
    }

    public Map<String, Object> getAllParameters() {
        return new HashMap<String, Object>();
    }

    public void setAllParameters(Map<String, Object> map) {
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object instanceof Boolean) {
                this.putBoolean(string, (Boolean)object);
                continue;
            }
            if (object instanceof Integer) {
                this.putInt(string, (Integer)object);
                continue;
            }
            if (object == null) continue;
            this.putString(string, object.toString());
        }
    }

    public URL getScriptDirectory() {
        URL uRL = null;
        String string = this.getString(DEFAULTPATH);
        if (string != null) {
            uRL = URLFactory.newFileURL((String)string);
        } else {
            URL uRL2 = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
            uRL = URLFactory.newDirURL((URL)uRL2, (String)"sql");
        }
        return uRL;
    }

    static {
        s_defaults.put(NLS_SKIP, false);
        s_defaults.put(UNSHAREDWORKSHEETOPEN, false);
        s_defaults.put(REPORTCLOSE, false);
        s_defaults.put(REPORTMAXCHARTROWS, 1000);
        s_defaults.put(MAXSCRIPTROWS, 5000);
        s_defaults.put(MAXSCRIPTLINES, 10010);
        s_defaults.put(MAXHISTORYROWS, 100);
        s_defaults.put(DEFAULTPATH, null);
        s_defaults.put(SAVEBINDS, false);
        s_defaults.put(COMMIT_PRIOR_TRANSACTION, false);
        s_defaults.put(AUTOPIN, false);
        Locale locale = DBConfig.getSafeLocale();
        String string = LocaleMapper.getOraLanguage((Locale)locale);
        s_defaults.put(NLS_LANG, string);
        String string2 = LocaleMapper.getOraTerritory((Locale)locale);
        s_defaults.put(NLS_TERR, string2);
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)string, (String)string2);
        OraTerritory oraTerritory = OraTerritory.getInstance((String)string, (String)string2);
        if (oraLocaleInfo.getLinguisticSort().indexOf("BINARY") > -1) {
            s_defaults.put(NLS_SORT, "BINARY");
        } else {
            s_defaults.put(NLS_SORT, oraLocaleInfo.getLinguisticSort());
        }
        s_defaults.put(NLS_COMP, "BINARY");
        s_defaults.put(NLS_DATE_LANG, string);
        s_defaults.put(NLS_DATE_FORM, oraTerritory.getOracleDateFormatString());
        s_defaults.put(NLS_TS_FORM, oraTerritory.getNLSTimestampFormatString());
        s_defaults.put(NLS_TS_TZ_FORM, oraTerritory.getNLSTimestampAndTimezoneFormatString());
        s_defaults.put(NLS_DEC_SEP, oraTerritory.getDecimalCharacter());
        s_defaults.put(NLS_GRP_SEP, oraTerritory.getGroupSeparator());
        s_defaults.put(NLS_CURR, oraTerritory.getLocalCurrencySymbol());
        s_defaults.put(NLS_ISO_CURR, string2);
        s_defaults.put(NLS_LENGTH, "BYTE");
        s_defaults.put(ARRAYFETCHSIZE, 50);
        s_defaults.put(NULLCOLOR, "NONE");
        s_defaults.put(NULLDISPLAY, "(null)");
        s_defaults.put(DISPLAY_STRUCT_VALUE_IN_GRID, false);
        s_defaults.put(DISPLAY_XMLTYPE_VALUE_IN_GRID, false);
        s_defaults.put(CONFIRM_TO_LOG, false);
        if (RaptorExtensionConstants.isStandAlone()) {
            s_defaults.put(AUTOCOMMIT, false);
            s_defaults.put(SINGLE_CLICK_TREE, true);
            s_defaults.put(WORKSHEETCLOSE, false);
            s_defaults.put(WORKSHEETOPEN, true);
        } else {
            s_defaults.put(AUTOCOMMIT, true);
            s_defaults.put(SINGLE_CLICK_TREE, false);
            s_defaults.put(WORKSHEETCLOSE, true);
            s_defaults.put(WORKSHEETOPEN, false);
        }
        s_defaults.put(SEARCH_AUTO_WILDCARD, false);
        s_defaults.put(EXTENSION, null);
        s_defaults.put(TPDRIVER, null);
        s_defaults.put(TEMPLATES_AUTOREPLACE, false);
        s_defaults.put(INSTANCE_VIEWER_GRAPH_DURATION, 2);
        s_defaults.put(PLSQLOPTIMLEVEL, 2);
        s_defaults.put(PLSQLSCOPE, "All");
        s_defaults.put(DROPTYPEFORCE, false);
        s_defaults.put(AUTOPINPLSQLEDITORS, true);
        s_defaults.put(MAXOPENPLSQLEDITORS, 8);
        s_defaults.put(READONLYPLSQLEDITORS, false);
        s_defaults.put(LINKDBWITHFILESOURCES, true);
        s_defaults.put(SUPPORTEDBREADCRUMBS, false);
        s_defaults.put(SUPPORTEDGUTTERNAVIGATION, true);
        s_defaults.put(SUPPORTEDQUICKDOCUMENTATION, true);
        s_defaults.put(SUPPORTEDSYNKSPECANDBODY, true);
        s_defaults.put(SUPPORTEDTESTQUERY, true);
        s_defaults.put(CUSTOM_SYNTAX_COLOR_URL, "N/A");
        s_defaults.put(SEMANTICANALYSIS_EXPANDADVICE, true);
        s_defaults.put(SEMANTICANALYSIS_TABLEADVICE, true);
        s_defaults.put(AUTOFORMAT, false);
        s_defaults.put("FORMAT_PROFILE_URL", "N/A");
        s_defaults.put(LEGACY_OUTLINE, "false");
        s_defaults.put(ARBORI_EDITOR, "false");
        s_defaults.put(DRAG_N_DROP_CHOICES, 1);
        s_defaults.put(DRAG_N_DROP_PROMPT, 0);
        s_defaults.put(USE_THICK_DRIVER, false);
        s_defaults.put(AUTO_READONLY_FORMAT, false);
        s_defaults.put(GLOGIN, false);
        s_defaults.put(GLOGIN_FILE, GLOGIN_FILE);
        s_defaults.put(DATAEDITOR_POSTONROWCHANGE, false);
        s_defaults.put(DATAEDITOR_AUTOCOMMIT, false);
        s_defaults.put(PROMPT_WHEN_CLOSE, true);
        s_defaults.put(ZEBRA_ROWS, false);
        s_defaults.put(CODEADVISOR_ENABLE, false);
        s_defaults.put(CODEADVISOR_BASIC, true);
        s_defaults.put(CODEADVISOR_DETAILED, false);
        s_defaults.put(CODEADVISOR_ENVIRONMENT, false);
        s_defaults.put(CODEADVISOR_REFRESHDELAY, "3000");
        s_defaults.put(CODEADVISOR_INACTIVITYDELAY, "1000");
        s_defaults.put(AUTOPIN_RESULTS_TABS, false);
        s_defaults.put(REINIT_ON_EXIT, true);
        s_defaults.put(SKIP_METADATA_DETAIL, true);
        s_defaults.put(KERBEROS_CONFIG, GLOGIN_FILE);
        s_defaults.put("KERBEROS_CACHE", GLOGIN_FILE);
        s_defaults.put(TNS_NAMES_DIR, GLOGIN_FILE);
        s_defaults.put(SQL_PATH_OVERRIDE, GLOGIN_FILE);
        s_defaults.put(DATAEDITOR_USE_SCN, true);
        s_defaults.put(SKIP_WELCOME, false);
        s_defaults.put(COPYHADOOP_SKIP_WELCOME, false);
        s_defaults.put(OLHI_SKIP_WELCOME, false);
        s_defaults.put(OSCHI_SKIP_WELCOME, false);
        s_defaults.put(APPSCAN_HIDE_WELCOME, false);
        s_defaults.put(PDF_AUTHOR, null);
        s_defaults.put(PDF_KEYWORDS, null);
        s_defaults.put(PDF_HEADER, null);
        s_defaults.put(PDF_FOOTER, null);
        s_defaults.put(PDF_INSERT_HEADER, false);
        s_defaults.put(PDF_INSERT_FOOTER, false);
        s_defaults.put(PDF_HEADER_PATTERN, null);
        s_defaults.put(PDF_FOOTER_PATTERN, null);
        s_defaults.put(PDF_AUTO_UPDATE_DATE, false);
        s_defaults.put(PDF_VERSION_SUPPORT, 2);
        s_defaults.put(PDF_COMPRESSION_LEVEL, 1);
        s_defaults.put(PDF_FONT_LOCATION, null);
        s_defaults.put(PDF_EXTERNAL_LIBRARY, null);
        s_defaults.put(PDF_EMBED_FONTS, false);
        s_defaults.put(PDF_FONT, 1);
        s_defaults.put(PDF_FONT_NAME, null);
        s_defaults.put(PDF_FONT_STYLE, 0);
        s_defaults.put(PDF_FONT_SIZE, 10);
        s_defaults.put(PDF_FONT_COLOR, -16777216);
        s_defaults.put(PDF_HEADER_FONT, 1);
        s_defaults.put(PDF_HEADER_FONT_NAME, null);
        s_defaults.put(PDF_HEADER_FONT_STYLE, 0);
        s_defaults.put(PDF_HEADER_FONT_SIZE, 10);
        s_defaults.put(PDF_HEADER_FONT_COLOR, -16777216);
        s_defaults.put(PDF_HEADER_ROW_SHADING, -1);
        s_defaults.put(PDF_HEADER_LABELING, 2);
        s_defaults.put(PDF_FOOTER_FONT, 1);
        s_defaults.put(PDF_FOOTER_FONT_NAME, null);
        s_defaults.put(PDF_FOOTER_FONT_STYLE, 0);
        s_defaults.put(PDF_FOOTER_FONT_SIZE, 10);
        s_defaults.put(PDF_FOOTER_FONT_COLOR, -16777216);
        s_defaults.put(PDF_FOOTER_ROW_SHADING, -1);
        s_defaults.put(PDF_FOOTER_LABELING, 0);
        s_defaults.put(PDF_USE_ROW_SHADING, false);
        s_defaults.put(PDF_SHOW_ALL_BORDERS, true);
        s_defaults.put(PDF_ODD_ROW_SHADING, -1);
        s_defaults.put(PDF_EVEN_ROW_SHADING, -1);
        s_defaults.put(PDF_BORDER_COLOR, -16777216);
        s_defaults.put(PDF_SPACING_BEFORE_TABLE, 12);
        s_defaults.put(PDF_SPACING_AFTER_TABLE, 12);
        s_defaults.put(PDF_TABLE_HORIZONTAL_ALIGNMENT, 0);
        s_defaults.put(PDF_COLUMN_WIDTH, 1);
        s_defaults.put(PDF_BLOB_ACTION, 2);
        s_defaults.put(PDF_CREATE_ZIP_FILE, false);
        s_defaults.put(PDF_CELL_PADTOP, 2);
        s_defaults.put(PDF_CELL_PADBOTTOM, 2);
        s_defaults.put(PDF_CELL_PADLEFT, 2);
        s_defaults.put(PDF_CELL_PADRIGHT, 2);
        s_defaults.put(PDF_CELL_HORIZONTALALIGN, 0);
        s_defaults.put(PDF_CELL_VERTICALALIGN, 0);
        s_defaults.put(PDF_CELL_WRAPTEXT, true);
        s_defaults.put(INDENT_CACHE, -1);
        s_defaults.put(INDENT_CACHE_USE_TAB, false);
        s_defaults.put(TERADATAUSEFEXP, Boolean.TRUE);
        s_defaults.put(TERADATAMINFEXPSESSIONS, new Integer(1));
        s_defaults.put(TERADATAMAXFEXPSESSIONS, new Integer(4));
    }
}

