/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.search;

import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.parser.plsql.DictionaryQuery;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.search.ItemNode;
import oracle.dbtools.raptor.controls.search.ResultsTreeNode;
import oracle.dbtools.raptor.controls.search.SchemaNode;
import oracle.dbtools.raptor.controls.search.SearchIdeNode;
import oracle.dbtools.raptor.controls.search.TypeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.Datum;

public class QueryTask
extends DatabaseQueryTask<ArrayList<Item>> {
    private final DictionaryQuery query;
    private String name;
    private final String conn;
    private String userName;
    private String[] objectTypes = null;
    private String[] schemas = null;
    private String[] idTypes = null;
    private String[] idUsages = null;
    private boolean isColumns = false;
    private boolean isAllSource = false;
    private boolean isAllViews = false;
    private boolean isAllStatements = false;
    private boolean isOrds = false;
    private boolean isWildcard = false;
    private boolean isAllDependencies = false;
    private DefaultMutableTreeNode root;
    static final String connPref = "IdeConnections%23";
    int cardinality;
    long time;

    public QueryTask(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        super(MessageFormat.format(ControlsArb.getString("SearchPanel.4"), Connections.getDisplayName(string2), string), IRaptorTaskRunMode.MODAL_OPTIONAL, true, true);
        String[] stringArray5 = null;
        this.name = string;
        this.conn = string2;
        this.query = new DictionaryQuery(this.conn, null, false){

            @Override
            protected boolean isMixedCase(String string) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (i == 0 && c == '\"') {
                        return true;
                    }
                    if ('A' <= c && c <= 'Z') {
                        bl2 = true;
                    }
                    if ('a' <= c && c <= 'z') {
                        bl3 = true;
                    }
                    if (!bl2 || !bl3) continue;
                    bl = true;
                    break;
                }
                return bl;
            }

            @Override
            protected String conditionalUpperCase(String string) {
                if ((string = string.toUpperCase()).charAt(0) == '\"') {
                    if (string.endsWith("%")) {
                        return string.substring(1, string.length() - 2) + "%";
                    }
                    return string.substring(1, string.length() - 1);
                }
                return string;
            }
        };
        this.objectTypes = stringArray;
        this.schemas = stringArray2;
        this.idTypes = stringArray3;
        this.idUsages = stringArray4;
        this.isColumns = bl;
        this.isAllSource = bl2;
        this.isAllStatements = bl3;
        this.isAllViews = bl4;
        this.isOrds = bl5;
        this.isWildcard = bl6;
        this.isAllDependencies = bl7;
        Properties properties = Connections.getInstance().getConnectionInfo(this.conn);
        if (properties != null) {
            this.userName = properties.getProperty("user");
        }
        if (properties != null && properties.getProperty("IS_PROXY") != null) {
            stringArray5 = new String[stringArray2.length];
            if (new Boolean(properties.getProperty("IS_PROXY")).booleanValue()) {
                String string3 = properties.getProperty("PROXY_USER_NAME");
                for (int i = 0; i < this.schemas.length; ++i) {
                    stringArray5[i] = string3;
                }
                this.schemas = stringArray5;
            }
        }
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ArrayList arrayList = null;
                        try {
                            arrayList = (ArrayList)QueryTask.this.getResult();
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                            return;
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                            return;
                        }
                        QueryTask.this.buildOutputTree(arrayList);
                        final Context context = Context.newIdeContext((Node)new SearchIdeNode(QueryTask.this.conn, QueryTask.this.name, QueryTask.this.cardinality, QueryTask.this.time, QueryTask.this.root));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public ArrayList<Item> doWork() {
        if (this.objectTypes != null) {
            this.query.prepareAllObjects(this.name, this.objectTypes, this.schemas);
        }
        if (this.idTypes != null || this.idUsages != null) {
            this.query.prepareAllIdentifiers(this.name, this.idTypes, this.idUsages, this.schemas);
        }
        if (this.isColumns) {
            this.query.prepareAllColumns(this.name, this.schemas);
        }
        if (this.isAllSource) {
            this.query.prepareAllSource(this.name, this.schemas, this.isWildcard);
        }
        if (this.isAllStatements) {
            this.query.prepareAllStatements(this.name, this.schemas, this.isWildcard);
        }
        if (this.isOrds) {
            this.query.prepareOrds(this.name, this.schemas, this.isWildcard);
        }
        if (this.isAllDependencies) {
            this.query.prepareAllDependencies(this.name, this.objectTypes, this.schemas);
        }
        long l = System.currentTimeMillis();
        ArrayList<Item> arrayList = this.query.fetch(this.name);
        if (this.isAllViews) {
            this.query.queryViews(arrayList, this.schemas, this.name);
        }
        this.time = System.currentTimeMillis() - l;
        this.cardinality = arrayList.size();
        return arrayList;
    }

    public boolean cancel() {
        DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(ControlsArb.getString("SearchPanel.46"), IRaptorTaskRunMode.NO_GUI, false, false){

            protected Void doWork() throws TaskException {
                if (QueryTask.this.query != null) {
                    QueryTask.this.query.cancel();
                }
                return null;
            }

            public String getConnectionName() {
                return QueryTask.this.conn;
            }

            public String getQuery() {
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        return super.cancel();
    }

    public String getConnectionName() {
        return this.query.getConnectionName();
    }

    public String getQuery() {
        return this.query != null ? this.query.QUERY_ALL_OBJECTS() : "";
    }

    private void buildOutputTree(ArrayList<Item> arrayList) {
        this.root = new TypeNode("");
        LinkedList<SchemaNode> linkedList = new LinkedList<SchemaNode>();
        LinkedList<TypeNode> linkedList2 = new LinkedList<TypeNode>();
        LinkedList<TypeNode> linkedList3 = new LinkedList<TypeNode>();
        for (Item item : arrayList) {
            ResultsTreeNode resultsTreeNode;
            ResultsTreeNode resultsTreeNode2;
            block13: {
                String string;
                int n;
                block12: {
                    ResultsTreeNode resultsTreeNode3 = new SchemaNode(item.owner);
                    n = linkedList.indexOf(resultsTreeNode3);
                    if (n == -1) {
                        linkedList.add((SchemaNode)resultsTreeNode3);
                        this.root.add(resultsTreeNode3);
                        linkedList2 = new LinkedList();
                        linkedList3 = new LinkedList();
                    } else {
                        resultsTreeNode3 = (ResultsTreeNode)linkedList.get(n);
                    }
                    resultsTreeNode2 = new TypeNode(item.objType);
                    int n2 = linkedList2.indexOf(resultsTreeNode2);
                    if (n2 == -1) {
                        linkedList2.add((TypeNode)resultsTreeNode2);
                        resultsTreeNode3.add(resultsTreeNode2);
                        linkedList3 = new LinkedList();
                    } else {
                        resultsTreeNode2 = (ResultsTreeNode)linkedList2.get(n2);
                    }
                    string = item.objName;
                    if (item.objType.endsWith(" BODY")) {
                        string = string + " Body";
                    }
                    resultsTreeNode = null;
                    if (-1 < item.line || "COLUMN".equals(item.colType)) break block12;
                    if (!Item.viewSrcColType.equals(item.colType)) break block13;
                }
                if ((n = linkedList3.indexOf(resultsTreeNode = new TypeNode(string))) == -1) {
                    linkedList3.add((TypeNode)resultsTreeNode);
                } else {
                    resultsTreeNode = (ResultsTreeNode)linkedList3.get(n);
                }
                resultsTreeNode.add(new ItemNode(item, this.name));
            }
            if (resultsTreeNode == null) {
                resultsTreeNode = new ItemNode(item, this.name);
            }
            resultsTreeNode2.add(resultsTreeNode);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/xe", "hr", "hr");
        String string = "declare\n    l_search     VARCHAR2(1000) := ?;\n    text         VARCHAR2(32767);\n    l_char       VARCHAR2(32767);\n    l_rc         SYS_REFCURSOR;\n    TYPE strtbl IS\n        TABLE OF VARCHAR2(1000) INDEX BY BINARY_INTEGER;\n    l_st         strtbl;\n    cnt          INTEGER;\n    match_pos    INTEGER;\n    line_begin   INTEGER;\n    line_end     INTEGER;\nBEGIN\n    cnt := 1;\n    FOR rec IN (\n        SELECT\n            *\n        FROM\n            all_views\n        WHERE\n            text_length < 32767\n    ) LOOP\n        text := upper(rec.text);\n        line_begin := 1;\n        line_end := rec.text_length;\n        match_pos := instr(\n            text,\n            l_search\n        );\n        WHILE 0 < match_pos LOOP\n            IF instr(\n                text,\n                chr(10),\n                match_pos\n            ) > 0 THEN\n                line_end := instr(\n                    text,\n                    chr(10),\n                    match_pos\n                ) - 1;\n            ELSE\n                line_end := rec.text_length; \n            END IF;\n            l_char := substr(\n                    text,\n                    1,\n                    line_end\n            );\n\n            IF instr(\n                l_char,\n                chr(10),\n                -1\n            ) > 0 THEN\n                line_begin := instr(\n                    l_char,\n                    chr(10),\n                    -1\n                ) + 1;\n                l_char := substr(\n                    l_char,\n                    line_begin                \n                );\n            END IF;\n\n            l_st(cnt) := substr(rec.owner || '.' || rec.view_name ||'->' || l_char,1,1000);\n\n            cnt := cnt + 1;\n            match_pos := instr(\n                text,\n                l_search,\n                line_end\n            );\n        END LOOP;\n\n        EXIT WHEN\n            500 < cnt;\n    END LOOP;\n\n    :out := l_st;\nEND;\n";
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);
        oracleCallableStatement.setString(1, "'SCHEMAID'");
        oracleCallableStatement.registerIndexTableOutParameter(2, 1000, 12, 1000);
        oracleCallableStatement.execute();
        Datum[] datumArray = oracleCallableStatement.getOraclePlsqlIndexTable(2);
        for (int i = 0; i < datumArray.length; ++i) {
            System.out.println(datumArray[i].stringValue());
        }
    }
}

