/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.ide.util.MetaClass;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.GlassPaneTaskViewer;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.SQLDialogHelpProvider;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.ActionSqlPanel;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.InheritXMLSpec;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.controls.sqldialog.SQLPromptPanel;
import oracle.dbtools.raptor.controls.validators.IValidator;
import oracle.dbtools.raptor.controls.validators.ValidatableObject;
import oracle.dbtools.raptor.controls.validators.ValidatorRegistry;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class ObjectActionController
implements Controller,
LayoutControl {
    private static ObjectActionController _instance;
    private static CopyOnWriteArrayList<IObjectActionListener> _listeners;
    public static final String IGNORE_REFRESH = "ObjectActionController.IGNORE_REFRESH";
    private static final Map<String, String> _associatedDrops;
    private static final IObjectActionListener EDITORS;
    private static int[] JEWT_BUTTONS;

    public static synchronized Controller getInstance() {
        if (_instance == null) {
            _instance = new ObjectActionController();
        }
        return _instance;
    }

    public static void addListener(IObjectActionListener iObjectActionListener) {
        if (_listeners == null) {
            _listeners = new CopyOnWriteArrayList();
        }
        _listeners.add(iObjectActionListener);
    }

    public static void removeListener(IObjectActionListener iObjectActionListener) {
        if (_listeners != null) {
            _listeners.remove(iObjectActionListener);
        }
    }

    private ObjectActionController() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ObjectAction objectAction = (ObjectAction)((Object)ideAction.getValue("ObjectAction.KEY"));
        if (objectAction != null) {
            Object object;
            Object object2;
            Object object3;
            if (objectAction.getProperty("ACTION_TYPE") != null && objectAction.getProperty("ACTION_TYPE").toString().equals("REPORT")) {
                context = (Context)objectAction.getProperty("CONTEXT");
            }
            String string = null;
            DBObject dBObject = null;
            dBObject = (DBObject)((Object)context.getProperty("ObjectAction.DBOBJECT"));
            string = dBObject != null ? dBObject.getConnectionName() : ((dBObject = (DBObject)((Object)objectAction.getMenuItem().getClientProperty("ObjectAction.DBOBJECT"))) != null ? dBObject.getConnectionName() : (String)context.getProperty("ObjectAction.CONN_NAME"));
            if (dBObject == null) {
                object3 = context.getSelection();
                object2 = object3 != null && ((Element[])object3).length == 1 ? object3[0] : context.getNode();
                dBObject = new DBObject((Element<?, ?>)object2);
            }
            object3 = null;
            if (context.getProperty("ObjectAction.TARGET.KEY") != null && context.getProperty("ObjectAction.TARGET.KEY") instanceof IDisplay) {
                object2 = (InputEvent)context.getProperty("ObjectAction.EVENT");
                object = null;
                if (object2 != null && object2 instanceof MouseEvent) {
                    object = ((MouseEvent)object2).getPoint();
                }
                object3 = ((IDisplay)context.getProperty("ObjectAction.TARGET.KEY")).getBinds((Point)object);
            }
            if (string == null) {
                string = dBObject.getConnectionName();
            }
            object2 = objectAction.getMetaClass();
            try {
                if (objectAction.isConnectionRequired() && (object = Connections.getInstance().getConnection(string)) == null) {
                    return true;
                }
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                ExceptionHandler.handleException((Throwable)(throwable instanceof Exception ? (Exception)throwable : dBException));
                return true;
            }
            if (object2 == null) {
                try {
                    this.processAction(context, objectAction, string, (Map<String, Object>)object3, dBObject, null);
                }
                catch (DBException dBException) {
                    ExceptionHandler.handleException((Throwable)dBException);
                }
            } else {
                try {
                    object = (AbstractMenuAction)ideAction.getValue("ObjectAction.CLASS");
                    if (object == null) {
                        object = (AbstractMenuAction)object2.newInstance();
                    }
                    if (object instanceof InheritXMLSpec) {
                        try {
                            this.processAction(context, objectAction, string, (Map<String, Object>)object3, dBObject, (AbstractMenuAction)object);
                        }
                        catch (DBException dBException) {
                            ExceptionHandler.handleException((Throwable)dBException);
                        }
                    } else {
                        this.invokeClassAction(context, objectAction, string, dBObject, (AbstractMenuAction)object);
                    }
                }
                catch (InstantiationException instantiationException) {
                    Logger.warn(this.getClass(), (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.warn(this.getClass(), (Throwable)illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.warn(this.getClass(), (Throwable)classNotFoundException);
                }
            }
            return true;
        }
        return false;
    }

    private void invokeClassAction(Context context, ObjectAction objectAction, String string, DBObject dBObject, AbstractMenuAction abstractMenuAction) {
        abstractMenuAction.setDBObject(dBObject);
        abstractMenuAction.setContext(context);
        abstractMenuAction.setArgs(objectAction.getClassArgs());
        abstractMenuAction.setObjectAction(objectAction);
        abstractMenuAction.launch();
        DBObject dBObject2 = abstractMenuAction.getDBObject();
        if (!abstractMenuAction.isBlockOACRefresh() && dBObject2 != null && objectAction.isConnectionRequired() && dBObject.getConnectionName() != null) {
            this.postProcessAction(string, objectAction, dBObject2.getDictionary(), null, dBObject);
        }
    }

    public void processAction(final Context context, final ObjectAction objectAction, final String string, Map<String, Object> map, final DBObject dBObject, final AbstractMenuAction abstractMenuAction) throws DBException {
        final GlassPaneTaskViewer glassPaneTaskViewer = new GlassPaneTaskViewer();
        final Map<String, Object> map2 = map != null ? map : dBObject.getDictionary();
        ArrayList<Element> arrayList = new ArrayList<Element>(Arrays.asList(context.getSelection()));
        if (!arrayList.contains(dBObject.getElement())) {
            arrayList.add(dBObject.getElement());
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl = true;
        for (Element element : arrayList) {
            DBObject dBObject2 = new DBObject(element);
            stringBuilder.append(bl ? "" : ", ").append('\'').append('\"').append(dBObject2.getObjectName()).append('\"').append('\'');
            stringBuilder2.append(bl ? "" : ", ").append('\'').append('\"').append(dBObject2.getSchemaName()).append('\"').append('\'');
            bl = false;
        }
        map2.put("OBJECT_NAMES", stringBuilder);
        map2.put("OBJECT_OWNERS", stringBuilder2);
        Object object = new DeferUIOperationTask(objectAction.getTitle()){

            @Override
            protected void invokeLater() {
                final SQLPromptPanel sQLPromptPanel = new SQLPromptPanel(objectAction, string, map2);
                if (map2 != null) {
                    sQLPromptPanel.setDictionary(map2);
                }
                String string3 = null;
                if (dBObject != null && dBObject.isValid()) {
                    sQLPromptPanel.setDictionary(dBObject.getDictionary());
                    string3 = dBObject.getConnectionName();
                }
                final String string2 = string3;
                final ActionSqlPanel actionSqlPanel = new ActionSqlPanel(sQLPromptPanel);
                JPanel jPanel = LayoutControl.GBC.createTabPanel(sQLPromptPanel);
                JPanel[] jPanelArray = new JPanel[]{jPanel, actionSqlPanel};
                String[] stringArray = new String[]{Messages.getString("ObjectActionController.4"), Messages.getString("ObjectActionController.5")};
                final JEWTDialog jEWTDialog = UIUtils.createTabbedPanelDialog((JPanel[])jPanelArray, (String[])stringArray, (String)objectAction.getTitle(), null, (HelpProvider)new SQLDialogHelpProvider(objectAction.getHelp()));
                glassPaneTaskViewer.setBackground(jEWTDialog.getBackground());
                jEWTDialog.setGlassPane((Component)glassPaneTaskViewer);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        actionSqlPanel.update();
                        RaptorTask<Void> raptorTask = new RaptorTask<Void>(objectAction.getTitle(), true, IRaptorTaskRunMode.TASKVIEWER){

                            protected Void doWork() throws TaskException {
                                try {
                                    ObjectActionController.this.processDialog(actionSqlPanel, objectAction, string, dBObject);
                                }
                                catch (ExecutionException executionException) {
                                    throw new TaskException((Throwable)executionException);
                                }
                                return null;
                            }
                        };
                        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                            public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        jEWTDialog.getGlassPane().setVisible(true);
                                        jEWTDialog.validate();
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }

                            public void taskCancelled(final RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        RaptorTaskUtils.showErrorMessage((String)string2, (Component)sQLPromptPanel, (RaptorTaskDescriptor)raptorTaskEvent.getTaskDescriptor());
                                        jEWTDialog.getGlassPane().setVisible(false);
                                        jEWTDialog.validate();
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }

                            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        RaptorTaskUtils.showErrorMessage((String)string2, (Component)sQLPromptPanel, (RaptorTaskDescriptor)raptorTaskEvent.getTaskDescriptor());
                                        jEWTDialog.getGlassPane().setVisible(false);
                                        jEWTDialog.validate();
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }

                            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        jEWTDialog.closeDialog(false);
                                        Runnable runnable = new Runnable(){

                                            @Override
                                            public void run() {
                                                ObjectActionController.this.processConfirm(objectAction, actionSqlPanel, string);
                                                ObjectActionController.this.postProcessAction(string, objectAction, actionSqlPanel.getDictionary(), actionSqlPanel.getPromptPanel().getValues(), dBObject);
                                                if (abstractMenuAction != null) {
                                                    ObjectActionController.this.invokeClassAction(context, objectAction, string2, dBObject, abstractMenuAction);
                                                }
                                            }
                                        };
                                        SwingUtilities.invokeLater(runnable);
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        });
                        if (ObjectActionController.this.validateValues(string, actionSqlPanel, objectAction)) {
                            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask, Collections.singletonList(glassPaneTaskViewer));
                        }
                    }
                };
                jEWTDialog.addActionListener(actionListener);
                ObjectActionController.this.setInitialDialogFocus(jEWTDialog);
                WizardLauncher.runDialog((JDialog)jEWTDialog);
            }

            public String getConnectionName() {
                return string;
            }
        };
        RaptorTaskManager.getInstance().addTask(object);
    }

    private void processDialog(ActionSqlPanel actionSqlPanel, ObjectAction objectAction, String string, DBObject dBObject) throws ExecutionException {
        this.processDialog(null, actionSqlPanel, objectAction, string, dBObject);
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        ObjectAction objectAction = (ObjectAction)((Object)ideAction.getValue("ObjectAction.KEY"));
        if (objectAction != null) {
            DBObject dBObject = (DBObject)((Object)context.getProperty("ObjectAction.DBOBJECT"));
            if (dBObject == null && (dBObject = (DBObject)((Object)objectAction.getMenuItem().getClientProperty("ObjectAction.DBOBJECT"))) == null) {
                dBObject = new DBObject(context.getElement());
            }
            boolean bl2 = true;
            MetaClass<AbstractMenuAction> metaClass = objectAction.getMetaClass();
            if (metaClass != null) {
                try {
                    AbstractMenuAction abstractMenuAction = (AbstractMenuAction)metaClass.newInstance();
                    abstractMenuAction.setDBObject(dBObject);
                    abstractMenuAction.setContext(context);
                    abstractMenuAction.setArgs(objectAction.getClassArgs());
                    bl2 = abstractMenuAction.isEnabled(context);
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                }
            }
            boolean bl3 = objectAction.isValidForVersion(dBObject, ideAction);
            ideAction.setEnabled(bl2 && bl3);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDialog(ActionEvent actionEvent, ActionSqlPanel actionSqlPanel, ObjectAction objectAction, String string, DBObject dBObject) throws ExecutionException {
        block21: {
            if (this.validateValues(string, actionSqlPanel, objectAction)) {
                if (objectAction.getSqlType() != null && objectAction.getSqlType().equalsIgnoreCase("script")) {
                    ScriptUtils.runAsScript(new StringReader(actionSqlPanel.getScriptSQL().trim()), string);
                    this.postProcessAction(string, objectAction, actionSqlPanel.getDictionary(), actionSqlPanel.getPromptPanel().getValues(), dBObject);
                } else {
                    if (objectAction.isScript()) {
                        try {
                            this.processScript(objectAction, actionSqlPanel, dBObject);
                        }
                        catch (Exception exception) {
                            throw new ExecutionException(Messages.getString("ObjectActionController.99") + "\n" + objectAction.getScript(), exception);
                        }
                    }
                    Connections connections = Connections.getInstance();
                    try {
                        if (!connections.lock(string)) break block21;
                        DBUtil dBUtil = DBUtil.getInstance((String)string);
                        dBUtil.setRaiseError(false);
                        String string2 = actionSqlPanel.getSQLNoNewlines().trim();
                        PreparedStatement preparedStatement = dBUtil.prepareExecute(string2, actionSqlPanel.getBinds());
                        if (preparedStatement == null) {
                            SQLException sQLException = dBUtil.getLastException();
                            String string3 = Messages.getString("ObjectActionController.99") + "\n" + string2;
                            ExecutionException executionException = sQLException != null ? new ExecutionException(string3, sQLException) : new ExecutionException(new SQLException(string3));
                            throw executionException;
                        }
                        try {
                            preparedStatement.execute();
                            Log.log((String)string2);
                            if (actionEvent != null) {
                                ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                            }
                        }
                        catch (Exception exception) {
                            throw new ExecutionException(Messages.getString("ObjectActionController.99") + "\n" + string2, exception);
                        }
                        finally {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Exception exception) {
                                    Logger.ignore(this.getClass(), (Throwable)exception);
                                }
                                preparedStatement = null;
                            }
                        }
                    }
                    finally {
                        connections.unlock(string);
                    }
                }
            }
        }
    }

    private boolean validateValues(String string, ActionSqlPanel actionSqlPanel, ObjectAction objectAction) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = actionSqlPanel.getPromptPanel().getValues();
        ObjectActionPrompt objectActionPrompt = null;
        String string2 = null;
        Object[] objectArray = new Object[1];
        for (int i = 0; i < list.size(); ++i) {
            objectActionPrompt = (ObjectActionPrompt)((Object)objectAction.getPrompts().get(i));
            string2 = list.get(i);
            if (objectActionPrompt.getType().equals("confirm")) continue;
            if (objectActionPrompt.isRequired() && (string2 == null || string2.trim().length() == 0)) {
                stringBuilder.append(objectActionPrompt.getPrompt() + Messages.getString("ObjectActionController.10"));
                bl = false;
                continue;
            }
            if (objectActionPrompt.getValidator() == null) continue;
            IValidator iValidator = ValidatorRegistry.getValidator(objectActionPrompt.getValidator());
            ValidatableObject validatableObject = new ValidatableObject();
            validatableObject.putValue("value", string2);
            validatableObject.putValue("datatype", objectActionPrompt.getDataType());
            validatableObject.putValue("typeAttrib", objectActionPrompt.getTypeAttribute());
            int n = actionSqlPanel.getPromptPanel().getPromptIndex(Messages.getString("ObjectActionController.14"));
            if (n >= 0) {
                validatableObject.putValue(Messages.getString("ObjectActionController.15"), list.get(n));
            }
            if (iValidator.isValid(string, validatableObject)) continue;
            objectArray[0] = string2;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(Messages.getString("ObjectActionController.16"));
            }
            stringBuilder.append(MessageFormat.format(iValidator.getMessage(), objectArray));
            bl = false;
        }
        if (!bl) {
            MessageDialog.error((Component)actionSqlPanel, (Object)stringBuilder.toString(), (String)Messages.getString("ObjectActionController.17"), null);
        }
        return bl;
    }

    private void postProcessAction(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        if (_listeners != null) {
            if (objectAction.isRemoveFromParent()) {
                Iterator<IObjectActionListener> iterator = dBObject.getURL();
                String object = DBURLFormatHelper.getBaseType((URL)((Object)iterator));
                URL uRL = null;
                DBObject dBObject2 = null;
                if (_associatedDrops.containsKey(object)) {
                    uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL(((URL)((Object)iterator)).getProtocol(), DBURLFormatHelper.getConnectionName(iterator), DBURLFormatHelper.getCatalog(iterator), DBURLFormatHelper.getSchema(iterator), _associatedDrops.get(object)), DBURLFormatHelper.getName(iterator));
                    try {
                        Node node = NodeFactory.findOrCreate((URL)uRL);
                        dBObject2 = new DBObject((Element<?, ?>)node);
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                    }
                }
                for (IObjectActionListener iObjectActionListener : _listeners) {
                    if (dBObject2 != null) {
                        try {
                            iObjectActionListener.removedFromParent(string, objectAction, map, list, dBObject2);
                        }
                        catch (Exception exception) {
                            Logger.warn(this.getClass(), (Throwable)exception);
                        }
                    }
                    try {
                        iObjectActionListener.removedFromParent(string, objectAction, map, list, dBObject);
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                    }
                }
                if (dBObject2 != null) {
                    this.revertNode(dBObject2);
                }
                this.revertNode(dBObject);
                if (dBObject2 != null) {
                    EDITORS.removedFromParent(string, objectAction, map, list, dBObject2);
                }
                EDITORS.removedFromParent(string, objectAction, map, list, dBObject);
                if (iterator != null) {
                    NodeFactory.uncache(iterator);
                }
                if (uRL != null) {
                    NodeFactory.uncache((URL)uRL);
                }
            }
            if (objectAction.getReload()) {
                for (IObjectActionListener iObjectActionListener : _listeners) {
                    try {
                        iObjectActionListener.reload(string, objectAction, map, list, dBObject);
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                    }
                }
                EDITORS.reload(string, objectAction, map, list, dBObject);
            }
            if (objectAction.getReloadParent()) {
                for (IObjectActionListener iObjectActionListener : _listeners) {
                    try {
                        iObjectActionListener.reloadParent(string, objectAction, map, list, dBObject);
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                    }
                }
                EDITORS.reloadParent(string, objectAction, map, list, dBObject);
            }
        }
    }

    private void revertNode(DBObject dBObject) {
        Node node = dBObject.getNode();
        if (node != null && node.isDirty()) {
            try {
                node.revert();
            }
            catch (IOException iOException) {
                Logger.severe(this.getClass(), (Throwable)iOException);
            }
        }
    }

    public void processConfirm(ObjectAction objectAction, ActionSqlPanel actionSqlPanel, String string) {
        Object object;
        ActionSql actionSql = new ActionSql();
        String string2 = objectAction.getConfirmTitle();
        string2 = string2 == null ? Messages.getString("ObjectActionController.18") : ActionSql.manualSubstitute(string2, actionSqlPanel.getDictionary());
        String string3 = objectAction.getTitle() + Messages.getString("ObjectActionController.19");
        if (objectAction.getConfirm() != null && !objectAction.getConfirm().equals("")) {
            string3 = ActionSql.manualSubstitute(objectAction.getConfirm(), actionSqlPanel.getDictionary());
            string3 = actionSql.processPrompts(string3, actionSqlPanel.getPromptPanel().getTextValues(), objectAction.getDefaults());
            if (objectAction.getConfirmSql() != null && !objectAction.getConfirmSql().equals("")) {
                actionSql.setSql(objectAction.getConfirmSql());
                actionSql.setDict(actionSqlPanel.getDictionary());
                actionSql.processSql();
                object = DBUtil.getInstance((String)string).executeReturnMap(actionSql.getSql(), actionSql.getBinds());
                string3 = ActionSql.manualSubstitute(string3, object);
            }
        }
        if (((Boolean)(object = DBConfig.getInstance().getBoolean("CONFIRM_TO_LOG"))).booleanValue()) {
            LogManager logManager = LogManager.getLogManager();
            if (string3 != null) {
                logManager.getMsgPage().log((Object)(string2 + "\n\t" + string3));
            } else {
                logManager.getMsgPage().log((Object)string2);
            }
        } else {
            PropertyPanel propertyPanel = new PropertyPanel();
            propertyPanel.removeAll();
            propertyPanel.addSingleComp(string3);
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)propertyPanel, (String)string2, null, (int)1);
            this.setInitialDialogFocus(jEWTDialog);
            WizardLauncher.runDialog((JDialog)jEWTDialog);
        }
    }

    private void setInitialDialogFocus(JEWTDialog jEWTDialog) {
        Component component = jEWTDialog.getInitialFocus();
        if (null == component) {
            component = jEWTDialog.getContent();
        }
        if ((component = this.findFocusComponent(component)) != null) {
            jEWTDialog.setInitialFocus(component);
        }
        int n = jEWTDialog.getDefaultButton();
        int n2 = jEWTDialog.getButtonMask();
        if (0 == (n2 & n)) {
            for (int n3 : JEWT_BUTTONS) {
                if (0 == (n2 & n3)) continue;
                n = n3;
                break;
            }
        }
        jEWTDialog.setDefaultButton(0);
        jEWTDialog.setDefaultButton(n);
        if (null == component) {
            jEWTDialog.setInitialFocus(n);
        }
    }

    private Component findFocusComponent(Component component) {
        if (null == component) {
            return null;
        }
        Component component2 = null;
        if (component.isFocusable() && component.isEnabled()) {
            if (component instanceof JTextComponent) {
                if (((JTextComponent)component).isEditable()) {
                    component2 = component;
                }
            } else if (component instanceof ItemSelectable) {
                component2 = component;
            }
        }
        if (null == component2 && component instanceof Container) {
            Component component3;
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n && (component2 = this.findFocusComponent(component3 = componentArray[i])) == null; ++i) {
            }
        }
        return component2;
    }

    private void processScript(ObjectAction objectAction, ActionSqlPanel actionSqlPanel, DBObject dBObject) throws ScriptException, SQLException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByExtension(objectAction.getScriptLanguage());
        scriptEngine.put("conn", dBObject.getConnection());
        DBUtil dBUtil = DBUtil.getInstance((String)dBObject.getConnectionName());
        dBUtil.setRaiseError(false);
        scriptEngine.put("dbutil", dBUtil);
        Map<String, Object> map = dBObject.getDictionary();
        for (String object2 : map.keySet()) {
            scriptEngine.put(object2, map.get(object2));
            Logger.info(this.getClass(), (String)("Adding:" + object2));
        }
        scriptEngine.put("binds", dBObject.getDictionary());
        List<String> list = actionSqlPanel.getPromptPanel().getValues();
        for (ObjectActionPrompt objectActionPrompt : objectAction.getPrompts()) {
            int n = actionSqlPanel.getPromptPanel().getPromptIndex(objectActionPrompt.getPrompt());
            scriptEngine.put(objectActionPrompt.getPrompt(), list.get(n));
            scriptEngine.put("prompt" + n, list.get(n));
            Logger.info(this.getClass(), (String)("Adding:" + objectActionPrompt.getPrompt() + "=" + (String)list.get(n)));
        }
        scriptEngine.put("prompts", actionSqlPanel.getDictionary());
        scriptEngine.eval(objectAction.getScript());
        SQLException sQLException = dBUtil.getLastException();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public static ObjectActionPostProcess getPostProcessCallback(ObjectAction objectAction, DBObject dBObject) {
        ObjectActionPostProcess objectActionPostProcess = new ObjectActionPostProcess(objectAction);
        if (dBObject != null) {
            objectActionPostProcess.setAffectedObject(dBObject);
        }
        return objectActionPostProcess;
    }

    public static IRaptorTaskListener getRaptorTaskListener(ObjectActionPostProcess objectActionPostProcess) {
        return ObjectActionController.getRaptorTaskListener(objectActionPostProcess, false);
    }

    public static IRaptorTaskListener getRaptorTaskListener(ObjectActionPostProcess objectActionPostProcess, boolean bl) {
        assert (objectActionPostProcess != null);
        return new ObjectActionRaptorTaskAdapter(objectActionPostProcess, bl);
    }

    static {
        _associatedDrops = new HashMap<String, String>();
        _associatedDrops.put("MATERIALIZED VIEW", "TABLE");
        _associatedDrops.put("PACKAGE", "PACKAGE BODY");
        _associatedDrops.put("TYPE", "TYPE BODY");
        EDITORS = new EditorObjectActionListener();
        JEWT_BUTTONS = new int[]{8, 1, 2, 16};
    }

    public static class ObjectActionPostProcess
    implements Runnable {
        private ObjectAction _objectAction;
        private List<DBObject> _affectedObjects;
        private List<String> _values;

        public ObjectActionPostProcess(ObjectAction objectAction) {
            assert (objectAction != null);
            this._objectAction = objectAction;
        }

        public void setAffectedObjects(List<DBObject> list) {
            assert (list != null);
            this._affectedObjects = list;
        }

        public void setAffectedObject(DBObject dBObject) {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            arrayList.add(dBObject);
            this.setAffectedObjects(arrayList);
        }

        public void setValues(List<String> list) {
            this._values = list;
        }

        @Override
        public void run() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ObjectActionController objectActionController = (ObjectActionController)ObjectActionController.getInstance();
                    for (DBObject dBObject : _affectedObjects) {
                        try {
                            String string = dBObject.getConnectionName();
                            if (!Connections.getInstance().isConnectionOpen(string)) continue;
                            objectActionController.postProcessAction(dBObject.getConnectionName(), _objectAction, dBObject.getDictionary(), _values, dBObject);
                        }
                        catch (Exception exception) {
                            Logger.warn(this.getClass(), (Throwable)exception);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private static class ObjectActionRaptorTaskAdapter
    extends RaptorTaskAdapter {
        ObjectActionPostProcess _objectActionPostProcess;
        boolean _doRefreshOnFail;

        public ObjectActionRaptorTaskAdapter(ObjectActionPostProcess objectActionPostProcess, boolean bl) {
            assert (objectActionPostProcess != null);
            this._objectActionPostProcess = objectActionPostProcess;
            this._doRefreshOnFail = bl;
        }

        private void run() {
            this._objectActionPostProcess.run();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.run();
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            if (this._doRefreshOnFail) {
                this.run();
            }
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            if (this._doRefreshOnFail) {
                this.run();
            }
        }
    }

    static class EditorObjectActionListener
    implements IObjectActionListener {
        EditorObjectActionListener() {
        }

        @Override
        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }

        @Override
        public void reload(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            this.reload(dBObject, Filter.SELF_AND_ANCESTORS);
        }

        @Override
        public void reloadParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            URL uRL = dBObject.getURL();
            if (NodeFactory.find((URL)uRL) != null) {
                this.reload(dBObject, Filter.SELF_AND_ANCESTORS);
            } else {
                this.close(dBObject, Filter.SELF_AND_CHILDREN);
                this.reload(dBObject, Filter.ANCESTORS_ONLY);
            }
        }

        @Override
        public void removedFromParent(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
            this.close(dBObject, Filter.SELF_AND_CHILDREN);
            this.reload(dBObject, Filter.ANCESTORS_ONLY);
        }

        private void close(DBObject dBObject, Filter filter) {
            List<Editor> list = this.getEditors(dBObject, filter);
            this.info("Close ", list);
            EditorManager.getEditorManager().closeEditors(list);
        }

        private void reload(DBObject dBObject, Filter filter) {
        }

        private List<Editor> getEditors(DBObject dBObject, Filter filter) {
            List list = EditorManager.getEditorManager().getAllEditors();
            URL uRL = dBObject.getURL();
            ArrayList<Editor> arrayList = new ArrayList<Editor>();
            for (Editor editor : list) {
                try {
                    IViewerNode iViewerNode;
                    if (Boolean.TRUE.equals(editor.getEditorAttribute(ObjectActionController.IGNORE_REFRESH))) continue;
                    URL uRL2 = null;
                    Node node = editor.getContext().getNode();
                    if (node instanceof IViewerNode && null == (node = (iViewerNode = (IViewerNode)node).getBaseNode())) {
                        Element<?, ?> element = iViewerNode.getDBObject().getElement();
                        if (element instanceof Locatable) {
                            Locatable locatable = (Locatable)element;
                            uRL2 = locatable.getURL();
                        } else {
                            Logger.warn(this.getClass(), (String)("Unable to determine URL " + editor.getContext().toString()));
                        }
                    }
                    if (node != null) {
                        uRL2 = node.getURL();
                    }
                    if (!filter.accept(uRL, uRL2)) continue;
                    arrayList.add(editor);
                }
                catch (Exception exception) {
                    Logger.severe(this.getClass(), (Throwable)exception);
                }
            }
            return arrayList;
        }

        private void info(String string, List<Editor> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Editor editor : list) {
                arrayList.add(editor.getTabLabel());
            }
            Logger.info(this.getClass(), (String)(string + arrayList));
        }

        static enum Filter {
            SELF{

                @Override
                public boolean accept(URL uRL, URL uRL2) {
                    assert (uRL != null);
                    assert (uRL2 != null);
                    return ModelUtil.areEqual((Object)uRL.toString(), (Object)uRL2.toString());
                }
            }
            ,
            SELF_AND_ANCESTORS{

                @Override
                public boolean accept(URL uRL, URL uRL2) {
                    return SELF.accept(uRL, uRL2) || ANCESTORS_ONLY.accept(uRL, uRL2);
                }
            }
            ,
            SELF_AND_CHILDREN{

                @Override
                public boolean accept(URL uRL, URL uRL2) {
                    assert (uRL != null);
                    assert (uRL2 != null);
                    return SELF.accept(uRL, uRL2) || Filter.areRelated(uRL2, uRL);
                }
            }
            ,
            ANCESTORS_ONLY{

                @Override
                public boolean accept(URL uRL, URL uRL2) {
                    assert (uRL != null);
                    assert (uRL2 != null);
                    return ModelUtil.areDifferent((Object)uRL, (Object)uRL2) && Filter.areRelated(uRL, uRL2);
                }
            };


            public abstract boolean accept(URL var1, URL var2);

            private static boolean areRelated(URL uRL, URL uRL2) {
                int n = uRL2.toString().length();
                return uRL.toString().startsWith(uRL2.toString()) && ('/' == uRL.toString().charAt(n) || '#' == uRL.toString().charAt(n));
            }
        }
    }
}

