/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.util.Logger;
import org.stringtemplate.v4.ST;

public class ImportGenXTab
extends ImportGen
implements IImportGenerator {
    public static final String NAME = ImportDataFormat.METHOD_EXTERNAL_TABLE_NAME;
    public static final int TYPE = 2;
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private boolean _isValid = false;
    private int _loadMethod;
    private LoadFile _loadFile;

    public String getName() {
        return NAME;
    }

    public Integer getType() {
        return 2;
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel) {
        return this.start(importProperties, importGenModel, false);
    }

    @Override
    public boolean start(ImportProperties importProperties, ImportGenModel importGenModel, boolean bl) {
        if (importProperties == null || importGenModel == null) {
            return false;
        }
        this._iProps = importProperties;
        this._iGenModel = importGenModel;
        if (!this._iProps.getValueBoolean(ImportKeys.IS_BATCH).booleanValue()) {
            this._iGenModel.initELogger();
            this._iGenModel.eLogImportMessages();
        }
        super.start(importProperties, importGenModel, bl);
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        if (!this._iGenModel.isExitCodeSuccess()) {
            return false;
        }
        return this.validate();
    }

    public boolean validate() {
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        this._isValid = true;
        return true;
    }

    @Override
    public boolean process() {
        if (!this._isValid) {
            return false;
        }
        this._iGenModel.setExitCode(ExitCode.EXIT_SUCCESS);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DEFINE OFF\n");
        this._loadMethod = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        if (this._loadMethod == 3 && !this._iGenModel.isExistingTable()) {
            stringBuffer.append(this._iGenModel.getCreateTableStatementWithComments() + "\n\n");
        }
        stringBuffer.append(this.getExtCreateTableStatement() + "\n\n");
        if (this._loadMethod == 3) {
            stringBuffer.append(this.getInsertStatementFromStaging() + "\n\n");
        }
        String string = stringBuffer.toString();
        string = string.replaceAll("\\r", "");
        this._iGenModel.streamPrintln(string);
        Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.68"));
        if (!this._iGenModel.isBatch()) {
            Logger.info(this.getClass(), (String)Messages.getString("ImportGenerator.77"));
            try {
                this._iGenModel.eLogHref((URL)this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
                this._iGenModel.eLogException((Throwable)exception);
            }
        }
        this._iGenModel.eLogToolEnd();
        return this._iGenModel.isExitCodeSuccess();
    }

    private String getExtCreateTableStatement() {
        String string;
        String string2;
        String string3;
        Object object2;
        String string4 = this._iGenModel.getGenTable().getTable().getTablename();
        String string5 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        String[] stringArray = this.formatTableColumns(this._loadMethod == 3 && this._iGenModel.isExistingTable());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string6 : stringArray) {
            arrayList.add(string6.replaceAll("NOT NULL", ""));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object2 : this._iGenModel.getGenTable().getColumns()) {
            string3 = (String)this._iProps.get(ImportKeys.CHARNUMCHARACTERS);
            string2 = this._iGenModel.addDoubleQuote(object2.getName()) + " CHAR(4000)";
            if (string3 != null && string3 != "" && string3.replaceAll("[0-9]*", "").equals("")) {
                string2 = this._iGenModel.addDoubleQuote(object2.getName()) + " CHAR(" + string3 + ")";
            }
            if (object2.getType().equalsIgnoreCase("DATE")) {
                if (object2.getFormat() == null) {
                    arrayList2.add(string2 + " date_format DATE");
                    continue;
                }
                arrayList2.add(string2 + " date_format DATE mask \"" + object2.getFormat() + "\"");
                continue;
            }
            if (object2.getType().equalsIgnoreCase("TIMESTAMP")) {
                if (object2.getFormat() == null) {
                    arrayList2.add(string2 + " date_format TIMESTAMP");
                    continue;
                }
                arrayList2.add(string2 + " date_format TIMESTAMP mask \"" + object2.getFormat() + "\"");
                continue;
            }
            arrayList2.add(string2);
        }
        ST sT = this._iGenModel.getTemplateGroup().getInstanceOf("CreateExtTableStatement");
        sT.add("tableName", (Object)(this._loadMethod == 3 ? this._iGenModel.addUser(string5) : this._iGenModel.addUser(this._iGenModel.addDoubleQuote(string4))));
        sT.add("colList", (Object)arrayList.toArray());
        sT.add("nameList", (Object)arrayList2.toArray());
        String string7 = this._loadFile.getCanonicalName();
        string7 = string7.replaceFirst("^([a-zA-Z]:)([^\\\\])", "$1\\\\$2");
        String string8 = string7.substring(string7.lastIndexOf(File.separator) + 1);
        string7 = string7.substring(string7.lastIndexOf(File.separator) + 1, string7.lastIndexOf(46));
        sT.add("fileName", (Object)string7);
        sT.add("path", this._iProps.get(ImportKeys.DIRPATH));
        sT.add("dirName", (Object)((String)this._iProps.get(ImportKeys.ORADIRNAME)));
        object2 = "NOBADFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USEBADFILE).booleanValue()) {
            string3 = (String)this._iProps.get(ImportKeys.ORABADDIRNAME);
            if (string3 == null || string3.length() == 0) {
                string3 = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            object2 = "BADFILE " + string3 + ":'" + string7 + ".bad'";
        }
        sT.add("badClause", object2);
        string3 = "NOLOGFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USELOGFILE).booleanValue()) {
            string2 = (String)this._iProps.get(ImportKeys.ORALOGDIRNAME);
            if (string2 == null || string2.length() == 0) {
                string2 = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            string3 = "LOGFILE " + string2 + ":'" + string7 + ".log'";
        }
        sT.add("logClause", (Object)string3);
        string2 = "NODISCARDFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USEDISCARDFILE).booleanValue()) {
            string = (String)this._iProps.get(ImportKeys.ORADISCARDDIRNAME);
            if (string == null || string.length() == 0) {
                string = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            string2 = "DISCARDFILE " + string + ":'" + string7 + ".discard'";
        }
        sT.add("discardClause", (Object)string2);
        string = this._iGenModel.getDataFormat();
        String string9 = BaseDataFormat.singleQuote((String)BaseDataFormat.getDelimiterString((String)string.getDelimiter()));
        if (string9 == null || string9.equals("")) {
            string9 = "','";
        } else if (string9.equals("'WHITESPACE'")) {
            string9 = "WHITESPACE";
        }
        sT.add("fieldDelimiter", (Object)string9);
        Integer n = this._iGenModel.getDataFormat().isHeader() ? string.getSkipRows() + 1 : string.getSkipRows();
        sT.add("toSkip", (Object)n.toString());
        sT.add("allFile", (Object)string8);
        String string10 = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (!string10.equals("")) {
            string10 = "CHARACTERSET " + string10;
        }
        sT.add("charset", (Object)string10);
        String string11 = BaseDataFormat.singleQuote((String)BaseDataFormat.getRecordTerminatorString((String)string.getRecordTerminator()));
        sT.add("newline", (Object)string11);
        String string12 = string.getEnclosureLeftValue();
        String string13 = string.getEnclosureRightValue();
        String string14 = "";
        if (string12.length() != 0) {
            string14 = "OPTIONALLY ENCLOSED BY '" + string12 + "' AND '" + string13 + "'";
        }
        sT.add("enclosures", (Object)string14);
        if (this._iProps.get(ImportKeys.PREVIEW_LIMIT) == null) {
            sT.add("limit", (Object)"");
        } else {
            sT.add("limit", (Object)("WHERE ROWNUM <= " + (String)this._iProps.get(ImportKeys.PREVIEW_LIMIT)));
        }
        return sT.render();
    }

    private String getInsertStatementFromStaging() {
        String string = (String)this._iProps.get(ImportKeys.TABLE_NAME);
        String string2 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        ST sT = (ST)this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        String[] stringArray = new String[((Column[])sT).length];
        int n = 0;
        for (Column column : sT) {
            stringArray[n++] = this._iGenModel.addDoubleQuote(column.getName());
        }
        ST sT2 = null;
        sT2 = (Boolean)this._iProps.get(ImportKeys.DROP_STAGING_TABLE) != false ? this._iGenModel.getTemplateGroup().getInstanceOf("InsertStatementFromStagingWithDrop") : this._iGenModel.getTemplateGroup().getInstanceOf("InsertStatementFromStaging");
        sT2.add("tableName", (Object)this._iGenModel.addUser(this._iGenModel.addDoubleQuote(string)));
        sT2.add("stagingTableName", (Object)this._iGenModel.addUser(this._iGenModel.addDoubleQuote(string2)));
        sT2.add("colList", (Object)stringArray);
        int n2 = (Integer)this._iProps.get(ImportKeys.LOAD_LIMIT);
        if (n2 > 0) {
            String string3 = "WHERE ROWNUM <= " + n2;
            sT2.add("loadLimitClause", (Object)string3);
        }
        return sT2.render();
    }
}

