/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DatabaseCopyException;
import oracle.dbtools.raptor.databasecopy.IAutoRefresh;
import oracle.dbtools.raptor.databasecopy.Messages;
import oracle.dbtools.raptor.databasecopy.SchemasCopy;
import oracle.dbtools.raptor.databasecopy.TablespaceCopy;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.dialogs.databasecopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.extract.ExtractLogger;
import oracle.dbtools.raptor.extract.ExtractMessagePage;
import oracle.dbtools.raptor.extract.models.ExtractListModelHelper;
import oracle.dbtools.raptor.extract.models.ExtractObjectHelper;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public abstract class CopyAPI {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CopyAPI.class.getName());
    protected ExtractListModel m_listModel;
    protected Connection m_sourceConn;
    private Connection m_destinationConn;
    protected String m_destinationConnName;
    private String m_destinationSchemaName;
    private Version m_targetVersion;
    private IAutoRefresh _treeRefreshCallback;
    private Context context;
    private File m_file;
    private OutputStream m_fout;
    private BufferedOutputStream m_bout;
    protected OutputStreamWriter m_out;
    private boolean _suppressLogging = false;
    private String copyLogName;
    private String encoding = IdeUtil.getIdeEncoding();
    private String m_EOL;
    private RaptorTask<Void> m_task = null;
    private HashMap<String, Boolean> m_selectedOptions = new HashMap();
    protected boolean m_cancel;
    private boolean _isReconcileTypesAndObjects = true;
    private boolean m_isCopyDDL = false;
    private boolean m_isNotReplaceDest = false;
    private boolean m_isReplaceDest = false;
    private boolean m_isIgnoreStorage = false;
    private boolean m_isAppendDest = false;
    private boolean m_isSkipDest = false;
    private boolean m_isCopyData = false;
    private boolean m_isTruncateData = false;
    private boolean m_isMaintainSchemas = false;
    private boolean m_isConsolidateSchemas = false;
    private boolean m_isUseLogger = false;
    protected final int OBJECTS_DATACOPY = 0;
    protected final int MAINTAIN_SCHEMAS_DATACOPY = 1;
    protected final int CONSOLIDATE_SCHEMAS_DATACOPY = 2;
    protected final int SPATIAL_METACOPY = 4;
    private ArrayList<DBObject> _dndObjectList = new ArrayList();
    private RaptorTask<Void> databaseCopyTask = null;
    private ExtractLogger _eLogger;
    private String m_destTablespace = null;
    protected boolean m_ignoreAllErrors = false;

    public CopyAPI() {
    }

    public CopyAPI(HashMap<String, Boolean> hashMap) {
        this.m_selectedOptions = hashMap;
    }

    public void setExtractListModel(ExtractListModel extractListModel) {
        this.m_listModel = extractListModel;
        this.setSourceConnection(this.m_listModel.getSourceConn());
        this.setDestinationConnection(this.m_listModel.getDestConn());
        this.getSelectedOptions();
        this.openLog();
        this.setDDLFormat();
        this.setDataFormat();
    }

    protected void setSourceConnection(Connection connection) {
        this.m_sourceConn = connection;
    }

    protected void setDestinationConnection(Connection connection) {
        this.m_destinationConn = connection;
        this.m_destinationConnName = Connections.getInstance().getConnectionName(this.m_destinationConn);
    }

    public String getDestinationSchemaName() {
        return this.m_destinationSchemaName;
    }

    public void setDestinationSchemaName(String string) {
        this.m_destinationSchemaName = string;
    }

    protected void isReconcileTypesAndObjects(boolean bl) {
        this._isReconcileTypesAndObjects = bl;
    }

    public synchronized void startDatabaseCopyWithDialog(IAutoRefresh iAutoRefresh) {
        this._treeRefreshCallback = iAutoRefresh;
        this.startDatabaseCopyWithDialog();
    }

    public void startDatabaseCopyWithDialog() {
        this.databaseCopyTask = new RaptorTask<Void>(DatabaseCopyArb.getString("COPY_START"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){
            private volatile Thread m_execThread;

            public Void doWork() {
                this.m_execThread = Thread.currentThread();
                try {
                    int[] nArray;
                    if (CopyAPI.this.isCopyData()) {
                        int[] nArray2 = new int[3];
                        nArray2[0] = 103;
                        nArray2[1] = 100;
                        nArray = nArray2;
                        nArray2[2] = 101;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = 103;
                        nArray = nArray3;
                        nArray3[1] = 100;
                    }
                    int[] nArray4 = nArray;
                    CopyAPI.this.m_listModel.expandFolders(1, nArray4, CopyAPI.this.databaseCopyTask.getRaptorTaskProgressUpdater());
                    CopyAPI.this.m_listModel.reconcileDestFromSource();
                    if (CopyAPI.this.isSkipDest()) {
                        CopyAPI.this.removeSkipObjects();
                    }
                    if (!CopyAPI.this.isCopyDDL()) {
                        CopyAPI.this.removeNonExistingDataObjects();
                    }
                    if ((!CopyAPI.this.m_listModel.getList(0).isEmpty() || CopyAPI.this._isReconcileTypesAndObjects) && (CopyAPI.this.validatePermisions() || CopyAPI.this.getDestinationSchemaName() == null || CopyAPI.this.getDestinationSchemaName() != null && CopyAPI.this.getDestinationSchemaName().isEmpty())) {
                        if (CopyAPI.this._isReconcileTypesAndObjects) {
                            CopyAPI.this.m_listModel.startProcess(CopyAPI.this.databaseCopyTask.getRaptorTaskProgressUpdater());
                        } else if (CopyAPI.this.isReplaceDest()) {
                            CopyAPI.this.m_listModel.startProcessReconcileObjects(CopyAPI.this.databaseCopyTask.getRaptorTaskProgressUpdater());
                        } else {
                            CopyAPI.this.m_listModel.startProcessReconcileObjects(105, CopyAPI.this.databaseCopyTask.getRaptorTaskProgressUpdater());
                        }
                        CopyAPI.this.m_listModel.reconcileDestFromSource();
                        this.checkCanProceed();
                        CopyAPI.this.startDatabaseCopy();
                    }
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    this.getDescriptor().setMessage(CopyPanelArb.getString("QUERY_CANCELLED"));
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                    CopyAPI.this.eLogException(executionException);
                    CopyAPI.this.initObjectFilters(null, false);
                    CopyAPI.this._treeRefreshCallback = null;
                }
                finally {
                    this.m_execThread = null;
                }
                return null;
            }

            public boolean cancel() {
                Thread thread = this.m_execThread;
                if (thread != null) {
                    DBUtil.cancelExecution((Thread)thread);
                    CopyAPI.this.m_cancel = true;
                    return true;
                }
                return false;
            }
        };
        this.databaseCopyTask.setCancellable(true);
        this.databaseCopyTask.setPausable(false);
        RaptorTaskDescriptor raptorTaskDescriptor = this.databaseCopyTask.getDescriptor();
        raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CopyAPI.this.cleanup();
                        try {
                            CopyAPI.this.eLogHref(new File(CopyAPI.this.copyLogName).toURI().toURL());
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            CopyAPI.this.eLogException(exception);
                        }
                        CopyAPI.this.eLogToolEnd();
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CopyAPI.this.cleanup();
                        CopyAPI.this.eLog(CopyWizArb.getString("COPY_CANCEL"));
                        CopyAPI.this.eLogToolEnd();
                    }
                });
            }
        });
        this.m_task = this.databaseCopyTask;
        RaptorTaskManager.getInstance().addTask(this.databaseCopyTask);
    }

    protected void startDatabaseCopy() {
        if (this.isCopyDDL() && !this.isCopyData()) {
            this.databaseCopyDDLOnly();
            return;
        }
        if (this.isCopyDDL()) {
            this.databaseCopyDDL();
        }
        if (this.isCopyData() && !this.m_cancel) {
            this.databaseCopyData();
        }
    }

    protected void endDatabaseCopy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        BasicDBObject basicDBObject;
        ExtractObject extractObject;
        ObjectAction objectAction;
        this.endDatabaseCopy();
        this.closeLog();
        if (this._treeRefreshCallback != null) {
            this._treeRefreshCallback.refresh();
        } else {
            objectAction = new ObjectAction();
            objectAction.setReloadParent(true);
            objectAction.setReload(true);
            extractObject = this.m_listModel.getFirstExtractObject();
            if (extractObject != null && (basicDBObject = extractObject.getDBObject()) != null) {
                URL uRL = DBURLFormatHelper.getURL("sqldev.nav", this.m_listModel.getDestConnName(), null, this.m_destinationSchemaName == null ? this.m_listModel.getDestConnUser() : this.m_destinationSchemaName, basicDBObject.getObjectType());
                DBObject dBObject = new DBObject(uRL);
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
                objectActionPostProcess.run();
            }
        }
        try {
            if (!this._suppressLogging) {
                objectAction = new TextNode(URLFactory.newFileURL((File)this.m_file));
                this.context = Context.newIdeContext((Node)objectAction);
                extractObject = new OpenEditorOptions(this.context);
                extractObject.setFlags(1);
                basicDBObject = EditorManager.getEditorManager().openEditor((OpenEditorOptions)extractObject);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this.eLogException(exception);
        }
        finally {
            this._treeRefreshCallback = null;
            this.initObjectFilters(null, false);
        }
    }

    protected void databaseCopyDDLOnly() {
        if (this.isReplaceDest()) {
            this.getExtractListAndExecuteDDL(4, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(2, 0, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
            if (this.m_isMaintainSchemas) {
                this.getExtractListAndCopyData(12, this.getSourceConn(), this.getDestinationConn(), 4);
            } else {
                this.getExtractListAndCopyData(14, this.getSourceConn(), this.getDestinationConn(), 4);
            }
        } else {
            this.getExtractListAndExecuteDDL(2, 105, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(3, 105, this.getDestinationConn());
            if (this.m_isMaintainSchemas) {
                this.getExtractListAndCopyData(13, this.getSourceConn(), this.getDestinationConn(), 4);
            } else {
                this.getExtractListAndCopyData(15, this.getSourceConn(), this.getDestinationConn(), 4);
            }
        }
    }

    protected void databaseCopyDDL() {
        if (this.isReplaceDest()) {
            this.getExtractListAndExecuteDDL(4, 104, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(2, 0, this.getDestinationConn());
            if (this.m_isMaintainSchemas) {
                this.getExtractListAndCopyData(12, this.getSourceConn(), this.getDestinationConn(), 4);
            } else {
                this.getExtractListAndCopyData(14, this.getSourceConn(), this.getDestinationConn(), 4);
            }
        } else {
            this.getExtractListAndExecuteDDL(2, 105, this.getDestinationConn());
            if (this.m_isMaintainSchemas) {
                this.getExtractListAndCopyData(13, this.getSourceConn(), this.getDestinationConn(), 4);
            } else {
                this.getExtractListAndCopyData(15, this.getSourceConn(), this.getDestinationConn(), 4);
            }
        }
    }

    public abstract void databaseCopyData();

    private void getSelectedOptions() {
        if (this.m_selectedOptions.get("DATABASE_COPY_DDL_ENABLED") != null) {
            this.m_isCopyDDL = this.m_selectedOptions.get("DATABASE_COPY_DDL_ENABLED");
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_NOT_REPLACE") != null) {
            this.m_isNotReplaceDest = this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_NOT_REPLACE");
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_DDL_IGNORE_STORAGE") != null) {
            this.m_isIgnoreStorage = this.m_selectedOptions.get("DATABASE_COPY_DDL_IGNORE_STORAGE");
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_REPLACE") != null) {
            this.m_isReplaceDest = this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_REPLACE");
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_SKIP") != null) {
            this.m_isSkipDest = this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_SKIP");
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_SCHEMAS_COPY") != null && this.m_selectedOptions.get("DATABASE_COPY_SCHEMAS_COPY").booleanValue()) {
            if (this.m_selectedOptions.get("MAINTAIN_SCHEMAS") != null) {
                this.m_isMaintainSchemas = this.m_selectedOptions.get("MAINTAIN_SCHEMAS");
            }
            if (this.m_selectedOptions.get("CONSOLIDATE_SCHEMA") != null) {
                this.m_isConsolidateSchemas = this.m_selectedOptions.get("CONSOLIDATE_SCHEMA");
            }
        } else {
            this.m_isConsolidateSchemas = true;
            this.m_isMaintainSchemas = false;
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_DATA_ENABLED") != null) {
            this.m_isCopyData = this.m_selectedOptions.get("DATABASE_COPY_DATA_ENABLED");
        }
        if (this.m_selectedOptions.get("DATABASE_COPY_DATA_TRUNCATE_ENABLED") != null) {
            this.m_isTruncateData = this.m_selectedOptions.get("DATABASE_COPY_DATA_TRUNCATE_ENABLED");
        }
    }

    public synchronized void initObjectFilters(ArrayList<DatabaseNode> arrayList, boolean bl) {
        DBObject dBObject = null;
        this._dndObjectList.clear();
        this._suppressLogging = bl;
        if (arrayList != null) {
            for (DatabaseNode databaseNode : arrayList) {
                dBObject = databaseNode instanceof ObjectNode ? new DBObject((Element)((ObjectNode)databaseNode).getData()) : (databaseNode instanceof PlSqlNode ? new DBObject((Element)((PlSqlNode)databaseNode).getData()) : null);
                if (dBObject == null) continue;
                this._dndObjectList.add(dBObject);
            }
        }
    }

    protected boolean compareSourceAndDesintationVersions(Connection connection, Connection connection2) {
        if (connection == null || connection2 == null) {
            return false;
        }
        Version version = RaptorVersionTracker.getDbVersion(connection);
        if (this.m_targetVersion.compareTo(version) < 0) {
            this.lineStart();
            this.log(MessageFormat.format(CopyPanelArb.getString("NO_SEGMENT_CLAUSE_MSG"), this.m_targetVersion.toString(), version.toString()) + this.getTerm());
            this.lineEnd();
            return false;
        }
        return true;
    }

    protected void setDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat();
        dDLFormat.setPretty(false);
        dDLFormat.setSchema(false);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setCascade(true);
        dDLFormat.setDrop(true);
        dDLFormat.setAlter(false);
        dDLFormat.isExtractEnabled(this.isCopyDDL());
        boolean bl = false;
        if (this.m_destinationConn != null) {
            this.m_targetVersion = RaptorVersionTracker.getDbVersion(this.m_destinationConn);
        }
        boolean bl2 = bl = !this.compareSourceAndDesintationVersions(this.m_sourceConn, this.m_destinationConn);
        if (bl) {
            dDLFormat.setVersion(this.m_targetVersion.toString());
            dDLFormat.setSegments(false);
            dDLFormat.setPartitioning(false);
            dDLFormat.setTablespace(false);
        } else {
            dDLFormat.setSegments(!this.m_isIgnoreStorage);
            dDLFormat.setPartitioning(!this.m_isIgnoreStorage);
            dDLFormat.setTablespace(!this.m_isIgnoreStorage);
        }
        this.m_listModel.setDDLFormat(dDLFormat);
    }

    protected void setDataFormat() {
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD);
        extractDataFormat.setFormat(BaseDataFormat.COPY);
        extractDataFormat.isExportEnabled(true);
        this.m_listModel.setDataFormat(extractDataFormat);
    }

    protected void removeSkipObjects() {
        List list = null;
        list = this.m_listModel.getList(0, new int[]{104});
        boolean bl = false;
        for (ExtractObject extractObject : list) {
            if (!bl) {
                this.lineStart();
                bl = true;
            }
            String string = DatabaseCopyArb.getString("SKIPPING_OBJ") + " " + extractObject.getDBObject().getObjectName();
            this.setProg(string);
            this.m_listModel.removeExtractObject(extractObject);
            this.log(string);
        }
        if (bl) {
            this.lineEnd();
        }
    }

    protected void removeNonExistingDataObjects() {
        List list = null;
        list = this.m_listModel.getList(0, new int[]{105});
        boolean bl = false;
        for (ExtractObject extractObject : list) {
            if (!bl) {
                this.lineStart();
                bl = true;
            }
            String string = DatabaseCopyArb.getString("SKIPPING_OBJ") + " " + extractObject.getDBObject().getObjectName();
            this.setProg(string);
            this.m_listModel.removeExtractObject(extractObject);
            this.log(string);
        }
        if (bl) {
            this.lineEnd();
        }
    }

    protected boolean validatePermisions() {
        List list = null;
        if (!this.m_isCopyDDL) {
            return true;
        }
        String string = DatabaseCopyArb.getString("VALIDATING_PERMISSIONS");
        this.setProg(string);
        boolean bl = false;
        Connection connection = null;
        DBUtil dBUtil = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        list = this.m_listModel.getList(1);
        for (ExtractObject extractObject : list) {
            if (extractObject.getDBObject().getSchemaName().equals(extractObject.getSourceConnUser(false))) continue;
            String string2 = (String)hashMap.get(extractObject.getSourceConnName());
            if (string2 != null && string2.equals("F")) {
                bl = this.handleNotPermitted(extractObject, bl);
                continue;
            }
            if (connection != extractObject.getSourceConn()) {
                connection = extractObject.getSourceConn();
                dBUtil = DBUtil.getInstance((Connection)connection);
            }
            if (!this.queryPermission(dBUtil)) {
                bl = this.handleNotPermitted(extractObject, bl);
                continue;
            }
            hashMap.put(extractObject.getSourceConnName(), "Y");
        }
        if (bl) {
            this.lineEnd();
        }
        return !this.m_listModel.getList(0).isEmpty();
    }

    private boolean handleNotPermitted(ExtractObject extractObject, boolean bl) {
        String string = DatabaseCopyArb.format("NOT_PERMITTED", Connections.getDisplayName(extractObject.getSourceConnName()), extractObject.getDBObject().getSchemaName(), extractObject.getDBObject().getObjectName());
        if (!extractObject.isExistsDest()) {
            this.m_listModel.removeExtractObject(extractObject);
            if (!bl) {
                this.lineStart();
                bl = true;
            }
            this.log(string);
            this.log(DatabaseCopyArb.getString("NOT_PERMITTED2") + this.getTerm());
        } else if (this.m_isReplaceDest) {
            this.m_listModel.removeExtractObject(extractObject);
            if (!bl) {
                this.lineStart();
                bl = true;
            }
            this.log(string);
            this.log(DatabaseCopyArb.getString("NOT_PERMITTED2") + this.getTerm());
        }
        return bl;
    }

    protected void removeTypes() {
        List list = null;
        list = this.m_listModel.getList(0, new int[]{104});
        for (String string : this.m_listModel.getDDLTypes().getTypeList()) {
            if (!this.m_listModel.getListForType(list, string).isEmpty()) continue;
            this.m_listModel.getDDLTypes().setTypeState(string, false);
        }
        this.removeTypes();
    }

    protected void getExtractListAndExecuteDDL(int n, int n2, Connection connection) {
        List list = null;
        list = n2 == 0 ? this.m_listModel.getList(n) : this.m_listModel.getList(n, new int[]{n2});
        boolean bl = false;
        try {
            for (ExtractObject extractObject : list) {
                if (!bl) {
                    this.lineStart();
                    bl = true;
                }
                this.checkCancelled();
                this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + extractObject.getDBObject().getObjectName());
                if (this.executeSql(extractObject.getDDL(n, ExtractObject.COPY_DDL), connection)) continue;
                String string = CopyPanelArb.format("DDL_ERROR_OBJECT", extractObject.getDBObject().getObjectType(), extractObject.getDBObject().getObjectName()) + this.getTerm();
                if (this.m_ignoreAllErrors) continue;
                DatabaseCopyException databaseCopyException = new DatabaseCopyException();
                int n3 = 0;
                try {
                    n3 = databaseCopyException.askContinueOnError(string + CopyPanelArb.getString("DBCOPY_PROGRESS_CONTINUE"));
                    if (n3 == 2) {
                        this.cancel();
                        continue;
                    }
                    if (n3 == 1) {
                        this.m_ignoreAllErrors = true;
                        continue;
                    }
                    this.m_ignoreAllErrors = false;
                }
                catch (Throwable throwable) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                    this.eLogException(throwable);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this.eLogException(exception);
        }
        if (bl) {
            this.lineEnd();
        }
    }

    protected void getExtractListAndCopyData(int n, Connection connection, Connection connection2, int n2) {
        Object var5_5 = null;
        String string = null;
        boolean bl = false;
        List list = null;
        if (n == 12 || n == 13 || n == 14 || n == 15) {
            list = this.m_listModel.getList(n);
            bl = true;
        } else {
            list = this.m_listModel.getList(n, new int[]{103});
        }
        boolean bl2 = false;
        String string2 = null;
        DataMover dataMover = null;
        if (connection != null) {
            dataMover = new DataMover(connection, connection2, this.m_ignoreAllErrors);
            dataMover.setLogFile(this.m_out);
        }
        try {
            for (ExtractObject extractObject : list) {
                BasicDBObject basicDBObject;
                this.checkCancelled();
                if (connection == null) {
                    dataMover = new DataMover(extractObject.getSourceConn(), connection2, this.m_ignoreAllErrors);
                    dataMover.setLogFile(this.m_out);
                }
                if ((basicDBObject = extractObject.getDBObject()).getObjectType().equalsIgnoreCase("VIEW")) continue;
                this.setProg(DatabaseCopyArb.getString("MOVING_DATA") + " " + basicDBObject.getObjectName());
                if (!bl2) {
                    this.lineStart();
                    bl2 = true;
                }
                this.log(CopyPanelArb.getString("MOVING_DATA_MESSAGE") + basicDBObject.getObjectName());
                String string3 = null;
                boolean bl3 = true;
                if (bl) {
                    URL uRL;
                    URL uRL2;
                    DBObject dBObject;
                    if (((String)extractObject.getPropertyValue("KEY_SPATIAL_DEST_TABLE")).equals("MDSYS.SDO_GEOM_METADATA_TABLE") && !ExtractReconciler.isExistsObject((Connection)connection2, (BasicDBObject)(dBObject = new DBObject(uRL2 = DBURLFormatHelper.getURL(uRL = DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(connection2), null, "MDSYS", "TABLE"), "SDO_GEOM_METADATA_TABLE"))))) {
                        bl3 = false;
                        this.log(CopyPanelArb.format("SPATIAL_META_ERROR", extractObject.getDBObject().getSchemaName()));
                    }
                    if (bl3) {
                        string2 = "where " + extractObject.getWhere();
                        string2 = string2 + (String)extractObject.getPropertyValue("SPATIAL_SOURCE_SCHEMA_WHERE");
                        string = (String)extractObject.getPropertyValue("SPATIAL_DEST_DELETE");
                        string3 = (String)extractObject.getPropertyValue("SPATIAL_DEST_INSERT");
                    }
                } else {
                    string2 = extractObject.getFinalWhere();
                }
                if (bl3 && !dataMover.move(basicDBObject, extractObject.getColumns(), string3, string2, string, n2, true)) {
                    this.cancel();
                    this.checkCancelled();
                    break;
                }
                this.lineEnd();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            this.eLogException(exception);
        }
    }

    protected boolean executeSql(String string, Connection connection) {
        try {
            this.log(string + this.getTerm());
            String string2 = ScriptRunnerContext.getOutputEncoding();
            StringReader stringReader = new StringReader(string);
            ScriptExecutor scriptExecutor = new ScriptExecutor((Reader)stringReader, connection);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)true);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            scriptExecutor.setOut(bufferedOutputStream);
            scriptExecutor.run();
            bufferedOutputStream.flush();
            this.log(byteArrayOutputStream.toString(string2));
            return (Boolean)scriptRunnerContext.getProperty("sqldev.error.any.in") == false;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            this.eLogException(exception);
            return true;
        }
    }

    protected String getTerm() {
        if (this.m_EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this.m_EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this.m_EOL;
    }

    protected void setProg(String string) {
        RaptorTaskDescriptor raptorTaskDescriptor = null;
        if (this.m_task != null) {
            raptorTaskDescriptor = this.m_task.getDescriptor();
            raptorTaskDescriptor.setMessage(string);
        }
    }

    protected IRaptorTaskProgressUpdater getProgressUpdater() {
        IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater = null;
        if (this.m_task != null) {
            iRaptorTaskProgressUpdater = this.m_task.getRaptorTaskProgressUpdater();
        }
        return iRaptorTaskProgressUpdater;
    }

    public void cancel() {
        this.m_cancel = true;
    }

    protected void openLog() {
        if (!this._suppressLogging) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
                StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
                this.copyLogName = Ide.getUserSettingsDirectory() + "DatabaseCopy." + stringBuilder + ".log";
                this.m_file = new File(this.copyLogName);
                this.m_fout = new FileOutputStream(this.m_file.getPath());
                this.m_bout = new BufferedOutputStream(this.m_fout);
                this.m_out = new OutputStreamWriter((OutputStream)this.m_bout, this.encoding);
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)CopyPanelArb.getString("FILE_CREATION_ERROR"), (String)(this.m_file.getPath() + this.m_file.getName()), null);
            }
        }
    }

    protected void lineStart() {
        try {
            if (this.m_out != null) {
                this.m_out.write(Messages.getString("CopyAPI.169") + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("CopyAPI.169"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.eLogException(iOException);
        }
    }

    protected void lineEnd() {
        try {
            if (this.m_out != null) {
                this.m_out.write(Messages.getString("CopyAPI.170") + this.getTerm() + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("CopyAPI.170"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.eLogException(iOException);
        }
    }

    protected void lineError() {
        try {
            if (this.m_out != null) {
                this.m_out.write(Messages.getString("CopyAPI.171") + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("CopyAPI.171"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.eLogException(iOException);
        }
    }

    protected void log(String string) {
        try {
            if (this.m_out != null) {
                this.m_out.write(string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()));
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, string);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.eLogException(iOException);
        }
    }

    protected void flushLog() {
        try {
            if (this.m_out != null) {
                this.m_out.flush();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.eLogException(iOException);
        }
    }

    protected void closeLog() {
        try {
            if (this.m_out != null) {
                this.m_out.flush();
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.eLogException(iOException);
        }
    }

    protected OutputStream getLogStream() {
        return this.m_fout;
    }

    protected boolean checkDBObjectExists(DBObject dBObject, DBUtil dBUtil) {
        boolean bl = false;
        String string = "select table_name from user_tables where table_name = :TABLE_NAME";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE_NAME", dBObject.getObjectName());
        String string2 = dBUtil.executeOracleReturnOneCol(string, hashMap);
        if (string2 != null) {
            bl = true;
        }
        return bl;
    }

    public void setDatabaseCopy() {
        this.initELogger();
        String string = CopyPanelArb.getString("OBJECTS_COPY");
        if (this instanceof SchemasCopy) {
            string = CopyPanelArb.getString("SCHEMAS_COPY");
        } else if (this instanceof TablespaceCopy) {
            string = CopyPanelArb.getString("TABLESPACE_COPY");
        }
        String string2 = CopyPanelArb.getString("OPTION") + " " + string;
        this.log(string2);
        this.eLog(string2);
        string2 = CopyPanelArb.getString("SELECTED_SOURCE") + " " + Connections.getDisplayName(this.m_listModel.getSourceConnName());
        this.log(string2);
        this.eLog(string2);
        string2 = this.getDestinationSchemaName() == null ? CopyPanelArb.getString("SELECTED_DEST") + " " + Connections.getDisplayName(this.m_listModel.getDestConnName()) : CopyPanelArb.getString("SELECTED_DEST") + " " + Connections.getDisplayName(this.m_listModel.getDestConnName()) + "." + this.getDestinationSchemaName();
        this.log(string2);
        this.eLog(string2);
        this.logMetaObjects();
        this.logDataObjects();
        this.log(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DDL_OPTION")) + ": " + (this.isCopyDDL() ? CopyPanelArb.getString("YES") : CopyPanelArb.getString("NO")));
        if (this.isCopyDDL()) {
            this.log(this.isReplaceDest() ? CopyPanelArb.getString("REPLACE") : CopyPanelArb.getString("DO_NOT_REPLACE") + " " + CopyPanelArb.getString("EXISTING_OBJECTS"));
            this.log(this.isIgnoreStorage() ? CopyWizArb.getString("IGNORE_STORAGE") : CopyWizArb.getString("INCLUDE_STORAGE"));
        }
        this.log(MnemonicUtil.extractLabelTextWithoutMnemonic(CopyWizArb.getString("COPY_DATA_OPTION")) + ": " + (this.isCopyData() ? CopyPanelArb.getString("YES") : CopyPanelArb.getString("NO")));
        if (this.isCopyData() && !this.isReplaceDest()) {
            String string3 = CopyPanelArb.getString("APPEND");
            if (this.isAppendDest()) {
                string3 = CopyPanelArb.getString("APPEND");
            }
            if (this.isTruncateData()) {
                string3 = CopyPanelArb.getString("TRUNCATE");
            }
            this.log(string3 + " " + CopyPanelArb.getString("EXISTING_OBJECTS"));
        }
    }

    protected void eLog(String string) {
        if (this._eLogger != null) {
            this._eLogger.log(string);
        }
    }

    protected void eLogException(Throwable throwable) {
        if (throwable != null && this._eLogger != null) {
            this._eLogger.logException(throwable);
        }
    }

    protected void eLogHref(URL uRL) {
        if (uRL != null && this._eLogger != null) {
            this._eLogger.logHref(uRL);
        }
    }

    protected void eLogToolEnd() {
        if (this._eLogger != null) {
            this._eLogger.logToolEnd();
        }
    }

    protected void initELogger() {
        this._eLogger = new ExtractLogger(ExtractMessagePage.EXTRACT_VIEW_ID);
        this._eLogger.logToolStart(this.getELoggerName());
    }

    protected ExtractLogger getELogger() {
        return this._eLogger;
    }

    protected String getELoggerName() {
        return CopyWizArb.getString("COPY_TOOL");
    }

    private void logMetaObjects() {
        List list = this.m_listModel.getList(0, new int[]{108});
        List list2 = this.m_listModel.getDDLTypes().getTypeList();
        boolean bl = false;
        for (String string : list2) {
            if (!bl) {
                this.log(CopyPanelArb.getString("DDL_OBJS"));
                bl = true;
            }
            this.log(DDLTypes.getFolderName((String)string));
            this.logMetaObjectsForType(list, string, false);
        }
    }

    private void logMetaObjectsForType(List<ExtractObject> list, String string, boolean bl) {
        block6: {
            List list2;
            block5: {
                List list3 = this.m_listModel.getListForType(list, "TABLE");
                list2 = this.m_listModel.getListForType(list, string);
                if (list2.size() >= 1) break block5;
                if (list3.isEmpty()) break block6;
                if (string == "CONSTRAINT" || string == "REFCONSTRAINT" || string == "INDEX" || string == "TRIGGER") {
                    for (ExtractObject extractObject : list3) {
                        String string2 = extractObject.getSourceConnName();
                        BasicDBObject basicDBObject = this.m_listModel.getDBObject(extractObject.getUrl());
                        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, basicDBObject.getSchemaName(), string);
                        URL uRL2 = DBURLFormatHelper.getURL(uRL, basicDBObject.getObjectName());
                        DBObject dBObject = new DBObject(uRL2);
                        DBObject dBObject2 = new DBObject(extractObject.getDBObject().getURL());
                        if (dBObject2.getElement() != null && dBObject2.getElement() instanceof ObjectFolder) {
                            this.log(ExtractResources.format((String)"FOR_ALL_FOLDER", (Object[])new Object[]{DDLTypes.getFolderName((String)string), DDLTypes.getFolderName((String)dBObject2.getObjectFolderType()), Connections.getDisplayName(dBObject2.getConnectionName()) + "." + dBObject2.getSchemaName()}));
                            continue;
                        }
                        this.log(ExtractResources.format((String)"FOR", (Object[])new Object[]{DDLTypes.getFolderName((String)string), extractObject.getDisplayName(bl)}));
                    }
                } else {
                    this.log(ExtractListModelHelper.getAllObjectsString(string));
                }
                break block6;
            }
            for (ExtractObject extractObject : list2) {
                this.log(ExtractObjectHelper.getLabel(extractObject, bl).getText());
            }
        }
    }

    private void logDataObjects() {
        List list = this.m_listModel.getDDLTypes().getTypeListForData(false);
        boolean bl = false;
        for (String string : list) {
            if (!bl) {
                this.log(CopyPanelArb.getString("DATA_OBJS"));
                bl = true;
            }
            this.log(DDLTypes.getFolderName((String)string));
            this.logDataObjectsByType(string);
        }
    }

    private void logDataObjectsByType(String string) {
        List list = this.m_listModel.getList(0, new int[]{109});
        List list2 = this.m_listModel.getListForType(list, string);
        if (list2.size() < 1) {
            this.log(ExtractResources.getString((String)"ALL") + " " + DDLTypes.getFolderName((String)string));
        } else {
            for (ExtractObject extractObject : list2) {
                this.log(ExtractObjectHelper.getLabel(extractObject).getText());
                if (extractObject.getWhere().length() <= 0) continue;
                this.log(ExtractResources.getString((String)"EO_PRED_OBJ_WHERE") + " " + extractObject.getWhere());
            }
        }
    }

    protected boolean queryPermission(DBUtil dBUtil) {
        boolean bl = false;
        String string = "select 1 from sys.dba_tables where rownum = 1";
        HashMap hashMap = new HashMap();
        String string2 = dBUtil.executeOracleReturnOneCol(string, hashMap);
        if (string2 != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isCopyDDL() {
        return this.m_isCopyDDL;
    }

    public void isCopyDDL(boolean bl) {
        this.m_isCopyDDL = bl;
    }

    public boolean isNotReplaceDest() {
        return this.m_isNotReplaceDest;
    }

    public void isNotReplaceDest(boolean bl) {
        this.m_isNotReplaceDest = bl;
    }

    public boolean isReplaceDest() {
        return this.m_isReplaceDest;
    }

    public void isReplaceDest(boolean bl) {
        this.m_isReplaceDest = bl;
    }

    public boolean isIgnoreStorage() {
        return this.m_isIgnoreStorage;
    }

    public void isIgnoreStorage(boolean bl) {
        this.m_isIgnoreStorage = bl;
    }

    public boolean isAppendDest() {
        return this.m_isAppendDest;
    }

    public void isAppendDest(boolean bl) {
        this.m_isAppendDest = bl;
    }

    public boolean isSkipDest() {
        return this.m_isSkipDest;
    }

    public void isSkipDest(boolean bl) {
        this.m_isSkipDest = bl;
    }

    public boolean isCopyData() {
        return this.m_isCopyData;
    }

    public void isCopyData(boolean bl) {
        this.m_isCopyData = bl;
    }

    public boolean isTruncateData() {
        return this.m_isTruncateData;
    }

    public void isTruncateData(boolean bl) {
        this.m_isTruncateData = bl;
    }

    protected Connection getSourceConn() {
        return this.m_sourceConn;
    }

    protected Connection getDestinationConn() {
        return this.m_destinationConn;
    }

    protected void setSourceConn(Connection connection) {
        this.m_sourceConn = connection;
    }

    protected void setDestinationConn(Connection connection) {
        this.m_destinationConn = connection;
    }

    protected Version getDestVersion() {
        return this.m_targetVersion;
    }

    protected void setDestVersion(Version version) {
        this.m_targetVersion = version;
    }

    protected ExtractListModel getExtractListModel() {
        return this.m_listModel;
    }

    protected boolean isMaintainSchemas() {
        return this.m_isMaintainSchemas;
    }

    protected void isMaintainSchemas(boolean bl) {
        this.m_isMaintainSchemas = bl;
        this.m_isConsolidateSchemas = !bl;
    }

    protected boolean isConsolidateSchemas() {
        return this.m_isConsolidateSchemas;
    }

    public void isUseLogger(boolean bl) {
        this.m_isUseLogger = bl;
    }

    protected void checkCancelled() throws InterruptedException {
        if (Thread.interrupted() || this.m_cancel) {
            try {
                this.m_destinationConn.rollback();
            }
            catch (SQLException sQLException) {
                LOGGER.severe(CopyPanelArb.getString("NO_ROLLBACK"));
                this.eLogException(sQLException);
            }
        }
    }

    public void setDestinationTablespace(String string) {
        this.m_destTablespace = string;
    }

    public String getDestinationTablespaceString() {
        return " TABLESPACE \"" + this.m_destTablespace + "\"";
    }

    public BufferedOutputStream getBufferedOutputStream() {
        return this.m_bout;
    }

    public RaptorTask<Void> getCopyTask() {
        return this.databaseCopyTask;
    }

    public OutputStreamWriter getOutputStreamWriter() {
        return this.m_out;
    }
}

