/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatools.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Vector;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.datatools.DataToolsResources;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.readers.IImportFormatOptions;
import oracle.dbtools.raptor.format.CopyFormatter;
import oracle.dbtools.raptor.format.DataPumpFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;

public abstract class BaseDataFormat {
    public static int EXPORT_PREFERENCES = 0;
    public static int EXPORT_WIZARD = 1;
    public static int CART = 3;
    public static int IMPORT_PREFERENCES = 4;
    public static int IMPORT_WIZARD = 5;
    public static int HADOOP_OLH_IMPORT_WIZARD = 6;
    public static int HADOOP_OSCH_IMPORT_WIZARD = 7;
    public static String DELIMITED = "Delimited".toLowerCase();
    public static String CSV = "CSV".toLowerCase();
    public static String TEXT = "TEXT".toLowerCase();
    public static String FIXED = "fixed".toLowerCase();
    public static String LOADER = "LOADER".toLowerCase();
    public static String EXCEL = "Excel 95-2003 ( XLS)".toLowerCase();
    public static String EXCELX = "Excel 2003+ ( XLSX )".toLowerCase();
    public static String INSERT = "INSERT".toLowerCase();
    public static String JSON = "JSON".toLowerCase();
    public static String PDF = "PDF".toLowerCase();
    public static String COPY = "COPY".toLowerCase();
    public static String DATAPUMP = "DATAPUMP".toLowerCase();
    public static String HSV = "hdfs delimited".toLowerCase();
    public static String DELIMITER = ",";
    public static String ENCLOSURE_LEFT = "\"";
    public static String ENCLOSURE_RIGHT = "\"";
    public static String LINE_TERMINATOR = "ENV_DEFAULT";
    public static final String LDR_LINE_TERMINATOR = "TERM_OTHER";
    protected Vector<String> _delimiters;
    private Vector<String> _enclosuresLeft;
    private Vector<String> _enclosuresRight;
    protected Vector<String> _recordTerminators;
    protected int _usage = EXPORT_WIZARD;
    protected boolean _header = true;
    protected String _format;
    private boolean _schema = false;
    private boolean _showSchema = false;
    protected IResultFormatter _formatter;
    protected String _encoding;
    protected String _delimiter;
    protected boolean _enclosures = true;
    protected String _enclosureLeft;
    protected String _enclosureRight;
    protected boolean _enclosureRightDouble;
    protected String _recTerm = System.getProperty("line.separator");
    protected String _termChars;
    protected String _envChars;
    protected IFormatOptions _options;

    public BaseDataFormat(int n) {
        this._usage = n;
        this.initFormat();
    }

    public BaseDataFormat(int n, String string) {
        this._usage = n;
        this.setFormat(string);
        this.initFormat();
    }

    public int getUsage() {
        return this._usage;
    }

    public IFormatOptions getOptions() {
        return this._options;
    }

    public boolean allowsLobs() {
        return this._formatter != null && this._formatter.allowsLobs();
    }

    public boolean allowsVirtual() {
        return this._formatter != null && this._formatter.allowsVirtual();
    }

    public boolean isDelimited() {
        return this._format != null && (this._format.equals(DELIMITED) || this._format.equals("dsv".toLowerCase()));
    }

    public boolean isCsv() {
        return this._format != null && (this._format.equals(CSV) || this._format.equals("csv".toLowerCase()));
    }

    public boolean isText() {
        return this._format != null && (this._format.equals(TEXT) || this._format.equals("tsv".toLowerCase()) || this._format.equals("txt"));
    }

    public boolean isFixed() {
        return this._format != null && (this._format.equals(FIXED) || this._format.equals("txt".toLowerCase()));
    }

    public boolean isInsert() {
        return this._format != null && (this._format.equals(INSERT) || this._format.equals("sql".toLowerCase()));
    }

    public boolean isLoader() {
        return this._format != null && (this._format.equals(LOADER) || this._format.equals("ctl".toLowerCase()));
    }

    public boolean isExcel() {
        return this._format != null && (this._format.equals(EXCEL) || this._format.equals("xls".toLowerCase()));
    }

    public boolean isExcelX() {
        return this._format != null && (this._format.equals(EXCELX) || this._format.equals("xlsx".toLowerCase()));
    }

    public boolean isPDF() {
        return this._format != null && (this._format.equals(PDF) || this._format.equals("pdf".toLowerCase()));
    }

    public boolean isHSV() {
        return this._format != null && this._format.equals(HSV);
    }

    public abstract String[] getFormats();

    public String getFormat() {
        return this._format;
    }

    public void setFormat(String string) {
        if (string != null) {
            this._format = string;
            if (this._usage < IMPORT_PREFERENCES) {
                try {
                    this._formatter = null;
                    this._formatter = FormatRegistry.getFormatter((String)this._format);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._formatter == null) {
                    this._formatter = this._format.equals(DATAPUMP) ? new DataPumpFormatter() : new CopyFormatter();
                }
                this._options = this._formatter;
            } else {
                this._options = (IImportFormatOptions)DataReaderRegistry.getReader((String)this.getReaderType());
            }
        }
    }

    private String getReaderType() {
        if (this.isCsv()) {
            return "csv";
        }
        if (this.isExcel()) {
            return "xls";
        }
        if (this.isExcelX()) {
            return "xlsx";
        }
        if (this.isText()) {
            return "tsv";
        }
        if (this.isHSV()) {
            return "hsv";
        }
        return "dsv";
    }

    public boolean isHeaderOptionSupported() {
        return this._options.isHeaderOptionSupported();
    }

    public boolean isHeader() {
        if (this._options == null || !this._options.isHeaderOptionSupported()) {
            return false;
        }
        return this._header;
    }

    public void isHeader(boolean bl) {
        if (this._options == null || !this._options.isHeaderOptionSupported()) {
            return;
        }
        this._header = bl;
    }

    public boolean getShowSchema() {
        return this._showSchema;
    }

    public void setShowSchema(boolean bl) {
        this._showSchema = bl;
    }

    public boolean getSchema() {
        return this._schema;
    }

    public void setSchema(boolean bl) {
        this._schema = bl;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public Vector<String> getEnclosuresLeft() {
        this._enclosuresLeft = new Vector();
        this._enclosuresLeft.add("\"");
        this._enclosuresLeft.add("'");
        this._enclosuresLeft.add("(");
        this._enclosuresLeft.add("[");
        this._enclosuresLeft.add("<");
        this._enclosuresLeft.add(DataToolsResources.getString((String)"NONE"));
        if (this._enclosuresLeft.contains(this.getEnclosureLeft())) {
            return this._enclosuresLeft;
        }
        this._enclosuresLeft.add(this.getEnclosureLeft());
        return this._enclosuresLeft;
    }

    public Vector<String> getEnclosuresRight() {
        this._enclosuresRight = new Vector();
        this._enclosuresRight.add("\"");
        this._enclosuresRight.add("'");
        this._enclosuresRight.add(")");
        this._enclosuresRight.add("]");
        this._enclosuresRight.add(">");
        this._enclosuresRight.add(DataToolsResources.getString((String)"NONE"));
        if (this._enclosuresRight.contains(this.getEnclosureRight())) {
            return this._enclosuresRight;
        }
        this._enclosuresRight.add(this.getEnclosureRight());
        return this._enclosuresRight;
    }

    public Vector<String> getRecordTerminators() {
        this._recordTerminators = new Vector();
        this._recordTerminators.add(DataToolsResources.getString((String)"PLATFORM_DEFAULT"));
        this._recordTerminators.add(DataToolsResources.getString((String)"ENV_DEFAULT"));
        this._recordTerminators.add(DataToolsResources.getString((String)"LF"));
        this._recordTerminators.add(DataToolsResources.getString((String)"CRLF"));
        this._recordTerminators.add(DataToolsResources.getString((String)"CR"));
        this._recordTerminators.add(DataToolsResources.getString((String)LDR_LINE_TERMINATOR));
        if (this._recordTerminators.contains(this._recTerm)) {
            return this._recordTerminators;
        }
        this._recordTerminators.add(this._recTerm);
        return this._recordTerminators;
    }

    public Vector<String> getDelimiters() {
        this._delimiters = new Vector();
        this._delimiters.add(",");
        this._delimiters.add("|");
        this._delimiters.add(";");
        this._delimiters.add(":");
        this._delimiters.add(DataToolsResources.getString((String)"TAB"));
        this._delimiters.add(DataToolsResources.getString((String)"WHITESPACE"));
        this._delimiters.add(DataToolsResources.getString((String)"SPACE"));
        if (this._delimiters.contains(this.getDelimiter())) {
            return this._delimiters;
        }
        this._delimiters.add(this.getDelimiter());
        return this._delimiters;
    }

    public String getDelimiter() {
        if (this._options == null || !this._options.isDelimiterSupported()) {
            return "";
        }
        return this._delimiter;
    }

    public String getTranslatedDelimiter() {
        if (this._delimiter != null && this._delimiter.length() > 0) {
            if (this._delimiter == "\t") {
                return DataToolsResources.getString((String)"TAB");
            }
            if (this._delimiter.equals("  ")) {
                return DataToolsResources.getString((String)"WHITESPACE");
            }
            if (this._delimiter.equals(" ")) {
                return DataToolsResources.getString((String)"SPACE");
            }
        }
        return this._delimiter;
    }

    public String getDelimiterValue() {
        String string = this.getDelimiter();
        if (string != null && string.length() > 0) {
            string = string.equals(DataToolsResources.getString((String)"TAB")) ? "\t" : (string.equals(DataToolsResources.getString((String)"WHITESPACE")) ? "  " : (string.equals(DataToolsResources.getString((String)"SPACE")) ? " " : BaseDataFormat.convertHex(string, this.getEncoding())));
        }
        return string;
    }

    public static String getDelimiterString(String string) {
        String string2 = string;
        if (string2.equals(DataToolsResources.getString((String)"TAB"))) {
            string2 = "X'09'";
        } else if (string2.equals(DataToolsResources.getString((String)"WHITESPACE"))) {
            string2 = "WHITESPACE";
        } else if (string2.equals(DataToolsResources.getString((String)"SPACE"))) {
            string2 = " ";
        }
        if (string2.equals("\t")) {
            return "\\t";
        }
        return string2;
    }

    public static boolean isDelimiterWhiteSpace(String string) {
        return string.length() > 1 && string.equals("  ");
    }

    public void setDelimiter(String string) {
        if (this._options == null || !this._options.isDelimiterSupported()) {
            return;
        }
        this._delimiter = string;
    }

    public boolean getEnclosures() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return false;
        }
        return this.getEnclosureLeftValue().length() != 0 && this.getEnclosureRightValue().length() != 0;
    }

    public String getEnclosureLeft() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return "";
        }
        return this._enclosureLeft;
    }

    public String getEnclosureLeftValue() {
        String string = this.getEnclosureLeft();
        if (string == null || string.equals(DataToolsResources.getString((String)"NONE"))) {
            return "";
        }
        return BaseDataFormat.convertHex(this.getEnclosureLeft(), this.getEncoding());
    }

    public void setEnclosureLeft(String string) {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return;
        }
        this._enclosureLeft = string;
    }

    public String getEnclosureRight() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return "";
        }
        return this._enclosureRight;
    }

    public String getEnclosureRightFromLeft(String string) {
        for (int i = 0; i < this._enclosuresLeft.size(); ++i) {
            String string2 = this._enclosuresLeft.elementAt(i);
            if (!string2.equals(string)) continue;
            return this._enclosuresRight.elementAt(i);
        }
        return null;
    }

    public String getEnclosureRightValue() {
        String string = this.getEnclosureRight();
        if (string != null && string.equals(DataToolsResources.getString((String)"NONE"))) {
            return this.getEnclosureLeftValue();
        }
        return string != null && string.length() > 0 ? BaseDataFormat.convertHex(string, this.getEncoding()) : this.getEnclosureLeftValue();
    }

    public void setEnclosureRight(String string) {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return;
        }
        this._enclosureRight = string;
    }

    public boolean isEnclosureRightDouble() {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return false;
        }
        return this._enclosureRightDouble;
    }

    public void isEnclosureRightDouble(boolean bl) {
        if (this._options == null || !this._options.isEnclosuresSupported()) {
            return;
        }
        this._enclosureRightDouble = bl;
    }

    public void setRecordTerminator(String string) {
        if (this._options == null || !this._options.isLineTerminatorSupported()) {
            return;
        }
        this._recTerm = string;
    }

    public String getRecordTerminator() {
        if (this._options == null || !this._options.isLineTerminatorSupported()) {
            return "";
        }
        return this._recTerm;
    }

    public static String getRecordTerminatorString(String string) {
        String string2 = BaseDataFormat.isRecordTerminatorPlatform(string) ? System.getProperty("line.separator") : (BaseDataFormat.isRecordTerminatorEnvironment(string) ? BaseDataFormat.getEnvTerminatorValue() : (BaseDataFormat.isRecordTerminatorStandard(string) ? System.getProperty("line.separator") : (BaseDataFormat.isRecordTerminatorCRLF(string) ? "\r\n" : (BaseDataFormat.isRecordTerminatorLF(string) ? "\n" : (BaseDataFormat.isRecordTerminatorCR(string) ? "\r" : string)))));
        if (string2.equals("\r")) {
            return "\\r";
        }
        if (string2.equals("\r\n")) {
            return "\\r\\n";
        }
        if (string2.equals("\n")) {
            return "\\n";
        }
        return string2;
    }

    public String getRecordTerminatorValue() {
        return this.getRecordTerminatorValue(this.getRecordTerminator());
    }

    public String getRecordTerminatorValue(String string) {
        String string2 = BaseDataFormat.isRecordTerminatorPlatform(string) ? System.getProperty("line.separator") : (BaseDataFormat.isRecordTerminatorEnvironment(string) ? BaseDataFormat.getEnvTerminatorValue() : (BaseDataFormat.isRecordTerminatorStandard(string) ? "\r\n" : (BaseDataFormat.isRecordTerminatorCRLF(string) ? "\r\n" : (BaseDataFormat.isRecordTerminatorLF(string) ? "\n" : (BaseDataFormat.isRecordTerminatorCR(string) ? "\r" : string)))));
        return BaseDataFormat.convertHex(string2, this.getEncoding());
    }

    private static String convertHex(String string, String string2) {
        String string3 = "";
        if (string != null && string.length() > 3 && (string.substring(0, 2).equals("X'") || string.substring(0, 2).equals("x'"))) {
            try {
                Object object;
                int n = (string.length() - 3) / 2;
                byte[] byArray = new byte[n];
                int n2 = 2;
                int n3 = 0;
                while (n2 < string.length() - 1) {
                    object = "";
                    object = (String)object + string.charAt(n2);
                    object = (String)object + string.charAt(n2 + 1);
                    BigInteger bigInteger = new BigInteger((String)object, 16);
                    int n4 = bigInteger.intValue();
                    string3 = string3 + new Character((char)n4).toString();
                    byArray[n3] = bigInteger.byteValue();
                    n2 += 2;
                    ++n3;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string2 != null ? string2 : "UTF8");
                object = new char[n];
                int n5 = inputStreamReader.read((char[])object, 0, n);
                return n5 != -1 ? new String((char[])object) : string3;
            }
            catch (Exception exception) {
                if (string3 == "") {
                    return string;
                }
            }
        } else {
            return string;
        }
        return string3;
    }

    private static boolean isHexFormat(String string) {
        return string.length() > 3 && (string.substring(0, 2).equals("X'") || string.substring(0, 2).equals("x'"));
    }

    public static String getEnvTerminatorValue() {
        IdeSettings ideSettings;
        EnvironOptions environOptions;
        int n;
        String string = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        return string;
    }

    public static boolean isRecordTerminatorStandard(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DataToolsResources.getString((String)"STANDARD"));
    }

    public static boolean isRecordTerminatorPlatform(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DataToolsResources.getString((String)"PLATFORM_DEFAULT"));
    }

    public static boolean isRecordTerminatorEnvironment(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DataToolsResources.getString((String)"ENV_DEFAULT"));
    }

    public static boolean isRecordTerminatorOther(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DataToolsResources.getString((String)LDR_LINE_TERMINATOR));
    }

    public static boolean isRecordTerminatorImportDefault(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DataToolsResources.getString((String)"FILE_FORMAT_DEFAULT"));
    }

    public static boolean isRecordTerminatorImportFile(String string) {
        if (string == null) {
            return false;
        }
        return string.equals(DataToolsResources.getString((String)"IMPORT_FILE"));
    }

    public static boolean isRecordTerminatorLF(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(DataToolsResources.getString((String)"LF"))) {
            return true;
        }
        return string.equals("\\n");
    }

    public static boolean isRecordTerminatorCRLF(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(DataToolsResources.getString((String)"CRLF"))) {
            return true;
        }
        return string.equals("\\r\\n");
    }

    public static boolean isRecordTerminatorCR(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(DataToolsResources.getString((String)"CR"))) {
            return true;
        }
        return string.equals("\\r");
    }

    public static String getDelimiterForConfigValue(String string) {
        if (string == null) {
            return ",";
        }
        if (string.equals(DataToolsResources.getString((String)"TAB"))) {
            return "TAB";
        }
        if (string.equals(DataToolsResources.getString((String)"SPACE"))) {
            return "SPACE";
        }
        if (string.equals(DataToolsResources.getString((String)"WHITESPACE"))) {
            return "WHITESPACE";
        }
        return string;
    }

    public static String getDelimiterFromConfigValue(String string) {
        if (string == null) {
            return DataToolsResources.getString((String)",");
        }
        if (string.equals("TAB")) {
            return DataToolsResources.getString((String)"TAB");
        }
        if (string.equals("SPACE")) {
            return DataToolsResources.getString((String)"SPACE");
        }
        if (string.equals("WHITESPACE")) {
            return DataToolsResources.getString((String)"WHITESPACE");
        }
        return string;
    }

    public static String getEnclosureForConfigValue(String string) {
        if (string == null) {
            return "NONE";
        }
        if (string.equals(DataToolsResources.getString((String)"NONE"))) {
            return "NONE";
        }
        return string;
    }

    public static String getEnclosureFromConfigValue(String string) {
        if (string == null) {
            return DataToolsResources.getString((String)"NONE");
        }
        if (string.equals("NONE")) {
            return DataToolsResources.getString((String)"NONE");
        }
        return string;
    }

    public static String getRecordTerminatorForConfigValue(String string) {
        if (string == null) {
            return "PLATFORM_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorPlatform(string)) {
            return "PLATFORM_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorEnvironment(string)) {
            return "ENV_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorStandard(string)) {
            return "STANDARD";
        }
        if (BaseDataFormat.isRecordTerminatorEnvironment(string)) {
            return "FILE_FORMAT_DEFAULT";
        }
        if (BaseDataFormat.isRecordTerminatorEnvironment(string)) {
            return "IMPORT_FILE";
        }
        if (BaseDataFormat.isRecordTerminatorLF(string)) {
            return "LF";
        }
        if (BaseDataFormat.isRecordTerminatorCRLF(string)) {
            return "CRLF";
        }
        if (BaseDataFormat.isRecordTerminatorCR(string)) {
            return "CR";
        }
        if (BaseDataFormat.isRecordTerminatorOther(string)) {
            return LDR_LINE_TERMINATOR;
        }
        return string;
    }

    public static String getRecordTerminatorFromConfigValue(String string) {
        if (string == null) {
            return DataToolsResources.getString((String)"PLATFORM_DEFAULT");
        }
        if (string.equals("PLATFORM_DEFAULT")) {
            return DataToolsResources.getString((String)"PLATFORM_DEFAULT");
        }
        if (string.equals("ENV_DEFAULT")) {
            return DataToolsResources.getString((String)"ENV_DEFAULT");
        }
        if (string.equals("STANDARD")) {
            return DataToolsResources.getString((String)"STANDARD");
        }
        if (string.equals("FILE_FORMAT_DEFAULT")) {
            return DataToolsResources.getString((String)"FILE_FORMAT_DEFAULT");
        }
        if (string.equals("IMPORT_FILE")) {
            return DataToolsResources.getString((String)"IMPORT_FILE");
        }
        if (string.equals("LF")) {
            return DataToolsResources.getString((String)"LF");
        }
        if (string.equals("CRLF")) {
            return DataToolsResources.getString((String)"CRLF");
        }
        if (string.equals("CR")) {
            return DataToolsResources.getString((String)"CR");
        }
        if (string.equals(LDR_LINE_TERMINATOR)) {
            return DataToolsResources.getString((String)LDR_LINE_TERMINATOR);
        }
        return string;
    }

    public static String singleQuote(String string) {
        return BaseDataFormat.isHexFormat(string) ? string : "'" + string + "'";
    }

    protected void initConfigOptions(IStorage iStorage) {
        Boolean bl;
        if (this._options.isHeaderOptionSupported()) {
            bl = iStorage.getBoolean(this._options.getHeaderConfigKey());
            this.isHeader(bl != null ? bl : true);
        }
        if (this._options.isDelimiterSupported()) {
            this._delimiter = this._options.isDelimiterConfigurable() ? BaseDataFormat.getDelimiterFromConfigValue(iStorage.getString(this._options.getDelimiterConfigKey())) : this._options.getDefaultDelimiter();
        }
        if (this._options.isEnclosuresSupported()) {
            bl = iStorage.getBoolean(this._options.getEnclosuresConfigKey());
            this._enclosures = bl != null ? bl : false;
            this._enclosureLeft = BaseDataFormat.getEnclosureFromConfigValue(iStorage.getString(this._options.getEnclosureLeftConfigKey()));
            this._enclosureRight = BaseDataFormat.getEnclosureFromConfigValue(iStorage.getString(this._options.getEnclosureRightConfigKey()));
            bl = iStorage.getBoolean(this._options.getEnclosureRightDoubleConfigKey());
            this.isEnclosureRightDouble(bl != null ? bl : true);
        }
        if (this._options.isLineTerminatorSupported()) {
            this._recTerm = BaseDataFormat.getRecordTerminatorFromConfigValue(iStorage.getString(this._options.getLineTerminatorConfigKey()));
            if (this._usage == IMPORT_WIZARD || this._usage == IMPORT_PREFERENCES) {
                if (this._recTerm == null || this._recTerm.length() == 0 || this._recTerm == DataToolsResources.getString((String)"ENV_DEFAULT") || this._recTerm == DataToolsResources.getString((String)"PLATFORM_DEFAULT")) {
                    this._recTerm = DataToolsResources.getString((String)"STANDARD");
                }
            } else if (this._recTerm == null || this._recTerm.length() == 0) {
                this._recTerm = DataToolsResources.getString((String)"ENV_DEFAULT");
            }
        }
    }

    public void saveFormatPreferences(IStorage iStorage) {
        if (this._options.isHeaderOptionSupported()) {
            iStorage.putBoolean(this._options.getHeaderConfigKey(), this._header);
        }
        if (this._options.isDelimiterSupported() && this._options.isDelimiterConfigurable()) {
            iStorage.putString(this._options.getDelimiterConfigKey(), BaseDataFormat.getDelimiterForConfigValue(this._delimiter));
        }
        if (this._options.isEnclosuresSupported()) {
            iStorage.putBoolean(this._options.getEnclosuresConfigKey(), this._enclosures);
            iStorage.putString(this._options.getEnclosureLeftConfigKey(), BaseDataFormat.getEnclosureForConfigValue(this._enclosureLeft));
            iStorage.putString(this._options.getEnclosureRightConfigKey(), BaseDataFormat.getEnclosureForConfigValue(this._enclosureRight));
            iStorage.putBoolean(this._options.getEnclosureRightDoubleConfigKey(), this._enclosureRightDouble);
        }
        if (this._options.isLineTerminatorSupported()) {
            iStorage.putString(this._options.getLineTerminatorConfigKey(), BaseDataFormat.getRecordTerminatorForConfigValue(this._recTerm));
        }
    }

    protected abstract void initFormat();

    public abstract void saveBasicPreferences(IStorage var1);
}

