/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatools.core;

import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;

public final class DataFormatHelper {
    public static String EXCEL = "Excel 95-2003 ( XLS)".toLowerCase();
    public static String EXCELX = "Excel 2003+ ( XLSX )".toLowerCase();
    public static String PDF = "PDF".toLowerCase();
    public static String HSV = "hdfs delimited".toLowerCase();
    private static String[] IMPORTformatS_HSV = new String[]{HSV};
    private static String[] IMPORTformatS_DELIMITED = new String[]{BaseDataFormat.DELIMITED, BaseDataFormat.CSV, BaseDataFormat.TEXT};
    private static String[] IMPORTformatS_EXCEL = new String[]{EXCEL, EXCELX};

    public static boolean isText(String string) {
        return string != null && (string.equals(ImportDataFormat.TEXT) || string.equals("tsv".toLowerCase()) || string.equals("txt"));
    }

    public static boolean isExcel(String string) {
        return string != null && (string.equals(EXCEL) || string.equals("xls".toLowerCase()));
    }

    public static boolean isExcelX(String string) {
        return string != null && (string.equals(EXCELX) || string.equals("xlsx".toLowerCase()));
    }

    public static boolean isPDF(String string) {
        return string != null && (string.equals(PDF) || string.equals("pdf".toLowerCase()));
    }

    public static boolean isHSV(String string) {
        return string != null && string.equals(HSV);
    }

    public static String[] getImportFormats(String string) {
        if (DataFormatHelper.isExcel(string) || DataFormatHelper.isExcelX(string)) {
            return IMPORTformatS_EXCEL;
        }
        if (DataFormatHelper.isHSV(string)) {
            return IMPORTformatS_HSV;
        }
        return IMPORTformatS_DELIMITED;
    }

    public static boolean isCompatible(ImportDataFormat importDataFormat, String string) {
        if (ImportDataFormat.isDelimited((String)importDataFormat.getFormat()) || ImportDataFormat.isCsv((String)importDataFormat.getFormat()) || ImportDataFormat.isText((String)importDataFormat.getFormat())) {
            return string == null || string.equals(BaseDataFormat.DELIMITED) || string.equals(BaseDataFormat.CSV) || string.equals(BaseDataFormat.TEXT);
        }
        return string == null || string.equals(BaseDataFormat.EXCEL) || string.equals(BaseDataFormat.EXCELX);
    }
}

