/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.editor.tree;

import java.util.ArrayList;
import java.util.Stack;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;

    public CheckTreeSelectionModel(TreeModel treeModel) {
        this.model = treeModel;
        this.setSelectionMode(4);
    }

    public boolean isPartiallySelected(TreePath treePath) {
        if (this.isPathSelected(treePath, true)) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!this.isDescendant(treePathArray[i], treePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathSelected(TreePath treePath, boolean bl) {
        if (!bl) {
            return super.isPathSelected(treePath);
        }
        while (treePath != null && !super.isPathSelected(treePath)) {
            treePath = treePath.getParentPath();
        }
        return treePath != null;
    }

    private boolean isDescendant(TreePath treePath, TreePath treePath2) {
        Object[] objectArray = treePath.getPath();
        Object[] objectArray2 = treePath2.getPath();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray[i] == objectArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        throw new UnsupportedOperationException("not implemented yet!!!");
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        Object object;
        TreePath treePath;
        int n;
        for (n = 0; n < treePathArray.length; ++n) {
            treePath = treePathArray[n];
            object = this.getSelectionPaths();
            if (object == null) break;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < ((TreePath[])object).length; ++i) {
                if (!this.isDescendant((TreePath)object[i], treePath)) continue;
                arrayList.add(object[i]);
            }
            super.removeSelectionPaths(arrayList.toArray(new TreePath[0]));
        }
        for (n = 0; n < treePathArray.length; ++n) {
            treePath = treePathArray[n];
            object = null;
            while (this.areSiblingsSelected(treePath)) {
                object = treePath;
                if (treePath.getParentPath() == null) break;
                treePath = treePath.getParentPath();
            }
            if (object != null) {
                if (((TreePath)object).getParentPath() != null) {
                    this.addSelectionPath(((TreePath)object).getParentPath());
                    continue;
                }
                if (!this.isSelectionEmpty()) {
                    this.removeSelectionPaths(this.getSelectionPaths());
                }
                super.addSelectionPaths(new TreePath[]{object});
                continue;
            }
            super.addSelectionPaths(new TreePath[]{treePath});
        }
    }

    private boolean areSiblingsSelected(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        Object object2 = treePath2.getLastPathComponent();
        int n = this.model.getChildCount(object2);
        for (int i = 0; i < n; ++i) {
            Object object3 = this.model.getChild(object2, i);
            if (object3 == object || this.isPathSelected(treePath2.pathByAddingChild(object3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            if (treePath.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{treePath});
                continue;
            }
            this.toggleRemoveSelection(treePath);
        }
    }

    private void toggleRemoveSelection(TreePath treePath) {
        TreePath treePath2;
        Stack<TreePath> stack = new Stack<TreePath>();
        for (treePath2 = treePath.getParentPath(); treePath2 != null && !this.isPathSelected(treePath2); treePath2 = treePath2.getParentPath()) {
            stack.push(treePath2);
        }
        if (treePath2 != null) {
            stack.push(treePath2);
        } else {
            super.removeSelectionPaths(new TreePath[]{treePath});
            return;
        }
        while (!stack.isEmpty()) {
            TreePath treePath3 = (TreePath)stack.pop();
            TreePath treePath4 = stack.isEmpty() ? treePath : (TreePath)stack.peek();
            Object object = treePath3.getLastPathComponent();
            Object object2 = treePath4.getLastPathComponent();
            int n = this.model.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object3 = this.model.getChild(object, i);
                if (object3 == object2) continue;
                super.addSelectionPaths(new TreePath[]{treePath3.pathByAddingChild(object3)});
            }
        }
        super.removeSelectionPaths(new TreePath[]{treePath2});
    }
}

