/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import oracle.dbtools.common.ddl.DDLRegistry;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.ddl.Messages;
import oracle.dbtools.raptor.export.service.ExportLauncherSD;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class DDLContextMenuListener
implements ContextMenuListener,
Controller {
    private JMenu _menu;
    public static final String DDL_AS_FILE_CMD = "DatabaseNavigator.DDL_AS_FILE_CMD";
    public static final int DDL_AS_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_AS_FILE_CMD");
    public static final String DDL_TO_WRKSHEET_CMD = "DatabaseNavigator.DDL_TO_WRKSHEET_CMD";
    public static final int DDL_TO_WRKSHEET_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_WRKSHEET_CMD");
    public static final String DDL_TO_CLIPBOARD_CMD = "DatabaseNavigator.DDL_TO_CLIPBOARD_CMD";
    public static final int DDL_TO_CLIPBOARD_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_CLIPBOARD_CMD");
    public static final String DDL_TO_HTML_FILE_CMD = "DatabaseNavigator.EXPORT_DDL_TO_HTML_FILE";
    public static final IdeAction DDL_TO_FILE = IdeAction.find((int)DDL_AS_FILE_CMD_ID);
    public static final IdeAction DDL_TO_WRKSHEET = IdeAction.find((int)DDL_TO_WRKSHEET_CMD_ID);
    public static final IdeAction DDL_TO_CLIPBOARD = IdeAction.find((int)DDL_TO_CLIPBOARD_CMD_ID);
    private Element[] _elems;

    private void init() {
        if (this._menu == null) {
            String string = DatabaseNavigatorResources.getString("QUICK_DDL");
            this._menu = new JMenu(string);
            this._menu.getAccessibleContext().setAccessibleName(string + oracle.dbtools.raptor.dialogs.Messages.getString((String)"XMLBasedObjectAction.25"));
            this._menu.add((Action)DDL_TO_FILE);
            this._menu.add((Action)DDL_TO_WRKSHEET);
            this._menu.add((Action)DDL_TO_CLIPBOARD);
            DDL_TO_FILE.addController((Controller)this);
            DDL_TO_WRKSHEET.addController((Controller)this);
            DDL_TO_CLIPBOARD.addController((Controller)this);
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (!(view instanceof NavigatorWindow) || view instanceof DBNavigatorWindow) {
            this.init();
            DBObject dBObject = null;
            boolean bl = true;
            this._elems = contextMenu.getContext().getSelection();
            if (this._elems.length == 0) {
                bl = false;
            }
            for (Element element : this._elems) {
                dBObject = new DBObject(element);
                if (DDLRegistry.isSupported((String)dBObject.getKey())) continue;
                bl = false;
            }
            if (bl) {
                contextMenu.add((Component)this._menu);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DDL_AS_FILE_CMD_ID) {
            this.saveToFile(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_WRKSHEET_CMD_ID) {
            this.saveToWorkSheet(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_CLIPBOARD_CMD_ID) {
            this.saveToClip(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    private void getDDL(Context context, int n) {
        this.getDDL(context, n, null);
    }

    private void getDDL(Context context, int n, String string) {
        ExportParms exportParms = new ExportParms();
        exportParms.setSourceDBObjectList(this.getList(context));
        exportParms.setSaveAsType(n);
        exportParms.setSaveAs(string);
        exportParms.setServiceType(ExportServiceType.QUICK);
        ExportLauncherSD exportLauncherSD = new ExportLauncherSD();
        ExitCode exitCode = exportLauncherSD.start(exportParms);
        if (exitCode == ExitCode.EXIT_SUCCESS) {
            exportLauncherSD.export();
        } else {
            Logger.warn(this.getClass(), (String)exitCode.getMessage());
        }
    }

    private List<BasicDBObject> getList(Context context) {
        ArrayList<BasicDBObject> arrayList = new ArrayList<BasicDBObject>();
        for (Element element : this._elems) {
            arrayList.add(this.getDBObject((Node)element));
        }
        return arrayList;
    }

    private DBObject getDBObject(Node node) {
        if (node instanceof ObjectNode && ((ObjectNode)node).getObjectType().equals("MATERIALIZED VIEW LOG")) {
            ObjectNode objectNode = (ObjectNode)node;
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", objectNode.getConnectionName(), null, objectNode.getSchemaName(), objectNode.getObjectType());
            URL uRL2 = DBURLFormatHelper.getURL(uRL, objectNode.getShortLabel());
            return new DBObject(uRL2);
        }
        return new DBObject((Element<?, ?>)node);
    }

    private void saveToWorkSheet(Context context) {
        try {
            this.getDDL(context, 4);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private void saveToClip(Context context) {
        try {
            this.getDDL(context, 5);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private void saveToFile(Context context) {
        File file;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setPathContext("EXPORTDIR");
        String string = DBConfig.getInstance().getString("EXPORTDIR");
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
        }
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        file = new DefaultURLFilter(Messages.getString("DDLContextMenuListener.4"), ".sql");
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)file);
        TargetFormat targetFormat = new TargetFormat(1, 1);
        targetFormat.setSaveAsType(0);
        int n = -1;
        String string2 = "";
        while (n != 0) {
            int n2 = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n2 == 0) {
                File file2 = new File(uRLFileChooser.getSelectedURL().getPath());
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                    string2 = file2.getPath();
                }
                URL uRL = uRLFileChooser.getSelectedURL();
                if (string2.indexOf(".sql") == -1) {
                    string2 = string2 + ".sql";
                }
                targetFormat.setSaveAs(string2);
                n = targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                if (n != 1) continue;
                try {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)targetFormat.getValidationMessage(), (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                }
                continue;
            }
            return;
        }
        this.getDDL(context, 0, string2);
    }
}

