/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.format.ReportPatternInfo;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PDFXMLUtil {
    private static PDFXMLUtil _pdfXML = null;
    private PDFFormatOptions _pdfOptions = null;
    private int _indent = 0;
    private StringBuffer _xmlFormat = null;
    private LinkedHashMap<String, String> _pdfMap = new LinkedHashMap();

    public static PDFXMLUtil getInstance() {
        if (_pdfXML == null) {
            _pdfXML = new PDFXMLUtil();
        }
        return _pdfXML;
    }

    public String toXML(PDFFormatOptions pDFFormatOptions, int n) {
        this._pdfOptions = pDFFormatOptions;
        this._indent = n;
        this._xmlFormat = new StringBuffer();
        this.formatPDF();
        this.formatDocProperties();
        this.formatCellLayout();
        this.formatColumnLayout();
        this.formatTableLayout();
        this.formatHeaderLayout();
        this.formatFooterLayout();
        this.formatPageSetup();
        this._xmlFormat.append(this.formatEndTag("pdf", 1));
        return this._xmlFormat.toString();
    }

    private void formatPDF() {
        this._pdfMap.clear();
        this._pdfMap.put("version", this._pdfOptions.getSupportedVersion().toString());
        this._pdfMap.put("compression", this._pdfOptions.getCompressionLevel().toString());
        this._xmlFormat.append(this.formatStartTag("pdf", this._pdfMap, 1, false));
    }

    private void formatDocProperties() {
        this._pdfMap.clear();
        this._pdfMap.put("title", this._pdfOptions.getTitle());
        this._pdfMap.put("author", this._pdfOptions.getAuthor());
        this._pdfMap.put("subject", this._pdfOptions.getSubject());
        this._pdfMap.put("keywords", this._pdfOptions.getKeywords());
        this._xmlFormat.append(this.formatStartTag("docproperty", this._pdfMap, 2, true));
    }

    private void formatCellLayout() {
        this._pdfMap.clear();
        this._pdfMap.put("toppadding", Integer.toString(this._pdfOptions.getCellPaddingTop()));
        this._pdfMap.put("bottompadding", Integer.toString(this._pdfOptions.getCellPaddingBottom()));
        this._pdfMap.put("leftpadding", Integer.toString(this._pdfOptions.getCellPaddingLeft()));
        this._pdfMap.put("rightpadding", Integer.toString(this._pdfOptions.getCellPaddingRight()));
        this._pdfMap.put("horizontalalign", this._pdfOptions.getCellHorizontalAlignment().toString());
        this._pdfMap.put("verticalalign", this._pdfOptions.getCellVerticalAlignment().toString());
        this._pdfMap.put("wrap", Boolean.toString(this._pdfOptions.isWrapText()));
        this._xmlFormat.append(this.formatStartTag("cell", this._pdfMap, 2, true));
    }

    private void formatColumnLayout() {
        this._pdfMap.clear();
        this._xmlFormat.append(this.formatStartTag("column", this._pdfMap, 2, false));
        this._pdfMap.clear();
        this._pdfMap.put("font", this._pdfOptions.getHeaderFontName());
        this._pdfMap.put("size", Integer.toString(this._pdfOptions.getHeaderFontSize()));
        this._pdfMap.put("style", this._pdfOptions.getHeaderFontStyle().toString());
        this._pdfMap.put("color", Integer.toString(this._pdfOptions.getHeaderFontColor()));
        this._pdfMap.put("rowshading", Integer.toString(this._pdfOptions.getHeaderRowShading()));
        this._pdfMap.put("labeling", this._pdfOptions.getColumnHeadingsAction().toString());
        this._xmlFormat.append(this.formatStartTag("heading", this._pdfMap, 3, true));
        this._pdfMap.clear();
        this._pdfMap.put("font", this._pdfOptions.getFooterFontName());
        this._pdfMap.put("size", Integer.toString(this._pdfOptions.getFooterFontSize()));
        this._pdfMap.put("style", this._pdfOptions.getFooterFontStyle().toString());
        this._pdfMap.put("color", Integer.toString(this._pdfOptions.getFooterFontColor()));
        this._pdfMap.put("rowshading", Integer.toString(this._pdfOptions.getFooterRowShading()));
        this._pdfMap.put("labeling", this._pdfOptions.getColumnFootingsAction().toString());
        this._xmlFormat.append(this.formatStartTag("footing", this._pdfMap, 3, true));
        this._pdfMap.clear();
        this._pdfMap.put("blob", this._pdfOptions.getBlobAction().toString());
        this._pdfMap.put("zip", Boolean.toString(this._pdfOptions.isCreateZipFile()));
        this._xmlFormat.append(this.formatStartTag("blob", this._pdfMap, 3, true));
        this._xmlFormat.append(this.formatEndTag("column", 2));
    }

    private void formatTableLayout() {
        this._pdfMap.clear();
        this._pdfMap.put("font", this._pdfOptions.getFontName());
        this._pdfMap.put("size", Integer.toString(this._pdfOptions.getFontSize()));
        this._pdfMap.put("style", this._pdfOptions.getFontStyle().toString());
        this._pdfMap.put("color", Integer.toString(this._pdfOptions.getFontColor()));
        this._pdfMap.put("userowshading", Boolean.toString(this._pdfOptions.isUseRowShading()));
        this._pdfMap.put("oddrowshading", Integer.toString(this._pdfOptions.getOddRowShading()));
        this._pdfMap.put("evenrowshading", Integer.toString(this._pdfOptions.getEvenRowShading()));
        this._pdfMap.put("showborders", Boolean.toString(this._pdfOptions.isShowAllBorders()));
        this._pdfMap.put("spacingbefore", Integer.toString(this._pdfOptions.getSpacingBeforeTable()));
        this._pdfMap.put("spacingafter", Integer.toString(this._pdfOptions.getSpacingAfterTable()));
        this._pdfMap.put("horizontalalign", this._pdfOptions.getTableHorizontalAlignment().toString());
        this._xmlFormat.append(this.formatStartTag("table", this._pdfMap, 2, true));
    }

    private void formatHeaderLayout() {
        this._pdfMap.clear();
        this._pdfMap.put("enable", Boolean.toString(this._pdfOptions.isInsertHeader()));
        this._pdfMap.put("generatedate", Boolean.toString(this._pdfOptions.isAutoUpdateDate()));
        this._xmlFormat.append(this.formatStartTag("header", this._pdfMap, 2, false));
        this._pdfMap.clear();
        this._xmlFormat.append(this.formatStartTag("data", this._pdfMap, 3, false));
        this._xmlFormat.append(this.formatValue(this._pdfOptions.getHeader(), 3));
        this._xmlFormat.append(this.formatEndTag("data", 3));
        ArrayList arrayList = this._pdfOptions.getHeaderPatternList();
        if (arrayList != null) {
            for (ReportPatternInfo reportPatternInfo : arrayList) {
                this._pdfMap.clear();
                this._pdfMap.put("pattern", reportPatternInfo.getPattern());
                this._pdfMap.put("position", Integer.toString(reportPatternInfo.getPosition()));
                this._pdfMap.put("value", reportPatternInfo.getText());
                this._xmlFormat.append(this.formatStartTag("pattern", this._pdfMap, 3, true));
            }
        }
        this._xmlFormat.append(this.formatEndTag("header", 2));
    }

    private void formatFooterLayout() {
        this._pdfMap.clear();
        this._pdfMap.put("enable", Boolean.toString(this._pdfOptions.isInsertFooter()));
        this._pdfMap.put("generatedate", Boolean.toString(this._pdfOptions.isAutoUpdateDate()));
        this._xmlFormat.append(this.formatStartTag("footer", this._pdfMap, 2, false));
        this._pdfMap.clear();
        this._pdfMap.put("value", this._pdfOptions.getFooter());
        this._xmlFormat.append(this.formatStartTag("data", this._pdfMap, 3, true));
        ArrayList arrayList = this._pdfOptions.getFooterPatternList();
        if (arrayList != null) {
            for (ReportPatternInfo reportPatternInfo : arrayList) {
                this._pdfMap.clear();
                this._pdfMap.put("pattern", reportPatternInfo.getPattern());
                this._pdfMap.put("position", Integer.toString(reportPatternInfo.getPosition()));
                this._pdfMap.put("value", reportPatternInfo.getText());
                this._xmlFormat.append(this.formatStartTag("pattern", this._pdfMap, 3, true));
            }
        }
        this._xmlFormat.append(this.formatEndTag("footer", 2));
    }

    private void formatPageSetup() {
        this._pdfMap.clear();
        this._pdfMap.put("papersize", this._pdfOptions.getPaperSize().toString());
        this._pdfMap.put("orientation", Integer.toString(this._pdfOptions.getOrientation()));
        this._pdfMap.put("measurement", "in");
        this._pdfMap.put("margintop", Float.toString(this._pdfOptions.getTopMarginUI()));
        this._pdfMap.put("marginbottom", Float.toString(this._pdfOptions.getBottomMarginUI()));
        this._pdfMap.put("marginleft", Float.toString(this._pdfOptions.getLeftMarginUI()));
        this._pdfMap.put("marginright", Float.toString(this._pdfOptions.getRightMarginUI()));
        this._xmlFormat.append(this.formatStartTag("pagesetup", this._pdfMap, 2, true));
    }

    private String formatStartTag(String string, HashMap<String, String> hashMap, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent(n));
        stringBuffer.append("<").append(string);
        if (hashMap != null) {
            Object[] objectArray = hashMap.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                String string3 = hashMap.get(string2);
                stringBuffer.append(" ").append(string2).append("=").append("\"").append(string3).append("\"");
            }
        }
        if (bl) {
            stringBuffer.append(" />").append("\n");
        } else {
            stringBuffer.append(">").append("\n");
        }
        return stringBuffer.toString();
    }

    private String formatValue(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent(n));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String formatEndTag(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getIndent(n));
        stringBuffer.append("</").append(string).append(">").append("\n");
        return stringBuffer.toString();
    }

    private String getIndent(int n) {
        String string = "";
        int n2 = n + this._indent;
        for (int i = 0; i < n2; ++i) {
            string = string + "\t";
        }
        return string;
    }

    private void populateDocProperties(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setTitle(XMLHelper.getAttributeNode((Node)node, (String)"title"));
        pDFFormatOptions.setAuthor(XMLHelper.getAttributeNode((Node)node, (String)"author"));
        pDFFormatOptions.setSubject(XMLHelper.getAttributeNode((Node)node, (String)"subject"));
        pDFFormatOptions.setKeywords(XMLHelper.getAttributeNode((Node)node, (String)"keywords"));
    }

    private void populateCellLayout(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setCellPaddingTop(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"toppadding")));
        pDFFormatOptions.setCellPaddingBottom(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"bottompadding")));
        pDFFormatOptions.setCellPaddingLeft(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"leftpadding")));
        pDFFormatOptions.setCellPaddingRight(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"rightpadding")));
        pDFFormatOptions.setCellHorizontalAlignment(ReportFormatOptions.HORIZONTAL_ALIGNMENT.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"horizontalalign")));
        pDFFormatOptions.setCellVerticalAlignment(ReportFormatOptions.VERTICAL_ALIGNMENT.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"verticalalign")));
        pDFFormatOptions.setWrapText(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"wrap")));
    }

    private void populateColumnLayout(PDFFormatOptions pDFFormatOptions, Node node) {
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"heading");
        pDFFormatOptions.setHeaderFontName(XMLHelper.getAttributeNode((Node)node2, (String)"font"));
        pDFFormatOptions.setHeaderFontSize(Integer.parseInt(XMLHelper.getAttributeNode((Node)node2, (String)"size")));
        pDFFormatOptions.setHeaderFontStyle(ReportFormatOptions.FONT_STYLE.valueOf((String)XMLHelper.getAttributeNode((Node)node2, (String)"style")));
        pDFFormatOptions.setHeaderFontColor(Integer.parseInt(XMLHelper.getAttributeNode((Node)node2, (String)"color")));
        pDFFormatOptions.setHeaderRowShading(Integer.parseInt(XMLHelper.getAttributeNode((Node)node2, (String)"rowshading")));
        pDFFormatOptions.setColumnHeadingsAction(ReportFormatOptions.COLUMN_LABELING.valueOf((String)XMLHelper.getAttributeNode((Node)node2, (String)"labeling")));
        node2 = XMLHelper.getChildNode((Node)node, (String)"footing");
        pDFFormatOptions.setFooterFontName(XMLHelper.getAttributeNode((Node)node2, (String)"font"));
        pDFFormatOptions.setFooterFontSize(Integer.parseInt(XMLHelper.getAttributeNode((Node)node2, (String)"size")));
        pDFFormatOptions.setFooterFontStyle(ReportFormatOptions.FONT_STYLE.valueOf((String)XMLHelper.getAttributeNode((Node)node2, (String)"style")));
        pDFFormatOptions.setFooterFontColor(Integer.parseInt(XMLHelper.getAttributeNode((Node)node2, (String)"color")));
        pDFFormatOptions.setFooterRowShading(Integer.parseInt(XMLHelper.getAttributeNode((Node)node2, (String)"rowshading")));
        pDFFormatOptions.setColumnFootingsAction(ReportFormatOptions.COLUMN_LABELING.valueOf((String)XMLHelper.getAttributeNode((Node)node2, (String)"labeling")));
        node2 = XMLHelper.getChildNode((Node)node, (String)"blob");
        pDFFormatOptions.setBlobAction(PDFFormatOptions.BLOB_ACTION.valueOf((String)XMLHelper.getAttributeNode((Node)node2, (String)"blob")));
        pDFFormatOptions.setCreateZipFile(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"zip")));
    }

    private void populateHeader(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setInsertHeader(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"enable")));
        pDFFormatOptions.setAutoUpdateDate(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"generatedate")));
        pDFFormatOptions.setHeader(XMLHelper.getNodeValue((Node)node, (String)"data"));
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"pattern");
        ReportPatternInfo reportPatternInfo = null;
        ArrayList<ReportPatternInfo> arrayList = new ArrayList<ReportPatternInfo>();
        for (XMLNode xMLNode : xMLNodeArray) {
            String string = XMLHelper.getAttributeNode((Node)xMLNode, (String)"pattern");
            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"value");
            int n = Integer.parseInt(XMLHelper.getAttributeNode((Node)xMLNode, (String)"position"));
            reportPatternInfo = new ReportPatternInfo(n, string, string2);
            arrayList.add(reportPatternInfo);
        }
        if (!arrayList.isEmpty()) {
            pDFFormatOptions.setHeaderPatternList(arrayList);
        }
    }

    private void populateFooter(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setInsertFooter(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"enable")));
        pDFFormatOptions.setAutoUpdateDate(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"generatedate")));
        pDFFormatOptions.setFooter(XMLHelper.getNodeValue((Node)node, (String)"data"));
        XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"pattern");
        ReportPatternInfo reportPatternInfo = null;
        ArrayList<ReportPatternInfo> arrayList = new ArrayList<ReportPatternInfo>();
        for (XMLNode xMLNode : xMLNodeArray) {
            String string = XMLHelper.getAttributeNode((Node)xMLNode, (String)"pattern");
            String string2 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"value");
            int n = Integer.parseInt(XMLHelper.getAttributeNode((Node)xMLNode, (String)"position"));
            reportPatternInfo = new ReportPatternInfo(n, string, string2);
            arrayList.add(reportPatternInfo);
        }
        if (!arrayList.isEmpty()) {
            pDFFormatOptions.setFooterPatternList(arrayList);
        }
    }

    private void populateTableLayout(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setFontName(XMLHelper.getAttributeNode((Node)node, (String)"font"));
        pDFFormatOptions.setFontSize(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"size")));
        pDFFormatOptions.setFontStyle(ReportFormatOptions.FONT_STYLE.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"style")));
        pDFFormatOptions.setFontColor(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"color")));
        pDFFormatOptions.setUseRowShading(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"userowshading")));
        pDFFormatOptions.setOddRowShading(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"oddrowshading")));
        pDFFormatOptions.setEvenRowShading(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"evenrowshading")));
        pDFFormatOptions.setShowAllBorders(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"showborders")));
        pDFFormatOptions.setSpacingBeforeTable(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"spacingbefore")));
        pDFFormatOptions.setSpacingAfterTable(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"spacingafter")));
        pDFFormatOptions.setTableHorizontalAlignment(ReportFormatOptions.HORIZONTAL_ALIGNMENT.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"horizontalalign")));
    }

    private void populatePageSetup(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setPaperSize(ReportFormatOptions.PAPER_SIZE.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"papersize")));
        pDFFormatOptions.setOrientation(Integer.parseInt(XMLHelper.getAttributeNode((Node)node, (String)"orientation")));
        pDFFormatOptions.setTopMarginUI(Float.parseFloat(XMLHelper.getAttributeNode((Node)node, (String)"margintop")));
        pDFFormatOptions.setBottomMarginUI(Float.parseFloat(XMLHelper.getAttributeNode((Node)node, (String)"marginbottom")));
        pDFFormatOptions.setLeftMarginUI(Float.parseFloat(XMLHelper.getAttributeNode((Node)node, (String)"marginleft")));
        pDFFormatOptions.setRightMarginUI(Float.parseFloat(XMLHelper.getAttributeNode((Node)node, (String)"marginright")));
    }

    private void populatePDF(PDFFormatOptions pDFFormatOptions, Node node) {
        pDFFormatOptions.setSupportedVersion(PDFFormatOptions.PDF_COMPATIBILITY.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"version")));
        pDFFormatOptions.setCompressionLevel(PDFFormatOptions.COMPRESSION_LEVEL.valueOf((String)XMLHelper.getAttributeNode((Node)node, (String)"compression")));
    }

    public PDFFormatOptions getPDFOptions(Node node) {
        if (node == null || !node.getNodeName().equals("pdf")) {
            return null;
        }
        PDFFormatOptions pDFFormatOptions = new PDFFormatOptions();
        this.populatePDF(pDFFormatOptions, node);
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        String string = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node2 = nodeList.item(i);
            string = node2.getNodeName();
            if (string.equalsIgnoreCase("docproperty")) {
                this.populateDocProperties(pDFFormatOptions, node2);
                continue;
            }
            if (string.equalsIgnoreCase("cell")) {
                this.populateCellLayout(pDFFormatOptions, node2);
                continue;
            }
            if (string.equalsIgnoreCase("column")) {
                this.populateColumnLayout(pDFFormatOptions, node2);
                continue;
            }
            if (string.equalsIgnoreCase("table")) {
                this.populateTableLayout(pDFFormatOptions, node2);
                continue;
            }
            if (string.equalsIgnoreCase("header")) {
                this.populateHeader(pDFFormatOptions, node2);
                continue;
            }
            if (string.equalsIgnoreCase("footer")) {
                this.populateFooter(pDFFormatOptions, node2);
                continue;
            }
            if (!string.equalsIgnoreCase("pagesetup")) continue;
            this.populatePageSetup(pDFFormatOptions, node2);
        }
        return pDFFormatOptions;
    }
}

