/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.service;

import java.awt.Component;
import javax.swing.JOptionPane;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportAPI;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.ddl.TargetFormatHelper;
import oracle.dbtools.raptor.export.service.ExportServiceAddendumSD;
import oracle.dbtools.raptor.export.service.ExportToolRunModeSD;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;

public class ExportLauncherSD
extends ExportAPI {
    private ExportParms _eParms;

    public ExitCode start(ExportParms exportParms) {
        try {
            this._eParms = exportParms;
            ExportToolRunModeSD exportToolRunModeSD = new ExportToolRunModeSD();
            exportToolRunModeSD.setRunMode(IToolRunMode.RunMode.GUI);
            exportToolRunModeSD.setParms(exportParms);
            exportToolRunModeSD.setLineTerminator(this.getLineTerminator());
            exportToolRunModeSD.isShowELog(this._eParms.getTargetFormat() == null || !this._eParms.getTargetFormat().isDeployCloud());
            exportToolRunModeSD.setAddendum(new ExportServiceAddendumSD());
            this._eParms.setToolRunMode((IToolRunMode)exportToolRunModeSD);
            ExitCode exitCode = super.start(exportParms, (IToolRunMode)exportToolRunModeSD);
            ExportService exportService = this.getService();
            TargetFormat targetFormat = exportService.getTargetFormat();
            this.getRunMode().setToolName(exportService.getToolName());
            this.getRunMode().newToolLogger();
            exportService.initELogger();
            return exitCode;
        }
        catch (Exception exception) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + exception.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    public void export() {
        final ExportService exportService = this.getService();
        boolean bl = false;
        ExtractObject extractObject = exportService.getListModel().getFirstDataObject();
        if (extractObject != null && extractObject.getTable() != null && extractObject.getTable() instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)extractObject.getTable())).allRowsFetched();
        }
        final TargetFormat targetFormat = exportService.getTargetFormat();
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
        if (exportService.isDeployPdbCloud()) {
            iRaptorTaskRunMode = IRaptorTaskRunMode.TASKVIEWER;
        } else if (!exportService.isExportDBObjects()) {
            iRaptorTaskRunMode = targetFormat.getSaveAsType() == 0 && !bl ? IRaptorTaskRunMode.IDE_STATUSBAR : IRaptorTaskRunMode.MODAL;
        }
        String string = targetFormat.getSaveAsType() < 4 ? targetFormat.getSaveAs() : targetFormat.getSaveAsTypeString();
        String string2 = ExportResources.format((String)"UNLOADING", (Object[])new Object[]{string});
        exportService.isCancel(false);
        DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(string2, iRaptorTaskRunMode, false, true){

            public Void doWork() {
                try {
                    exportService.startGenOutput();
                    ExitCode exitCode = exportService.validate();
                    if (exitCode != ExitCode.EXIT_SUCCESS) {
                        exportService.getGenOutput().println(exitCode.getMessage());
                        exportService.isCancel(true);
                    } else {
                        exportService.export();
                    }
                }
                catch (Exception exception) {
                    Logger.warn(ExportAPI.class, (Throwable)exception);
                    exportService.eLogException(exception);
                    ExceptionHandler.handleException((Throwable)exception);
                }
                finally {
                    try {
                        exportService.getGenOutput().finished();
                        ExportLauncherSD.this.finish();
                    }
                    catch (Exception exception) {
                        Logger.warn(ExportAPI.class, (Throwable)exception);
                        exportService.eLogException(exception);
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                return null;
            }

            public boolean cancel() {
                exportService.isCancel(true);
                return true;
            }

            public String getConnectionName() {
                return exportService.getConnName();
            }

            public String getQuery() {
                return "";
            }
        };
        databaseQueryTask.setCancellable(true);
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    Object object;
                    exportService.taskFinishedServiceProcess();
                    try {
                        exportService.eLogHref(targetFormat.getSaveAsURL());
                    }
                    catch (Exception exception) {
                        Logger.warn(ExportAPI.class, (Throwable)exception);
                        exportService.eLogException(exception);
                    }
                    if ((targetFormat.isMultipleFiles() || targetFormat.isTypeFiles() || targetFormat.isSeparateDirs()) && (object = targetFormat.getControllingURL()) != null) {
                        try {
                            exportService.eLogHref(targetFormat.getControllingURL());
                        }
                        catch (Exception exception) {
                            Logger.warn(ExportAPI.class, (Throwable)exception);
                            exportService.eLogException(exception);
                        }
                    }
                    exportService.eLogToolEnd();
                    if (!targetFormat.isSftp()) {
                        object = exportService.getGenOutput();
                        if (object != null) {
                            TargetFormatHelper.openTargetInUI(targetFormat, object.getWriter(), object.getFileNameToOpen(), exportService.getConnName());
                        }
                    } else {
                        object = new SftpUtil();
                        boolean bl = ((SftpUtil)object).SftpPut((SftpParms)targetFormat.getSftpParms(), true);
                        if (!bl) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ExportResources.getString((String)"FTP_ERROR_MSG"), ExportResources.getString((String)"FTP_ERROR_TITLE"), 0);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.warn(ExportAPI.class, (Throwable)exception);
                }
                finally {
                    ExportLauncherSD.this.getRunMode().setTask(null);
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                exportService.isCancel(true);
                exportService.taskCancelledServiceProcess();
                exportService.eLog(ExportResources.getString((String)"EXPORT_CANCEL"));
                exportService.eLogToolEnd();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                exportService.isCancel(true);
                exportService.taskFailedServiceProcess();
                exportService.eLog(ExportResources.getString((String)"EXPORT_FAILED"));
                exportService.eLogToolEnd();
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        this.getRunMode().setTask((RaptorTask)databaseQueryTask);
    }

    public ExitCode run(ExportParms exportParms) {
        try {
            ExitCode exitCode = this.start(exportParms);
            if (!(exitCode != ExitCode.EXIT_SUCCESS && exitCode != ExitCode.EXIT_WARNING || (exitCode = this.validate()) != ExitCode.EXIT_SUCCESS && exitCode != ExitCode.EXIT_WARNING)) {
                this.export();
            }
            return exitCode;
        }
        catch (Exception exception) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + exception.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    protected String getLineTerminator() {
        if (Ide.isRunning()) {
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
            int n = environOptions.getLineTerminator();
            if (n == 1) {
                return "\r\n";
            }
            if (n == 3) {
                return "\r";
            }
            if (n == 2) {
                return "\n";
            }
            return System.getProperty("line.separator");
        }
        return System.getProperty("line.separator");
    }
}

