/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.raptor.extract.ExtractMessagePage;
import oracle.dbtools.raptor.logging.LogUtils;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class ExtractLogger
extends ToolLogger {
    private ExtractMessagePage _messagePane;

    public ExtractLogger() {
        super(IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING"));
    }

    public ExtractLogger(OutputStreamWriter outputStreamWriter) {
        super(outputStreamWriter);
    }

    public ExtractLogger(OutputStream outputStream) {
        super(outputStream);
    }

    public ExtractLogger(File file) {
        super(file);
    }

    public ExtractLogger(File file, String string) {
        super(file, string);
    }

    public ExtractLogger(String string) {
        super(ExtractResources.getString((String)"EXTRACT_TOOL"), string);
    }

    public ExtractLogger(String string, String string2) {
        super(string, string2, null);
    }

    public ExtractLogger(String string, String string2, String string3) {
        super(string, string2, string3, null);
    }

    public ExtractLogger(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public ExtractLogger(ViewId viewId) {
        this(viewId, null, null, null);
    }

    public ExtractLogger(ViewId viewId, String string, String string2, Icon icon) {
        this.getStartTime();
        this._messagePane = ExtractMessagePage.getExportMessagePage(viewId, string, string2, icon);
        this.setTerm();
    }

    public String getDefaultTerm() {
        this.setTerm();
        return this.getTerm();
    }

    public String getEncoding() {
        return IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING");
    }

    public String getUserDirectory() {
        return Ide.getUserSettingsDirectory();
    }

    public void log(String string, boolean bl) {
        if (this._out != null) {
            super.log(string, bl);
        } else if (this._messagePane != null) {
            this._messagePane.log(string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()), bl);
        }
    }

    public void log(AttributeSet attributeSet, String string, boolean bl) {
        if (this._out != null) {
            super.log(string);
        } else if (this._messagePane != null) {
            StyledMessage styledMessage = new StyledMessage(attributeSet, string + (string.endsWith(this.getTerm()) ? "" : this.getTerm()));
            this._messagePane.log(styledMessage, bl);
        }
    }

    public void logLabel(String string, boolean bl) {
        if (this._out != null) {
            super.log(string);
        } else if (this._messagePane != null) {
            this._messagePane.log(string, bl);
        }
    }

    public void logException(Throwable throwable) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.RED);
        this.log(simpleAttributeSet, ExtractResources.format((String)"EXCEPTION", (Object[])new Object[]{ExtractResources.getString((String)"EXCEPTION_CHECK_LOG")}), false);
        if (throwable != null) {
            String string = this.getExceptionText(throwable);
            this.log(simpleAttributeSet, ExtractResources.format((String)"EXCEPTION", (Object[])new Object[]{string}), true);
        }
    }

    public void logHref(URL uRL) {
        if (this._out != null) {
            super.log(uRL.toExternalForm());
        } else if (this._messagePane != null) {
            this._messagePane.log(LogUtils.getHref(uRL));
            this.log(this.getTerm());
        }
    }

    public void setTerm() {
        this.setTerm(IEnvironmentConfig.Storage.getInstance().getString("ENV_LINE_TERMINATOR"));
    }

    public void openTextNodeForLog() throws Exception {
        TextNode textNode = null;
        textNode = (TextNode)NodeFactory.findOrCreate(TextNode.class, (URL)this.getURL());
        final TextNode textNode2 = textNode;
        if (textNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)textNode2);
                        }
                    });
                }
            });
        }
    }

    public void error(Exception exception) {
        Logger.warn(ExtractLogger.class, (Throwable)exception);
    }

    public void error(String string) {
        Logger.warn(ExtractLogger.class, (String)string);
    }

    public void error(Exception exception, String string, String string2) {
        if (string != null) {
            Logger.warn(ExtractLogger.class, (String)string);
        }
        if (string2 != null) {
            Logger.warn(ExtractLogger.class, (String)string2);
        }
        if (exception != null) {
            Logger.warn(ToolLogger.class, (Throwable)exception);
            string2 = string2 + this.getTerm() + exception.getLocalizedMessage();
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)string2, null);
    }
}

