/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.ddl.DDLFormatHelper;
import oracle.dbtools.raptor.ddl.DDLTypesHelper;
import oracle.dbtools.raptor.extract.models.ExtractDataFormatHelper;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.icons.OracleIcons;

public class ExtractListModelHelper {
    ExtractListModel _listModel;

    public ExtractListModelHelper(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(this.getConnectionsNode());
        if (this._listModel.isDDLEnabled()) {
            defaultMutableTreeNode.add(this.getDDLFormatNode());
        }
        defaultMutableTreeNode.add(this.getMetaNode());
        if (this._listModel.isDataEnabled()) {
            defaultMutableTreeNode.add(this.getDataNode());
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode getConnectionsNode() {
        String string;
        JLabel jLabel;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString((String)"CONNECTIONS"));
        if (this._listModel.getSourceConn() != null) {
            jLabel = new JLabel();
            string = Connections.getDisplayName(Connections.getInstance().getConnectionName(this._listModel.getSourceConn()));
            jLabel.setText(ExtractResources.getString((String)"SOURCE") + ": " + string);
            jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        }
        if (this._listModel.getDestConn() != null) {
            jLabel = new JLabel();
            string = Connections.getDisplayName(Connections.getInstance().getConnectionName(this._listModel.getDestConn()));
            jLabel.setText(ExtractResources.getString((String)"DEST") + ": " + string);
            jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDDLFormatNode() {
        DDLFormat dDLFormat = this._listModel.getDDLFormat();
        return DDLFormatHelper.getSummaryNode(dDLFormat);
    }

    public DefaultMutableTreeNode getSummaryGlobalWhere() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString((String)"EO_PRED_GLOBAL_WHERE") + " " + this._listModel.getGlobalWhere());
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getMetaNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString((String)"DDL_OBJECTS"));
        List list = this._listModel.getDDLTypes().getTypeList();
        for (String string : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DDLTypesHelper.getFolderLabel(string));
            List<JLabel> list2 = this.getSummaryMetaObjectByType(string);
            for (JLabel jLabel : list2) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDataFormatNode() {
        ExtractDataFormat extractDataFormat = this._listModel.getDataFormat();
        return ExtractDataFormatHelper.getSummaryNode(this._listModel, extractDataFormat);
    }

    public DefaultMutableTreeNode getDataNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(ExtractResources.getString((String)"DATA_OBJECTS"));
        List list = this._listModel.getDDLTypes().getTypeListForData();
        for (String string : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DDLTypesHelper.getFolderLabel(string));
            List<DefaultMutableTreeNode> list2 = this.getSummaryDataNodeByType(string);
            for (DefaultMutableTreeNode defaultMutableTreeNode3 : list2) {
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public List<JLabel> getSummaryMetaObjectByType(String string) {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        List list = this._listModel.getList(0, new int[]{108});
        List list2 = this._listModel.getListForType(this._listModel.getList(0), "TABLE");
        List list3 = this._listModel.getListForType(list, string);
        if (list3.size() < 1) {
            if (list2.isEmpty()) {
                arrayList.add(this.getAllObjectsLabel(string));
            } else if (string == "CONSTRAINT" || string == "REFCONSTRAINT" || string == "INDEX" || string == "TRIGGER") {
                for (ExtractObject extractObject : list2) {
                    String string2 = extractObject.getSourceConnName();
                    BasicDBObject basicDBObject = this._listModel.getDBObject(extractObject.getUrl());
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, basicDBObject.getSchemaName(), string);
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, basicDBObject.getObjectName());
                    DBObject dBObject = new DBObject(uRL2);
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(DBURLFormatHelper.getIcon(dBObject.getURL()));
                    jLabel.setText(ExtractResources.format((String)"FOR", (Object[])new Object[]{DDLTypes.getFolderName((String)string), dBObject.getObjectName()}));
                    arrayList.add(jLabel);
                }
            } else {
                arrayList.add(this.getAllObjectsLabel(string));
            }
        } else {
            for (ExtractObject extractObject : list3) {
                arrayList.add(this.getLabel(extractObject));
            }
        }
        return arrayList;
    }

    public List<JLabel> getSummaryMetaObjectForType(List<ExtractObject> list, String string, boolean bl) {
        ArrayList<JLabel> arrayList;
        block5: {
            List list2;
            block4: {
                arrayList = new ArrayList<JLabel>();
                List list3 = this._listModel.getListForType(list, "TABLE");
                list2 = this._listModel.getListForType(list, string);
                if (list2.size() >= 1) break block4;
                if (list3.isEmpty() || string != "CONSTRAINT" && string != "REFCONSTRAINT" && string != "INDEX" && string != "TRIGGER") break block5;
                for (ExtractObject extractObject : list3) {
                    String string2 = extractObject.getSourceConnName();
                    BasicDBObject basicDBObject = this._listModel.getDBObject(extractObject.getUrl());
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, basicDBObject.getSchemaName(), string);
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, basicDBObject.getObjectName());
                    BasicDBObject basicDBObject2 = new BasicDBObject(uRL2);
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(DBURLFormatHelper.getIcon(basicDBObject2.getURL()));
                    BasicDBObject basicDBObject3 = extractObject.getDBObject();
                    if (basicDBObject3.isObjectFolderType()) {
                        jLabel.setText(ExtractResources.format((String)"FOR_ALL_FOLDER", (Object[])new Object[]{DDLTypes.getFolderName((String)string), DDLTypes.getFolderName((String)basicDBObject3.getObjectFolderType()), Connections.getDisplayName(basicDBObject3.getConnectionName()) + "." + basicDBObject3.getSchemaName()}));
                    } else {
                        jLabel.setText(ExtractResources.format((String)"FOR", (Object[])new Object[]{DDLTypes.getFolderName((String)string), extractObject.getDisplayName(bl)}));
                    }
                    arrayList.add(jLabel);
                }
                break block5;
            }
            for (ExtractObject extractObject : list2) {
                arrayList.add(this.getLabel(extractObject, bl));
            }
        }
        return arrayList;
    }

    public List<DefaultMutableTreeNode> getSummaryDataNodeByType(String string) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        List list = this._listModel.getList(0, new int[]{109});
        List list2 = this._listModel.getListForType(list, string);
        if (list2.size() < 1) {
            arrayList.add(new DefaultMutableTreeNode(this.getAllObjectsLabel(string)));
        } else {
            for (ExtractObject extractObject : list2) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.getLabel(extractObject));
                if (extractObject.getWhere().length() > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ExtractResources.getString((String)"EO_PRED_OBJ_WHERE") + " " + extractObject.getWhere());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                arrayList.add(defaultMutableTreeNode);
            }
        }
        return arrayList;
    }

    public static DefaultMutableTreeNode getSummaryBooleanItem(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return new DefaultMutableTreeNode(jLabel);
    }

    public static DefaultMutableTreeNode getSummaryLabelItem(String string, Icon icon, String string2) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string + ": " + string2);
        jLabel.setIcon(icon);
        return new DefaultMutableTreeNode(jLabel);
    }

    public static DefaultMutableTreeNode getSummaryLabelItem(String string, String string2) {
        return ExtractListModelHelper.getSummaryLabelItem(string, OracleIcons.getIcon((String)"attribute.png"), string2);
    }

    private JLabel getAllObjectsLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(ExtractListModelHelper.getAllObjectsString(string));
        return jLabel;
    }

    public static String getAllObjectsString(String string) {
        return ExtractResources.getString((String)"ALL") + " " + DDLTypes.getFolderName((String)string);
    }

    public JLabel getLabel(ExtractObject extractObject) {
        JLabel jLabel = new JLabel();
        if (extractObject.getDBObject() != null) {
            jLabel.setText(extractObject.getDBObject().getObjectName());
            jLabel.setIcon(DBURLFormatHelper.getIcon(extractObject.getDBObject().getURL()));
        } else if (extractObject.getTable() != null && extractObject.getTable() != null) {
            jLabel.setText(extractObject.getTableName());
        }
        return jLabel;
    }

    public JLabel getLabel(ExtractObject extractObject, boolean bl) {
        JLabel jLabel = new JLabel();
        BasicDBObject basicDBObject = extractObject.getDBObject();
        if (basicDBObject != null) {
            String string = basicDBObject.getObjectName();
            jLabel.setIcon(DBURLFormatHelper.getIcon(basicDBObject.getURL()));
            String string2 = basicDBObject.getCatalog();
            if (string2 == null) {
                string2 = "";
            } else if (!string2.isEmpty()) {
                string2 = string2 + ".";
            }
            if (basicDBObject.isObjectFolderType()) {
                jLabel.setText(ExtractResources.format((String)"FOR_FOLDER", (Object[])new Object[]{DDLTypes.getFolderName((String)basicDBObject.getObjectFolderType()), Connections.getDisplayName(basicDBObject.getConnectionName()) + "." + string2 + basicDBObject.getSchemaName()}));
                jLabel.setIcon(DDLTypesHelper.getFolderIcon(basicDBObject.getObjectFolderType()));
            } else {
                jLabel.setIcon(DBURLFormatHelper.getIcon(basicDBObject.getURL()));
                jLabel.setText(bl ? Connections.getDisplayName(basicDBObject.getConnectionName()) + "." + string2 + basicDBObject.getSchemaName() + "." + string : basicDBObject.getSchemaName() + "." + string);
            }
        } else if (extractObject.getTable() != null && extractObject.getTableName() != null) {
            jLabel.setText(extractObject.getTableName());
        }
        return jLabel;
    }
}

