/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import javax.swing.JLabel;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.ddl.DDLTypesHelper;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class ExtractObjectHelper {
    public static JLabel getLabel(ExtractObject extractObject) {
        JLabel jLabel = new JLabel();
        BasicDBObject basicDBObject = extractObject.getDBObject();
        if (basicDBObject != null) {
            jLabel.setText(basicDBObject.getObjectName());
            jLabel.setIcon(DBURLFormatHelper.getIcon(basicDBObject.getURL()));
        } else if (extractObject.getTable() != null && extractObject.getTableName() != null) {
            jLabel.setText(extractObject.getTableName());
        }
        return jLabel;
    }

    public static JLabel getLabel(ExtractObject extractObject, boolean bl) {
        JLabel jLabel = new JLabel();
        DBObject dBObject = new DBObject(extractObject.getDBObject().getURL());
        if (dBObject != null) {
            String string = dBObject.getObjectName();
            jLabel.setIcon(DBURLFormatHelper.getIcon(dBObject.getURL()));
            String string2 = DBURLFormatHelper.getCatalog(dBObject.getURL());
            if (string2 == null) {
                string2 = "";
            } else if (!string2.isEmpty()) {
                string2 = string2 + ".";
            }
            if (dBObject.getElement() != null && dBObject.getElement() instanceof ObjectFolder) {
                jLabel.setText(ExtractResources.format((String)"FOR_FOLDER", (Object[])new Object[]{DDLTypes.getFolderName((String)dBObject.getObjectFolderType()), Connections.getDisplayName(dBObject.getConnectionName()) + "." + string2 + dBObject.getSchemaName()}));
                jLabel.setIcon(DDLTypesHelper.getFolderIcon(dBObject.getObjectFolderType()));
            } else {
                jLabel.setIcon(DBURLFormatHelper.getIcon(dBObject.getURL()));
                jLabel.setText(bl ? Connections.getDisplayName(dBObject.getConnectionName()) + "." + string2 + dBObject.getSchemaName() + "." + string : dBObject.getSchemaName() + "." + string);
            }
        } else if (extractObject.getTable() != null && extractObject.getTableName() != null) {
            jLabel.setText(extractObject.getTableName());
        }
        return jLabel;
    }

    public static String getDisplayName(ExtractObject extractObject, boolean bl) {
        DBObject dBObject = new DBObject(extractObject.getDBObject().getURL());
        if (dBObject != null) {
            String string = dBObject.getObjectName();
            if (dBObject.getElement() != null && dBObject.getElement() instanceof ObjectFolder) {
                string = DDLTypes.getFolderName((String)dBObject.getObjectFolderType()) + " " + ExtractResources.getString((String)"FOLDER");
            }
            return bl ? Connections.getDisplayName(dBObject.getConnectionName()) + "." + dBObject.getSchemaName() + "." + string : dBObject.getSchemaName() + "." + string;
        }
        if (extractObject.getTable() != null && extractObject.getTableName() != null) {
            return extractObject.getTableName();
        }
        return "";
    }
}

